/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.jvmagent;

import com.intellij.rt.coverage.main.CoveragePremain;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.List;
import kotlinx.kover.jvmagent.KoverAgentSettings;
import kotlinx.kover.jvmagent.KoverJvmAgentPremain;

public class IntellijIntegration {
    private static final boolean TRACKING_PER_TEST = false;
    private static final boolean CALCULATE_FOR_UNLOADED_CLASSES = false;
    private static final boolean LINES_ONLY_MODE = false;

    private IntellijIntegration() {
    }

    public static void callPremain(KoverAgentSettings settings, Instrumentation instrumentation) throws Exception {
        IntellijIntegration.setIntellijSystemProperties();
        String intelliJArgsString = IntellijIntegration.joinIntellijArgs(IntellijIntegration.createIntellijArgs(settings));
        CoveragePremain.premain(intelliJArgsString, instrumentation);
    }

    private static void setIntellijSystemProperties() {
        System.setProperty("idea.coverage.use.system.classloader", "true");
        System.setProperty("idea.coverage.log.level", "error");
        System.setProperty("idea.new.tracing.coverage", "true");
        System.setProperty("coverage.ignore.private.constructor.util.class", "true");
        System.setProperty("idea.coverage.calculate.hits", "false");
    }

    private static List<String> createIntellijArgs(KoverAgentSettings settings) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(settings.reportFilePath);
        args.add(Boolean.toString(false));
        args.add(Boolean.toString(false));
        args.add(Boolean.toString(settings.appendToReportFile));
        args.add(Boolean.toString(false));
        args.addAll(settings.inclusions);
        if (!settings.exclusions.isEmpty()) {
            args.add("-exclude");
            args.addAll(settings.exclusions);
        }
        return args;
    }

    private static String joinIntellijArgs(List<String> args) {
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            if (KoverJvmAgentPremain.isBoolean(arg)) {
                builder.append(arg);
            } else {
                builder.append('\"');
                builder.append(arg);
                builder.append('\"');
            }
            builder.append(',');
        }
        return builder.toString();
    }
}

