/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.jvmagent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kotlinx.kover.jvmagent.IntellijIntegration;
import kotlinx.kover.jvmagent.KoverAgentSettings;

public class KoverJvmAgentPremain {
    private static final String FILE_PREFIX_IN_ARGS = "file:";
    private static final String FILE_PATH_ARGUMENT = "report.file=";
    private static final String APPEND_ARGUMENT = "report.append=";
    private static final String EXCLUDE_WITH_WILDCARDS_ARGUMENT = "exclude=";
    private static final String EXCLUDE_WITH_REGEX_ARGUMENT = "exclude.regex=";
    private static final String INCLUDE_WITH_WILDCARDS_ARGUMENT = "include=";
    private static final String INCLUDE_WITH_REGEX_ARGUMENT = "include.regex=";
    private static final String regexMetacharacters = "<([{\\^-=$!|]})+.>";
    private static final HashSet<Character> regexMetacharactersSet = new HashSet();
    private static final List<String> arguments = Arrays.asList("report.file=", "report.append=", "exclude=", "exclude.regex=", "include=", "include.regex=");

    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        KoverAgentSettings settings = KoverJvmAgentPremain.readSettingsFromFile(KoverJvmAgentPremain.extractArgsFile(argsString));
        IntellijIntegration.callPremain(settings, instrumentation);
    }

    private static File extractArgsFile(String args) {
        if (!args.startsWith(FILE_PREFIX_IN_ARGS)) {
            throw new IllegalArgumentException("Incorrect arguments format for Kover JVM agent, arguments are expected to start with file:");
        }
        return new File(args.substring(FILE_PREFIX_IN_ARGS.length()));
    }

    public static boolean isBoolean(String value) {
        return "true".equals(value) || "false".equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KoverAgentSettings readSettingsFromFile(File file) throws IOException {
        KoverAgentSettings settings = new KoverAgentSettings();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = reader.readLine();
            while (line != null) {
                String wildcards;
                if (line.startsWith(FILE_PATH_ARGUMENT)) {
                    settings.reportFilePath = line.substring(FILE_PATH_ARGUMENT.length());
                } else if (line.startsWith(EXCLUDE_WITH_WILDCARDS_ARGUMENT)) {
                    wildcards = line.substring(EXCLUDE_WITH_WILDCARDS_ARGUMENT.length());
                    settings.exclusions.add(KoverJvmAgentPremain.wildcardsToRegex(wildcards));
                } else if (line.startsWith(EXCLUDE_WITH_REGEX_ARGUMENT)) {
                    settings.exclusions.add(line.substring(EXCLUDE_WITH_REGEX_ARGUMENT.length()));
                } else if (line.startsWith(INCLUDE_WITH_WILDCARDS_ARGUMENT)) {
                    wildcards = line.substring(INCLUDE_WITH_WILDCARDS_ARGUMENT.length());
                    settings.inclusions.add(KoverJvmAgentPremain.wildcardsToRegex(wildcards));
                } else if (line.startsWith(INCLUDE_WITH_REGEX_ARGUMENT)) {
                    settings.inclusions.add(line.substring(INCLUDE_WITH_REGEX_ARGUMENT.length()));
                } else if (line.startsWith(APPEND_ARGUMENT)) {
                    String value = line.substring(APPEND_ARGUMENT.length());
                    if (!KoverJvmAgentPremain.isBoolean(value)) {
                        throw new IllegalArgumentException("Incorrect value for argument report.append= in Kover JVM agent arguments file, expected true or false");
                    }
                    settings.appendToReportFile = Boolean.parseBoolean(value);
                } else if (!line.isEmpty()) {
                    throw new IllegalArgumentException("Unrecognized line in Kover arguments file: " + line + ". Line must start with one of prefixes: " + arguments);
                }
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (settings.reportFilePath == null) {
            throw new IllegalArgumentException("Path to the report file is required, add report.file= argument to the args file");
        }
        return settings;
    }

    private static String wildcardsToRegex(String value) {
        StringBuilder builder = new StringBuilder(value.length() * 2);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (regexMetacharactersSet.contains(Character.valueOf(c))) {
                builder.append('\\').append(c);
                continue;
            }
            if (c == '*') {
                builder.append(".*");
                continue;
            }
            if (c == '?') {
                builder.append('.');
                continue;
            }
            if (c == '#') {
                builder.append("[^.]*");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static {
        for (int i = 0; i < regexMetacharacters.length(); ++i) {
            char c = regexMetacharacters.charAt(i);
            regexMetacharactersSet.add(Character.valueOf(c));
        }
    }
}

