/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.instrumentation.CoverageEnumerator;
import com.intellij.rt.coverage.instrumentation.CoverageEnumeratorWithInstructions;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.JSR45Util;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccessVisitor;
import com.intellij.rt.coverage.instrumentation.dataAccess.EmptyCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import com.intellij.rt.coverage.instrumentation.util.LinesUtil;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.OptionsUtil;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationVisitor
extends ClassVisitor {
    private static final List<MethodFilter> ourMethodFilters = FilterUtils.createMethodFilters();
    private final InstrumentationData myContext;
    private final CoverageDataAccessVisitor myDataAccess;
    private final ProjectData myProjectData;
    private String mySource;

    /*
     * WARNING - void declaration
     */
    public InstrumentationVisitor(ProjectData projectData, final InstrumentationData context, ClassVisitor classVisitor, CoverageDataAccess dataAccess) {
        super(589824, new CoverageDataAccessVisitor((ClassVisitor)var3_3, dataAccess){
            {
                void var2_2;
                void var1_1;
                super((ClassVisitor)var1_1, (CoverageDataAccess)var2_2);
            }

            protected boolean shouldInstrumentMethod() {
                return !context.hasNoLinesInCurrentMethod();
            }
        });
        void var1_1;
        void var2_2;
        void var3_3;
        this.myDataAccess = (CoverageDataAccessVisitor)this.cv;
        this.myContext = var2_2;
        this.myProjectData = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myContext.put(Key.CLASS_ACCESS, access);
        this.myContext.put(Key.INTERFACES, interfaces);
        super.visit((int)var1_1, (int)var2_2, (String)var3_3, signature, superName, interfaces);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myContext.resetMethod();
        this.myContext.put(Key.METHOD_ACCESS, access);
        this.myContext.put(Key.METHOD_NAME, name);
        this.myContext.put(Key.METHOD_DESC, descriptor);
        this.myContext.put(Key.METHOD_SIGNATURE, signature);
        this.myContext.put(Key.EXCEPTIONS, exceptions);
        if (!this.shouldInstrumentMethod(access)) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        boolean branchCoverage = this.getOptions().isBranchCoverage;
        CoverageEnumerator enumerator = this.getOptions().isInstructionCoverage ? new CoverageEnumeratorWithInstructions(this.myContext, branchCoverage) : new CoverageEnumerator(this.myContext, branchCoverage);
        MethodVisitor mv = this.chainFilters(enumerator, FilterUtils.createLineFilters());
        if (branchCoverage) {
            mv = this.chainFilters(mv, FilterUtils.createBranchFilters());
        }
        return new MethodVisitor(this, 589824, mv, (int)var1_1, (String)var2_2, (String)var3_3, signature, exceptions, enumerator){
            final /* synthetic */ int val$access;
            final /* synthetic */ String val$name;
            final /* synthetic */ String val$descriptor;
            final /* synthetic */ String val$signature;
            final /* synthetic */ String[] val$exceptions;
            final /* synthetic */ CoverageEnumerator val$enumerator;
            final /* synthetic */ InstrumentationVisitor this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$access = n;
                this.val$name = string;
                this.val$descriptor = string2;
                this.val$signature = string3;
                this.val$exceptions = stringArray;
                this.val$enumerator = coverageEnumerator;
                super((int)var2_2, (MethodVisitor)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            public void visitEnd() {
                super.visitEnd();
                if (this.this$0.myDataAccess.getDataAccess() != EmptyCoverageDataAccess.INSTANCE) {
                    void var1_1;
                    MethodVisitor methodVisitor = InstrumentationVisitor.access$101(this.this$0, this.val$access, this.val$name, this.val$descriptor, this.val$signature, this.val$exceptions);
                    this.val$enumerator.accept(this.this$0.myContext.hasNoLinesInCurrentMethod() ? methodVisitor : this.this$0.new HitsVisitor((MethodVisitor)var1_1));
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldInstrumentMethod(int access) {
        void var1_1;
        if ((access & 0x40) != 0) {
            return false;
        }
        if ((var1_1 & 0x400) != 0) {
            return false;
        }
        for (MethodFilter methodFilter : ourMethodFilters) {
            if (!methodFilter.shouldIgnore(this.myContext)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private MethodVisitor chainFilters(MethodVisitor root, List<CoverageFilter> filters) {
        void var1_1;
        for (CoverageFilter filter : filters) {
            void var3_3;
            if (!filter.isApplicable(this.myContext)) continue;
            filter.initFilter(root, this.myContext);
            root = var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitEnd() {
        super.visitEnd();
        String className = this.myContext.get(Key.CLASS_NAME);
        ClassData classData = this.myProjectData.getOrCreateClassData(className);
        classData.setLines(LinesUtil.calcLineArray(this.myContext.getMaxSeenLine(), this.myContext.getLines()));
        classData.createMask(this.myContext.getSize(), this.getOptions().isCalculateHits);
        classData.setSource(this.mySource);
        this.myContext.getProjectContext().addIgnoredLines(className, this.myContext.getIgnoredLines());
        if (OptionsUtil.TEST_MODE) {
            InstrumentationData.assertIds(classData);
        }
        if (this.getOptions().isInstructionCoverage) {
            void var1_1;
            void var2_2;
            ClassInstructions classInstructions = new ClassInstructions(classData, this.myContext.getInstructions());
            this.myProjectData.getInstructions().put(var2_2.getName(), (ClassInstructions)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitSource(String source, String debug) {
        void var2_2;
        FileMapData[] mapping;
        super.visitSource(source, debug);
        String className = this.myContext.get(Key.CLASS_NAME);
        if (this.getOptions().isSaveSource) {
            this.mySource = this.myContext.getProjectContext().getFromPool(source);
        }
        if (debug != null && (mapping = JSR45Util.extractLineMapping((String)var2_2, className)) != null) {
            void var1_1;
            void var3_3;
            this.myContext.getProjectContext().addLineMaps((String)var3_3, (FileMapData[])var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitOuterClass(String outerClassName, String methodName, String methodSig) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getOptions().isSaveSource) {
            String fqnName = ClassNameUtil.convertToFQName(outerClassName);
            ClassData outerClass = this.myProjectData.getOrCreateClassData(this.myContext.getProjectContext().getFromPool(fqnName));
            if (outerClass.getSource() == null) {
                outerClass.setSource(this.mySource);
            }
        }
        super.visitOuterClass((String)var1_1, (String)var2_2, (String)var3_3);
    }

    private InstrumentationOptions getOptions() {
        return this.myContext.getProjectContext().getOptions();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MethodVisitor access$101(InstrumentationVisitor x0, int x1, String x2, String x3, String x4, String[] x5) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.visitMethod((int)var1_1, (String)var2_2, (String)var3_3, x4, x5);
    }

    private class HitsVisitor
    extends MethodVisitor {
        /*
         * WARNING - void declaration
         */
        public HitsVisitor(MethodVisitor methodVisitor) {
            void var2_2;
            super(589824, (MethodVisitor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void visitLineNumber(int line, Label start) {
            void var2_2;
            void var1_1;
            LineData lineData = InstrumentationVisitor.this.myContext.getLineData(line);
            if (lineData != null) {
                void var3_3;
                this.incrementHitById(var3_3.getId());
            }
            super.visitLineNumber((int)var1_1, (Label)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void visitLabel(Label label) {
            Switch aSwitch;
            super.visitLabel(label);
            Jump jump = InstrumentationVisitor.this.myContext.getJump(label);
            if (jump != null) {
                void var2_2;
                this.incrementHitById(var2_2.getId());
            }
            if ((aSwitch = InstrumentationVisitor.this.myContext.getSwitch(label)) != null) {
                void var1_1;
                this.incrementHitById(var1_1.getId());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void incrementHitById(int id) {
            void var1_1;
            if (id == -1) {
                return;
            }
            InstrumentationVisitor.this.myDataAccess.loadFromLocal();
            InstrumentationUtils.touchById(this.mv, (int)var1_1, ((InstrumentationVisitor)InstrumentationVisitor.this).getOptions().isCalculateHits);
        }
    }
}

