/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.offline;

import com.intellij.rt.coverage.offline.RawClassData;
import com.intellij.rt.coverage.offline.RawProjectData;
import com.intellij.rt.coverage.util.CommonArrayUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class RawHitsReport {
    private static final int MAGIC = 284996684;

    /*
     * WARNING - void declaration
     */
    static void dump(File file, RawProjectData data) {
        DataOutputStream os = null;
        try {
            void var1_3;
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            os = CoverageIOUtil.openWriteFile(file);
            RawHitsReport.dump(os, (RawProjectData)var1_3);
        }
        catch (Throwable e) {
            try {
                void var0_1;
                ErrorReporter.warn("Error during coverage report dump", (Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var2_4;
                CoverageIOUtil.close((Closeable)var2_4);
                throw throwable;
            }
            CoverageIOUtil.close(os);
            return;
        }
        CoverageIOUtil.close(os);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static void dump(DataOutput out, RawProjectData data) throws IOException {
        DataOutput dataOutput;
        Iterator<RawClassData> iterator;
        CoverageIOUtil.writeINT(out, 284996684);
        CoverageIOUtil.writeUTF(out, "");
        for (RawClassData classData : ((RawProjectData)((Object)iterator)).getClasses()) {
            void var3_3;
            void var2_2;
            int[] hits = CommonArrayUtil.getIntArray(classData.hits);
            if (hits == null || hits.length == 0) continue;
            CoverageIOUtil.writeUTF(out, var2_2.name);
            CoverageIOUtil.writeINT(out, hits.length);
            for (void hit : var3_3) {
                CoverageIOUtil.writeINT(out, (int)hit);
            }
        }
        CoverageIOUtil.writeUTF(dataOutput, "");
    }

    /*
     * WARNING - void declaration
     */
    public static RawProjectData load(File file2) throws IOException {
        void var1_4;
        RawProjectData projectData = new RawProjectData();
        DataInputStream is = null;
        try {
            String className;
            is = CoverageIOUtil.openReadFile(file2);
            int file2 = CoverageIOUtil.readINT(is);
            if (file2 != 284996684) {
                throw new IOException("This file is not in raw hits report format");
            }
            CoverageIOUtil.readUTFFast(is);
            while (!"".equals(className = CoverageIOUtil.readUTFFast(is))) {
                int length = CoverageIOUtil.readINT(is);
                int[] hits = (int[])projectData.getOrCreateClass((String)className, (int)length, (boolean)true).hits;
                for (int i = 0; i < length; ++i) {
                    hits[i] = CoverageIOUtil.readINT(is);
                }
            }
        }
        catch (Throwable throwable) {
            void var2_5;
            CoverageIOUtil.close((Closeable)var2_5);
            throw throwable;
        }
        CoverageIOUtil.close(is);
        return var1_4;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isRawHitsFile(File file) throws IOException {
        boolean throwable;
        DataInputStream is = null;
        try {
            File file2;
            is = CoverageIOUtil.openReadFile(file2);
            int bl = CoverageIOUtil.readINT(is);
            throwable = bl == 284996684;
        }
        catch (Throwable throwable2) {
            void var1_4;
            CoverageIOUtil.close((Closeable)var1_4);
            throw throwable2;
        }
        CoverageIOUtil.close(is);
        return throwable;
    }

    /*
     * WARNING - void declaration
     */
    public static void dumpOnExit(File file, RawProjectData data) {
        void var1_1;
        File file2;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable((RawProjectData)var1_1){
            final /* synthetic */ RawProjectData val$data;
            {
                this.val$data = rawProjectData;
            }

            public final void run() {
                RawHitsReport.dump(file2, this.val$data);
            }
        }));
    }
}

