/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.offline;

import com.intellij.rt.coverage.offline.RawHitsReport;
import com.intellij.rt.coverage.offline.RawProjectData;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.MethodCaller;
import java.io.File;

public class RawProjectInit {
    private static final MethodCaller INITIALIZER_METHOD_CALLER = new MethodCaller("inializeAndGetHitsMask", new Class[]{String.class, Integer.TYPE, Boolean.TYPE});
    private static final String KOVER_INITIALIZER_CLASS_NAME = "kotlinx.kover.offline.runtime.KoverInit";
    public static volatile RawProjectData ourProjectData;

    /*
     * WARNING - void declaration
     */
    public static int[] getOrCreateHits(String className, int length) {
        void var1_1;
        return (int[])RawProjectInit.getOrCreateHitsMaskInternal(className, (int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] getOrCreateHitsMask(String className, int length) {
        void var1_1;
        return (boolean[])RawProjectInit.getOrCreateHitsMaskInternal(className, (int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getOrCreateHitsMaskInternal(String className, int length, boolean hits) {
        if (ourProjectData != null) {
            return RawProjectInit.ourProjectData.getOrCreateClass((String)className, (int)length, (boolean)hits).hits;
        }
        try {
            try {
                return INITIALIZER_METHOD_CALLER.invokeStatic(RawProjectInit.class.getName(), new Object[]{className, length, hits}, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                void var2_3;
                return RawProjectInit.inializeAndGetHitsMask(className, length, (boolean)var2_3);
            }
        }
        catch (Exception e) {
            void var1_2;
            String string;
            ErrorReporter.error("Error in class data access: " + string, (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object inializeAndGetHitsMask(String className, int length, boolean hits) {
        void var2_2;
        void var1_1;
        String string;
        RawProjectInit.checkIsInitialized();
        return RawProjectInit.ourProjectData.getOrCreateClass((String)string, (int)var1_1, (boolean)var2_2).hits;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkIsInitialized() {
        if (ourProjectData == null) {
            Class<RawProjectData> clazz = RawProjectData.class;
            synchronized (RawProjectData.class) {
                if (ourProjectData == null) {
                    ourProjectData = new RawProjectData();
                    String filePath = System.getProperty("coverage.offline.report.path");
                    if (filePath != null) {
                        void var1_1;
                        File file = new File(filePath);
                        RawHitsReport.dumpOnExit(file, ourProjectData);
                        ErrorReporter.suggestBasePath(var1_1.getParent());
                    }
                    try {
                        Class.forName(KOVER_INITIALIZER_CLASS_NAME);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static RawProjectData getProjectData() {
        void var0;
        RawProjectData projectData = ourProjectData;
        if (projectData == null) {
            void var1_1;
            ClassLoader loader = RawProjectData.class.getClassLoader();
            ErrorReporter.error("Coverage data is null in RawProjectInit. This can be caused by accessing coverage data before tests' start. Alternatively, this could be a class loading issue: the data access method is called in class loaded by " + var1_1);
        }
        return var0;
    }
}

