/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.offline.api;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrument.RawReportLoader;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.instrumentation.UnloadedUtil;
import com.intellij.rt.coverage.instrumentation.data.ProjectContext;
import com.intellij.rt.coverage.offline.RawProjectData;
import com.intellij.rt.coverage.offline.api.ClassCoverage;
import com.intellij.rt.coverage.offline.api.LineCoverage;
import com.intellij.rt.coverage.offline.api.MethodCoverage;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageCollector {
    /*
     * WARNING - void declaration
     */
    static List<ClassCoverage> collect(RawProjectData rawData, ClassFinder classFinder) {
        void var2_2;
        Iterator<ClassData> iterator;
        ArrayList<ClassCoverage> classes = new ArrayList<ClassCoverage>();
        if (rawData == null) {
            return classes;
        }
        iterator = CoverageCollector.collectRawData((RawProjectData)((Object)iterator), classFinder);
        for (ClassData classData : ((ProjectData)((Object)iterator)).getClassesCollection()) {
            Map<String, List<LineData>> map;
            ClassCoverage classCoverage = new ClassCoverage(classData.getName(), classData.getSource());
            classes.add(classCoverage);
            map = ((ClassData)((Object)map)).mapLinesToMethods();
            for (Map.Entry entry : map.entrySet()) {
                List lines = (List)entry.getValue();
                MethodCoverage methodCoverage = new MethodCoverage((String)entry.getKey(), CoverageCollector.getMethodHits(lines));
                classCoverage.methods.add(methodCoverage);
                for (LineData lineData : lines) {
                    LineCoverage lineCoverage = CoverageCollector.collectLineCoverage(lineData);
                    methodCoverage.lines.add(lineCoverage);
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static ProjectData collectRawData(RawProjectData rawData, ClassFinder classFinder) {
        void var2_2;
        void var1_1;
        RawProjectData rawProjectData;
        void var3_3;
        ProjectData projectData = new ProjectData();
        InstrumentationOptions options = new InstrumentationOptions.Builder().setBranchCoverage(true).setSaveSource(true).build();
        ProjectContext context = new ProjectContext((InstrumentationOptions)var3_3, classFinder);
        UnloadedUtil.appendUnloaded(projectData, context);
        RawReportLoader.apply(projectData, rawProjectData);
        var1_1.finalizeCoverage(projectData);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static LineCoverage collectLineCoverage(LineData lineData) {
        void var1_3;
        SwitchData[] switches;
        LineCoverage lineCoverage = new LineCoverage(lineData.getLineNumber(), lineData.getHits());
        JumpData[] jumps = lineData.getJumps();
        if (jumps != null) {
            for (JumpData jump : jumps) {
                lineCoverage.branchHits.add(jump.getTrueHits());
                lineCoverage.branchHits.add(jump.getFalseHits());
            }
        }
        if ((switches = lineData.getSwitches()) != null) {
            int[] nArray;
            for (void switchData : nArray) {
                void var0_2;
                nArray = switchData.getHits();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int hits = nArray[i];
                    lineCoverage.branchHits.add(hits);
                }
                lineCoverage.branchHits.add(var0_2.getDefaultHits());
            }
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMethodHits(List<LineData> lines) {
        for (LineData lineData : lines) {
            void var1_1;
            int hits = lineData.getHits();
            if (hits <= 0) continue;
            return (int)var1_1;
        }
        return 0;
    }
}

