/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.offline.api;

import com.intellij.rt.coverage.offline.RawHitsReport;
import com.intellij.rt.coverage.offline.RawProjectData;
import com.intellij.rt.coverage.offline.RawProjectInit;
import com.intellij.rt.coverage.offline.api.ClassCoverage;
import com.intellij.rt.coverage.offline.api.CoverageCollector;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import com.intellij.rt.coverage.util.classFinder.OutputClassFinder;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageRuntime {
    /*
     * WARNING - void declaration
     */
    public static List<ClassCoverage> collectInRoots(List<File> roots) {
        OutputClassFinder outputClassFinder;
        void var1_1;
        RawProjectData projectData = CoverageRuntime.getProjectData();
        OutputClassFinder classFinder = new OutputClassFinder(null, roots);
        return CoverageCollector.collect((RawProjectData)var1_1, outputClassFinder);
    }

    /*
     * WARNING - void declaration
     */
    public static List<ClassCoverage> collectClassfileData(List<byte[]> classFiles) {
        ClassListFinder classListFinder;
        void var1_1;
        RawProjectData projectData = CoverageRuntime.getProjectData();
        ClassListFinder classFinder = new ClassListFinder(null, classFiles);
        return CoverageCollector.collect((RawProjectData)var1_1, classListFinder);
    }

    public static void setLogPath(File errorFile) {
        File file;
        ErrorReporter.setPath(errorFile == null ? null : file.getPath());
    }

    public static void setLogLevel(int level) {
        ErrorReporter.setLogLevel(level);
    }

    public static void dumpIcReport(DataOutput output) throws IOException {
        RawHitsReport.dump(output, CoverageRuntime.getProjectData());
    }

    private static RawProjectData getProjectData() {
        return RawProjectInit.getProjectData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassListFinder
    extends ClassFinder {
        private final List<byte[]> classFiles;

        /*
         * WARNING - void declaration
         */
        public ClassListFinder(ClassFilter filter, List<byte[]> classFiles) {
            super((ClassFilter)var1_1);
            void var2_2;
            void var1_1;
            this.classFiles = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void iterateMatchedClasses(ClassEntry.Consumer consumer) {
            for (byte[] classFile : this.classFiles) {
                void var3_3;
                ClassReader classReader = new ClassReader(classFile);
                String className = ClassNameUtil.convertToFQName(classReader.getClassName());
                consumer.consume(new ClassFileEntry(className, (byte[])var3_3));
            }
        }
    }

    private static class ClassFileEntry
    extends ClassEntry {
        private final byte[] classFile;

        /*
         * WARNING - void declaration
         */
        public ClassFileEntry(String className, byte[] classFile) {
            super((String)var1_1);
            void var2_2;
            void var1_1;
            this.classFile = var2_2;
        }

        public InputStream getClassInputStream() {
            return new ByteArrayInputStream(this.classFile);
        }
    }
}

