/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.offline.runtime;

import com.intellij.rt.coverage.offline.api.CoverageRuntime;
import java.io.File;
import kotlinx.kover.offline.runtime.api.KoverRuntime;

class KoverInit {
    private static void saveOnExit(final String fileName) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    KoverRuntime.saveReport(new File(fileName));
                }
                catch (Throwable e) {
                    System.err.println("Kover error: failed to save report file '" + fileName + "': " + e.getMessage());
                }
            }
        }));
    }

    private KoverInit() {
    }

    static {
        String logFileProp = System.getProperty("kover.offline.log.file.path");
        if (logFileProp == null) {
            CoverageRuntime.setLogPath(null);
        } else {
            CoverageRuntime.setLogPath(new File(logFileProp));
        }
        CoverageRuntime.setLogLevel(2);
        String reportNameSavedOnExitProp = System.getProperty("kover.offline.report.path");
        if (reportNameSavedOnExitProp != null) {
            KoverInit.saveOnExit(reportNameSavedOnExitProp);
        }
    }
}

