/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.offline.runtime.api;

import com.intellij.rt.coverage.offline.api.CoverageRuntime;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlinx.kover.offline.runtime.api.BranchCoverage;
import kotlinx.kover.offline.runtime.api.ClassCoverage;
import kotlinx.kover.offline.runtime.api.LineCoverage;
import kotlinx.kover.offline.runtime.api.MethodCoverage;

public class KoverRuntime {
    public static final String REPORT_PROPERTY_NAME = "kover.offline.report.path";
    public static final String LOG_FILE_PROPERTY_NAME = "kover.offline.log.file.path";

    public static List<ClassCoverage> collectByDirs(List<File> classFileRoots) {
        return KoverRuntime.convertClasses(CoverageRuntime.collectInRoots(classFileRoots));
    }

    public static List<ClassCoverage> collect(List<byte[]> classFiles) {
        return KoverRuntime.convertClasses(CoverageRuntime.collectClassfileData(classFiles));
    }

    public static void saveReport(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
             DataOutputStream outputStream = new DataOutputStream(out);){
            CoverageRuntime.dumpIcReport(outputStream);
        }
    }

    public static byte[] getReport() throws IOException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        try (DataOutputStream outputStream = new DataOutputStream(byteArrayStream);){
            CoverageRuntime.dumpIcReport(outputStream);
        }
        return byteArrayStream.toByteArray();
    }

    private static List<ClassCoverage> convertClasses(List<com.intellij.rt.coverage.offline.api.ClassCoverage> origins) {
        ArrayList<ClassCoverage> result = new ArrayList<ClassCoverage>(origins.size());
        for (com.intellij.rt.coverage.offline.api.ClassCoverage classCoverage : origins) {
            result.add(KoverRuntime.convertClass(classCoverage));
        }
        return result;
    }

    private static ClassCoverage convertClass(com.intellij.rt.coverage.offline.api.ClassCoverage origin) {
        List<com.intellij.rt.coverage.offline.api.MethodCoverage> originMethods = origin.methods;
        ArrayList<MethodCoverage> methods = new ArrayList<MethodCoverage>(originMethods.size());
        for (com.intellij.rt.coverage.offline.api.MethodCoverage methodCoverage : originMethods) {
            methods.add(KoverRuntime.convertMethod(methodCoverage));
        }
        ClassCoverage result = new ClassCoverage();
        result.className = origin.className;
        result.fileName = origin.fileName;
        result.methods = methods;
        return result;
    }

    private static MethodCoverage convertMethod(com.intellij.rt.coverage.offline.api.MethodCoverage origin) {
        List<com.intellij.rt.coverage.offline.api.LineCoverage> originLines = origin.lines;
        ArrayList<LineCoverage> lines = new ArrayList<LineCoverage>();
        for (com.intellij.rt.coverage.offline.api.LineCoverage lineCoverage : originLines) {
            lines.add(KoverRuntime.convertLine(lineCoverage));
        }
        MethodCoverage result = new MethodCoverage();
        result.signature = origin.signature;
        result.hit = origin.hits;
        result.lines = lines;
        return result;
    }

    private static LineCoverage convertLine(com.intellij.rt.coverage.offline.api.LineCoverage origin) {
        List<Integer> branchHits = origin.branchHits;
        ArrayList<BranchCoverage> branches = new ArrayList<BranchCoverage>(branchHits.size());
        for (int i = 0; i < branchHits.size(); ++i) {
            BranchCoverage branch = new BranchCoverage();
            branch.branchNumber = i;
            branch.hit = branchHits.get(i);
            branches.add(branch);
        }
        LineCoverage result = new LineCoverage();
        result.lineNumber = origin.lineNumber;
        result.hit = origin.hits;
        result.branches = branches;
        return result;
    }
}

