/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.engines.intellij;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.api.KoverExtension;
import kotlinx.kover.engines.intellij.IntellijAgent;
import kotlinx.kover.engines.intellij.IntellijEngineVersion;
import kotlinx.kover.engines.intellij.VersionsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"createIntellijAgent", "Lkotlinx/kover/engines/intellij/IntellijAgent;", "Lorg/gradle/api/Project;", "koverExtension", "Lkotlinx/kover/api/KoverExtension;", "createIntellijConfig", "Lorg/gradle/api/artifacts/Configuration;", "kover"})
public final class IntellijAgentKt {
    @NotNull
    public static final IntellijAgent createIntellijAgent(@NotNull Project $this$createIntellijAgent, @NotNull KoverExtension koverExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$createIntellijAgent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)koverExtension, (String)"koverExtension");
        Configuration intellijConfig = IntellijAgentKt.createIntellijConfig($this$createIntellijAgent, koverExtension);
        return new IntellijAgent(intellijConfig);
    }

    private static final Configuration createIntellijConfig(Project $this$createIntellijConfig, KoverExtension koverExtension) {
        Configuration config = (Configuration)$this$createIntellijConfig.getProject().getConfigurations().create("IntellijKoverConfig");
        config.setVisible(false);
        config.setTransitive(true);
        config.setDescription("Kotlin Kover Plugin configuration for IntelliJ agent and reporter");
        config.defaultDependencies(arg_0 -> IntellijAgentKt.createIntellijConfig$lambda-1(koverExtension, $this$createIntellijConfig, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
        return config;
    }

    private static final void createIntellijConfig$lambda-1(KoverExtension $koverExtension, Project $this_createIntellijConfig, DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)$koverExtension, (String)"$koverExtension");
        Intrinsics.checkNotNullParameter((Object)$this_createIntellijConfig, (String)"$this_createIntellijConfig");
        String agentVersion = (String)$koverExtension.getIntellijEngineVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)agentVersion, (String)"agentVersion");
        IntellijEngineVersion intellijEngineVersion = IntellijEngineVersion.Companion.parseOrNull(agentVersion);
        if (intellijEngineVersion != null) {
            IntellijEngineVersion intellijEngineVersion2 = intellijEngineVersion;
            boolean bl = false;
            boolean bl2 = false;
            IntellijEngineVersion it = intellijEngineVersion2;
            boolean bl3 = false;
            if (it.compareTo(VersionsKt.getMinimalIntellijVersion()) < 0) {
                throw new GradleException("IntelliJ engine version " + it + " is too low, minimal version is " + VersionsKt.getMinimalIntellijVersion());
            }
        }
        dependencies.add((Object)$this_createIntellijConfig.getDependencies().create((Object)Intrinsics.stringPlus((String)"org.jetbrains.intellij.deps:intellij-coverage-agent:", (Object)agentVersion)));
        dependencies.add((Object)$this_createIntellijConfig.getDependencies().create((Object)Intrinsics.stringPlus((String)"org.jetbrains.intellij.deps:intellij-coverage-reporter:", (Object)agentVersion)));
    }
}

