/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.api.CoverageEngine;
import kotlinx.kover.engines.intellij.IntelliJCoverageKt;
import kotlinx.kover.engines.jacoco.JacocoCoverageKt;
import kotlinx.kover.tasks.KoverCommonTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lkotlinx/kover/tasks/KoverHtmlReportTask;", "Lkotlinx/kover/tasks/KoverCommonTask;", "()V", "htmlReportDir", "Lorg/gradle/api/file/DirectoryProperty;", "getHtmlReportDir", "()Lorg/gradle/api/file/DirectoryProperty;", "generate", "", "kover"})
public class KoverHtmlReportTask
extends KoverCommonTask {
    @NotNull
    private final DirectoryProperty htmlReportDir;

    public KoverHtmlReportTask() {
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.htmlReportDir = directoryProperty;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getHtmlReportDir() {
        return this.htmlReportDir;
    }

    @TaskAction
    public final void generate() {
        File htmlDirFile = ((Directory)this.htmlReportDir.get()).getAsFile();
        if (this.getCoverageEngine$kover().get() == CoverageEngine.INTELLIJ) {
            Task task = (Task)this;
            Object object = this.getBinaryReportFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binaryReportFiles.get()");
            Iterable iterable = (Iterable)object;
            object = this.getSrcDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"srcDirs.get()");
            Iterable iterable2 = (Iterable)object;
            object = this.getOutputDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDirs.get()");
            Iterable iterable3 = (Iterable)object;
            object = this.getClasspath$kover().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classpath.get()");
            IntelliJCoverageKt.intellijReport(task, iterable, iterable2, iterable3, null, htmlDirFile, (FileCollection)object);
        } else {
            Task task = (Task)this;
            Object object = this.getBinaryReportFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binaryReportFiles.get()");
            Iterable iterable = (Iterable)object;
            object = this.getSrcDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"srcDirs.get()");
            Iterable iterable4 = (Iterable)object;
            object = this.getOutputDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDirs.get()");
            Iterable iterable5 = (Iterable)object;
            object = this.getClasspath$kover().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classpath.get()");
            JacocoCoverageKt.jacocoReport(task, iterable, iterable4, iterable5, (FileCollection)object, null, htmlDirFile);
        }
        this.getProject().getLogger().lifecycle("Kover: HTML report for '" + this.getProject().getName() + "' file://" + htmlDirFile.getCanonicalPath() + "/index.html");
    }
}

