/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.kover.AllProviders;
import kotlinx.kover.CoverageArgumentProvider;
import kotlinx.kover.IntellijErrorLogChecker;
import kotlinx.kover.KoverPlugin;
import kotlinx.kover.ProjectProviders;
import kotlinx.kover.ProvidersKt;
import kotlinx.kover.adapters.PluginAdaptersFactoryKt;
import kotlinx.kover.api.CoverageEngine;
import kotlinx.kover.api.KoverExtension;
import kotlinx.kover.api.KoverTaskExtension;
import kotlinx.kover.engines.commons.AgentsFactory;
import kotlinx.kover.engines.commons.CoverageAgent;
import kotlinx.kover.engines.intellij.VersionsKt;
import kotlinx.kover.tasks.KoverCollectingTask;
import kotlinx.kover.tasks.KoverHtmlReportTask;
import kotlinx.kover.tasks.KoverMergedHtmlReportTask;
import kotlinx.kover.tasks.KoverMergedTask;
import kotlinx.kover.tasks.KoverMergedVerificationTask;
import kotlinx.kover.tasks.KoverMergedXmlReportTask;
import kotlinx.kover.tasks.KoverProjectTask;
import kotlinx.kover.tasks.KoverVerificationTask;
import kotlinx.kover.tasks.KoverXmlReportTask;
import kotlinx.kover.tasks.NestedFiles;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J(\u0010\t\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\f\u0010\u0010\u001a\u00020\u0007*\u00020\u0002H\u0002J(\u0010\u0011\u001a\u00020\u0007*\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0002H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0002H\u0002JM\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u0018*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u00070\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJU\u0010\u001f\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020 *\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u00070\u001dH\u0002\u00a2\u0006\u0002\u0010#J\u0014\u0010$\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lkotlinx/kover/KoverPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "defaultJacocoVersion", "", "apply", "", "target", "applyToProject", "providers", "Lkotlinx/kover/AllProviders;", "agents", "", "Lkotlinx/kover/api/CoverageEngine;", "Lkotlinx/kover/engines/commons/CoverageAgent;", "checkAlreadyApplied", "configTest", "Lorg/gradle/api/tasks/testing/Test;", "createCollectingTask", "createKoverExtension", "Lkotlinx/kover/api/KoverExtension;", "createKoverMergedTask", "T", "Lkotlinx/kover/tasks/KoverMergedTask;", "taskName", "type", "Lkotlin/reflect/KClass;", "block", "Lkotlin/Function1;", "(Lorg/gradle/api/Project;Ljava/lang/String;Lkotlin/reflect/KClass;Lkotlinx/kover/AllProviders;Lkotlin/jvm/functions/Function1;)Lkotlinx/kover/tasks/KoverMergedTask;", "createKoverProjectTask", "Lkotlinx/kover/tasks/KoverProjectTask;", "projectProviders", "Lkotlinx/kover/ProjectProviders;", "(Lorg/gradle/api/Project;Ljava/lang/String;Lkotlin/reflect/KClass;Lkotlinx/kover/AllProviders;Lkotlinx/kover/ProjectProviders;Lkotlin/jvm/functions/Function1;)Lkotlinx/kover/tasks/KoverProjectTask;", "createMergedTasks", "kover"})
public final class KoverPlugin
implements Plugin<Project> {
    @NotNull
    private final String defaultJacocoVersion;

    public KoverPlugin() {
        this.defaultJacocoVersion = "0.8.7";
    }

    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.checkAlreadyApplied(target);
        KoverExtension koverExtension = this.createKoverExtension(target);
        Map<CoverageEngine, CoverageAgent> agents = AgentsFactory.INSTANCE.createAgents(target, koverExtension);
        AllProviders providers = ProvidersKt.createProviders(target, agents);
        target.allprojects(arg_0 -> KoverPlugin.apply$lambda-0(this, providers, agents, arg_0));
        this.createCollectingTask(target);
        this.createMergedTasks(target, providers);
    }

    private final void applyToProject(Project $this$applyToProject, AllProviders providers, Map<CoverageEngine, ? extends CoverageAgent> agents) {
        ProjectProviders projectProviders = providers.getProjects().get($this$applyToProject.getName());
        if (projectProviders == null) {
            throw new GradleException("Kover: Providers for project '" + $this$applyToProject.getName() + "' was not found");
        }
        ProjectProviders projectProviders2 = projectProviders;
        KoverXmlReportTask xmlReportTask2 = (KoverXmlReportTask)((Object)this.createKoverProjectTask($this$applyToProject, "koverXmlReport", Reflection.getOrCreateKotlinClass(KoverXmlReportTask.class), providers, projectProviders2, (Function1)new Function1<KoverXmlReportTask, Unit>($this$applyToProject){
            final /* synthetic */ Project $this_applyToProject;
            {
                this.$this_applyToProject = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KoverXmlReportTask it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                it.getXmlReportFile().set(this.$this_applyToProject.getLayout().getBuildDirectory().file("reports/kover/project-xml/report.xml"));
                it.setDescription("Generates code coverage XML report for all enabled test tasks in one project.");
            }
        }));
        KoverHtmlReportTask htmlReportTask2 = (KoverHtmlReportTask)((Object)this.createKoverProjectTask($this$applyToProject, "koverHtmlReport", Reflection.getOrCreateKotlinClass(KoverHtmlReportTask.class), providers, projectProviders2, applyToProject.htmlReportTask.1.INSTANCE));
        KoverVerificationTask verifyTask2 = (KoverVerificationTask)((Object)this.createKoverProjectTask($this$applyToProject, "koverVerify", Reflection.getOrCreateKotlinClass(KoverVerificationTask.class), providers, projectProviders2, applyToProject.verifyTask.1.INSTANCE));
        $this$applyToProject.getTasks().create("koverReport", arg_0 -> KoverPlugin.applyToProject$lambda-1(xmlReportTask2, htmlReportTask2, arg_0));
        $this$applyToProject.getTasks().configureEach(arg_0 -> KoverPlugin.applyToProject$lambda-2(verifyTask2, arg_0));
        $this$applyToProject.getTasks().withType(Test.class).configureEach(arg_0 -> KoverPlugin.applyToProject$lambda-3(this, providers, agents, arg_0));
    }

    private final void createMergedTasks(Project $this$createMergedTasks, AllProviders providers) {
        KoverMergedXmlReportTask xmlReportTask2 = (KoverMergedXmlReportTask)((Object)this.createKoverMergedTask($this$createMergedTasks, "koverMergedXmlReport", Reflection.getOrCreateKotlinClass(KoverMergedXmlReportTask.class), providers, (Function1)new Function1<KoverMergedXmlReportTask, Unit>($this$createMergedTasks){
            final /* synthetic */ Project $this_createMergedTasks;
            {
                this.$this_createMergedTasks = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KoverMergedXmlReportTask it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                it.getXmlReportFile().set(this.$this_createMergedTasks.getLayout().getBuildDirectory().file("reports/kover/report.xml"));
                it.setDescription("Generates code coverage XML report for all enabled test tasks in all projects.");
            }
        }));
        KoverMergedHtmlReportTask htmlReportTask2 = (KoverMergedHtmlReportTask)((Object)this.createKoverMergedTask($this$createMergedTasks, "koverMergedHtmlReport", Reflection.getOrCreateKotlinClass(KoverMergedHtmlReportTask.class), providers, (Function1)new Function1<KoverMergedHtmlReportTask, Unit>($this$createMergedTasks){
            final /* synthetic */ Project $this_createMergedTasks;
            {
                this.$this_createMergedTasks = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KoverMergedHtmlReportTask it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                it.getHtmlReportDir().set(this.$this_createMergedTasks.getLayout().getBuildDirectory().dir("reports/kover/html"));
                it.setDescription("Generates code coverage HTML report for all enabled test tasks in all projects.");
            }
        }));
        Task reportTask = (Task)$this$createMergedTasks.getTasks().create("koverMergedReport", arg_0 -> KoverPlugin.createMergedTasks$lambda-4(xmlReportTask2, htmlReportTask2, arg_0));
        KoverMergedVerificationTask verifyTask2 = (KoverMergedVerificationTask)((Object)this.createKoverMergedTask($this$createMergedTasks, "koverMergedVerify", Reflection.getOrCreateKotlinClass(KoverMergedVerificationTask.class), providers, createMergedTasks.verifyTask.1.INSTANCE));
        $this$createMergedTasks.getTasks().configureEach(arg_0 -> KoverPlugin.createMergedTasks$lambda-6($this$createMergedTasks, reportTask, verifyTask2, arg_0));
    }

    private final <T extends KoverMergedTask> T createKoverMergedTask(Project $this$createKoverMergedTask, String taskName, KClass<T> type, AllProviders providers, Function1<? super T, Unit> block) {
        Task task = $this$createKoverMergedTask.getTasks().create(taskName, JvmClassMappingKt.getJavaClass(type), arg_0 -> KoverPlugin.createKoverMergedTask$lambda-8(providers, block, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"tasks.create(taskName, t\u2026    block(task)\n        }");
        return (T)((Object)((KoverMergedTask)task));
    }

    private final void createCollectingTask(Project $this$createCollectingTask) {
        $this$createCollectingTask.getTasks().create("koverCollectReports", KoverCollectingTask.class, arg_0 -> KoverPlugin.createCollectingTask$lambda-11($this$createCollectingTask, arg_0));
    }

    private final <T extends KoverProjectTask> T createKoverProjectTask(Project $this$createKoverProjectTask, String taskName, KClass<T> type, AllProviders providers, ProjectProviders projectProviders, Function1<? super T, Unit> block) {
        Task task = $this$createKoverProjectTask.getTasks().create(taskName, JvmClassMappingKt.getJavaClass(type), arg_0 -> KoverPlugin.createKoverProjectTask$lambda-14(providers, projectProviders, block, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"tasks.create(taskName, t\u2026    block(task)\n        }");
        return (T)((Object)((KoverProjectTask)task));
    }

    private final KoverExtension createKoverExtension(Project $this$createKoverExtension) {
        Object[] objectArray = new Object[]{$this$createKoverExtension.getObjects()};
        KoverExtension extension = (KoverExtension)$this$createKoverExtension.getExtensions().create("kover", KoverExtension.class, objectArray);
        extension.setDisabled(false);
        extension.getCoverageEngine().set((Object)CoverageEngine.INTELLIJ);
        extension.getIntellijEngineVersion().set((Object)VersionsKt.getDefaultIntellijVersion().toString());
        extension.getJacocoEngineVersion().set((Object)this.defaultJacocoVersion);
        Intrinsics.checkNotNullExpressionValue((Object)extension, (String)"extension");
        return extension;
    }

    private final void configTest(Test $this$configTest, AllProviders providers, Map<CoverageEngine, ? extends CoverageAgent> agents) {
        Object[] objectArray = new Object[]{$this$configTest.getProject().getObjects()};
        KoverTaskExtension taskExtension = (KoverTaskExtension)$this$configTest.getExtensions().create("kover", KoverTaskExtension.class, objectArray);
        taskExtension.setDisabled(false);
        taskExtension.getBinaryReportFile().set($this$configTest.getProject().provider(() -> KoverPlugin.configTest$lambda-15(providers, $this$configTest)));
        Provider excludeAndroidPackages = $this$configTest.getProject().provider(() -> KoverPlugin.configTest$lambda-16($this$configTest, providers));
        List list = $this$configTest.getJvmArgumentProviders();
        Task task = (Task)$this$configTest;
        Provider<KoverExtension> provider = providers.getKoverExtension();
        Intrinsics.checkNotNullExpressionValue((Object)excludeAndroidPackages, (String)"excludeAndroidPackages");
        list.add(new CoverageArgumentProvider(task, agents, provider, (Provider<Boolean>)excludeAndroidPackages));
        Intrinsics.checkNotNullExpressionValue((Object)taskExtension, (String)"taskExtension");
        $this$configTest.doLast((Action)new IntellijErrorLogChecker(taskExtension));
    }

    private final void checkAlreadyApplied(Project $this$checkAlreadyApplied) {
        Project parent = $this$checkAlreadyApplied.getParent();
        while (parent != null) {
            if (parent.getPlugins().hasPlugin(KoverPlugin.class)) {
                throw new GradleException("Kover plugin is applied in both parent project '" + parent.getName() + "' and child project '" + $this$checkAlreadyApplied.getName() + "'. Kover plugin should be applied only in parent project.");
            }
            parent = $this$checkAlreadyApplied.getParent();
        }
    }

    private static final void apply$lambda-0(KoverPlugin this$0, AllProviders $providers, Map $agents, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$providers, (String)"$providers");
        Intrinsics.checkNotNullParameter((Object)$agents, (String)"$agents");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.applyToProject(it, $providers, $agents);
    }

    private static final void applyToProject$lambda-1(KoverXmlReportTask $xmlReportTask, KoverHtmlReportTask $htmlReportTask, Task it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$xmlReportTask), (String)"$xmlReportTask");
        Intrinsics.checkNotNullParameter((Object)((Object)$htmlReportTask), (String)"$htmlReportTask");
        it.setGroup("verification");
        Object[] objectArray = new Object[]{$xmlReportTask};
        it.dependsOn(objectArray);
        objectArray = new Object[]{$htmlReportTask};
        it.dependsOn(objectArray);
        it.setDescription("Generates code coverage HTML and XML reports for all enabled test tasks in one project.");
    }

    private static final void applyToProject$lambda-2(KoverVerificationTask $verifyTask, Task it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$verifyTask), (String)"$verifyTask");
        if (Intrinsics.areEqual((Object)it.getName(), (Object)"check")) {
            Object[] objectArray = new Object[]{$verifyTask};
            it.dependsOn(objectArray);
        }
    }

    private static final void applyToProject$lambda-3(KoverPlugin this$0, AllProviders $providers, Map $agents, Test t) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$providers, (String)"$providers");
        Intrinsics.checkNotNullParameter((Object)$agents, (String)"$agents");
        Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
        this$0.configTest(t, $providers, $agents);
    }

    private static final void createMergedTasks$lambda-4(KoverMergedXmlReportTask $xmlReportTask, KoverMergedHtmlReportTask $htmlReportTask, Task it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$xmlReportTask), (String)"$xmlReportTask");
        Intrinsics.checkNotNullParameter((Object)((Object)$htmlReportTask), (String)"$htmlReportTask");
        it.setGroup("verification");
        Object[] objectArray = new Object[]{$xmlReportTask};
        it.dependsOn(objectArray);
        objectArray = new Object[]{$htmlReportTask};
        it.dependsOn(objectArray);
        it.setDescription("Generates code coverage HTML and XML reports for all enabled test tasks in all projects.");
    }

    private static final List createMergedTasks$lambda-6$lambda-5(Project $this_createMergedTasks, Task $reportTask, KoverMergedVerificationTask $verifyTask) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this_createMergedTasks, (String)"$this_createMergedTasks");
        Intrinsics.checkNotNullParameter((Object)((Object)$verifyTask), (String)"$verifyTask");
        KoverExtension koverExtension = (KoverExtension)$this_createMergedTasks.getExtensions().getByType(KoverExtension.class);
        if (koverExtension.getGenerateReportOnCheck()) {
            Object[] objectArray = new Task[]{$reportTask, (Task)$verifyTask};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)((Object)$verifyTask));
        }
        return list;
    }

    private static final void createMergedTasks$lambda-6(Project $this_createMergedTasks, Task $reportTask, KoverMergedVerificationTask $verifyTask, Task it) {
        Intrinsics.checkNotNullParameter((Object)$this_createMergedTasks, (String)"$this_createMergedTasks");
        Intrinsics.checkNotNullParameter((Object)((Object)$verifyTask), (String)"$verifyTask");
        if (Intrinsics.areEqual((Object)it.getName(), (Object)"check")) {
            Object[] objectArray = new Object[]{$this_createMergedTasks.provider(() -> KoverPlugin.createMergedTasks$lambda-6$lambda-5($this_createMergedTasks, $reportTask, $verifyTask))};
            it.dependsOn(objectArray);
        }
    }

    private static final void createKoverMergedTask$lambda-8(AllProviders $providers, Function1 $block, KoverMergedTask task) {
        Intrinsics.checkNotNullParameter((Object)$providers, (String)"$providers");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        task.setGroup("verification");
        Map<String, ProjectProviders> $this$forEach$iv = $providers.getProjects();
        boolean $i$f$forEach = false;
        Map<String, ProjectProviders> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ProjectProviders>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            ObjectFactory element$iv;
            ObjectFactory $dstr$projectName$m = element$iv = iterator.next();
            boolean bl2 = false;
            ObjectFactory objectFactory = $dstr$projectName$m;
            boolean bl3 = false;
            String projectName = objectFactory.getKey();
            ObjectFactory objectFactory2 = $dstr$projectName$m;
            boolean bl4 = false;
            ProjectProviders m = objectFactory2.getValue();
            MapProperty<String, NestedFiles> mapProperty = task.getBinaryReportFiles();
            objectFactory2 = task.getProject().getObjects();
            Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"task.project.objects");
            mapProperty.put((Object)projectName, (Object)new NestedFiles(objectFactory2, m.getReports()));
            MapProperty<String, NestedFiles> mapProperty2 = task.getSrcDirs();
            objectFactory2 = task.getProject().getObjects();
            Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"task.project.objects");
            mapProperty2.put((Object)projectName, (Object)new NestedFiles(objectFactory2, m.getSources()));
            MapProperty<String, NestedFiles> mapProperty3 = task.getOutputDirs();
            objectFactory2 = task.getProject().getObjects();
            Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"task.project.objects");
            mapProperty3.put((Object)projectName, (Object)new NestedFiles(objectFactory2, m.getOutput()));
        }
        task.getCoverageEngine$kover().set($providers.getEngine());
        task.getClasspath$kover().set($providers.getClasspath());
        Object[] objectArray = new Object[]{$providers.getMerged().getTests()};
        task.dependsOn(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)task), (String)"task");
        $block.invoke((Object)task);
    }

    private static final boolean createCollectingTask$lambda-11$lambda-9(Task it) {
        return false;
    }

    private static final void createCollectingTask$lambda-11$lambda-10(KoverCollectingTask $task, Project proj) {
        KoverXmlReportTask xmlReportTask2 = (KoverXmlReportTask)proj.getTasks().withType(KoverXmlReportTask.class).getByName("koverXmlReport");
        KoverHtmlReportTask htmlReportTask2 = (KoverHtmlReportTask)proj.getTasks().withType(KoverHtmlReportTask.class).getByName("koverHtmlReport");
        Object object = new Object[]{xmlReportTask2};
        $task.mustRunAfter((Object[])object);
        object = new Object[]{htmlReportTask2};
        $task.mustRunAfter((Object[])object);
        object = $task.getXmlFiles$kover();
        String string = proj.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proj.name");
        RegularFileProperty regularFileProperty = xmlReportTask2.getXmlReportFile();
        boolean bl = false;
        object.put(string, regularFileProperty);
        object = $task.getHtmlDirs$kover();
        string = proj.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proj.name");
        regularFileProperty = htmlReportTask2.getHtmlReportDir();
        bl = false;
        object.put(string, regularFileProperty);
    }

    private static final void createCollectingTask$lambda-11(Project $this_createCollectingTask, KoverCollectingTask task) {
        Intrinsics.checkNotNullParameter((Object)$this_createCollectingTask, (String)"$this_createCollectingTask");
        task.setGroup("verification");
        task.setDescription("Collects all projects reports into one directory.");
        task.getOutputDir().set($this_createCollectingTask.getProject().getLayout().getBuildDirectory().dir("reports/kover/projects"));
        task.getOutputs().upToDateWhen(KoverPlugin::createCollectingTask$lambda-11$lambda-9);
        $this_createCollectingTask.allprojects(arg_0 -> KoverPlugin.createCollectingTask$lambda-11$lambda-10(task, arg_0));
    }

    private static final boolean createKoverProjectTask$lambda-14$lambda-12(ProjectProviders $projectProviders, Task it) {
        Intrinsics.checkNotNullParameter((Object)$projectProviders, (String)"$projectProviders");
        return (Boolean)$projectProviders.getDisabled().get() == false;
    }

    private static final boolean createKoverProjectTask$lambda-14$lambda-13(KoverProjectTask $task, Task it) {
        return !((FileCollection)$task.getBinaryReportFiles().get()).isEmpty();
    }

    private static final void createKoverProjectTask$lambda-14(AllProviders $providers, ProjectProviders $projectProviders, Function1 $block, KoverProjectTask task) {
        Intrinsics.checkNotNullParameter((Object)$providers, (String)"$providers");
        Intrinsics.checkNotNullParameter((Object)$projectProviders, (String)"$projectProviders");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        task.setGroup("verification");
        task.getCoverageEngine$kover().set($providers.getEngine());
        task.getClasspath$kover().set($providers.getClasspath());
        task.getSrcDirs().set($projectProviders.getSources());
        task.getOutputDirs().set($projectProviders.getOutput());
        task.getBinaryReportFiles().set($projectProviders.getReports());
        Object[] objectArray = new Object[]{$projectProviders.getTests()};
        task.dependsOn(objectArray);
        task.onlyIf(arg_0 -> KoverPlugin.createKoverProjectTask$lambda-14$lambda-12($projectProviders, arg_0));
        task.onlyIf(arg_0 -> KoverPlugin.createKoverProjectTask$lambda-14$lambda-13(task, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)task), (String)"task");
        $block.invoke((Object)task);
    }

    private static final File configTest$lambda-15(AllProviders $providers, Test $this_configTest) {
        Intrinsics.checkNotNullParameter((Object)$providers, (String)"$providers");
        Intrinsics.checkNotNullParameter((Object)$this_configTest, (String)"$this_configTest");
        KoverExtension koverExtension = (KoverExtension)$providers.getKoverExtension().get();
        String suffix = koverExtension.getCoverageEngine().get() == CoverageEngine.INTELLIJ ? ".ic" : ".exec";
        return ((Directory)$this_configTest.getProject().getLayout().getBuildDirectory().get()).file("kover/" + $this_configTest.getName() + suffix).getAsFile();
    }

    private static final Boolean configTest$lambda-16(Test $this_configTest, AllProviders $providers) {
        Intrinsics.checkNotNullParameter((Object)$this_configTest, (String)"$this_configTest");
        Intrinsics.checkNotNullParameter((Object)$providers, (String)"$providers");
        Project project = $this_configTest.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return PluginAdaptersFactoryKt.getAndroidPluginIsApplied(project) && !((KoverExtension)$providers.getKoverExtension().get()).getInstrumentAndroidPackage();
    }
}

