/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.engines.intellij;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u0007"}, d2={"getIntellijDependencies", "", "", "engineVersion", "isLowVersion", "", "minimalVersion", "kover"})
public final class IntellijEngineKt {
    @NotNull
    public static final List<String> getIntellijDependencies(@NotNull String engineVersion) {
        Intrinsics.checkNotNullParameter((Object)engineVersion, (String)"engineVersion");
        if (IntellijEngineKt.isLowVersion(engineVersion, "1.0.680")) {
            throw (Throwable)new GradleException("IntelliJ engine version " + engineVersion + " is too low, minimal version is 1.0.680");
        }
        return CollectionsKt.listOf((Object[])new String[]{"org.jetbrains.intellij.deps:intellij-coverage-agent:" + engineVersion, "org.jetbrains.intellij.deps:intellij-coverage-reporter:" + engineVersion});
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isLowVersion(String $this$isLowVersion, String minimalVersion) {
        List customParts = StringsKt.split$default((CharSequence)$this$isLowVersion, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        if (customParts.size() != 3) {
            throw (Throwable)new GradleException("Invalid custom IntelliJ Coverage Engine version '" + $this$isLowVersion + "'. Expected 'x.x.xxx'");
        }
        List minimalParts = StringsKt.split$default((CharSequence)minimalVersion, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
        if (minimalParts.size() != 3) {
            throw (Throwable)new GradleException("Invalid minimal IntelliJ Coverage Engine version '" + $this$isLowVersion + '\'');
        }
        int n = 0;
        int n2 = 2;
        while (n <= n2) {
            void i;
            if (((String)customParts.get((int)i)).compareTo((String)minimalParts.get((int)i)) > 0) {
                return false;
            }
            if (((String)customParts.get((int)i)).compareTo((String)minimalParts.get((int)i)) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

