/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import java.util.Random;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;

public class IntGen
implements ParameterGenerator<Integer> {
    private static final int DEFAULT_BEGIN = -10;
    private static final int DEFAULT_END = 10;
    private final Random random = new Random(0L);
    private final int begin;
    private final int end;

    public IntGen(String configuration) {
        if (configuration.isEmpty()) {
            this.begin = -10;
            this.end = 10;
            return;
        }
        String[] args = configuration.replaceAll("\\s", "").split(":");
        switch (args.length) {
            case 2: {
                this.begin = Integer.parseInt(args[0]);
                this.end = Integer.parseInt(args[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Configuration should have two arguments (begin and end) separated by colon");
            }
        }
    }

    @Override
    public Integer generate() {
        return this.begin + this.random.nextInt(this.end - this.begin + 1);
    }

    void checkRange(int min, int max, String type) {
        if (this.begin < min || this.end - 1 > max) {
            throw new IllegalArgumentException("Illegal range for " + type + " type: [" + this.begin + "; " + this.end + ")");
        }
    }
}

