/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CallStackTraceElement;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CodeLocationIdProvider;
import org.jetbrains.kotlinx.lincheck.strategy.managed.JavaUtilRemapper;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedGuaranteeType;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyGuarantee;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyTransformer;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyTransformer$ManagedStrategyGuaranteeTransformer$WhenMappings;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyTransformerKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.MethodCallTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ReadTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.TracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.WriteTracePoint;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.TryCatchBlockSorter;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0000\u0018\u00002\u00020\u0001:\u0011/0123456789:;<=>?B\u008f\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012P\u0010\u0003\u001aL\u0012H\u0012F\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u0012\u0004\u0012\u00020\u000e0\u0005j\u0002`\u000f0\u0004\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u0013\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018JE\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0$H\u0016\u00a2\u0006\u0002\u0010%J?\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u001a2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010+J\u001a\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u001a2\b\u0010.\u001a\u0004\u0018\u00010\u001aH\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RX\u0010\u0003\u001aL\u0012H\u0012F\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u0012\u0004\u0012\u00020\u000e0\u0005j\u0002`\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "Lorg/objectweb/asm/ClassVisitor;", "cv", "tracePointConstructors", "", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "iThread", "actorId", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePointConstructor;", "guarantees", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyGuarantee;", "eliminateLocalObjects", "", "collectStateRepresentation", "constructTraceRepresentation", "codeLocationIdProvider", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationIdProvider;", "(Lorg/objectweb/asm/ClassVisitor;Ljava/util/List;Ljava/util/List;ZZZLorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationIdProvider;)V", "className", "", "classVersion", "fileName", "visit", "", "version", "access", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "mname", "desc", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "visitSource", "source", "debug", "AFUTrackingTransformer", "CallStackTraceLoggingTransformer", "ClassInitializationTransformer", "HashCodeStubTransformer", "LocalObjectManagingTransformer", "ManagedStrategyGuaranteeTransformer", "ManagedStrategyMethodVisitor", "ParkUnparkTransformer", "RandomTransformer", "SharedVariableAccessMethodTransformer", "SynchronizedBlockAddingTransformer", "SynchronizedBlockTransformer", "ThreadYieldTransformer", "TimeStubTransformer", "UnsafeTransformer", "VMSupportsCS8MethodGenerator", "WaitNotifyTransformer", "lincheck"})
public final class ManagedStrategyTransformer
extends ClassVisitor {
    private String className;
    private int classVersion;
    private String fileName;
    private final List<Function3<Integer, Integer, List<CallStackTraceElement>, TracePoint>> tracePointConstructors;
    private final List<ManagedStrategyGuarantee> guarantees;
    private final boolean eliminateLocalObjects;
    private final boolean collectStateRepresentation;
    private final boolean constructTraceRepresentation;
    private final CodeLocationIdProvider codeLocationIdProvider;

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
        Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
        this.className = name;
        this.classVersion = version;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(@NotNull String source, @Nullable String debug) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.fileName = source;
        super.visitSource(source, debug);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String mname, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        boolean isSynchronized;
        Intrinsics.checkNotNullParameter((Object)mname, (String)"mname");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        String string = this.className;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        }
        if (ManagedStrategyTransformerKt.access$isStrategyMethod(string)) {
            MethodVisitor methodVisitor = super.visitMethod(access, mname, desc, signature, exceptions);
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"super.visitMethod(access\u2026c, signature, exceptions)");
            return methodVisitor;
        }
        int access2 = access;
        if ((access2 & 0x100) != 0 && Intrinsics.areEqual((Object)mname, (Object)"VMSupportsCS8")) {
            MethodVisitor mv = super.visitMethod(access2 & ~256, mname, desc, signature, exceptions);
            return new VMSupportsCS8MethodGenerator(new GeneratorAdapter(mv, access2 & ~256, mname, desc));
        }
        boolean bl = isSynchronized = (access2 & 0x20) != 0;
        if (isSynchronized) {
            access2 ^= 0x20;
        }
        MethodVisitor mv = super.visitMethod(access2, mname, desc, signature, exceptions);
        mv = (MethodVisitor)new JSRInlinerAdapter(mv, access2, mname, desc, signature, exceptions);
        mv = (MethodVisitor)new TryCatchBlockSorter(mv, access2, mname, desc, signature, exceptions);
        mv = new SynchronizedBlockTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        if (isSynchronized) {
            mv = new SynchronizedBlockAddingTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc), access2, this.classVersion);
        }
        mv = new ClassInitializationTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        if (this.constructTraceRepresentation) {
            mv = new AFUTrackingTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        }
        mv = new ManagedStrategyGuaranteeTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        mv = new CallStackTraceLoggingTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        mv = new HashCodeStubTransformer(new GeneratorAdapter(mv, access2, mname, desc));
        mv = new UnsafeTransformer(new GeneratorAdapter(mv, access2, mname, desc));
        mv = new WaitNotifyTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        mv = new ParkUnparkTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        mv = new LocalObjectManagingTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        mv = new SharedVariableAccessMethodTransformer(mname, new GeneratorAdapter(mv, access2, mname, desc));
        mv = new TimeStubTransformer(new GeneratorAdapter(mv, access2, mname, desc));
        mv = new RandomTransformer(new GeneratorAdapter(mv, access2, mname, desc));
        mv = new ThreadYieldTransformer(new GeneratorAdapter(mv, access2, mname, desc));
        return mv;
    }

    public ManagedStrategyTransformer(@Nullable ClassVisitor cv, @NotNull List<Function3<Integer, Integer, List<CallStackTraceElement>, TracePoint>> tracePointConstructors, @NotNull List<ManagedStrategyGuarantee> guarantees, boolean eliminateLocalObjects, boolean collectStateRepresentation, boolean constructTraceRepresentation, @NotNull CodeLocationIdProvider codeLocationIdProvider) {
        Intrinsics.checkNotNullParameter(tracePointConstructors, (String)"tracePointConstructors");
        Intrinsics.checkNotNullParameter(guarantees, (String)"guarantees");
        Intrinsics.checkNotNullParameter((Object)codeLocationIdProvider, (String)"codeLocationIdProvider");
        super(589824, (ClassVisitor)new ClassRemapper(cv, (Remapper)new JavaUtilRemapper()));
        this.tracePointConstructors = tracePointConstructors;
        this.guarantees = guarantees;
        this.eliminateLocalObjects = eliminateLocalObjects;
        this.collectStateRepresentation = collectStateRepresentation;
        this.constructTraceRepresentation = constructTraceRepresentation;
        this.codeLocationIdProvider = codeLocationIdProvider;
    }

    public static final /* synthetic */ String access$getClassName$p(ManagedStrategyTransformer $this) {
        String string = $this.className;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        }
        return string;
    }

    public static final /* synthetic */ void access$setClassName$p(ManagedStrategyTransformer $this, String string) {
        $this.className = string;
    }

    public static final /* synthetic */ void access$setFileName$p(ManagedStrategyTransformer $this, String string) {
        $this.fileName = string;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$VMSupportsCS8MethodGenerator;", "Lorg/objectweb/asm/MethodVisitor;", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "visitEnd", "", "lincheck"})
    private static final class VMSupportsCS8MethodGenerator
    extends MethodVisitor {
        @NotNull
        private final GeneratorAdapter adapter;

        public void visitEnd() {
            GeneratorAdapter generatorAdapter = this.adapter;
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            $this$run.visitCode();
            $this$run.push(true);
            $this$run.returnValue();
            $this$run.visitMaxs(1, 0);
            $this$run.visitEnd();
        }

        @NotNull
        public final GeneratorAdapter getAdapter() {
            return this.adapter;
        }

        public VMSupportsCS8MethodGenerator(@NotNull GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(589824, null);
            this.adapter = adapter;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001f\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J#\u0010\u0017\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJy\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u00152P\u0010\u001c\u001aL\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020#0\"j\u0002`$\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0\u001dj\u0002`'H\u0002\u00a2\u0006\u0002\u0010(J#\u0010)\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010*\u001a\u00020\tH\u0002J(\u0010+\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010-\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$SharedVariableAccessMethodTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "beforeSharedVariableWrite", "", "fieldName", "desc", "captureReadValue", "tracePointLocal", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "captureWrittenValue", "dupArrayOnArrayStore", "opcode", "dupOwnerOnPutField", "getArrayLoadType", "Lorg/objectweb/asm/Type;", "getArrayStoreType", "invokeBeforeSharedVariableRead", "invokeBeforeSharedVariableReadOrWrite", "method", "Lorg/objectweb/asm/commons/Method;", "tracePointType", "codeLocationConstructor", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "iThread", "actorId", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "Ljava/lang/StackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationTracePointConstructor;", "(Lorg/objectweb/asm/commons/Method;Ljava/lang/Integer;Lorg/objectweb/asm/Type;Lkotlin/jvm/functions/Function4;)V", "invokeBeforeSharedVariableWrite", "invokeIsLocalObject", "visitFieldInsn", "owner", "visitInsn", "lincheck"})
    private final class SharedVariableAccessMethodTransformer
    extends ManagedStrategyMethodVisitor {
        public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (ManagedStrategyTransformerKt.access$isFinalField(owner, name) || ManagedStrategyTransformerKt.access$isSuspendStateMachine(owner)) {
                super.visitFieldInsn(opcode, owner, name, desc);
                return;
            }
            switch (opcode) {
                case 178: {
                    Integer tracePointLocal = this.newTracePointLocal();
                    this.invokeBeforeSharedVariableRead(name, tracePointLocal);
                    super.visitFieldInsn(opcode, owner, name, desc);
                    this.captureReadValue(desc, tracePointLocal);
                    break;
                }
                case 180: {
                    int isLocalObject = $this$run.newLocal(Type.BOOLEAN_TYPE);
                    Label skipCodeLocationBefore = $this$run.newLabel();
                    Integer tracePointLocal = this.newTracePointLocal();
                    $this$run.dup();
                    this.invokeIsLocalObject();
                    ManagedStrategyTransformerKt.access$copyLocal($this$run, isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationBefore);
                    this.invokeBeforeSharedVariableRead(name, tracePointLocal);
                    $this$run.visitLabel(skipCodeLocationBefore);
                    super.visitFieldInsn(opcode, owner, name, desc);
                    Label skipCodeLocationAfter = $this$run.newLabel();
                    $this$run.loadLocal(isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationAfter);
                    this.captureReadValue(desc, tracePointLocal);
                    $this$run.visitLabel(skipCodeLocationAfter);
                    break;
                }
                case 179: {
                    this.beforeSharedVariableWrite(name, desc);
                    super.visitFieldInsn(opcode, owner, name, desc);
                    this.invokeMakeStateRepresentation();
                    break;
                }
                case 181: {
                    int isLocalObject = $this$run.newLocal(Type.BOOLEAN_TYPE);
                    Label skipCodeLocationBefore = $this$run.newLabel();
                    this.dupOwnerOnPutField(desc);
                    this.invokeIsLocalObject();
                    ManagedStrategyTransformerKt.access$copyLocal($this$run, isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationBefore);
                    this.beforeSharedVariableWrite(name, desc);
                    $this$run.visitLabel(skipCodeLocationBefore);
                    super.visitFieldInsn(opcode, owner, name, desc);
                    Label skipCodeLocationAfter = $this$run.newLabel();
                    $this$run.loadLocal(isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationAfter);
                    this.invokeMakeStateRepresentation();
                    $this$run.visitLabel(skipCodeLocationAfter);
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unknown field opcode");
                }
            }
        }

        public void visitInsn(int opcode) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            switch (opcode) {
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    int isLocalObject = $this$run.newLocal(Type.BOOLEAN_TYPE);
                    Label skipCodeLocationBefore = this.getAdapter().newLabel();
                    Integer tracePointLocal = this.newTracePointLocal();
                    $this$run.dup2();
                    $this$run.pop();
                    this.invokeIsLocalObject();
                    ManagedStrategyTransformerKt.access$copyLocal($this$run, isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationBefore);
                    this.invokeBeforeSharedVariableRead(null, tracePointLocal);
                    $this$run.visitLabel(skipCodeLocationBefore);
                    super.visitInsn(opcode);
                    Label skipCodeLocationAfter = $this$run.newLabel();
                    $this$run.loadLocal(isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationAfter);
                    String string = this.getArrayLoadType(opcode).getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getArrayLoadType(opcode).descriptor");
                    this.captureReadValue(string, tracePointLocal);
                    $this$run.visitLabel(skipCodeLocationAfter);
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    int isLocalObject = $this$run.newLocal(Type.BOOLEAN_TYPE);
                    Label skipCodeLocationBefore = this.getAdapter().newLabel();
                    this.dupArrayOnArrayStore(opcode);
                    this.invokeIsLocalObject();
                    ManagedStrategyTransformerKt.access$copyLocal($this$run, isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationBefore);
                    String string = this.getArrayStoreType(opcode).getDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getArrayStoreType(opcode).descriptor");
                    this.beforeSharedVariableWrite(null, string);
                    $this$run.visitLabel(skipCodeLocationBefore);
                    super.visitInsn(opcode);
                    Label skipCodeLocationAfter = $this$run.newLabel();
                    $this$run.loadLocal(isLocalObject);
                    $this$run.ifZCmp(157, skipCodeLocationAfter);
                    this.invokeMakeStateRepresentation();
                    $this$run.visitLabel(skipCodeLocationAfter);
                    break;
                }
                default: {
                    super.visitInsn(opcode);
                }
            }
        }

        private final void dupArrayOnArrayStore(int opcode) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            Type type = this.getArrayStoreType(opcode);
            int value = $this$run.newLocal(type);
            $this$run.storeLocal(value);
            $this$run.dup2();
            $this$run.pop();
            int array = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
            $this$run.storeLocal(array);
            $this$run.loadLocal(value);
            $this$run.loadLocal(array);
        }

        private final void dupOwnerOnPutField(String desc) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)"J", (Object)desc) ^ true && Intrinsics.areEqual((Object)"D", (Object)desc) ^ true) {
                $this$run.dup2();
                $this$run.pop();
            } else {
                $this$run.dup2X1();
                $this$run.pop2();
                $this$run.dupX2();
            }
        }

        private final void captureReadValue(String desc, Integer tracePointLocal) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (!ManagedStrategyTransformer.this.constructTraceRepresentation) {
                return;
            }
            Type valueType = Type.getType((String)desc);
            int readValue = $this$run.newLocal(valueType);
            ManagedStrategyTransformerKt.access$copyLocal($this$run, readValue);
            Integer n = tracePointLocal;
            Intrinsics.checkNotNull((Object)n);
            $this$run.loadLocal(n.intValue());
            $this$run.checkCast(ManagedStrategyTransformerKt.access$getREAD_TRACE_POINT_TYPE$p());
            $this$run.loadLocal(readValue);
            $this$run.box(valueType);
            $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getREAD_TRACE_POINT_TYPE$p(), ManagedStrategyTransformerKt.access$getINITIALIZE_READ_VALUE_METHOD$p());
        }

        private final void beforeSharedVariableWrite(String fieldName, String desc) {
            Integer tracePointLocal = this.newTracePointLocal();
            this.invokeBeforeSharedVariableWrite(fieldName, tracePointLocal);
            this.captureWrittenValue(desc, tracePointLocal);
        }

        static /* synthetic */ void beforeSharedVariableWrite$default(SharedVariableAccessMethodTransformer sharedVariableAccessMethodTransformer, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            sharedVariableAccessMethodTransformer.beforeSharedVariableWrite(string, string2);
        }

        private final void captureWrittenValue(String desc, Integer tracePointLocal) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (!ManagedStrategyTransformer.this.constructTraceRepresentation) {
                return;
            }
            Type valueType = Type.getType((String)desc);
            int storedValue = $this$run.newLocal(valueType);
            ManagedStrategyTransformerKt.access$copyLocal($this$run, storedValue);
            Integer n = tracePointLocal;
            Intrinsics.checkNotNull((Object)n);
            $this$run.loadLocal(n.intValue());
            $this$run.checkCast(ManagedStrategyTransformerKt.access$getWRITE_TRACE_POINT_TYPE$p());
            $this$run.loadLocal(storedValue);
            $this$run.box(valueType);
            $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getWRITE_TRACE_POINT_TYPE$p(), ManagedStrategyTransformerKt.access$getINITIALIZE_WRITTEN_VALUE_METHOD$p());
        }

        private final Type getArrayStoreType(int opcode) {
            Type type;
            switch (opcode) {
                case 83: {
                    Type type2 = ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p();
                    type = type2;
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"OBJECT_TYPE");
                    break;
                }
                case 79: {
                    Type type3 = Type.INT_TYPE;
                    type = type3;
                    Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"Type.INT_TYPE");
                    break;
                }
                case 81: {
                    Type type4 = Type.FLOAT_TYPE;
                    type = type4;
                    Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"Type.FLOAT_TYPE");
                    break;
                }
                case 84: {
                    Type type5 = Type.BOOLEAN_TYPE;
                    type = type5;
                    Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"Type.BOOLEAN_TYPE");
                    break;
                }
                case 85: {
                    Type type6 = Type.CHAR_TYPE;
                    type = type6;
                    Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"Type.CHAR_TYPE");
                    break;
                }
                case 86: {
                    Type type7 = Type.SHORT_TYPE;
                    type = type7;
                    Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"Type.SHORT_TYPE");
                    break;
                }
                case 80: {
                    Type type8 = Type.LONG_TYPE;
                    type = type8;
                    Intrinsics.checkNotNullExpressionValue((Object)type8, (String)"Type.LONG_TYPE");
                    break;
                }
                case 82: {
                    Type type9 = Type.DOUBLE_TYPE;
                    type = type9;
                    Intrinsics.checkNotNullExpressionValue((Object)type9, (String)"Type.DOUBLE_TYPE");
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unexpected opcode: " + opcode);
                }
            }
            return type;
        }

        private final Type getArrayLoadType(int opcode) {
            Type type;
            switch (opcode) {
                case 50: {
                    Type type2 = ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p();
                    type = type2;
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"OBJECT_TYPE");
                    break;
                }
                case 46: {
                    Type type3 = Type.INT_TYPE;
                    type = type3;
                    Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"Type.INT_TYPE");
                    break;
                }
                case 48: {
                    Type type4 = Type.FLOAT_TYPE;
                    type = type4;
                    Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"Type.FLOAT_TYPE");
                    break;
                }
                case 51: {
                    Type type5 = Type.BOOLEAN_TYPE;
                    type = type5;
                    Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"Type.BOOLEAN_TYPE");
                    break;
                }
                case 52: {
                    Type type6 = Type.CHAR_TYPE;
                    type = type6;
                    Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"Type.CHAR_TYPE");
                    break;
                }
                case 53: {
                    Type type7 = Type.SHORT_TYPE;
                    type = type7;
                    Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"Type.SHORT_TYPE");
                    break;
                }
                case 47: {
                    Type type8 = Type.LONG_TYPE;
                    type = type8;
                    Intrinsics.checkNotNullExpressionValue((Object)type8, (String)"Type.LONG_TYPE");
                    break;
                }
                case 49: {
                    Type type9 = Type.DOUBLE_TYPE;
                    type = type9;
                    Intrinsics.checkNotNullExpressionValue((Object)type9, (String)"Type.DOUBLE_TYPE");
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Unexpected opcode: " + opcode);
                }
            }
            return type;
        }

        private final void invokeBeforeSharedVariableRead(String fieldName, Integer tracePointLocal) {
            Method method = ManagedStrategyTransformerKt.access$getBEFORE_SHARED_VARIABLE_READ_METHOD$p();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"BEFORE_SHARED_VARIABLE_READ_METHOD");
            Type type = ManagedStrategyTransformerKt.access$getREAD_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"READ_TRACE_POINT_TYPE");
            this.invokeBeforeSharedVariableReadOrWrite(method, tracePointLocal, type, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)((Function4)new Function4<Integer, Integer, List<? extends CallStackTraceElement>, StackTraceElement, TracePoint>(fieldName){
                final /* synthetic */ String $fieldName;

                @NotNull
                public final TracePoint invoke(int iThread, int actorId, @NotNull List<CallStackTraceElement> callStackTrace, @NotNull StackTraceElement ste) {
                    Intrinsics.checkNotNullParameter(callStackTrace, (String)"callStackTrace");
                    Intrinsics.checkNotNullParameter((Object)ste, (String)"ste");
                    return new ReadTracePoint(iThread, actorId, callStackTrace, this.$fieldName, ste);
                }
                {
                    this.$fieldName = string;
                    super(4);
                }
            }));
        }

        static /* synthetic */ void invokeBeforeSharedVariableRead$default(SharedVariableAccessMethodTransformer sharedVariableAccessMethodTransformer, String string, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            sharedVariableAccessMethodTransformer.invokeBeforeSharedVariableRead(string, n);
        }

        private final void invokeBeforeSharedVariableWrite(String fieldName, Integer tracePointLocal) {
            Method method = ManagedStrategyTransformerKt.access$getBEFORE_SHARED_VARIABLE_WRITE_METHOD$p();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"BEFORE_SHARED_VARIABLE_WRITE_METHOD");
            Type type = ManagedStrategyTransformerKt.access$getWRITE_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"WRITE_TRACE_POINT_TYPE");
            this.invokeBeforeSharedVariableReadOrWrite(method, tracePointLocal, type, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)((Function4)new Function4<Integer, Integer, List<? extends CallStackTraceElement>, StackTraceElement, TracePoint>(fieldName){
                final /* synthetic */ String $fieldName;

                @NotNull
                public final TracePoint invoke(int iThread, int actorId, @NotNull List<CallStackTraceElement> callStackTrace, @NotNull StackTraceElement ste) {
                    Intrinsics.checkNotNullParameter(callStackTrace, (String)"callStackTrace");
                    Intrinsics.checkNotNullParameter((Object)ste, (String)"ste");
                    return new WriteTracePoint(iThread, actorId, callStackTrace, this.$fieldName, ste);
                }
                {
                    this.$fieldName = string;
                    super(4);
                }
            }));
        }

        static /* synthetic */ void invokeBeforeSharedVariableWrite$default(SharedVariableAccessMethodTransformer sharedVariableAccessMethodTransformer, String string, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            sharedVariableAccessMethodTransformer.invokeBeforeSharedVariableWrite(string, n);
        }

        private final void invokeBeforeSharedVariableReadOrWrite(Method method, Integer tracePointLocal, Type tracePointType, Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint> codeLocationConstructor) {
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            this.loadNewCodeLocationAndTracePoint(tracePointLocal, tracePointType, codeLocationConstructor);
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), method);
        }

        private final void invokeIsLocalObject() {
            if (ManagedStrategyTransformer.this.eliminateLocalObjects) {
                int objectLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                this.getAdapter().storeLocal(objectLocal);
                this.loadObjectManager();
                this.getAdapter().loadLocal(objectLocal);
                this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getOBJECT_MANAGER_TYPE$p(), ManagedStrategyTransformerKt.access$getIS_LOCAL_OBJECT_METHOD$p());
            } else {
                this.getAdapter().pop();
                this.getAdapter().push(false);
            }
        }

        public SharedVariableAccessMethodTransformer(@NotNull String methodName, GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(methodName, adapter);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyGuaranteeTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "classifyGuaranteeType", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedGuaranteeType;", "className", "invokeBeforeAtomicMethodCall", "", "visitMethodInsn", "opcode", "", "owner", "name", "desc", "itf", "", "lincheck"})
    private final class ManagedStrategyGuaranteeTransformer
    extends ManagedStrategyMethodVisitor {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            ManagedGuaranteeType managedGuaranteeType = this.classifyGuaranteeType(owner, name);
            if (managedGuaranteeType != null) {
                switch (ManagedStrategyTransformer$ManagedStrategyGuaranteeTransformer$WhenMappings.$EnumSwitchMapping$0[managedGuaranteeType.ordinal()]) {
                    case 1: {
                        this.runInIgnoredSection((Function0<Unit>)((Function0)new Function0<Unit>(this, opcode, owner, name, desc, itf){
                            final /* synthetic */ ManagedStrategyGuaranteeTransformer this$0;
                            final /* synthetic */ int $opcode;
                            final /* synthetic */ String $owner;
                            final /* synthetic */ String $name;
                            final /* synthetic */ String $desc;
                            final /* synthetic */ boolean $itf;

                            public final void invoke() {
                                this.this$0.getAdapter().visitMethodInsn(this.$opcode, this.$owner, this.$name, this.$desc, this.$itf);
                            }
                            {
                                this.this$0 = managedStrategyGuaranteeTransformer;
                                this.$opcode = n;
                                this.$owner = string;
                                this.$name = string2;
                                this.$desc = string3;
                                this.$itf = bl;
                                super(0);
                            }
                        }));
                        return;
                    }
                    case 2: {
                        this.invokeBeforeAtomicMethodCall();
                        this.runInIgnoredSection((Function0<Unit>)((Function0)new Function0<Unit>(this, opcode, owner, name, desc, itf){
                            final /* synthetic */ ManagedStrategyGuaranteeTransformer this$0;
                            final /* synthetic */ int $opcode;
                            final /* synthetic */ String $owner;
                            final /* synthetic */ String $name;
                            final /* synthetic */ String $desc;
                            final /* synthetic */ boolean $itf;

                            public final void invoke() {
                                this.this$0.getAdapter().visitMethodInsn(this.$opcode, this.$owner, this.$name, this.$desc, this.$itf);
                            }
                            {
                                this.this$0 = managedStrategyGuaranteeTransformer;
                                this.$opcode = n;
                                this.$owner = string;
                                this.$name = string2;
                                this.$desc = string3;
                                this.$itf = bl;
                                super(0);
                            }
                        }));
                        this.invokeMakeStateRepresentation();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.getAdapter().visitMethodInsn(opcode, owner, name, desc, itf);
        }

        private final ManagedGuaranteeType classifyGuaranteeType(String className, String methodName) {
            for (ManagedStrategyGuarantee guarantee : ManagedStrategyTransformer.this.guarantees) {
                if (!((Boolean)guarantee.getMethodPredicate$lincheck().invoke((Object)methodName)).booleanValue() || !((Boolean)guarantee.getClassPredicate$lincheck().invoke((Object)UtilsKt.getCanonicalClassName(className))).booleanValue()) continue;
                return guarantee.getType$lincheck();
            }
            return null;
        }

        private final void invokeBeforeAtomicMethodCall() {
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            this.getAdapter().push(ManagedStrategyTransformer.this.codeLocationIdProvider.getLastId());
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getBEFORE_ATOMIC_METHOD_CALL_METHOD$p());
        }

        public ManagedStrategyGuaranteeTransformer(@NotNull String methodName, GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(methodName, adapter);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ClassInitializationTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "isClinit", "", "visitCode", "", "visitInsn", "opcode", "", "lincheck"})
    private final class ClassInitializationTransformer
    extends ManagedStrategyMethodVisitor {
        private final boolean isClinit;

        public void visitCode() {
            if (this.isClinit) {
                this.invokeBeforeIgnoredSectionEntering();
            }
            this.mv.visitCode();
        }

        public void visitInsn(int opcode) {
            if (this.isClinit) {
                switch (opcode) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        this.invokeAfterIgnoredSectionLeaving();
                        break;
                    }
                }
            }
            this.mv.visitInsn(opcode);
        }

        public ClassInitializationTransformer(@NotNull String methodName, GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(methodName, adapter);
            this.isClinit = Intrinsics.areEqual((Object)methodName, (Object)"<clinit>");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\tH\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\b\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$CallStackTraceLoggingTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "isSuspendStateMachine", "", "()Z", "isSuspendStateMachine$delegate", "Lkotlin/Lazy;", "afterMethodCall", "", "returnType", "Lorg/objectweb/asm/Type;", "tracePointLocal", "", "beforeMethodCall", "opcode", "owner", "desc", "captureOwnerName", "captureParameters", "invokeAfterMethodCall", "invokeBeforeMethodCall", "isInternalCoroutineCall", "name", "onException", "visitMethodInsn", "itf", "lincheck"})
    private final class CallStackTraceLoggingTransformer
    extends ManagedStrategyMethodVisitor {
        private final Lazy isSuspendStateMachine$delegate;

        private final boolean isSuspendStateMachine() {
            Lazy lazy = this.isSuspendStateMachine$delegate;
            CallStackTraceLoggingTransformer callStackTraceLoggingTransformer = this;
            Object var3_3 = null;
            boolean bl = false;
            return (Boolean)lazy.getValue();
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (this.isSuspendStateMachine() || ManagedStrategyTransformerKt.access$isStrategyMethod(owner) || this.isInternalCoroutineCall(owner, name)) {
                $this$run.visitMethodInsn(opcode, owner, name, desc, itf);
                return;
            }
            if (!ManagedStrategyTransformer.this.constructTraceRepresentation) {
                ManagedStrategyTransformer.this.codeLocationIdProvider.newId();
                $this$run.visitMethodInsn(opcode, owner, name, desc, itf);
                return;
            }
            Label callStart = $this$run.newLabel();
            Label callEnd = $this$run.newLabel();
            Label exceptionHandler = $this$run.newLabel();
            Label skipHandler = $this$run.newLabel();
            Integer n = this.newTracePointLocal();
            Intrinsics.checkNotNull((Object)n);
            int tracePointLocal = n;
            this.beforeMethodCall(opcode, owner, name, desc, tracePointLocal);
            if (Intrinsics.areEqual((Object)name, (Object)"<init>") ^ true) {
                $this$run.visitTryCatchBlock(callStart, callEnd, exceptionHandler, null);
            }
            $this$run.visitLabel(callStart);
            $this$run.visitMethodInsn(opcode, owner, name, desc, itf);
            $this$run.visitLabel(callEnd);
            Type type = new Method(name, desc).getReturnType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"Method(name, desc).returnType");
            this.afterMethodCall(type, tracePointLocal);
            $this$run.goTo(skipHandler);
            $this$run.visitLabel(exceptionHandler);
            this.onException(tracePointLocal);
            this.invokeAfterMethodCall(tracePointLocal);
            $this$run.throwException();
            $this$run.visitLabel(skipHandler);
        }

        private final void beforeMethodCall(int opcode, String owner, String methodName, String desc, int tracePointLocal) {
            this.invokeBeforeMethodCall(methodName, tracePointLocal);
            this.captureParameters(opcode, owner, methodName, desc, tracePointLocal);
            this.captureOwnerName(opcode, owner, methodName, desc, tracePointLocal);
        }

        private final void afterMethodCall(Type returnType, int tracePointLocal) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)returnType, (Object)Type.VOID_TYPE) ^ true) {
                int returnedValue = $this$run.newLocal(returnType);
                ManagedStrategyTransformerKt.access$copyLocal($this$run, returnedValue);
                $this$run.loadLocal(tracePointLocal);
                $this$run.checkCast(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p());
                $this$run.loadLocal(returnedValue);
                $this$run.box(returnType);
                $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p(), ManagedStrategyTransformerKt.access$getINITIALIZE_RETURNED_VALUE_METHOD$p());
            }
            this.invokeAfterMethodCall(tracePointLocal);
        }

        private final void onException(int tracePointLocal) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            int exceptionLocal = $this$run.newLocal(ManagedStrategyTransformerKt.access$getTHROWABLE_TYPE$p());
            ManagedStrategyTransformerKt.access$copyLocal($this$run, exceptionLocal);
            $this$run.loadLocal(tracePointLocal);
            $this$run.checkCast(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p());
            $this$run.loadLocal(exceptionLocal);
            $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p(), ManagedStrategyTransformerKt.access$getINITIALIZE_THROWN_EXCEPTION_METHOD$p());
        }

        /*
         * WARNING - void declaration
         */
        private final void captureParameters(int opcode, String owner, String methodName, String desc, int tracePointLocal) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            Object[] paramTypes = Type.getArgumentTypes((String)desc);
            Intrinsics.checkNotNullExpressionValue((Object)paramTypes, (String)"paramTypes");
            Object[] objectArray = paramTypes;
            boolean bl4 = false;
            if (objectArray.length == 0) {
                return;
            }
            int[] params = ManagedStrategyTransformerKt.access$copyParameters($this$run, (Type[])paramTypes);
            int firstLoggedParameter = ManagedStrategyTransformerKt.access$isAFUMethodCall(opcode, owner, methodName, desc) ? 1 : 0;
            Object object = ArraysKt.last((Object[])paramTypes);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"paramTypes.last()");
            int lastLoggedParameter = Intrinsics.areEqual((Object)((Type)object).getInternalName(), (Object)"kotlin/coroutines/Continuation") && ManagedStrategyTransformerKt.access$isSuspend(owner, methodName, desc) ? paramTypes.length - 1 : paramTypes.length;
            $this$run.push(lastLoggedParameter - firstLoggedParameter);
            Type type = ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"OBJECT_TYPE");
            $this$run.visitTypeInsn(189, type.getInternalName());
            int parameterValuesLocal = $this$run.newLocal(ManagedStrategyTransformerKt.access$getOBJECT_ARRAY_TYPE$p());
            $this$run.storeLocal(parameterValuesLocal);
            int n = firstLoggedParameter;
            int n2 = lastLoggedParameter;
            while (n < n2) {
                void i;
                $this$run.loadLocal(parameterValuesLocal);
                $this$run.push((int)(i - firstLoggedParameter));
                $this$run.loadLocal(params[i]);
                $this$run.box((Type)paramTypes[i]);
                $this$run.arrayStore(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                ++i;
            }
            $this$run.loadLocal(tracePointLocal);
            $this$run.checkCast(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p());
            $this$run.loadLocal(parameterValuesLocal);
            $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p(), ManagedStrategyTransformerKt.access$getINITIALIZE_PARAMETERS_METHOD$p());
        }

        private final void captureOwnerName(int opcode, String owner, String methodName, String desc, int tracePointLocal) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (!ManagedStrategyTransformerKt.access$isAFUMethodCall(opcode, owner, methodName, desc)) {
                return;
            }
            int afuLocal = $this$run.newLocal(Type.getType((String)('L' + owner + ';')));
            int[] params = ManagedStrategyTransformerKt.access$storeParameters($this$run, desc);
            ManagedStrategyTransformerKt.access$copyLocal($this$run, afuLocal);
            for (int param : params) {
                $this$run.loadLocal(param);
            }
            $this$run.loadLocal(tracePointLocal);
            $this$run.checkCast(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p());
            this.loadObjectManager();
            $this$run.loadLocal(afuLocal);
            $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getOBJECT_MANAGER_TYPE$p(), ManagedStrategyTransformerKt.access$getGET_OBJECT_NAME$p());
            $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p(), ManagedStrategyTransformerKt.access$getINITIALIZE_OWNER_NAME_METHOD$p());
        }

        private final void invokeBeforeMethodCall(String methodName, int tracePointLocal) {
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            Integer n = tracePointLocal;
            Type type = ManagedStrategyTransformerKt.access$getMETHOD_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"METHOD_TRACE_POINT_TYPE");
            this.loadNewCodeLocationAndTracePoint(n, type, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)((Function4)new Function4<Integer, Integer, List<? extends CallStackTraceElement>, StackTraceElement, TracePoint>(methodName){
                final /* synthetic */ String $methodName;

                @NotNull
                public final TracePoint invoke(int iThread, int actorId, @NotNull List<CallStackTraceElement> callStackTrace, @NotNull StackTraceElement ste) {
                    Intrinsics.checkNotNullParameter(callStackTrace, (String)"callStackTrace");
                    Intrinsics.checkNotNullParameter((Object)ste, (String)"ste");
                    return new MethodCallTracePoint(iThread, actorId, callStackTrace, this.$methodName, ste);
                }
                {
                    this.$methodName = string;
                    super(4);
                }
            }));
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getBEFORE_METHOD_CALL_METHOD$p());
        }

        private final void invokeAfterMethodCall(int tracePointLocal) {
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            this.getAdapter().loadLocal(tracePointLocal);
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getAFTER_METHOD_CALL_METHOD$p());
        }

        private final boolean isInternalCoroutineCall(String owner, String name) {
            return Intrinsics.areEqual((Object)owner, (Object)"kotlin/coroutines/intrinsics/IntrinsicsKt") && Intrinsics.areEqual((Object)name, (Object)"getCOROUTINE_SUSPENDED");
        }

        public CallStackTraceLoggingTransformer(@NotNull String methodName, GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(methodName, adapter);
            this.isSuspendStateMachine$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ CallStackTraceLoggingTransformer this$0;

                public final boolean invoke() {
                    return ManagedStrategyTransformerKt.access$isSuspendStateMachine(ManagedStrategyTransformer.access$getClassName$p(this.this$0.ManagedStrategyTransformer.this));
                }
                {
                    this.this$0 = callStackTraceLoggingTransformer;
                    super(0);
                }
            }));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$UnsafeTransformer;", "Lorg/objectweb/asm/MethodVisitor;", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "visitMethodInsn", "", "opcode", "", "owner", "", "name", "desc", "itf", "", "lincheck"})
    private static final class UnsafeTransformer
    extends MethodVisitor {
        @NotNull
        private final GeneratorAdapter adapter;

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (ManagedStrategyTransformerKt.access$isUnsafe(owner) && Intrinsics.areEqual((Object)name, (Object)"getUnsafe")) {
                this.adapter.push(UtilsKt.getCanonicalClassName(owner));
                this.adapter.invokeStatic(ManagedStrategyTransformerKt.access$getUNSAFE_HOLDER_TYPE$p(), ManagedStrategyTransformerKt.access$getGET_UNSAFE_METHOD$p());
                this.adapter.checkCast(Type.getType((String)('L' + owner + ';')));
                return;
            }
            this.adapter.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @NotNull
        public final GeneratorAdapter getAdapter() {
            return this.adapter;
        }

        public UnsafeTransformer(@NotNull GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(589824, (MethodVisitor)adapter);
            this.adapter = adapter;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$AFUTrackingTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "mv", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "visitMethodInsn", "", "opcode", "", "owner", "mname", "desc", "isInterface", "", "lincheck"})
    private final class AFUTrackingTransformer
    extends ManagedStrategyMethodVisitor {
        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String mname, @NotNull String desc, boolean isInterface) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)mname, (String)"mname");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            boolean isAFUCreation = opcode == 184 && Intrinsics.areEqual((Object)mname, (Object)"newUpdater") && ManagedStrategyTransformerKt.access$isAFU(owner);
            if (isAFUCreation) {
                int nameLocal = $this$run.newLocal(ManagedStrategyTransformerKt.access$getSTRING_TYPE$p());
                ManagedStrategyTransformerKt.access$copyLocal($this$run, nameLocal);
                $this$run.visitMethodInsn(opcode, owner, mname, desc, isInterface);
                int afuLocal = $this$run.newLocal(Type.getType((String)('L' + owner + ';')));
                ManagedStrategyTransformerKt.access$copyLocal($this$run, afuLocal);
                this.loadObjectManager();
                $this$run.loadLocal(afuLocal);
                $this$run.loadLocal(nameLocal);
                $this$run.invokeVirtual(ManagedStrategyTransformerKt.access$getOBJECT_MANAGER_TYPE$p(), ManagedStrategyTransformerKt.access$getSET_OBJECT_NAME$p());
            } else {
                $this$run.visitMethodInsn(opcode, owner, mname, desc, isInterface);
            }
        }

        public AFUTrackingTransformer(@NotNull String methodName, GeneratorAdapter mv) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            super(methodName, mv);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$HashCodeStubTransformer;", "Lorg/objectweb/asm/MethodVisitor;", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "visitMethodInsn", "", "opcode", "", "owner", "", "name", "desc", "itf", "", "lincheck"})
    private static final class HashCodeStubTransformer
    extends MethodVisitor {
        @NotNull
        private final GeneratorAdapter adapter;

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            boolean isObjectHashCodeInvocation;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            boolean isAnyHashCodeInvocation = Intrinsics.areEqual((Object)owner, (Object)"kotlin/Any") && Intrinsics.areEqual((Object)name, (Object)"hashCode");
            boolean bl = isObjectHashCodeInvocation = Intrinsics.areEqual((Object)owner, (Object)"java/lang/Object") && Intrinsics.areEqual((Object)name, (Object)"hashCode");
            if (isAnyHashCodeInvocation || isObjectHashCodeInvocation) {
                this.adapter.pop();
                this.adapter.push(0);
                return;
            }
            this.adapter.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @NotNull
        public final GeneratorAdapter getAdapter() {
            return this.adapter;
        }

        public HashCodeStubTransformer(@NotNull GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(589824, (MethodVisitor)adapter);
            this.adapter = adapter;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$TimeStubTransformer;", "Lorg/objectweb/asm/MethodVisitor;", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "visitMethodInsn", "", "opcode", "", "owner", "", "name", "desc", "itf", "", "lincheck"})
    private static final class TimeStubTransformer
    extends MethodVisitor {
        @NotNull
        private final GeneratorAdapter adapter;

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (Intrinsics.areEqual((Object)owner, (Object)"java/lang/System") && (Intrinsics.areEqual((Object)name, (Object)"nanoTime") || Intrinsics.areEqual((Object)name, (Object)"currentTimeMillis"))) {
                this.adapter.push(1337L);
                return;
            }
            this.adapter.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @NotNull
        public final GeneratorAdapter getAdapter() {
            return this.adapter;
        }

        public TimeStubTransformer(@NotNull GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(589824, (MethodVisitor)adapter);
            this.adapter = adapter;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006RA\u0010\u0007\u001a(\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$RandomTransformer;", "Lorg/objectweb/asm/MethodVisitor;", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "randomMethods", "", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "getRandomMethods", "()[Ljava/lang/reflect/Method;", "randomMethods$delegate", "Lkotlin/Lazy;", "extendsRandom", "", "className", "", "isRandomMethod", "methodName", "desc", "loadRandom", "", "visitMethodInsn", "opcode", "", "owner", "name", "itf", "lincheck"})
    private static final class RandomTransformer
    extends MethodVisitor {
        private final Lazy randomMethods$delegate;
        @NotNull
        private final GeneratorAdapter adapter;

        private final java.lang.reflect.Method[] getRandomMethods() {
            Lazy lazy = this.randomMethods$delegate;
            RandomTransformer randomTransformer = this;
            Object var3_3 = null;
            boolean bl = false;
            return (java.lang.reflect.Method[])lazy.getValue();
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (opcode == 182 && this.extendsRandom(UtilsKt.getCanonicalClassName(owner)) && this.isRandomMethod(name, desc)) {
                int[] locals = ManagedStrategyTransformerKt.access$storeParameters(this.adapter, desc);
                this.adapter.pop();
                this.loadRandom();
                ManagedStrategyTransformerKt.access$loadLocals(this.adapter, locals);
                this.adapter.visitMethodInsn(opcode, "java/util/Random", name, desc, itf);
                return;
            }
            boolean isThreadLocalRandomMethod = Intrinsics.areEqual((Object)owner, (Object)"java/util/concurrent/ThreadLocalRandom");
            boolean isStriped64Method = Intrinsics.areEqual((Object)owner, (Object)"java/util/concurrent/atomic/Striped64");
            if (isThreadLocalRandomMethod && (Intrinsics.areEqual((Object)name, (Object)"nextSecondarySeed") || Intrinsics.areEqual((Object)name, (Object)"getProbe")) || isStriped64Method && Intrinsics.areEqual((Object)name, (Object)"getProbe")) {
                this.loadRandom();
                this.adapter.invokeVirtual(ManagedStrategyTransformerKt.access$getRANDOM_TYPE$p(), ManagedStrategyTransformerKt.access$getNEXT_INT_METHOD$p());
                return;
            }
            if ((isThreadLocalRandomMethod || isStriped64Method) && Intrinsics.areEqual((Object)name, (Object)"advanceProbe")) {
                this.adapter.pop();
                this.loadRandom();
                this.adapter.invokeVirtual(ManagedStrategyTransformerKt.access$getRANDOM_TYPE$p(), ManagedStrategyTransformerKt.access$getNEXT_INT_METHOD$p());
                return;
            }
            this.adapter.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        private final void loadRandom() {
            this.adapter.getStatic(ManagedStrategyTransformerKt.access$getMANAGED_STATE_HOLDER_TYPE$p(), "random", ManagedStrategyTransformerKt.access$getRANDOM_TYPE$p());
        }

        private final boolean extendsRandom(String className) {
            return Random.class.isAssignableFrom(Class.forName(className));
        }

        private final boolean isRandomMethod(String methodName, String desc) {
            boolean bl;
            block1: {
                java.lang.reflect.Method[] methodArray = this.getRandomMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"randomMethods");
                java.lang.reflect.Method[] $this$any$iv = methodArray;
                boolean $i$f$any = false;
                java.lang.reflect.Method[] methodArray2 = $this$any$iv;
                int n = methodArray2.length;
                for (int i = 0; i < n; ++i) {
                    Method method;
                    java.lang.reflect.Method element$iv;
                    java.lang.reflect.Method it = element$iv = methodArray2[i];
                    boolean bl2 = false;
                    Method method2 = method = Method.getMethod((java.lang.reflect.Method)it);
                    Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                    boolean bl3 = Intrinsics.areEqual((Object)method2.getName(), (Object)methodName) && Intrinsics.areEqual((Object)method.getDescriptor(), (Object)desc);
                    if (!bl3) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final GeneratorAdapter getAdapter() {
            return this.adapter;
        }

        public RandomTransformer(@NotNull GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(589824, (MethodVisitor)adapter);
            this.adapter = adapter;
            this.randomMethods$delegate = LazyKt.lazy((Function0)randomMethods.2.INSTANCE);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ThreadYieldTransformer;", "Lorg/objectweb/asm/MethodVisitor;", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "visitMethodInsn", "", "opcode", "", "owner", "", "name", "desc", "itf", "", "lincheck"})
    private static final class ThreadYieldTransformer
    extends MethodVisitor {
        @NotNull
        private final GeneratorAdapter adapter;

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (opcode == 184 && Intrinsics.areEqual((Object)owner, (Object)"java/lang/Thread") && Intrinsics.areEqual((Object)name, (Object)"yield")) {
                return;
            }
            this.adapter.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @NotNull
        public final GeneratorAdapter getAdapter() {
            return this.adapter;
        }

        public ThreadYieldTransformer(@NotNull GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(589824, (MethodVisitor)adapter);
            this.adapter = adapter;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002Jj\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2P\u0010\r\u001aL\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u000ej\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$SynchronizedBlockTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "mv", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "invokeBeforeLockAcquire", "", "invokeBeforeLockAcquireOrRelease", "method", "Lorg/objectweb/asm/commons/Method;", "codeLocationConstructor", "Lkotlin/Function4;", "", "Lkotlin/ParameterName;", "name", "iThread", "actorId", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "Ljava/lang/StackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationTracePointConstructor;", "tracePointType", "Lorg/objectweb/asm/Type;", "invokeBeforeLockRelease", "visitInsn", "opcode", "lincheck"})
    private final class SynchronizedBlockTransformer
    extends ManagedStrategyMethodVisitor {
        public void visitInsn(int opcode) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            switch (opcode) {
                case 194: {
                    Label opEnd = $this$run.newLabel();
                    Label label = $this$run.newLabel();
                    Intrinsics.checkNotNullExpressionValue((Object)label, (String)"newLabel()");
                    Label skipMonitorEnter = label;
                    $this$run.dup();
                    this.invokeBeforeLockAcquire();
                    $this$run.ifZCmp(153, skipMonitorEnter);
                    $this$run.monitorEnter();
                    $this$run.goTo(opEnd);
                    $this$run.visitLabel(skipMonitorEnter);
                    $this$run.pop();
                    $this$run.visitLabel(opEnd);
                    break;
                }
                case 195: {
                    Label opEnd = $this$run.newLabel();
                    Label label = $this$run.newLabel();
                    Intrinsics.checkNotNullExpressionValue((Object)label, (String)"newLabel()");
                    Label skipMonitorExit = label;
                    $this$run.dup();
                    this.invokeBeforeLockRelease();
                    $this$run.ifZCmp(153, skipMonitorExit);
                    $this$run.monitorExit();
                    $this$run.goTo(opEnd);
                    $this$run.visitLabel(skipMonitorExit);
                    $this$run.pop();
                    $this$run.visitLabel(opEnd);
                    break;
                }
                default: {
                    $this$run.visitInsn(opcode);
                }
            }
        }

        private final void invokeBeforeLockAcquire() {
            Method method = ManagedStrategyTransformerKt.access$getBEFORE_LOCK_ACQUIRE_METHOD$p();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"BEFORE_LOCK_ACQUIRE_METHOD");
            Function4 function4 = invokeBeforeLockAcquire.1.INSTANCE;
            Type type = ManagedStrategyTransformerKt.access$getMONITORENTER_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"MONITORENTER_TRACE_POINT_TYPE");
            this.invokeBeforeLockAcquireOrRelease(method, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)function4, type);
        }

        private final void invokeBeforeLockRelease() {
            Method method = ManagedStrategyTransformerKt.access$getBEFORE_LOCK_RELEASE_METHOD$p();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"BEFORE_LOCK_RELEASE_METHOD");
            Function4 function4 = invokeBeforeLockRelease.1.INSTANCE;
            Type type = ManagedStrategyTransformerKt.access$getMONITOREXIT_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"MONITOREXIT_TRACE_POINT_TYPE");
            this.invokeBeforeLockAcquireOrRelease(method, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)function4, type);
        }

        private final void invokeBeforeLockAcquireOrRelease(Method method, Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint> codeLocationConstructor, Type tracePointType) {
            int monitorLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
            this.getAdapter().storeLocal(monitorLocal);
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            this.loadNewCodeLocationAndTracePoint(null, tracePointType, codeLocationConstructor);
            this.getAdapter().loadLocal(monitorLocal);
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), method);
        }

        public SynchronizedBlockTransformer(@NotNull String methodName, GeneratorAdapter mv) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            super(methodName, mv);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$SynchronizedBlockAddingTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "mv", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "access", "", "classVersion", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;II)V", "catchLabel", "Lorg/objectweb/asm/Label;", "isStatic", "", "tryLabel", "loadSynchronizedMethodMonitorOwner", "", "visitCode", "visitInsn", "opcode", "visitMaxs", "maxStack", "maxLocals", "lincheck"})
    private final class SynchronizedBlockAddingTransformer
    extends ManagedStrategyMethodVisitor {
        private final boolean isStatic;
        private final Label tryLabel;
        private final Label catchLabel;
        private final int classVersion;

        public void visitCode() {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            super.visitCode();
            this.loadSynchronizedMethodMonitorOwner();
            $this$run.monitorEnter();
            $this$run.visitLabel(this.tryLabel);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            $this$run.visitLabel(this.catchLabel);
            this.loadSynchronizedMethodMonitorOwner();
            $this$run.monitorExit();
            $this$run.throwException();
            $this$run.visitTryCatchBlock(this.tryLabel, this.catchLabel, this.catchLabel, null);
            $this$run.visitMaxs(maxStack, maxLocals);
        }

        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    this.loadSynchronizedMethodMonitorOwner();
                    this.getAdapter().monitorExit();
                    break;
                }
            }
            this.getAdapter().visitInsn(opcode);
        }

        private final void loadSynchronizedMethodMonitorOwner() {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            if (this.isStatic) {
                Type classType = Type.getType((String)('L' + ManagedStrategyTransformer.access$getClassName$p(ManagedStrategyTransformer.this) + ';'));
                if (this.classVersion >= 49) {
                    $this$run.visitLdcInsn((Object)classType);
                } else {
                    Type type = classType;
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"classType");
                    $this$run.visitLdcInsn((Object)type.getClassName());
                    $this$run.invokeStatic(ManagedStrategyTransformerKt.access$getCLASS_TYPE$p(), ManagedStrategyTransformerKt.access$getCLASS_FOR_NAME_METHOD$p());
                }
            } else {
                $this$run.loadThis();
            }
        }

        public SynchronizedBlockAddingTransformer(@NotNull String methodName, GeneratorAdapter mv, int access, int classVersion) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            super(methodName, mv);
            this.classVersion = classVersion;
            this.isStatic = (access & 8) != 0;
            this.tryLabel = new Label();
            this.catchLabel = new Label();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002Jr\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2P\u0010\u0012\u001aL\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u0013j\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J \u0010$\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J0\u0010%\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u000bH\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$WaitNotifyTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "mv", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "invokeBeforeNotify", "", "notifyAll", "", "invokeBeforeWait", "withTimeout", "invokeOnWaitOrNotify", "method", "Lorg/objectweb/asm/commons/Method;", "flag", "codeLocationConstructor", "Lkotlin/Function4;", "", "Lkotlin/ParameterName;", "name", "iThread", "actorId", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "Ljava/lang/StackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationTracePointConstructor;", "tracePointType", "Lorg/objectweb/asm/Type;", "isNotify", "opcode", "desc", "isWait", "visitMethodInsn", "owner", "itf", "lincheck"})
    private final class WaitNotifyTransformer
    extends ManagedStrategyMethodVisitor {
        /*
         * Unable to fully structure code
         */
        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            var6_6 = this.getAdapter();
            var7_7 = false;
            var8_8 = false;
            $this$run = var6_6;
            $i$a$-run-ManagedStrategyTransformer$WaitNotifyTransformer$visitMethodInsn$1 = false;
            skipWaitOrNotify = $this$run.newLabel();
            isWait = this.isWait(opcode, name, desc);
            isNotify = this.isNotify(opcode, name, desc);
            if (isWait) {
                skipWaitOrNotify = $this$run.newLabel();
                withTimeout = Intrinsics.areEqual((Object)desc, (Object)"()V") ^ true;
                lastArgument = 0;
                firstArgument = 0;
                var17_18 = desc;
                switch (var17_18.hashCode()) {
                    case 39216884: {
                        if (!var17_18.equals("(JI)V")) ** break;
                        break;
                    }
                    case 1264111: {
                        if (!var17_18.equals("(J)V")) ** break;
                        firstArgument = $this$run.newLocal(Type.LONG_TYPE);
                        $this$run.storeLocal(firstArgument);
                        ** break;
                    }
                }
                lastArgument = $this$run.newLocal(Type.INT_TYPE);
                $this$run.storeLocal(lastArgument);
                firstArgument = $this$run.newLocal(Type.LONG_TYPE);
                $this$run.storeLocal(firstArgument);
lbl31:
                // 5 sources

                $this$run.dup();
                this.invokeBeforeWait(withTimeout);
                v0 = $this$run.newLabel();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"newLabel()");
                beforeWait = v0;
                $this$run.ifZCmp(157, beforeWait);
                $this$run.pop();
                $this$run.goTo(skipWaitOrNotify);
                $this$run.visitLabel(beforeWait);
                var18_19 = desc;
                switch (var18_19.hashCode()) {
                    case 39216884: {
                        if (!var18_19.equals("(JI)V")) ** break;
                        break;
                    }
                    case 1264111: {
                        if (!var18_19.equals("(J)V")) ** break;
                        $this$run.loadLocal(firstArgument);
                        ** break;
                    }
                }
                $this$run.loadLocal(firstArgument);
                $this$run.loadLocal(lastArgument);
            }
lbl51:
            // 7 sources

            if (isNotify) {
                notifyAll = Intrinsics.areEqual((Object)name, (Object)"notifyAll");
                $this$run.dup();
                this.invokeBeforeNotify(notifyAll);
                beforeNotify = $this$run.newLabel();
                $this$run.ifZCmp(157, beforeNotify);
                $this$run.pop();
                $this$run.goTo(skipWaitOrNotify);
                $this$run.visitLabel(beforeNotify);
            }
            $this$run.visitMethodInsn(opcode, owner, name, desc, itf);
            $this$run.visitLabel(skipWaitOrNotify);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWait(int opcode, String name, String desc) {
            if (opcode != 182 || !Intrinsics.areEqual((Object)name, (Object)"wait")) return false;
            String string = desc;
            switch (string.hashCode()) {
                case 39216884: {
                    if (!string.equals("(JI)V")) return false;
                    return true;
                }
                case 39797: {
                    if (!string.equals("()V")) return false;
                    return true;
                }
                case 1264111: {
                    if (!string.equals("(J)V")) return false;
                    return true;
                }
            }
            return false;
        }

        private final boolean isNotify(int opcode, String name, String desc) {
            boolean isNotify = opcode == 182 && Intrinsics.areEqual((Object)name, (Object)"notify") && Intrinsics.areEqual((Object)desc, (Object)"()V");
            boolean isNotifyAll = opcode == 182 && Intrinsics.areEqual((Object)name, (Object)"notifyAll") && Intrinsics.areEqual((Object)desc, (Object)"()V");
            return isNotify || isNotifyAll;
        }

        private final void invokeBeforeWait(boolean withTimeout) {
            Method method = ManagedStrategyTransformerKt.access$getBEFORE_WAIT_METHOD$p();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"BEFORE_WAIT_METHOD");
            Function4 function4 = invokeBeforeWait.1.INSTANCE;
            Type type = ManagedStrategyTransformerKt.access$getWAIT_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"WAIT_TRACE_POINT_TYPE");
            this.invokeOnWaitOrNotify(method, withTimeout, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)function4, type);
        }

        private final void invokeBeforeNotify(boolean notifyAll) {
            Method method = ManagedStrategyTransformerKt.access$getBEFORE_NOTIFY_METHOD$p();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"BEFORE_NOTIFY_METHOD");
            Function4 function4 = invokeBeforeNotify.1.INSTANCE;
            Type type = ManagedStrategyTransformerKt.access$getNOTIFY_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"NOTIFY_TRACE_POINT_TYPE");
            this.invokeOnWaitOrNotify(method, notifyAll, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)function4, type);
        }

        private final void invokeOnWaitOrNotify(Method method, boolean flag, Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint> codeLocationConstructor, Type tracePointType) {
            int monitorLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
            this.getAdapter().storeLocal(monitorLocal);
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            this.loadNewCodeLocationAndTracePoint(null, tracePointType, codeLocationConstructor);
            this.getAdapter().loadLocal(monitorLocal);
            this.getAdapter().push(flag);
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), method);
        }

        public WaitNotifyTransformer(@NotNull String methodName, GeneratorAdapter mv) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            super(methodName, mv);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J0\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ParkUnparkTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "mv", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "invokeAfterUnpark", "", "invokeBeforePark", "visitMethodInsn", "opcode", "", "owner", "name", "desc", "itf", "", "lincheck"})
    private final class ParkUnparkTransformer
    extends ManagedStrategyMethodVisitor {
        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            boolean isPark;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            Label label = $this$run.newLabel();
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"newLabel()");
            Label beforePark = label;
            Label label2 = $this$run.newLabel();
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"newLabel()");
            Label afterPark = label2;
            boolean bl4 = isPark = ManagedStrategyTransformerKt.access$isUnsafe(owner) && Intrinsics.areEqual((Object)name, (Object)"park");
            if (isPark) {
                Label label3 = $this$run.newLabel();
                Intrinsics.checkNotNullExpressionValue((Object)label3, (String)"newLabel()");
                Label withoutTimeoutBranch = label3;
                Label label4 = $this$run.newLabel();
                Intrinsics.checkNotNullExpressionValue((Object)label4, (String)"newLabel()");
                Label invokeBeforeParkEnd = label4;
                $this$run.dup2();
                $this$run.push(0L);
                $this$run.ifCmp(Type.LONG_TYPE, 153, withoutTimeoutBranch);
                $this$run.push(true);
                this.invokeBeforePark();
                $this$run.goTo(invokeBeforeParkEnd);
                $this$run.visitLabel(withoutTimeoutBranch);
                $this$run.push(false);
                this.invokeBeforePark();
                $this$run.visitLabel(invokeBeforeParkEnd);
                $this$run.ifZCmp(157, beforePark);
                $this$run.pop2();
                $this$run.pop();
                $this$run.pop();
                $this$run.goTo(afterPark);
            }
            $this$run.visitLabel(beforePark);
            boolean isUnpark = ManagedStrategyTransformerKt.access$isUnsafe(owner) && Intrinsics.areEqual((Object)name, (Object)"unpark");
            int threadLocal = 0;
            if (isUnpark) {
                $this$run.dup();
                threadLocal = $this$run.newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                $this$run.storeLocal(threadLocal);
            }
            $this$run.visitMethodInsn(opcode, owner, name, desc, itf);
            $this$run.visitLabel(afterPark);
            if (isUnpark) {
                $this$run.loadLocal(threadLocal);
                this.invokeAfterUnpark();
            }
        }

        private final void invokeBeforePark() {
            int withTimeoutLocal = this.getAdapter().newLocal(Type.BOOLEAN_TYPE);
            this.getAdapter().storeLocal(withTimeoutLocal);
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            Type type = ManagedStrategyTransformerKt.access$getPARK_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"PARK_TRACE_POINT_TYPE");
            this.loadNewCodeLocationAndTracePoint(null, type, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)((Function4)invokeBeforePark.1.INSTANCE));
            this.getAdapter().loadLocal(withTimeoutLocal);
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getBEFORE_PARK_METHOD$p());
        }

        private final void invokeAfterUnpark() {
            int threadLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
            this.getAdapter().storeLocal(threadLocal);
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            Type type = ManagedStrategyTransformerKt.access$getUNPARK_TRACE_POINT_TYPE$p();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"UNPARK_TRACE_POINT_TYPE");
            this.loadNewCodeLocationAndTracePoint(null, type, (Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint>)((Function4)invokeAfterUnpark.1.INSTANCE));
            this.getAdapter().loadLocal(threadLocal);
            this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getAFTER_UNPARK_METHOD$p());
        }

        public ParkUnparkTransformer(@NotNull String methodName, GeneratorAdapter mv) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            super(methodName, mv);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J(\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J0\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0004H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$LocalObjectManagingTransformer;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;", "methodName", "", "mv", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "invokeAddDependency", "", "invokeDeleteLocalObject", "invokeOnNewLocalObject", "visitFieldInsn", "opcode", "", "owner", "name", "desc", "visitInsn", "visitIntInsn", "operand", "visitMethodInsn", "descriptor", "isInterface", "", "visitTypeInsn", "type", "lincheck"})
    private final class LocalObjectManagingTransformer
    extends ManagedStrategyMethodVisitor {
        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            block11: {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                isObjectCreation = opcode == 183 && Intrinsics.areEqual((Object)name, (Object)"<init>") != false && Intrinsics.areEqual((Object)owner, (Object)"java/lang/Object") != false;
                isImpossibleToTransformPrimitive = ManagedStrategyTransformerKt.isImpossibleToTransformApiClass(UtilsKt.getCanonicalClassName(owner));
                var9_8 = name;
                v0 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"Locale.US");
                var10_10 = v0;
                var11_12 = false;
                v1 = var9_8.toLowerCase(var10_10);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"(this as java.lang.String).toLowerCase(locale)");
                lowerCaseName = v1;
                if (!isImpossibleToTransformPrimitive) ** GOTO lbl-1000
                $this$any$iv = ManagedStrategyTransformerKt.access$getWRITE_KEYWORDS$p();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        $i$a$-any-ManagedStrategyTransformer$LocalObjectManagingTransformer$visitMethodInsn$isPrimitiveWrite$1 = false;
                        if (!StringsKt.contains$default((CharSequence)lowerCaseName, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        v2 = true;
                        break block11;
                    }
                    v2 = false;
                }
            }
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = isPrimitiveWrite = false;
            }
            if (!isPrimitiveWrite) ** GOTO lbl-1000
            v4 = Type.getArgumentTypes((String)descriptor);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"Type.getArgumentTypes(descriptor)");
            v5 /* !! */  = (Type)ArraysKt.lastOrNull((Object[])v4);
            if (v5 /* !! */  != null && (v5 /* !! */  = v5 /* !! */ .getDescriptor()) != null ? ManagedStrategyTransformerKt.access$isNotPrimitiveType((String)v5 /* !! */ ) : false) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            isObjectPrimitiveWrite = v6;
            if (isObjectCreation) {
                this.getAdapter().dup();
                this.getAdapter().visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                this.invokeOnNewLocalObject();
            } else if (isObjectPrimitiveWrite) {
                params = ManagedStrategyTransformerKt.access$copyParameters(this.getAdapter(), descriptor);
                this.getAdapter().visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                this.getAdapter().loadLocal(ArraysKt.first((int[])params));
                this.getAdapter().loadLocal(ArraysKt.last((int[])params));
                this.invokeAddDependency();
            } else {
                this.getAdapter().visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        }

        public void visitIntInsn(int opcode, int operand) {
            this.getAdapter().visitIntInsn(opcode, operand);
            if (opcode == 188) {
                this.getAdapter().dup();
                this.invokeOnNewLocalObject();
            }
        }

        public void visitTypeInsn(int opcode, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.getAdapter().visitTypeInsn(opcode, type);
            if (opcode == 189) {
                this.getAdapter().dup();
                this.invokeOnNewLocalObject();
            }
        }

        public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            boolean isNotPrimitiveType = ManagedStrategyTransformerKt.access$isNotPrimitiveType(desc);
            boolean isFinalField = ManagedStrategyTransformerKt.access$isFinalField(owner, name);
            if (isNotPrimitiveType) {
                switch (opcode) {
                    case 179: {
                        this.getAdapter().dup();
                        this.invokeDeleteLocalObject();
                        break;
                    }
                    case 181: {
                        if (isFinalField) break;
                        this.getAdapter().dup2();
                        this.invokeAddDependency();
                        break;
                    }
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitInsn(int opcode) {
            GeneratorAdapter generatorAdapter = this.getAdapter();
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            int value = 0;
            switch (opcode) {
                case 83: {
                    value = $this$run.newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                    $this$run.storeLocal(value);
                    $this$run.dup2();
                    $this$run.pop();
                    $this$run.loadLocal(value);
                    this.invokeAddDependency();
                    $this$run.loadLocal(value);
                    break;
                }
                case 177: {
                    if (!Intrinsics.areEqual((Object)this.getMethodName(), (Object)"<init>")) break;
                    Type ownerType = Type.getObjectType((String)ManagedStrategyTransformer.access$getClassName$p(ManagedStrategyTransformer.this));
                    for (Field field : ManagedStrategyTransformerKt.access$getNonStaticFinalFields(ManagedStrategyTransformer.access$getClassName$p(ManagedStrategyTransformer.this))) {
                        Class<?> clazz = field.getType();
                        Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.type");
                        if (clazz.isPrimitive()) continue;
                        Type fieldType = Type.getType(field.getType());
                        $this$run.loadThis();
                        $this$run.loadThis();
                        $this$run.getField(ownerType, field.getName(), fieldType);
                        this.invokeAddDependency();
                    }
                    break;
                }
            }
            this.getAdapter().visitInsn(opcode);
        }

        private final void invokeOnNewLocalObject() {
            if (ManagedStrategyTransformer.this.eliminateLocalObjects) {
                int objectLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                this.getAdapter().storeLocal(objectLocal);
                this.loadObjectManager();
                this.getAdapter().loadLocal(objectLocal);
                this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getOBJECT_MANAGER_TYPE$p(), ManagedStrategyTransformerKt.access$getNEW_LOCAL_OBJECT_METHOD$p());
            } else {
                this.getAdapter().pop();
            }
        }

        private final void invokeDeleteLocalObject() {
            if (ManagedStrategyTransformer.this.eliminateLocalObjects) {
                int objectLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                this.getAdapter().storeLocal(objectLocal);
                this.loadObjectManager();
                this.getAdapter().loadLocal(objectLocal);
                this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getOBJECT_MANAGER_TYPE$p(), ManagedStrategyTransformerKt.access$getDELETE_LOCAL_OBJECT_METHOD$p());
            } else {
                this.getAdapter().pop();
            }
        }

        private final void invokeAddDependency() {
            if (ManagedStrategyTransformer.this.eliminateLocalObjects) {
                int ownerLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                int dependantLocal = this.getAdapter().newLocal(ManagedStrategyTransformerKt.access$getOBJECT_TYPE$p());
                this.getAdapter().storeLocal(dependantLocal);
                this.getAdapter().storeLocal(ownerLocal);
                this.loadObjectManager();
                this.getAdapter().loadLocal(ownerLocal);
                this.getAdapter().loadLocal(dependantLocal);
                this.getAdapter().invokeVirtual(ManagedStrategyTransformerKt.access$getOBJECT_MANAGER_TYPE$p(), ManagedStrategyTransformerKt.access$getADD_DEPENDENCY_METHOD$p());
            } else {
                int n = 2;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    this.getAdapter().pop();
                }
            }
        }

        public LocalObjectManagingTransformer(@NotNull String methodName, GeneratorAdapter mv) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
            super(methodName, mv);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0004J\b\u0010\u000f\u001a\u00020\u000eH\u0004J\b\u0010\u0010\u001a\u00020\u000eH\u0004J\b\u0010\u0011\u001a\u00020\u000eH\u0004Jq\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00152P\u0010\u0016\u001aL\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u0017j\u0002`!H\u0004\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u000eH\u0004J\b\u0010$\u001a\u00020\u000eH\u0004J\u000f\u0010%\u001a\u0004\u0018\u00010\nH\u0004\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0)H\u0004J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer$ManagedStrategyMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "methodName", "", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyTransformer;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "lineNumber", "", "getMethodName", "()Ljava/lang/String;", "invokeAfterIgnoredSectionLeaving", "", "invokeBeforeIgnoredSectionEntering", "invokeMakeStateRepresentation", "loadCurrentThreadNumber", "loadNewCodeLocationAndTracePoint", "tracePointLocal", "tracePointType", "Lorg/objectweb/asm/Type;", "codeLocationConstructor", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "iThread", "actorId", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "Ljava/lang/StackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationTracePointConstructor;", "(Ljava/lang/Integer;Lorg/objectweb/asm/Type;Lkotlin/jvm/functions/Function4;)V", "loadObjectManager", "loadStrategy", "newTracePointLocal", "()Ljava/lang/Integer;", "runInIgnoredSection", "block", "Lkotlin/Function0;", "visitLineNumber", "line", "start", "Lorg/objectweb/asm/Label;", "lincheck"})
    private class ManagedStrategyMethodVisitor
    extends MethodVisitor {
        private int lineNumber;
        @NotNull
        private final String methodName;
        @NotNull
        private final GeneratorAdapter adapter;

        protected final void invokeBeforeIgnoredSectionEntering() {
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            this.adapter.invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getENTER_IGNORED_SECTION_METHOD$p());
        }

        protected final void invokeAfterIgnoredSectionLeaving() {
            this.loadStrategy();
            this.loadCurrentThreadNumber();
            this.adapter.invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getLEAVE_IGNORED_SECTION_METHOD$p());
        }

        protected final void invokeMakeStateRepresentation() {
            if (ManagedStrategyTransformer.this.collectStateRepresentation) {
                this.loadStrategy();
                this.loadCurrentThreadNumber();
                this.adapter.invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getMAKE_STATE_REPRESENTATION_METHOD$p());
            }
        }

        protected final void loadStrategy() {
            this.adapter.getStatic(ManagedStrategyTransformerKt.access$getMANAGED_STATE_HOLDER_TYPE$p(), "strategy", ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p());
        }

        protected final void loadObjectManager() {
            this.adapter.getStatic(ManagedStrategyTransformerKt.access$getMANAGED_STATE_HOLDER_TYPE$p(), "objectManager", ManagedStrategyTransformerKt.access$getOBJECT_MANAGER_TYPE$p());
        }

        protected final void loadCurrentThreadNumber() {
            this.loadStrategy();
            this.adapter.invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getCURRENT_THREAD_NUMBER_METHOD$p());
        }

        protected final void loadNewCodeLocationAndTracePoint(@Nullable Integer tracePointLocal, @NotNull Type tracePointType, @NotNull Function4<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? super StackTraceElement, ? extends TracePoint> codeLocationConstructor) {
            Intrinsics.checkNotNullParameter((Object)tracePointType, (String)"tracePointType");
            Intrinsics.checkNotNullParameter(codeLocationConstructor, (String)"codeLocationConstructor");
            this.adapter.push(ManagedStrategyTransformer.this.codeLocationIdProvider.newId());
            if (ManagedStrategyTransformer.this.constructTraceRepresentation) {
                String className = ManagedStrategyTransformer.access$getClassName$p(ManagedStrategyTransformer.this);
                String fileName = ManagedStrategyTransformer.this.fileName;
                int lineNumber = this.lineNumber;
                ManagedStrategyTransformer.this.tracePointConstructors.add(new Function3<Integer, Integer, List<? extends CallStackTraceElement>, TracePoint>(this, className, fileName, lineNumber, codeLocationConstructor){
                    final /* synthetic */ ManagedStrategyMethodVisitor this$0;
                    final /* synthetic */ String $className;
                    final /* synthetic */ String $fileName;
                    final /* synthetic */ int $lineNumber;
                    final /* synthetic */ Function4 $codeLocationConstructor;

                    @NotNull
                    public final TracePoint invoke(int iThread, int actorId, @NotNull List<CallStackTraceElement> callStackTrace) {
                        Intrinsics.checkNotNullParameter(callStackTrace, (String)"callStackTrace");
                        StackTraceElement ste = new StackTraceElement(this.$className, this.this$0.getMethodName(), this.$fileName, this.$lineNumber);
                        return (TracePoint)this.$codeLocationConstructor.invoke((Object)iThread, (Object)actorId, callStackTrace, (Object)ste);
                    }
                    {
                        this.this$0 = managedStrategyMethodVisitor;
                        this.$className = string;
                        this.$fileName = string2;
                        this.$lineNumber = n;
                        this.$codeLocationConstructor = function4;
                        super(3);
                    }
                });
                this.loadStrategy();
                this.adapter.push(CollectionsKt.getLastIndex((List)ManagedStrategyTransformer.this.tracePointConstructors));
                this.adapter.invokeVirtual(ManagedStrategyTransformerKt.access$getMANAGED_STRATEGY_TYPE$p(), ManagedStrategyTransformerKt.access$getCREATE_TRACE_POINT_METHOD$p());
                this.adapter.checkCast(tracePointType);
                if (tracePointLocal != null) {
                    ManagedStrategyTransformerKt.access$copyLocal(this.adapter, tracePointLocal);
                }
            } else {
                this.adapter.push((Type)null);
            }
        }

        @Nullable
        protected final Integer newTracePointLocal() {
            Integer n;
            if (ManagedStrategyTransformer.this.constructTraceRepresentation) {
                int tracePointLocal = this.adapter.newLocal(ManagedStrategyTransformerKt.access$getTRACE_POINT_TYPE$p());
                this.adapter.push((Type)null);
                this.adapter.storeLocal(tracePointLocal);
                n = tracePointLocal;
            } else {
                n = null;
            }
            return n;
        }

        protected final void runInIgnoredSection(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            GeneratorAdapter generatorAdapter = this.adapter;
            boolean bl = false;
            boolean bl2 = false;
            GeneratorAdapter $this$run = generatorAdapter;
            boolean bl3 = false;
            Label callStart = $this$run.newLabel();
            Label callEnd = $this$run.newLabel();
            Label exceptionHandler = $this$run.newLabel();
            Label skipHandler = $this$run.newLabel();
            if (Intrinsics.areEqual((Object)$this$run.getName(), (Object)"<init>") ^ true) {
                $this$run.visitTryCatchBlock(callStart, callEnd, exceptionHandler, null);
            }
            this.invokeBeforeIgnoredSectionEntering();
            $this$run.visitLabel(callStart);
            block.invoke();
            $this$run.visitLabel(callEnd);
            this.invokeAfterIgnoredSectionLeaving();
            $this$run.goTo(skipHandler);
            $this$run.visitLabel(exceptionHandler);
            this.invokeAfterIgnoredSectionLeaving();
            $this$run.throwException();
            $this$run.visitLabel(skipHandler);
        }

        public void visitLineNumber(int line, @NotNull Label start) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.lineNumber = line;
            super.visitLineNumber(line, start);
        }

        @NotNull
        protected final String getMethodName() {
            return this.methodName;
        }

        @NotNull
        public final GeneratorAdapter getAdapter() {
            return this.adapter;
        }

        public ManagedStrategyMethodVisitor(@NotNull String methodName, GeneratorAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            super(589824, (MethodVisitor)adapter);
            this.methodName = methodName;
            this.adapter = adapter;
        }
    }
}

