/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.verifier.linearizability;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.Cancelled;
import org.jetbrains.kotlinx.lincheck.Result;
import org.jetbrains.kotlinx.lincheck.Suspended;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionResult;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.execution.HBClock;
import org.jetbrains.kotlinx.lincheck.verifier.LTS;
import org.jetbrains.kotlinx.lincheck.verifier.TransitionInfo;
import org.jetbrains.kotlinx.lincheck.verifier.VerifierContext;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tB;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0015\u001a\u00020\u0000*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/lincheck/verifier/linearizability/LinearizabilityContext;", "Lorg/jetbrains/kotlinx/lincheck/verifier/VerifierContext;", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "results", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionResult;", "state", "Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;", "Lorg/jetbrains/kotlinx/lincheck/verifier/LTS;", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionResult;Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;)V", "executed", "", "suspended", "", "tickets", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionResult;Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;[I[Z[I)V", "hblegal", "", "threadId", "", "nextContext", "createContext", "Lorg/jetbrains/kotlinx/lincheck/verifier/TransitionInfo;", "lincheck"})
public final class LinearizabilityContext
extends VerifierContext {
    @Override
    @Nullable
    public LinearizabilityContext nextContext(int threadId) {
        boolean promptCancel;
        boolean legal;
        int n;
        if (this.isCompleted(threadId)) {
            return null;
        }
        int n2 = threadId;
        boolean bl = n2 == 0 ? true : (1 <= (n = n2) && this.getScenario().getThreads() >= n ? this.isCompleted(0) && this.hblegal(threadId) : (legal = this.getInitCompleted() && this.getParallelCompleted()));
        if (!legal) {
            return null;
        }
        int actorId = this.getExecuted()[threadId];
        Actor actor = UtilsKt.get(this.getScenario(), threadId).get(actorId);
        Result expectedResult = UtilsKt.get(this.getResults(), threadId).get(actorId);
        int ticket = this.getTickets()[threadId];
        boolean bl2 = promptCancel = actor.getPromptCancellation() && ticket != -1 && expectedResult == Cancelled.INSTANCE;
        if (this.getSuspended()[threadId] || promptCancel) {
            return actor.getCancelOnSuspension() && expectedResult == Cancelled.INSTANCE ? this.createContext(this.getState().nextByCancellation(actor, ticket), threadId) : null;
        }
        TransitionInfo transitionInfo2 = this.getState().next(actor, expectedResult, this.getTickets()[threadId]);
        return transitionInfo2 != null ? this.createContext(transitionInfo2, threadId) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hblegal(int threadId) {
        int actorId = this.getExecuted()[threadId];
        HBClock clocks = this.getResults().getParallelResultsWithClock().get(threadId - 1).get(actorId).getClockOnStart();
        int n = 1;
        int n2 = this.getScenario().getThreads();
        if (n <= n2) {
            while (true) {
                void i;
                if (this.getExecuted()[i] < clocks.get((int)(i - true))) {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final LinearizabilityContext createContext(TransitionInfo $this$createContext, int threadId) {
        int[] nArray = this.getExecuted();
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        int[] nextExecuted = nArray2;
        boolean[] blArray = this.getSuspended();
        boolean bl2 = false;
        boolean[] blArray2 = Arrays.copyOf(blArray, blArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)blArray2, (String)"java.util.Arrays.copyOf(this, size)");
        boolean[] nextSuspended = blArray2;
        int[] nArray3 = this.getTickets();
        int n = 0;
        int[] nArray4 = Arrays.copyOf(nArray3, nArray3.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray4, (String)"java.util.Arrays.copyOf(this, size)");
        int[] nextTickets = nArray4;
        int n2 = nextTickets[threadId] = Intrinsics.areEqual((Object)$this$createContext.getResult(), (Object)Suspended.INSTANCE) ? $this$createContext.getTicket() : -1;
        if ($this$createContext.getRf() != null) {
            int[] $this$forEachIndexed$iv = nextTickets;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int item$iv : $this$forEachIndexed$iv) {
                void ticket;
                int n3 = index$iv++;
                int n4 = item$iv;
                int tid = n3;
                boolean bl3 = false;
                if (tid == threadId || ticket == -1) continue;
                nextTickets[tid] = $this$createContext.getRf()[ticket];
            }
        }
        nextSuspended[threadId] = Intrinsics.areEqual((Object)$this$createContext.getResult(), (Object)Suspended.INSTANCE);
        IntRange intRange = this.getThreads();
        int $this$forEachIndexed$iv = intRange.getFirst();
        if ($this$forEachIndexed$iv <= (n = intRange.getLast())) {
            while (true) {
                void tid;
                if ($this$createContext.getResumedTickets().contains(nextTickets[tid])) {
                    nextSuspended[tid] = false;
                }
                if (tid == n) break;
                ++tid;
            }
        }
        if ($this$createContext.getOperationCompleted()) {
            int n5 = threadId;
            int n6 = nextExecuted[n5];
            nextExecuted[n5] = n6 + 1;
        }
        int[] nArray5 = nextTickets;
        boolean[] blArray3 = nextSuspended;
        int[] nArray6 = nextExecuted;
        ExecutionResult executionResult = this.getResults();
        LTS.State state = $this$createContext.getNextState();
        return new LinearizabilityContext(this.getScenario(), executionResult, state, nArray6, blArray3, nArray5);
    }

    public LinearizabilityContext(@NotNull ExecutionScenario scenario, @NotNull ExecutionResult results, @NotNull LTS.State state) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(scenario, results, state, null, null, null, 56, null);
    }

    public LinearizabilityContext(@NotNull ExecutionScenario scenario, @NotNull ExecutionResult results, @NotNull LTS.State state, @NotNull int[] executed, @NotNull boolean[] suspended, @NotNull int[] tickets) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)executed, (String)"executed");
        Intrinsics.checkNotNullParameter((Object)suspended, (String)"suspended");
        Intrinsics.checkNotNullParameter((Object)tickets, (String)"tickets");
        super(scenario, results, state, executed, suspended, tickets);
    }
}

