/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.kotlinx.lincheck.ActorKt;
import org.jetbrains.kotlinx.lincheck.annotations.OpGroupConfig;
import org.jetbrains.kotlinx.lincheck.annotations.Operation;
import org.jetbrains.kotlinx.lincheck.annotations.Param;
import org.jetbrains.kotlinx.lincheck.annotations.StateRepresentation;
import org.jetbrains.kotlinx.lincheck.annotations.Validate;
import org.jetbrains.kotlinx.lincheck.execution.ActorGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.BooleanGen;
import org.jetbrains.kotlinx.lincheck.paramgen.ByteGen;
import org.jetbrains.kotlinx.lincheck.paramgen.DoubleGen;
import org.jetbrains.kotlinx.lincheck.paramgen.FloatGen;
import org.jetbrains.kotlinx.lincheck.paramgen.IntGen;
import org.jetbrains.kotlinx.lincheck.paramgen.LongGen;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.ShortGen;
import org.jetbrains.kotlinx.lincheck.paramgen.StringGen;

public class CTestStructure {
    public final List<ActorGenerator> actorGenerators;
    public final List<OperationGroup> operationGroups;
    public final List<Method> validationFunctions;
    public final Method stateRepresentation;

    private CTestStructure(List<ActorGenerator> actorGenerators, List<OperationGroup> operationGroups, List<Method> validationFunctions, Method stateRepresentation) {
        this.actorGenerators = actorGenerators;
        this.operationGroups = operationGroups;
        this.validationFunctions = validationFunctions;
        this.stateRepresentation = stateRepresentation;
    }

    public static CTestStructure getFromTestClass(Class<?> testClass) {
        HashMap namedGens = new HashMap();
        HashMap<String, OperationGroup> groupConfigs = new HashMap<String, OperationGroup>();
        ArrayList<ActorGenerator> actorGenerators = new ArrayList<ActorGenerator>();
        ArrayList<Method> validationFunctions = new ArrayList<Method>();
        ArrayList<Method> stateRepresentations = new ArrayList<Method>();
        for (Class<?> clazz = testClass; clazz != null; clazz = clazz.getSuperclass()) {
            CTestStructure.readTestStructureFromClass(clazz, namedGens, groupConfigs, actorGenerators, validationFunctions, stateRepresentations);
        }
        if (stateRepresentations.size() > 1) {
            throw new IllegalStateException("Several functions marked with " + StateRepresentation.class.getSimpleName() + " were found, while at most one should be specified: " + stateRepresentations.stream().map(Method::getName).collect(Collectors.joining(", ")));
        }
        Method stateRepresentation = null;
        if (!stateRepresentations.isEmpty()) {
            stateRepresentation = (Method)stateRepresentations.get(0);
        }
        return new CTestStructure(actorGenerators, new ArrayList<OperationGroup>(groupConfigs.values()), validationFunctions, stateRepresentation);
    }

    private static void readTestStructureFromClass(Class<?> clazz, Map<String, ParameterGenerator<?>> namedGens, Map<String, OperationGroup> groupConfigs, List<ActorGenerator> actorGenerators, List<Method> validationFunctions, List<Method> stateRepresentations) {
        for (Param paramAnn : (Param[])clazz.getAnnotationsByType(Param.class)) {
            if (paramAnn.name().isEmpty()) {
                throw new IllegalArgumentException("@Param name in class declaration cannot be empty");
            }
            namedGens.put(paramAnn.name(), CTestStructure.createGenerator(paramAnn));
        }
        Map<Class<?>, ParameterGenerator<?>> defaultGens = CTestStructure.createDefaultGenerators();
        for (OpGroupConfig opGroupConfigAnn : (OpGroupConfig[])clazz.getAnnotationsByType(OpGroupConfig.class)) {
            groupConfigs.put(opGroupConfigAnn.name(), new OperationGroup(opGroupConfigAnn.name(), opGroupConfigAnn.nonParallel()));
        }
        for (Method m : CTestStructure.getDeclaredMethodSorted(clazz)) {
            if (m.isAnnotationPresent(Operation.class)) {
                Operation opAnn = m.getAnnotation(Operation.class);
                boolean isSuspendableMethod = ActorKt.isSuspendable(m);
                if (opAnn.params().length > 0 && opAnn.params().length != m.getParameterCount()) {
                    throw new IllegalArgumentException("Invalid count of paramgen for " + m.toString() + " method in @Operation");
                }
                ArrayList gens = new ArrayList();
                int nParameters = m.getParameterCount() - (isSuspendableMethod ? 1 : 0);
                for (int i = 0; i < nParameters; ++i) {
                    String nameInOperation = opAnn.params().length > 0 ? opAnn.params()[i] : null;
                    gens.add(CTestStructure.getOrCreateGenerator(m, m.getParameters()[i], nameInOperation, namedGens, defaultGens));
                }
                List<Class<? extends Throwable>> handledExceptions = Arrays.asList(opAnn.handleExceptionsAsResult());
                ActorGenerator actorGenerator = new ActorGenerator(m, gens, handledExceptions, opAnn.runOnce(), opAnn.cancellableOnSuspension(), opAnn.allowExtraSuspension(), opAnn.blocking(), opAnn.causesBlocking(), opAnn.promptCancellation());
                actorGenerators.add(actorGenerator);
                String opGroup = opAnn.group();
                if (!opGroup.isEmpty()) {
                    OperationGroup operationGroup = groupConfigs.get(opGroup);
                    if (operationGroup == null) {
                        throw new IllegalStateException("Operation group " + opGroup + " is not configured");
                    }
                    operationGroup.actors.add(actorGenerator);
                }
            }
            if (m.isAnnotationPresent(Validate.class)) {
                if (m.getParameterCount() != 0) {
                    throw new IllegalStateException("Validation function " + m.getName() + " should not have parameters");
                }
                validationFunctions.add(m);
            }
            if (!m.isAnnotationPresent(StateRepresentation.class)) continue;
            if (m.getParameterCount() != 0) {
                throw new IllegalStateException("State representation function " + m.getName() + " should not have parameters");
            }
            if (m.getReturnType() != String.class) {
                throw new IllegalStateException("State representation function " + m.getName() + " should have String return type");
            }
            stateRepresentations.add(m);
        }
    }

    private static Method[] getDeclaredMethodSorted(Class<?> clazz) {
        Method[] methods2 = clazz.getDeclaredMethods();
        Comparator<Method> comparator = Comparator.comparing(Method::getName).thenComparing(m -> Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(":")));
        Arrays.sort(methods2, comparator);
        return methods2;
    }

    private static ParameterGenerator<?> getOrCreateGenerator(Method m, Parameter p, String nameInOperation, Map<String, ParameterGenerator<?>> namedGens, Map<Class<?>, ParameterGenerator<?>> defaultGens) {
        Param paramAnn = p.getAnnotation(Param.class);
        if (paramAnn == null) {
            String name;
            String string = nameInOperation != null ? nameInOperation : (name = p.isNamePresent() ? p.getName() : null);
            if (name != null) {
                return CTestStructure.checkAndGetNamedGenerator(namedGens, name);
            }
            ParameterGenerator<?> defaultGenerator = defaultGens.get(p.getType());
            if (defaultGenerator != null) {
                return defaultGenerator;
            }
            throw new IllegalStateException("Generator for parameter \"" + p + "\" in method \"" + m.getName() + "\" should be specified.");
        }
        if (!paramAnn.name().isEmpty() && paramAnn.gen() != ParameterGenerator.Dummy.class) {
            throw new IllegalStateException("@Param should have either name or gen with optionally configuration");
        }
        if (!paramAnn.name().isEmpty()) {
            return CTestStructure.checkAndGetNamedGenerator(namedGens, paramAnn.name());
        }
        return CTestStructure.createGenerator(paramAnn);
    }

    private static ParameterGenerator<?> createGenerator(Param paramAnn) {
        try {
            return paramAnn.gen().getConstructor(String.class).newInstance(paramAnn.conf());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create parameter gen", e);
        }
    }

    private static Map<Class<?>, ParameterGenerator<?>> createDefaultGenerators() {
        HashMap defaultGens = new HashMap();
        defaultGens.put(Boolean.TYPE, new BooleanGen(""));
        defaultGens.put(Boolean.class, (ParameterGenerator)defaultGens.get(Boolean.TYPE));
        defaultGens.put(Byte.TYPE, new ByteGen(""));
        defaultGens.put(Byte.class, (ParameterGenerator)defaultGens.get(Byte.TYPE));
        defaultGens.put(Short.TYPE, new ShortGen(""));
        defaultGens.put(Short.class, (ParameterGenerator)defaultGens.get(Short.TYPE));
        defaultGens.put(Integer.TYPE, new IntGen(""));
        defaultGens.put(Integer.class, (ParameterGenerator)defaultGens.get(Integer.TYPE));
        defaultGens.put(Long.TYPE, new LongGen(""));
        defaultGens.put(Long.class, (ParameterGenerator)defaultGens.get(Long.TYPE));
        defaultGens.put(Float.TYPE, new FloatGen(""));
        defaultGens.put(Float.class, (ParameterGenerator)defaultGens.get(Float.TYPE));
        defaultGens.put(Double.TYPE, new DoubleGen(""));
        defaultGens.put(Double.class, (ParameterGenerator)defaultGens.get(Double.TYPE));
        defaultGens.put(String.class, new StringGen(""));
        return defaultGens;
    }

    private static ParameterGenerator<?> checkAndGetNamedGenerator(Map<String, ParameterGenerator<?>> namedGens, String name) {
        return Objects.requireNonNull(namedGens.get(name), "Unknown generator name: \"" + name + "\"");
    }

    public static class OperationGroup {
        public final String name;
        public final boolean nonParallel;
        public final List<ActorGenerator> actors;

        public OperationGroup(String name, boolean nonParallel) {
            this.name = name;
            this.nonParallel = nonParallel;
            this.actors = new ArrayList<ActorGenerator>();
        }

        public String toString() {
            return "OperationGroup{name='" + this.name + '\'' + ", nonParallel=" + this.nonParallel + ", actors=" + this.actors + '}';
        }
    }
}

