/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.CTestConfiguration;
import org.jetbrains.kotlinx.lincheck.CTestConfigurationKt;
import org.jetbrains.kotlinx.lincheck.CTestStructure;
import org.jetbrains.kotlinx.lincheck.LinChecker;
import org.jetbrains.kotlinx.lincheck.LinChecker$hasSuspendableActorsInInitPart$1;
import org.jetbrains.kotlinx.lincheck.LinCheckerKt$sam$java_util_function_Predicate$0;
import org.jetbrains.kotlinx.lincheck.LincheckAssertionError;
import org.jetbrains.kotlinx.lincheck.LoggingLevel;
import org.jetbrains.kotlinx.lincheck.Options;
import org.jetbrains.kotlinx.lincheck.Reporter;
import org.jetbrains.kotlinx.lincheck.ReporterKt;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.annotations.LogLevel;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionGenerator;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0001,B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u000f\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u000bH\u0002J\f\u0010\u001d\u001a\u00020\u0011*\u00020\u0011H\u0002J\u0014\u0010\u001e\u001a\n \u000e*\u0004\u0018\u00010\u001f0\u001f*\u00020\u000bH\u0002J\u001c\u0010 \u001a\n \u000e*\u0004\u0018\u00010!0!*\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0014\u0010#\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u001e\u0010%\u001a\u0004\u0018\u00010\u001b*\u00020\u00112\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020!H\u0002J&\u0010'\u001a\u0004\u0018\u00010\u001b*\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0016\u0010'\u001a\u0004\u0018\u00010\u001b*\u00020\u00112\u0006\u0010$\u001a\u00020\u000bH\u0002J\f\u0010+\u001a\u00020\u0019*\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0018\u0010\u0017\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker;", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "(Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/Options;)V", "reporter", "Lorg/jetbrains/kotlinx/lincheck/Reporter;", "testConfigurations", "", "Lorg/jetbrains/kotlinx/lincheck/CTestConfiguration;", "testStructure", "Lorg/jetbrains/kotlinx/lincheck/CTestStructure;", "kotlin.jvm.PlatformType", "hasPostPartAndSuspendableActors", "", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "getHasPostPartAndSuspendableActors", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;)Z", "hasSuspendableActorsInInitPart", "getHasSuspendableActorsInInitPart", "isParallelPartEmpty", "isValid", "check", "", "checkImpl", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "checkImpl$lincheck", "copy", "createExecutionGenerator", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionGenerator;", "createVerifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "checkStateEquivalence", "minimize", "testCfg", "run", "verifier", "tryMinimize", "threadId", "", "position", "validate", "Companion", "lincheck"})
public final class LinChecker {
    private final CTestStructure testStructure;
    private final List<CTestConfiguration> testConfigurations;
    private final Reporter reporter;
    private final Class<?> testClass;
    public static final Companion Companion = new Companion(null);

    public final void check() {
        LincheckFailure lincheckFailure = this.checkImpl$lincheck();
        if (lincheckFailure == null) {
            return;
        }
        LincheckFailure failure = lincheckFailure;
        throw (Throwable)((Object)new LincheckAssertionError(failure));
    }

    @Nullable
    public final LincheckFailure checkImpl$lincheck() {
        Collection collection = this.testConfigurations;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "No Lincheck test configuration to run";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        for (CTestConfiguration testCfg : this.testConfigurations) {
            LincheckFailure failure = this.checkImpl(testCfg);
            if (failure == null) continue;
            return failure;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final LincheckFailure checkImpl(CTestConfiguration $this$checkImpl) {
        ExecutionGenerator exGen = this.createExecutionGenerator($this$checkImpl);
        Verifier verifier = this.createVerifier($this$checkImpl, true);
        int n = 0;
        int n2 = ((Collection)$this$checkImpl.getCustomScenarios()).size();
        while (n < n2) {
            void i;
            ExecutionScenario scenario = $this$checkImpl.getCustomScenarios().get((int)i);
            this.validate(scenario);
            this.reporter.logIteration((int)(i + true), $this$checkImpl.getCustomScenarios().size(), scenario);
            Verifier verifier2 = verifier;
            Intrinsics.checkNotNullExpressionValue((Object)verifier2, (String)"verifier");
            LincheckFailure failure = this.run(scenario, $this$checkImpl, verifier2);
            if (failure != null) {
                return failure;
            }
            ++i;
        }
        n = $this$checkImpl.getIterations();
        n2 = 0;
        int n3 = 0;
        n3 = 0;
        int n4 = n;
        while (n3 < n4) {
            ExecutionScenario scenario;
            int i = n3++;
            boolean bl = false;
            ExecutionScenario executionScenario = scenario = exGen.nextExecution();
            Intrinsics.checkNotNullExpressionValue((Object)executionScenario, (String)"scenario");
            this.validate(executionScenario);
            this.reporter.logIteration(i + 1 + $this$checkImpl.getCustomScenarios().size(), $this$checkImpl.getIterations(), scenario);
            Verifier verifier3 = verifier;
            Intrinsics.checkNotNullExpressionValue((Object)verifier3, (String)"verifier");
            LincheckFailure failure = this.run(scenario, $this$checkImpl, verifier3);
            if (failure == null) continue;
            LincheckFailure minimizedFailedIteration = !$this$checkImpl.getMinimizeFailedScenario() ? failure : this.minimize(failure, $this$checkImpl);
            this.reporter.logFailedIteration(minimizedFailedIteration);
            return minimizedFailedIteration;
        }
        return null;
    }

    private final LincheckFailure minimize(LincheckFailure $this$minimize, CTestConfiguration testCfg) {
        this.reporter.logScenarioMinimization($this$minimize.getScenario());
        LincheckFailure minimizedFailure = $this$minimize;
        while (true) {
            if (this.tryMinimize(minimizedFailure.getScenario(), testCfg) != null) continue;
            break;
        }
        return minimizedFailure;
    }

    /*
     * WARNING - void declaration
     */
    private final LincheckFailure tryMinimize(ExecutionScenario $this$tryMinimize, CTestConfiguration testCfg) {
        int j;
        int i;
        List<List<Actor>> list = $this$tryMinimize.parallelExecution;
        Intrinsics.checkNotNullExpressionValue(list, (String)"parallelExecution");
        int n = ((Collection)list).size();
        --n;
        boolean bl = false;
        while (n >= 0) {
            List<Actor> list2 = $this$tryMinimize.parallelExecution.get(i);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"parallelExecution[i]");
            int n2 = ((Collection)list2).size();
            --n2;
            boolean bl2 = false;
            while (n2 >= 0) {
                void j2;
                LincheckFailure failure = this.tryMinimize($this$tryMinimize, i + 1, (int)j2, testCfg);
                if (failure != null) {
                    return failure;
                }
                --j2;
            }
            --i;
        }
        List<Actor> list3 = $this$tryMinimize.initExecution;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"initExecution");
        i = ((Collection)list3).size();
        --i;
        bl = false;
        while (i >= 0) {
            LincheckFailure failure = this.tryMinimize($this$tryMinimize, 0, j, testCfg);
            if (failure != null) {
                return failure;
            }
            --j;
        }
        List<Actor> list4 = $this$tryMinimize.postExecution;
        Intrinsics.checkNotNullExpressionValue(list4, (String)"postExecution");
        j = ((Collection)list4).size();
        --j;
        bl = false;
        while (j >= 0) {
            LincheckFailure failure = this.tryMinimize($this$tryMinimize, $this$tryMinimize.getThreads() + 1, j, testCfg);
            if (failure != null) {
                return failure;
            }
            --j;
        }
        return null;
    }

    private final LincheckFailure tryMinimize(ExecutionScenario $this$tryMinimize, int threadId, int position, CTestConfiguration testCfg) {
        LincheckFailure lincheckFailure;
        ExecutionScenario newScenario = this.copy($this$tryMinimize);
        List<Actor> list = UtilsKt.get(newScenario, threadId);
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.kotlinx.lincheck.Actor>");
        }
        List actors = TypeIntrinsics.asMutableList(list);
        actors.remove(position);
        if (actors.isEmpty() && threadId != 0 && threadId != newScenario.getThreads() + 1) {
            newScenario.parallelExecution.remove(threadId - 1);
        }
        if (this.isValid(newScenario)) {
            Verifier verifier;
            Verifier verifier2 = verifier = this.createVerifier(testCfg, false);
            Intrinsics.checkNotNullExpressionValue((Object)verifier2, (String)"verifier");
            lincheckFailure = this.run(newScenario, testCfg, verifier2);
        } else {
            lincheckFailure = null;
        }
        return lincheckFailure;
    }

    private final LincheckFailure run(ExecutionScenario $this$run, CTestConfiguration testCfg, Verifier verifier) {
        List<Method> list = this.testStructure.validationFunctions;
        Intrinsics.checkNotNullExpressionValue(list, (String)"testStructure.validationFunctions");
        return testCfg.createStrategy(this.testClass, $this$run, list, this.testStructure.stateRepresentation, verifier).run();
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionScenario copy(ExecutionScenario $this$copy) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list = new ArrayList($this$copy.initExecution);
        List<List<Actor>> list2 = $this$copy.parallelExecution;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"parallelExecution");
        Iterable iterable = list2;
        List list3 = list;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list4 = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ArrayList arrayList = new ArrayList((Collection)it);
            collection.add(arrayList);
        }
        collection = (List)destination$iv$iv;
        List list5 = new ArrayList($this$copy.postExecution);
        List list6 = collection;
        List list7 = list3;
        return new ExecutionScenario(list7, list6, list5);
    }

    private final boolean isValid(ExecutionScenario $this$isValid) {
        return !this.isParallelPartEmpty($this$isValid) && (!$this$isValid.hasSuspendableActors() || !this.getHasSuspendableActorsInInitPart($this$isValid) && !this.getHasPostPartAndSuspendableActors($this$isValid));
    }

    private final void validate(ExecutionScenario $this$validate) {
        boolean bl = !this.isParallelPartEmpty($this$validate);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The generated scenario has empty parallel part";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if ($this$validate.hasSuspendableActors()) {
            bl = !this.getHasSuspendableActorsInInitPart($this$validate);
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "The generated scenario for the test class with suspendable methods contains suspendable actors in initial part";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = !this.getHasPostPartAndSuspendableActors($this$validate);
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "The generated scenario  for the test class with suspendable methods has non-empty post part";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    private final boolean getHasSuspendableActorsInInitPart(ExecutionScenario $this$hasSuspendableActorsInInitPart) {
        Stream stream = $this$hasSuspendableActorsInInitPart.initExecution.stream();
        Object object = (Function1)LinChecker$hasSuspendableActorsInInitPart$1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new LinCheckerKt$sam$java_util_function_Predicate$0(function1);
        }
        return stream.anyMatch((Predicate)object);
    }

    private final boolean getHasPostPartAndSuspendableActors(ExecutionScenario $this$hasPostPartAndSuspendableActors) {
        return $this$hasPostPartAndSuspendableActors.parallelExecution.stream().anyMatch(hasPostPartAndSuspendableActors.1.INSTANCE) && $this$hasPostPartAndSuspendableActors.postExecution.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isParallelPartEmpty(ExecutionScenario $this$isParallelPartEmpty) {
        void $this$mapTo$iv$iv;
        List<List<Actor>> list = $this$isParallelPartEmpty.parallelExecution;
        Intrinsics.checkNotNullExpressionValue(list, (String)"parallelExecution");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.size();
            collection.add(n);
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)) == 0;
    }

    private final Verifier createVerifier(CTestConfiguration $this$createVerifier, boolean checkStateEquivalence) {
        boolean stateEquivalenceCorrect;
        Verifier verifier = $this$createVerifier.getVerifierClass().getConstructor(Class.class).newInstance($this$createVerifier.getSequentialSpecification());
        boolean bl = false;
        boolean bl2 = false;
        Verifier it = verifier;
        boolean bl3 = false;
        if (checkStateEquivalence && !(stateEquivalenceCorrect = it.checkStateEquivalenceImplementation())) {
            if ($this$createVerifier.getRequireStateEquivalenceImplCheck()) {
                ReporterKt.appendStateEquivalenceViolationMessage(new StringBuilder(), $this$createVerifier.getSequentialSpecification());
                String errorMessage = Unit.INSTANCE.toString();
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(errorMessage.toString());
            }
            this.reporter.logStateEquivalenceViolation($this$createVerifier.getSequentialSpecification());
        }
        return verifier;
    }

    private final ExecutionGenerator createExecutionGenerator(CTestConfiguration $this$createExecutionGenerator) {
        return $this$createExecutionGenerator.getGeneratorClass().getConstructor(CTestConfiguration.class, CTestStructure.class).newInstance($this$createExecutionGenerator, this.testStructure);
    }

    public LinChecker(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Object object;
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.testClass = testClass;
        this.testStructure = CTestStructure.getFromTestClass(this.testClass);
        Object object2 = options;
        if (object2 == null || (object2 = object2.getLogLevel$lincheck()) == null) {
            LogLevel logLevel = this.testClass.getAnnotation(LogLevel.class);
            object2 = object = logLevel != null ? logLevel.value() : null;
        }
        if (object2 == null) {
            object = ReporterKt.DEFAULT_LOG_LEVEL;
        }
        Object logLevel = object;
        this.reporter = new Reporter((LoggingLevel)((Object)logLevel));
        this.testConfigurations = options != null ? CollectionsKt.listOf(options.createTestConfigurations(this.testClass)) : CTestConfigurationKt.createFromTestClassAnnotations(this.testClass);
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Companion.check(testClass, options);
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass) {
        org.jetbrains.kotlinx.lincheck.LinChecker$Companion.check$default(Companion, testClass, null, 2, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0012\b\u0002\u0010\u0007\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker$Companion;", "", "()V", "check", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "lincheck"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            new LinChecker(testClass, options).check();
        }

        public static /* synthetic */ void check$default(Companion companion, Class clazz, Options options, int n, Object object) {
            if ((n & 2) != 0) {
                options = null;
            }
            companion.check(clazz, options);
        }

        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass) {
            org.jetbrains.kotlinx.lincheck.LinChecker$Companion.check$default(this, testClass, null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

