/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\b\u0000\u0018\u0000 62\u000209:\u000267B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0019H\u0082\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010 \u001a\u00020\b2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b \u0010!J\u001f\u0010#\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b#\u0010\u0018J\u001f\u0010$\u001a\u00020\b2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001dH\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b(\u0010\u0010R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010\u0002\u001a\u00020\u00018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010,R\u0016\u0010-\u001a\u00020\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010,R\u001f\u00100\u001a\b\u0012\u0004\u0012\u00020/0.8\u0006@\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0016\u00104\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u0010+R\u0016\u00105\u001a\u00020\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u0010,\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor;", "", "nThreads", "runnerHash", "<init>", "(II)V", "", "timeoutMs", "", "await", "(J)V", "iThread", "deadline", "awaitTask", "(IJ)V", "close", "()V", "", "getResult", "(IJ)Ljava/lang/Object;", "getTask", "(I)Ljava/lang/Object;", "any", "setResult", "(ILjava/lang/Object;)V", "Lkotlin/Function0;", "getter", "spinWait", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "", "Ljava/lang/Runnable;", "tasks", "submitAndAwait", "([Ljava/lang/Runnable;J)V", "task", "submitTask", "submitTasks", "([Ljava/lang/Object;)V", "testThreadRunnable", "(I)Ljava/lang/Runnable;", "updateAdaptiveSpinCount", "", "hangDetected", "Z", "I", "spinCount", "", "Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "threads", "Ljava/util/List;", "getThreads", "()Ljava/util/List;", "wasParked", "wasParkedBalance", "Companion", "TestThread", "lincheck", "Ljava/io/Closeable;"})
public final class FixedActiveThreadsExecutor
implements Closeable {
    @NotNull
    private final List<TestThread> threads;
    AtomicReferenceArray tasks;
    private AtomicReferenceArray results;
    private int spinCount;
    private volatile boolean wasParked;
    private int wasParkedBalance;
    private boolean hangDetected;
    private final int nThreads;
    private static final Object SHUTDOWN;
    private static final Object DONE;
    private static final int MAX_SPIN_COUNT = 1000000;
    private static final int WAS_PARK_BALANCE_THRESHOLD = 20;
    public static final Companion Companion;

    @NotNull
    public final List<TestThread> getThreads() {
        return this.threads;
    }

    public final void submitAndAwait(@NotNull Runnable[] tasks, long timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        boolean bl = tasks.length == this.nThreads;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.submitTasks(tasks);
        this.await(timeoutMs);
        this.updateAdaptiveSpinCount();
    }

    /*
     * WARNING - void declaration
     */
    private final void submitTasks(Object[] tasks) {
        int n = 0;
        int n2 = this.nThreads;
        while (n < n2) {
            void i;
            this.results.set((int)i, null);
            this.submitTask((int)i, tasks[i]);
            ++i;
        }
    }

    private final void updateAdaptiveSpinCount() {
        if (this.wasParked) {
            this.wasParked = false;
            int n = this.wasParkedBalance;
            this.wasParkedBalance = n + 1;
            if (this.wasParkedBalance >= 20) {
                this.spinCount /= 2;
                this.wasParkedBalance = 0;
            }
        } else {
            int n = this.wasParkedBalance;
            this.wasParkedBalance = n + -1;
            if (this.wasParkedBalance <= -20) {
                n = this.spinCount * 2;
                int n2 = 1000000;
                boolean bl = false;
                this.spinCount = Math.min(n, n2);
                this.wasParkedBalance = 0;
            }
        }
    }

    private final void submitTask(int iThread, Object task) {
        if (this.tasks.compareAndSet(iThread, null, task)) {
            return;
        }
        Object e = this.tasks.get(iThread);
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlinx.lincheck.runner.FixedActiveThreadsExecutor.TestThread");
        }
        TestThread thread = (TestThread)e;
        this.tasks.set(iThread, task);
        LockSupport.unpark(thread);
    }

    /*
     * WARNING - void declaration
     */
    private final void await(long timeoutMs) {
        long deadline = System.currentTimeMillis() + timeoutMs;
        int n = 0;
        int n2 = this.nThreads;
        while (n < n2) {
            void iThread;
            this.awaitTask((int)iThread, deadline);
            ++iThread;
        }
    }

    private final void awaitTask(int iThread, long deadline) {
        Object result2 = this.getResult(iThread, deadline);
        if (Intrinsics.areEqual((Object)result2, (Object)DONE) ^ true) {
            Object object = result2;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
            }
            throw (Throwable)new ExecutionException((Throwable)object);
        }
    }

    private final Object getResult(int iThread, long deadline) {
        Object v1;
        int n;
        boolean $i$f$spinWait;
        FixedActiveThreadsExecutor this_$iv;
        block5: {
            this_$iv = this;
            $i$f$spinWait = false;
            n = this_$iv.spinCount;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl2 = false;
                boolean bl3 = false;
                Object e = this.results.get(iThread);
                if (e == null) continue;
                Object e2 = e;
                boolean bl4 = false;
                boolean bl5 = false;
                Object it$iv2 = e2;
                boolean bl6 = false;
                v1 = it$iv2;
                break block5;
            }
            this_$iv.wasParked = true;
            v1 = null;
        }
        if (v1 != null) {
            this_$iv = v1;
            $i$f$spinWait = false;
            n = 0;
            FixedActiveThreadsExecutor it = this_$iv;
            boolean bl = false;
            return it;
        }
        Thread currentThread = Thread.currentThread();
        if (this.results.compareAndSet(iThread, null, Thread.currentThread())) {
            while (this.results.get(iThread) == currentThread) {
                long timeLeft = deadline - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    this.hangDetected = true;
                    throw (Throwable)new TimeoutException();
                }
                LockSupport.parkNanos(timeLeft * (long)1000000);
            }
        }
        Object e = this.results.get(iThread);
        Intrinsics.checkNotNull(e);
        return e;
    }

    private final Runnable testThreadRunnable(int iThread) {
        return new Runnable(this, iThread){
            final /* synthetic */ FixedActiveThreadsExecutor this$0;
            final /* synthetic */ int $iThread;

            public final void run() {
                Object task;
                while (!Intrinsics.areEqual((Object)(task = FixedActiveThreadsExecutor.access$getTask(this.this$0, this.$iThread)), (Object)FixedActiveThreadsExecutor.access$getSHUTDOWN$cp())) {
                    this.this$0.tasks.set(this.$iThread, null);
                    Object object = task;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Runnable");
                    }
                    Runnable runnable = (Runnable)object;
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        FixedActiveThreadsExecutor.access$setResult(this.this$0, this.$iThread, UtilsKt.wrapInvalidAccessFromUnnamedModuleExceptionWithDescription(e));
                        continue;
                    }
                    FixedActiveThreadsExecutor.access$setResult(this.this$0, this.$iThread, FixedActiveThreadsExecutor.access$getDONE$cp());
                }
                return;
            }
            {
                this.this$0 = fixedActiveThreadsExecutor;
                this.$iThread = n;
            }
        };
    }

    private final Object getTask(int iThread) {
        Object v1;
        int n;
        FixedActiveThreadsExecutor this_$iv;
        block4: {
            this_$iv = this;
            boolean $i$f$spinWait = false;
            n = this_$iv.spinCount;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl2 = false;
                boolean bl3 = false;
                Object e = this.tasks.get(iThread);
                if (e == null) continue;
                Object e2 = e;
                boolean bl4 = false;
                boolean bl5 = false;
                Object it$iv2 = e2;
                boolean bl6 = false;
                v1 = it$iv2;
                break block4;
            }
            this_$iv.wasParked = true;
            v1 = null;
        }
        if (v1 != null) {
            this_$iv = v1;
            boolean bl = false;
            n = 0;
            FixedActiveThreadsExecutor it = this_$iv;
            boolean bl7 = false;
            return it;
        }
        Thread currentThread = Thread.currentThread();
        if (this.tasks.compareAndSet(iThread, null, Thread.currentThread())) {
            while (this.tasks.get(iThread) == currentThread) {
                LockSupport.park();
            }
        }
        Object e = this.tasks.get(iThread);
        Intrinsics.checkNotNull(e);
        return e;
    }

    private final void setResult(int iThread, Object any) {
        if (this.results.compareAndSet(iThread, null, any)) {
            return;
        }
        Object e = this.results.get(iThread);
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Thread");
        }
        Thread thread = (Thread)e;
        this.results.set(iThread, any);
        LockSupport.unpark(thread);
    }

    private final Object spinWait(Function0<? extends Object> getter) {
        int $i$f$spinWait = 0;
        int n = this.spinCount;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            Object object = getter.invoke();
            if (object == null) continue;
            Object object2 = object;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it2 = object2;
            boolean bl5 = false;
            return it2;
        }
        this.wasParked = true;
        return null;
    }

    @Override
    public void close() {
        Object[] objectArray;
        int n = this.nThreads;
        FixedActiveThreadsExecutor fixedActiveThreadsExecutor = this;
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3 = n2;
            int n4 = n2++;
            objectArray = objectArray2;
            boolean bl = false;
            objectArray[n4] = object = SHUTDOWN;
        }
        objectArray = objectArray2;
        fixedActiveThreadsExecutor.submitTasks(objectArray);
        if (this.hangDetected) {
            for (TestThread t : this.threads) {
                t.stop();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public FixedActiveThreadsExecutor(int nThreads, int runnerHash) {
        Collection<TestThread> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.nThreads = nThreads;
        this.tasks = new AtomicReferenceArray(this.nThreads);
        this.results = new AtomicReferenceArray(this.nThreads);
        this.spinCount = 40000;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.nThreads);
        FixedActiveThreadsExecutor fixedActiveThreadsExecutor = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void iThread;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            TestThread testThread = new TestThread((int)iThread, runnerHash, this.testThreadRunnable((int)iThread));
            boolean bl2 = false;
            boolean bl3 = false;
            TestThread it = testThread;
            boolean bl4 = false;
            it.start();
            TestThread testThread2 = testThread;
            collection.add(testThread2);
        }
        collection = (List)destination$iv$iv;
        fixedActiveThreadsExecutor.threads = collection;
    }

    public static final /* synthetic */ Object access$getTask(FixedActiveThreadsExecutor $this, int iThread) {
        return $this.getTask(iThread);
    }

    public static final /* synthetic */ Object access$getSHUTDOWN$cp() {
        return SHUTDOWN;
    }

    public static final /* synthetic */ void access$setResult(FixedActiveThreadsExecutor $this, int iThread, Object any) {
        $this.setResult(iThread, any);
    }

    public static final /* synthetic */ Object access$getDONE$cp() {
        return DONE;
    }

    public static final /* synthetic */ void access$setSpinCount$p(FixedActiveThreadsExecutor $this, int n) {
        $this.spinCount = n;
    }

    public static final /* synthetic */ boolean access$getWasParked$p(FixedActiveThreadsExecutor $this) {
        return $this.wasParked;
    }

    static {
        Companion = new Companion(null);
        SHUTDOWN = new Object();
        DONE = new Object();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R \u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "Ljava/lang/Thread;", "iThread", "", "runnerHash", "r", "Ljava/lang/Runnable;", "(IILjava/lang/Runnable;)V", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "getCont", "()Lkotlinx/coroutines/CancellableContinuation;", "setCont", "(Lkotlinx/coroutines/CancellableContinuation;)V", "getIThread", "()I", "getRunnerHash", "lincheck"})
    public static final class TestThread
    extends Thread {
        @Nullable
        private CancellableContinuation<?> cont;
        private final int iThread;
        private final int runnerHash;

        @Nullable
        public final CancellableContinuation<?> getCont() {
            return this.cont;
        }

        public final void setCont(@Nullable CancellableContinuation<?> cancellableContinuation) {
            this.cont = cancellableContinuation;
        }

        public final int getIThread() {
            return this.iThread;
        }

        public final int getRunnerHash() {
            return this.runnerHash;
        }

        public TestThread(int iThread, int runnerHash, @NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            super(r, "FixedActiveThreadsExecutor@" + runnerHash + '-' + iThread);
            this.iThread = iThread;
            this.runnerHash = runnerHash;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$Companion;", "", "()V", "DONE", "MAX_SPIN_COUNT", "", "SHUTDOWN", "WAS_PARK_BALANCE_THRESHOLD", "lincheck"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

