/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategy;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ObjectManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000eJ\u0018\u0010\u000f\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000eH\u0007J(\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000eR\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyStateHolder;", "", "()V", "objectManager", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ObjectManager;", "random", "Ljava/util/Random;", "strategy", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy;", "resetState", "", "loader", "Ljava/lang/ClassLoader;", "testClass", "Ljava/lang/Class;", "resetStateImpl", "setState", "lincheck"})
public final class ManagedStrategyStateHolder {
    @JvmField
    @Nullable
    public static ManagedStrategy strategy;
    @JvmField
    @Nullable
    public static ObjectManager objectManager;
    @JvmField
    @Nullable
    public static Random random;
    public static final ManagedStrategyStateHolder INSTANCE;

    public final void setState(@NotNull ClassLoader loader, @Nullable ManagedStrategy strategy, @NotNull Class<? extends Object> testClass) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        try {
            Class<?> clazz = loader.loadClass(ManagedStrategyStateHolder.class.getCanonicalName());
            clazz.getField("strategy").set(null, strategy);
            clazz.getField("objectManager").set(null, new ObjectManager(testClass));
            Class<?> randomClass = loader.loadClass(Random.class.getCanonicalName());
            clazz.getField("random").set(null, randomClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable e) {
            throw (Throwable)new IllegalStateException("Cannot set state to ManagedStateHolder", e);
        }
    }

    public final void resetState(@NotNull ClassLoader loader, @NotNull Class<? extends Object> testClass) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        try {
            Class<?> clazz = loader.loadClass(ManagedStrategyStateHolder.class.getCanonicalName());
            clazz.getMethod("resetStateImpl", Class.class).invoke(null, testClass);
        }
        catch (Exception e) {
            throw (Throwable)new IllegalStateException("Cannot set state to ManagedStateHolder", e);
        }
    }

    @JvmStatic
    public static final void resetStateImpl(@NotNull Class<? extends Object> testClass) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Random random = ManagedStrategyStateHolder.random;
        Intrinsics.checkNotNull((Object)random);
        random.setSeed(1337L);
        objectManager = new ObjectManager(testClass);
    }

    private ManagedStrategyStateHolder() {
    }

    static {
        ManagedStrategyStateHolder managedStrategyStateHolder;
        INSTANCE = managedStrategyStateHolder = new ManagedStrategyStateHolder();
    }
}

