/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0001J\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\tR \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ObjectManager;", "", "testClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "localObjects", "Ljava/util/IdentityHashMap;", "", "objectNames", "", "addDependency", "", "owner", "dependent", "deleteLocalObject", "o", "getObjectName", "isLocalObject", "", "newLocalObject", "setObjectName", "name", "lincheck"})
public final class ObjectManager {
    private final IdentityHashMap<Object, List<Object>> localObjects;
    private final IdentityHashMap<Object, String> objectNames;
    private final Class<? extends Object> testClass;

    public final void newLocalObject(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (Intrinsics.areEqual((Object)o.getClass().getName(), (Object)this.testClass.getName())) {
            return;
        }
        boolean bl = false;
        ((Map)this.localObjects).put(o, (List)new ArrayList());
    }

    public final void deleteLocalObject(@Nullable Object o) {
        if (o == null) {
            return;
        }
        List<Object> list = this.localObjects.remove(o);
        if (list == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"localObjects.remove(o) ?: return");
        List<Object> objects = list;
        Iterable $this$forEach$iv = objects;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.deleteLocalObject(it);
        }
    }

    public final boolean isLocalObject(@Nullable Object o) {
        return this.localObjects.containsKey(o);
    }

    public final void addDependency(@NotNull Object owner, @Nullable Object dependent) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (dependent == null) {
            return;
        }
        List<Object> ownerObjects = this.localObjects.get(owner);
        if (ownerObjects != null) {
            ownerObjects.add(dependent);
        } else {
            this.deleteLocalObject(dependent);
        }
    }

    public final void setObjectName(@NotNull Object o, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Map)this.objectNames).put(o, name);
    }

    @Nullable
    public final String getObjectName(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return this.objectNames.get(o);
    }

    public ObjectManager(@NotNull Class<? extends Object> testClass) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.testClass = testClass;
        this.localObjects = new IdentityHashMap();
        this.objectNames = new IdentityHashMap();
    }
}

