/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;

class TransformationClassWriter
extends ClassWriter {
    private final Remapper remapper;

    public TransformationClassWriter(int classVersion, Remapper remapper) {
        super(classVersion > 50 ? 2 : 1);
        this.remapper = remapper;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        String result2 = super.getCommonSuperClass(this.originalInternalName(type1), this.originalInternalName(type2));
        if (this.remapper != null) {
            return this.remapper.map(result2);
        }
        return result2;
    }

    private String originalInternalName(String internalName) {
        if (internalName.startsWith("org/jetbrains/kotlinx/lincheck/tran$f*rmed/")) {
            return internalName.substring("org/jetbrains/kotlinx/lincheck/tran$f*rmed/".length());
        }
        return internalName;
    }
}

