/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.execution;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ReporterKt;

public class ExecutionScenario {
    public final List<Actor> initExecution;
    public final List<List<Actor>> parallelExecution;
    public final List<Actor> postExecution;

    public ExecutionScenario(List<Actor> initExecution, List<List<Actor>> parallelExecution, List<Actor> postExecution) {
        this.initExecution = initExecution;
        this.parallelExecution = parallelExecution;
        this.postExecution = postExecution;
    }

    public int getThreads() {
        return this.parallelExecution.size();
    }

    public boolean hasSuspendableActors() {
        return Stream.concat(this.parallelExecution.stream().flatMap(Collection::stream), this.postExecution.stream()).anyMatch(Actor::isSuspendable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ReporterKt.appendExecutionScenario(sb, this);
        return sb.toString();
    }
}

