/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/lincheck/paramgen/StringGen;", "Lorg/jetbrains/kotlinx/lincheck/paramgen/ParameterGenerator;", "", "randomProvider", "Lorg/jetbrains/kotlinx/lincheck/RandomProvider;", "configuration", "(Lorg/jetbrains/kotlinx/lincheck/RandomProvider;Ljava/lang/String;)V", "alphabet", "", "currentWordLength", "", "maxWordLength", "random", "Ljava/util/Random;", "generate", "reset", "", "Companion", "lincheck"})
public final class StringGen
implements ParameterGenerator<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Random random;
    private int maxWordLength;
    @NotNull
    private char[] alphabet;
    private int currentWordLength;
    private static final int DEFAULT_MAX_WORD_LENGTH = 15;
    @NotNull
    private static final char[] DEFAULT_ALPHABET;

    public StringGen(@NotNull RandomProvider randomProvider, @NotNull String configuration) {
        Intrinsics.checkNotNullParameter((Object)randomProvider, (String)"randomProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.currentWordLength = 1;
        this.random = randomProvider.createRandom();
        if (((CharSequence)configuration).length() == 0) {
            this.maxWordLength = 15;
            this.alphabet = DEFAULT_ALPHABET;
        } else {
            int firstCommaIndex = StringsKt.indexOf$default((CharSequence)configuration, (char)':', (int)0, (boolean)false, (int)6, null);
            if (firstCommaIndex < 0) {
                this.maxWordLength = Integer.parseInt(configuration);
                this.alphabet = DEFAULT_ALPHABET;
            } else {
                String string = configuration.substring(0, firstCommaIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                this.maxWordLength = Integer.parseInt(string);
                String string2 = configuration.substring(firstCommaIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                char[] cArray = string2.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                this.alphabet = cArray;
            }
        }
    }

    @Override
    @NotNull
    public String generate() {
        if (this.currentWordLength < this.maxWordLength && this.random.nextDouble() > 0.5) {
            int n = this.currentWordLength;
            this.currentWordLength = n + 1;
        }
        char[] cs = new char[this.currentWordLength];
        int n = cs.length;
        for (int i = 0; i < n; ++i) {
            cs[i] = this.alphabet[this.random.nextInt(this.alphabet.length)];
        }
        return new String(cs);
    }

    @Override
    public void reset() {
        this.currentWordLength = 1;
    }

    static {
        char[] cArray = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_ ".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        DEFAULT_ALPHABET = cArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/lincheck/paramgen/StringGen$Companion;", "", "()V", "DEFAULT_ALPHABET", "", "DEFAULT_MAX_WORD_LENGTH", "", "lincheck"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

