/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.util.ArrayList;
import java.util.List;
import kotlin.coroutines.Continuation;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ExceptionResult;
import org.jetbrains.kotlinx.lincheck.NoResult;
import org.jetbrains.kotlinx.lincheck.Result;
import org.jetbrains.kotlinx.lincheck.ResultKt;
import org.jetbrains.kotlinx.lincheck.SuspendedVoidResult;
import org.jetbrains.kotlinx.lincheck.ValueResult;
import org.jetbrains.kotlinx.lincheck.VoidResult;
import org.jetbrains.kotlinx.lincheck.runner.ParallelThreadsRunner;
import org.jetbrains.kotlinx.lincheck.runner.Runner;
import org.jetbrains.kotlinx.lincheck.runner.TestThreadExecution;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.TryCatchBlockSorter;
import org.objectweb.asm.util.CheckClassAdapter;

public class TestThreadExecutionGenerator {
    private static final Type[] NO_ARGS = new Type[0];
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Method OBJECT_GET_CLASS = new Method("getClass", CLASS_TYPE, NO_ARGS);
    private static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
    private static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    private static final Method EMPTY_CONSTRUCTOR = new Method("<init>", Type.VOID_TYPE, NO_ARGS);
    private static final Type RUNNER_TYPE = Type.getType(Runner.class);
    private static final Method RUNNER_ON_START_METHOD = new Method("onStart", Type.VOID_TYPE, new Type[]{Type.INT_TYPE});
    private static final Method RUNNER_ON_FINISH_METHOD = new Method("onFinish", Type.VOID_TYPE, new Type[]{Type.INT_TYPE});
    private static final Method RUNNER_ON_FAILURE_METHOD = new Method("onFailure", Type.VOID_TYPE, new Type[]{Type.INT_TYPE, THROWABLE_TYPE});
    private static final Method RUNNER_ON_ACTOR_START = new Method("onActorStart", Type.VOID_TYPE, new Type[]{Type.INT_TYPE});
    private static final Type TEST_THREAD_EXECUTION_TYPE = Type.getType(TestThreadExecution.class);
    private static final Method TEST_THREAD_EXECUTION_CONSTRUCTOR;
    private static final Method TEST_THREAD_EXECUTION_INC_CLOCK;
    private static final Method TEST_THREAD_EXECUTION_READ_CLOCKS;
    private static final Type RESULT_TYPE;
    private static final Type NO_RESULT_TYPE;
    private static final String NO_RESULT_CLASS_NAME;
    private static final Type VOID_RESULT_TYPE;
    private static final String VOID_RESULT_CLASS_NAME;
    private static final Type SUSPENDED_VOID_RESULT_TYPE;
    private static final String SUSPENDED_RESULT_CLASS_NAME;
    private static final String INSTANCE = "INSTANCE";
    private static final Type VALUE_RESULT_TYPE;
    private static final Method VALUE_RESULT_TYPE_CONSTRUCTOR;
    private static final Type EXCEPTION_RESULT_TYPE;
    private static final Type RESULT_KT_TYPE;
    private static final Method RESULT_KT_CREATE_EXCEPTION_RESULT_METHOD;
    private static final Type RESULT_ARRAY_TYPE;
    private static final Method RESULT_WAS_SUSPENDED_GETTER_METHOD;
    private static final Type PARALLEL_THREADS_RUNNER_TYPE;
    private static final Method PARALLEL_THREADS_RUNNER_PROCESS_INVOCATION_RESULT_METHOD;
    private static final Method RUNNER_IS_PARALLEL_EXECUTION_COMPLETED_METHOD;
    private static int generatedClassNumber;

    public static TestThreadExecution create(Runner runner, int iThread, List<Actor> actors, List<ParallelThreadsRunner.Completion> completions, boolean scenarioContainsSuspendableActors) {
        String className = TestThreadExecution.class.getCanonicalName() + generatedClassNumber++;
        String internalClassName = className.replace('.', '/');
        ArrayList<Object> objArgs = new ArrayList<Object>();
        Class<? extends TestThreadExecution> clz = runner.getClassLoader().defineClass(className, TestThreadExecutionGenerator.generateClass(internalClassName, Type.getType(runner.getTestClass()), iThread, actors, objArgs, completions, scenarioContainsSuspendableActors));
        try {
            TestThreadExecution execution = clz.newInstance();
            execution.runner = runner;
            execution.objArgs = objArgs.toArray();
            return execution;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot initialize generated execution class", e);
        }
    }

    private static byte[] generateClass(String internalClassName, Type testClassType, int iThread, List<Actor> actors, List<Object> objArgs, List<ParallelThreadsRunner.Completion> completions, boolean scenarioContainsSuspendableActors) {
        ClassWriter cw = new ClassWriter(2);
        CheckClassAdapter cca = new CheckClassAdapter((ClassVisitor)cw, false);
        cca.visit(52, 33, internalClassName, null, TEST_THREAD_EXECUTION_TYPE.getInternalName(), null);
        TestThreadExecutionGenerator.generateConstructor((ClassVisitor)cca);
        TestThreadExecutionGenerator.generateRun((ClassVisitor)cca, testClassType, iThread, actors, objArgs, completions, scenarioContainsSuspendableActors);
        cca.visitEnd();
        return cw.toByteArray();
    }

    private static void generateConstructor(ClassVisitor cv) {
        GeneratorAdapter mv = new GeneratorAdapter(1, EMPTY_CONSTRUCTOR, null, null, cv);
        mv.visitCode();
        mv.loadThis();
        mv.invokeConstructor(TEST_THREAD_EXECUTION_TYPE, TEST_THREAD_EXECUTION_CONSTRUCTOR);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void generateRun(ClassVisitor cv, Type testType, int iThread, List<Actor> actors, List<Object> objArgs, List<ParallelThreadsRunner.Completion> completions, boolean scenarioContainsSuspendableActors) {
        int access = 1;
        Method m = new Method("run", Type.VOID_TYPE, NO_ARGS);
        GeneratorAdapter mv = new GeneratorAdapter(access, m, (MethodVisitor)new TryCatchBlockSorter(cv.visitMethod(access, m.getName(), m.getDescriptor(), null, null), access, m.getName(), m.getDescriptor(), null, null));
        mv.visitCode();
        int resLocal = mv.newLocal(RESULT_ARRAY_TYPE);
        mv.loadThis();
        mv.getField(TEST_THREAD_EXECUTION_TYPE, "results", RESULT_ARRAY_TYPE);
        mv.storeLocal(resLocal);
        mv.loadThis();
        mv.getField(TEST_THREAD_EXECUTION_TYPE, "runner", RUNNER_TYPE);
        mv.push(iThread);
        mv.invokeVirtual(RUNNER_TYPE, RUNNER_ON_START_METHOD);
        int iLocal = mv.newLocal(Type.INT_TYPE);
        mv.push(0);
        mv.storeLocal(iLocal);
        for (int i = 0; i < actors.size(); ++i) {
            TestThreadExecutionGenerator.readClocksIfNeeded(i, mv);
            Label returnNoResult = mv.newLabel();
            if (scenarioContainsSuspendableActors) {
                mv.loadThis();
                mv.getField(TEST_THREAD_EXECUTION_TYPE, "runner", RUNNER_TYPE);
                mv.invokeVirtual(RUNNER_TYPE, RUNNER_IS_PARALLEL_EXECUTION_COMPLETED_METHOD);
                mv.push(true);
                mv.ifCmp(Type.BOOLEAN_TYPE, 153, returnNoResult);
            }
            Actor actor = actors.get(i);
            Label handledExceptionHandler = null;
            Label actorCatchBlockStart = mv.newLabel();
            Label actorCatchBlockEnd = mv.newLabel();
            if (actor.getHandlesExceptions()) {
                handledExceptionHandler = mv.newLabel();
                for (Class<? extends Throwable> ec : actor.getHandledExceptions()) {
                    mv.visitTryCatchBlock(actorCatchBlockStart, actorCatchBlockEnd, handledExceptionHandler, Type.getType(ec).getInternalName());
                }
            }
            Label unexpectedExceptionHandler = mv.newLabel();
            mv.visitTryCatchBlock(actorCatchBlockStart, actorCatchBlockEnd, unexpectedExceptionHandler, THROWABLE_TYPE.getInternalName());
            mv.visitLabel(actorCatchBlockStart);
            mv.loadThis();
            mv.getField(TEST_THREAD_EXECUTION_TYPE, "runner", RUNNER_TYPE);
            mv.push(iThread);
            mv.invokeVirtual(RUNNER_TYPE, RUNNER_ON_ACTOR_START);
            mv.loadLocal(resLocal);
            mv.push(i);
            if (scenarioContainsSuspendableActors) {
                mv.loadThis();
                mv.getField(TEST_THREAD_EXECUTION_TYPE, "runner", RUNNER_TYPE);
                mv.checkCast(PARALLEL_THREADS_RUNNER_TYPE);
            } else if (actor.getMethod().getReturnType() != Void.TYPE) {
                mv.newInstance(VALUE_RESULT_TYPE);
                mv.visitInsn(89);
            }
            mv.loadThis();
            mv.getField(TEST_THREAD_EXECUTION_TYPE, "testInstance", OBJECT_TYPE);
            mv.checkCast(testType);
            TestThreadExecutionGenerator.loadArguments(mv, actor, objArgs, actor.isSuspendable() ? completions.get(i) : null);
            Method actorMethod = Method.getMethod((java.lang.reflect.Method)actor.getMethod());
            mv.invokeVirtual(testType, actorMethod);
            mv.box(actorMethod.getReturnType());
            if (scenarioContainsSuspendableActors) {
                mv.push(iThread);
                mv.push(i);
                mv.invokeVirtual(PARALLEL_THREADS_RUNNER_TYPE, PARALLEL_THREADS_RUNNER_PROCESS_INVOCATION_RESULT_METHOD);
                if (actor.getMethod().getReturnType() == Void.TYPE) {
                    TestThreadExecutionGenerator.createVoidResult(actor, mv);
                }
            } else if (actor.getMethod().getReturnType() == Void.TYPE) {
                TestThreadExecutionGenerator.createVoidResult(actor, mv);
            } else {
                mv.invokeConstructor(VALUE_RESULT_TYPE, VALUE_RESULT_TYPE_CONSTRUCTOR);
            }
            mv.arrayStore(RESULT_TYPE);
            mv.visitLabel(actorCatchBlockEnd);
            Label skipHandlers = mv.newLabel();
            mv.goTo(skipHandlers);
            if (actor.getHandlesExceptions()) {
                mv.visitLabel(handledExceptionHandler);
                if (scenarioContainsSuspendableActors) {
                    TestThreadExecutionGenerator.storeExceptionResultFromSuspendableThrowable(mv, resLocal, iLocal, iThread, i);
                } else {
                    TestThreadExecutionGenerator.storeExceptionResultFromThrowable(mv, resLocal, iLocal);
                }
            }
            mv.goTo(skipHandlers);
            mv.visitLabel(unexpectedExceptionHandler);
            mv.dup();
            int eLocal = mv.newLocal(THROWABLE_TYPE);
            mv.storeLocal(eLocal);
            mv.loadThis();
            mv.getField(TEST_THREAD_EXECUTION_TYPE, "runner", RUNNER_TYPE);
            mv.push(iThread);
            mv.loadLocal(eLocal);
            mv.invokeVirtual(RUNNER_TYPE, RUNNER_ON_FAILURE_METHOD);
            mv.throwException();
            mv.visitLabel(skipHandlers);
            mv.loadThis();
            mv.invokeVirtual(TEST_THREAD_EXECUTION_TYPE, TEST_THREAD_EXECUTION_INC_CLOCK);
            mv.iinc(iLocal, 1);
            Label launchNextActor = mv.newLabel();
            mv.visitJumpInsn(167, launchNextActor);
            mv.visitLabel(returnNoResult);
            mv.loadLocal(resLocal);
            mv.push(i);
            mv.visitFieldInsn(178, NO_RESULT_CLASS_NAME, INSTANCE, NO_RESULT_TYPE.getDescriptor());
            mv.arrayStore(RESULT_TYPE);
            mv.iinc(iLocal, 1);
            mv.visitLabel(launchNextActor);
        }
        mv.loadThis();
        mv.getField(TEST_THREAD_EXECUTION_TYPE, "runner", RUNNER_TYPE);
        mv.push(iThread);
        mv.invokeVirtual(RUNNER_TYPE, RUNNER_ON_FINISH_METHOD);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void readClocksIfNeeded(int actorNumber, GeneratorAdapter mv) {
        mv.loadThis();
        mv.getField(TEST_THREAD_EXECUTION_TYPE, "useClocks", Type.BOOLEAN_TYPE);
        Label l = new Label();
        mv.visitJumpInsn(153, l);
        mv.loadThis();
        mv.push(actorNumber);
        mv.invokeVirtual(TEST_THREAD_EXECUTION_TYPE, TEST_THREAD_EXECUTION_READ_CLOCKS);
        mv.visitLabel(l);
    }

    private static void createVoidResult(Actor actor, GeneratorAdapter mv) {
        if (actor.isSuspendable()) {
            Label suspendedVoidResult = mv.newLabel();
            mv.invokeVirtual(RESULT_TYPE, RESULT_WAS_SUSPENDED_GETTER_METHOD);
            mv.push(true);
            mv.ifCmp(Type.BOOLEAN_TYPE, 153, suspendedVoidResult);
            mv.visitFieldInsn(178, VOID_RESULT_CLASS_NAME, INSTANCE, VOID_RESULT_TYPE.getDescriptor());
            mv.visitLabel(suspendedVoidResult);
            mv.visitFieldInsn(178, SUSPENDED_RESULT_CLASS_NAME, INSTANCE, SUSPENDED_VOID_RESULT_TYPE.getDescriptor());
        } else {
            mv.pop();
            mv.visitFieldInsn(178, VOID_RESULT_CLASS_NAME, INSTANCE, VOID_RESULT_TYPE.getDescriptor());
        }
    }

    private static void storeExceptionResultFromThrowable(GeneratorAdapter mv, int resLocal, int iLocal) {
        mv.invokeVirtual(OBJECT_TYPE, OBJECT_GET_CLASS);
        int eLocal = mv.newLocal(CLASS_TYPE);
        mv.storeLocal(eLocal);
        mv.loadLocal(resLocal);
        mv.loadLocal(iLocal);
        mv.loadLocal(eLocal);
        mv.invokeStatic(RESULT_KT_TYPE, RESULT_KT_CREATE_EXCEPTION_RESULT_METHOD);
        mv.checkCast(RESULT_TYPE);
        mv.arrayStore(RESULT_TYPE);
    }

    private static void storeExceptionResultFromSuspendableThrowable(GeneratorAdapter mv, int resLocal, int iLocal, int iThread, int actorId) {
        int eLocal = mv.newLocal(THROWABLE_TYPE);
        mv.storeLocal(eLocal);
        mv.loadLocal(resLocal);
        mv.loadLocal(iLocal);
        mv.loadThis();
        mv.getField(TEST_THREAD_EXECUTION_TYPE, "runner", RUNNER_TYPE);
        mv.checkCast(PARALLEL_THREADS_RUNNER_TYPE);
        mv.loadLocal(eLocal);
        mv.push(iThread);
        mv.push(actorId);
        mv.invokeVirtual(PARALLEL_THREADS_RUNNER_TYPE, PARALLEL_THREADS_RUNNER_PROCESS_INVOCATION_RESULT_METHOD);
        mv.arrayStore(RESULT_TYPE);
    }

    private static void loadArguments(GeneratorAdapter mv, Actor actor, List<Object> objArgs, ParallelThreadsRunner.Completion completion) {
        int nArguments = actor.getArguments().size();
        for (int j = 0; j < nArguments; ++j) {
            TestThreadExecutionGenerator.pushArgumentOnStack(mv, objArgs, actor.getArguments().toArray()[j], actor.getMethod().getParameterTypes()[j]);
        }
        if (actor.isSuspendable()) {
            TestThreadExecutionGenerator.pushArgumentOnStack(mv, objArgs, completion, Continuation.class);
        }
    }

    private static void pushArgumentOnStack(GeneratorAdapter mv, List<Object> objArgs, Object arg, Class<?> argClass) {
        if (argClass == Boolean.TYPE) {
            mv.push(((Boolean)arg).booleanValue());
        } else if (argClass == Byte.TYPE) {
            mv.push((int)((Byte)arg).byteValue());
        } else if (argClass == Character.TYPE) {
            mv.push((int)((Character)arg).charValue());
        } else if (argClass == Short.TYPE) {
            mv.push((int)((Short)arg).shortValue());
        } else if (argClass == Integer.TYPE) {
            mv.push(((Integer)arg).intValue());
        } else if (argClass == Long.TYPE) {
            mv.push(((Long)arg).longValue());
        } else if (argClass == Float.TYPE) {
            mv.push(((Float)arg).floatValue());
        } else if (argClass == Double.TYPE) {
            mv.push(((Double)arg).doubleValue());
        } else if (argClass == String.class) {
            mv.push((String)arg);
        } else {
            mv.loadThis();
            mv.getField(TEST_THREAD_EXECUTION_TYPE, "objArgs", OBJECT_ARRAY_TYPE);
            mv.push(objArgs.size());
            mv.arrayLoad(OBJECT_TYPE);
            mv.checkCast(Type.getType(argClass));
            objArgs.add(arg);
        }
    }

    static {
        TEST_THREAD_EXECUTION_INC_CLOCK = new Method("incClock", Type.VOID_TYPE, NO_ARGS);
        TEST_THREAD_EXECUTION_READ_CLOCKS = new Method("readClocks", Type.VOID_TYPE, new Type[]{Type.INT_TYPE});
        RESULT_TYPE = Type.getType(Result.class);
        NO_RESULT_TYPE = Type.getType(NoResult.class);
        NO_RESULT_CLASS_NAME = NoResult.class.getCanonicalName().replace('.', '/');
        VOID_RESULT_TYPE = Type.getType(VoidResult.class);
        VOID_RESULT_CLASS_NAME = VoidResult.class.getCanonicalName().replace('.', '/');
        SUSPENDED_VOID_RESULT_TYPE = Type.getType(SuspendedVoidResult.class);
        SUSPENDED_RESULT_CLASS_NAME = SuspendedVoidResult.class.getCanonicalName().replace('.', '/');
        VALUE_RESULT_TYPE = Type.getType(ValueResult.class);
        VALUE_RESULT_TYPE_CONSTRUCTOR = new Method("<init>", Type.VOID_TYPE, new Type[]{OBJECT_TYPE});
        EXCEPTION_RESULT_TYPE = Type.getType(ExceptionResult.class);
        RESULT_KT_TYPE = Type.getType(ResultKt.class);
        RESULT_KT_CREATE_EXCEPTION_RESULT_METHOD = new Method("createExceptionResult", EXCEPTION_RESULT_TYPE, new Type[]{CLASS_TYPE});
        RESULT_ARRAY_TYPE = Type.getType(Result[].class);
        RESULT_WAS_SUSPENDED_GETTER_METHOD = new Method("getWasSuspended", Type.BOOLEAN_TYPE, new Type[0]);
        PARALLEL_THREADS_RUNNER_TYPE = Type.getType(ParallelThreadsRunner.class);
        PARALLEL_THREADS_RUNNER_PROCESS_INVOCATION_RESULT_METHOD = new Method("processInvocationResult", RESULT_TYPE, new Type[]{OBJECT_TYPE, Type.INT_TYPE, Type.INT_TYPE});
        RUNNER_IS_PARALLEL_EXECUTION_COMPLETED_METHOD = new Method("isParallelExecutionCompleted", Type.BOOLEAN_TYPE, new Type[0]);
        generatedClassNumber = 0;
        try {
            TEST_THREAD_EXECUTION_CONSTRUCTOR = Method.getMethod(TestThreadExecution.class.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

