/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyTransformerKt;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0006\u0010\u000b\u001a\u00020\u0006\"\u001c\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"causesTransformationProblem", "", "Ljava/lang/Class;", "getCausesTransformationProblem", "(Ljava/lang/Class;)Z", "findAllTransformationProblemsIn", "", "packageName", "", "getAllClasses", "", "main", "lincheck"})
public final class JavaUtilRemapperKt {
    public static final void main() {
        Object[] objectArray = new String[]{"java.util", "java.lang", "java.math", "java.text", "java.time"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            JavaUtilRemapperKt.findAllTransformationProblemsIn(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void findAllTransformationProblemsIn(String packageName) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = JavaUtilRemapperKt.getAllClasses(packageName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            String n = (String)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Class.forName((String)it));
        }
        List classes = (List)destination$iv$iv;
        for (Class clazz : classes) {
            Class<?> clazz2;
            int n;
            block14: {
                String string = clazz.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
                if (StringsKt.startsWith$default((String)string, (String)"java.util", (boolean)false, (int)2, null)) {
                    if (clazz.isInterface()) {
                        Set<String> set = ManagedStrategyTransformerKt.getTRANSFORMED_JAVA_UTIL_INTERFACES();
                        String string2 = clazz.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clazz.name");
                        if (set.contains(UtilsKt.getInternalClassName(string2))) continue;
                    }
                    if (!clazz.isInterface()) {
                        Set<String> set = ManagedStrategyTransformerKt.getNOT_TRANSFORMED_JAVA_UTIL_CLASSES();
                        String string3 = clazz.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"clazz.name");
                        if (!set.contains(UtilsKt.getInternalClassName(string3))) continue;
                    }
                }
                Class<?>[] superInterfaces = clazz.getInterfaces();
                Intrinsics.checkNotNullExpressionValue(superInterfaces, (String)"superInterfaces");
                Class<?>[] $this$firstOrNull$iv = superInterfaces;
                boolean $i$f$firstOrNull = false;
                boolean bl = false;
                int classArray = $this$firstOrNull$iv.length;
                while (n < classArray) {
                    Class<?> element$iv;
                    Class<?> it = element$iv = $this$firstOrNull$iv[n];
                    boolean bl2 = false;
                    Set<String> set = ManagedStrategyTransformerKt.getTRANSFORMED_JAVA_UTIL_INTERFACES();
                    String string4 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.name");
                    if (set.contains(UtilsKt.getInternalClassName(string4))) {
                        clazz2 = element$iv;
                        break block14;
                    }
                    ++n;
                }
                clazz2 = null;
            }
            if (clazz2 != null) {
                Class<?> it = clazz2;
                n = 0;
                System.out.println((Object)("CONFLICT: " + clazz.getName() + " is not transformed, but its sub-interface " + it.getName() + " is"));
            }
            if (clazz.getSuperclass() != null) {
                Class it;
                n = 0;
                if (JavaUtilRemapperKt.getCausesTransformationProblem(it)) {
                    System.out.println((Object)("CONFLICT: " + clazz.getName() + " is not transformed, but its subclass " + it.getName() + " is"));
                }
            }
            Field[] fieldArray = clazz.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"clazz.fields");
            for (Field field : fieldArray) {
                Class<?> clazz3 = field.getType();
                Intrinsics.checkNotNullExpressionValue(clazz3, (String)"f.type");
                if (!JavaUtilRemapperKt.getCausesTransformationProblem(clazz3)) continue;
                System.out.println((Object)("CONFLICT: " + clazz.getName() + " is not transformed, but its public field of type `" + field.getType().getName() + "` is"));
            }
            Method[] methodArray = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"clazz.methods");
            for (AccessibleObject accessibleObject : methodArray) {
                Class<?>[] classArray;
                Class<?> clazz4 = ((Method)accessibleObject).getReturnType();
                Intrinsics.checkNotNullExpressionValue(clazz4, (String)"m.returnType");
                if (JavaUtilRemapperKt.getCausesTransformationProblem(clazz4)) {
                    System.out.println((Object)("CONFLICT: " + clazz.getName() + " is not transformed, but the return type " + ((Method)accessibleObject).getReturnType().getName() + " in its method `" + ((Method)accessibleObject).getName() + "` is"));
                }
                Intrinsics.checkNotNullExpressionValue(((Method)accessibleObject).getParameterTypes(), (String)"m.parameterTypes");
                for (Class<?> p : classArray) {
                    Intrinsics.checkNotNullExpressionValue(p, (String)"p");
                    if (!JavaUtilRemapperKt.getCausesTransformationProblem(p)) continue;
                    System.out.println((Object)("CONFLICT: " + clazz.getName() + " is not transformed, but the parameter type " + p.getName() + " in its method `" + ((Method)accessibleObject).getName() + "` is"));
                }
            }
        }
    }

    private static final List<String> getAllClasses(String packageName) {
        if (!(!Intrinsics.areEqual((Object)packageName, (Object)"java"))) {
            boolean bl = false;
            String string = "For some reason unable to find classes in `java` package. Use more specified name such as `java.util`";
            throw new IllegalStateException(string.toString());
        }
        Scanner[] scannerArray = new Scanner[]{(Scanner)new SubTypesScanner(false)};
        Reflections reflections = new Reflections(StringsKt.replace$default((String)packageName, (char)'.', (char)'/', (boolean)false, (int)4, null), scannerArray);
        Set set = reflections.getAllTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"reflections.allTypes");
        return CollectionsKt.toList((Iterable)set);
    }

    private static final boolean getCausesTransformationProblem(Class<?> $this$causesTransformationProblem) {
        boolean bl;
        String string = $this$causesTransformationProblem.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.startsWith$default((String)string, (String)"java.util.", (boolean)false, (int)2, null)) {
            bl = false;
        } else if ($this$causesTransformationProblem.isEnum()) {
            bl = false;
        } else if ($this$causesTransformationProblem.isArray()) {
            Class<?> clazz = $this$causesTransformationProblem.getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"this.componentType");
            bl = JavaUtilRemapperKt.getCausesTransformationProblem(clazz);
        } else if ($this$causesTransformationProblem.isInterface()) {
            Set<String> set = ManagedStrategyTransformerKt.getTRANSFORMED_JAVA_UTIL_INTERFACES();
            String string2 = $this$causesTransformationProblem.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            bl = set.contains(UtilsKt.getInternalClassName(string2));
        } else {
            Set<String> set = ManagedStrategyTransformerKt.getNOT_TRANSFORMED_JAVA_UTIL_CLASSES();
            String string3 = $this$causesTransformationProblem.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            bl = !set.contains(UtilsKt.getInternalClassName(string3));
        }
        return bl;
    }

    public static /* synthetic */ void main(String[] args) {
        JavaUtilRemapperKt.main();
    }
}

