/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.verifier.quiescent;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionResult;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.execution.HBClock;
import org.jetbrains.kotlinx.lincheck.execution.HBClockKt;
import org.jetbrains.kotlinx.lincheck.execution.ResultWithClock;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;
import org.jetbrains.kotlinx.lincheck.verifier.linearizability.LinearizabilityVerifier;
import org.jetbrains.kotlinx.lincheck.verifier.quiescent.QuiescentConsistencyVerifierKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0014\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\t*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/lincheck/verifier/quiescent/QuiescentConsistencyVerifier;", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "sequentialSpecification", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "linearizabilityVerifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/linearizability/LinearizabilityVerifier;", "scenarioMapping", "", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "converted", "getConverted", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;)Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "checkScenarioAndResultsAreSimilarlyConverted", "", "scenario", "results", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionResult;", "verifyResults", "", "convert", "originalScenario", "newThreads", "", "lincheck"})
public final class QuiescentConsistencyVerifier
implements Verifier {
    @NotNull
    private final LinearizabilityVerifier linearizabilityVerifier;
    @NotNull
    private final Map<ExecutionScenario, ExecutionScenario> scenarioMapping;

    public QuiescentConsistencyVerifier(@NotNull Class<?> sequentialSpecification) {
        Intrinsics.checkNotNullParameter(sequentialSpecification, (String)"sequentialSpecification");
        this.linearizabilityVerifier = new LinearizabilityVerifier(sequentialSpecification);
        this.scenarioMapping = new WeakHashMap();
    }

    @Override
    public boolean verifyResults(@NotNull ExecutionScenario scenario, @NotNull ExecutionResult results) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        ExecutionScenario convertedScenario = this.getConverted(scenario);
        ExecutionResult convertedResults = this.convert(results, scenario, convertedScenario.getThreads());
        this.checkScenarioAndResultsAreSimilarlyConverted(convertedScenario, convertedResults);
        return this.linearizabilityVerifier.verifyResults(convertedScenario, convertedResults);
    }

    private final ExecutionScenario getConverted(ExecutionScenario $this$converted) {
        ExecutionScenario executionScenario = this.scenarioMapping.computeIfAbsent($this$converted, arg_0 -> QuiescentConsistencyVerifier._get_converted_$lambda-2($this$converted, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)executionScenario, (String)"scenarioMapping.computeI\u2026ted, postExecution)\n    }");
        return executionScenario;
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionResult convert(ExecutionResult $this$convert, ExecutionScenario originalScenario, int newThreads) {
        int[] a;
        int i;
        int n;
        int index$iv;
        boolean $i$f$forEachIndexed;
        Iterable $this$forEachIndexed$iv;
        int t;
        ArrayList[] clockMapping;
        int n2;
        int it;
        ArrayList<List> parallelResults = new ArrayList<List>();
        int n3 = originalScenario.getThreads();
        int n4 = 0;
        while (n4 < n3) {
            it = n4++;
            boolean $i$a$-repeat-QuiescentConsistencyVerifier$convert$232 = false;
            parallelResults.add(new ArrayList());
        }
        n4 = 0;
        it = originalScenario.getThreads();
        ArrayList[] $i$a$-repeat-QuiescentConsistencyVerifier$convert$232 = new ArrayList[it];
        while (n4 < it) {
            int n5 = n4++;
            $i$a$-repeat-QuiescentConsistencyVerifier$convert$232[n5] = new ArrayList();
        }
        ArrayList[] clocks = $i$a$-repeat-QuiescentConsistencyVerifier$convert$232;
        it = 0;
        int $i$a$-repeat-QuiescentConsistencyVerifier$convert$232 = originalScenario.getThreads();
        ArrayList[] arrayListArray = new ArrayList[$i$a$-repeat-QuiescentConsistencyVerifier$convert$232];
        while (it < $i$a$-repeat-QuiescentConsistencyVerifier$convert$232) {
            n2 = it++;
            arrayListArray[n2] = new ArrayList();
        }
        ArrayList[] $this$forEach$iv = clockMapping = arrayListArray;
        boolean $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (int j = 0; j < n2; ++j) {
            ArrayList arrayList;
            ArrayList it2 = arrayList = $this$forEach$iv[j];
            boolean bl = false;
            it2.add(-1);
        }
        List<List<Actor>> list = originalScenario.parallelExecution;
        Intrinsics.checkNotNullExpressionValue(list, (String)"originalScenario.parallelExecution");
        Iterable $this$forEachIndexed$iv2 = list;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object t2 : $this$forEachIndexed$iv2) {
            void threadActors;
            int it2;
            if ((it2 = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List bl = (List)t2;
            t = it2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)threadActors, (String)"threadActors");
            $this$forEachIndexed$iv = (Iterable)threadActors;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Actor actor = (Actor)item$iv2;
                i = n;
                boolean bl3 = false;
                ResultWithClock r = $this$convert.getParallelResultsWithClock().get(t).get(i);
                Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
                if (QuiescentConsistencyVerifierKt.access$isQuiescentConsistent((Actor)a)) {
                    clockMapping[t].add(clockMapping[t].get(i));
                    Object[] n9 = new ResultWithClock[]{HBClockKt.withEmptyClock(r.getResult(), newThreads)};
                    parallelResults.add(CollectionsKt.mutableListOf((Object[])n9));
                    continue;
                }
                clockMapping[t].add(((Number)clockMapping[t].get(i)).intValue() + 1);
                int n5 = 0;
                int[] nArray = new int[newThreads];
                while (n5 < newThreads) {
                    int n6 = n5++;
                    nArray[n6] = 0;
                }
                int[] c = nArray;
                clocks[t].add(c);
                ((List)parallelResults.get(t)).add(new ResultWithClock(r.getResult(), new HBClock(c)));
            }
        }
        ArrayList[] $this$forEachIndexed$iv3 = clocks;
        boolean $i$f$forEachIndexed3 = false;
        int index$iv3 = 0;
        for (ArrayList item$iv : $this$forEachIndexed$iv3) {
            void threadClocks;
            int n7 = index$iv3++;
            ArrayList threadActors = item$iv;
            t = n7;
            boolean bl = false;
            $this$forEachIndexed$iv = (Iterable)threadClocks;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                a = (int[])item$iv2;
                i = n;
                boolean bl4 = false;
                int n8 = originalScenario.getThreads();
                for (int j = 0; j < n8; ++j) {
                    int old = $this$convert.getParallelResultsWithClock().get(t).get(i).getClockOnStart().get(j);
                    Integer n9 = old == -1 ? Integer.valueOf(-1) : (Integer)clockMapping[j].get(old);
                    Intrinsics.checkNotNullExpressionValue((Object)n9, (String)"if (old == -1) -1 else clockMapping[j][old]");
                    c[j] = ((Number)n9).intValue();
                }
            }
        }
        return new ExecutionResult($this$convert.getInitResults(), (List<? extends List<ResultWithClock>>)parallelResults, $this$convert.getPostResults());
    }

    private final void checkScenarioAndResultsAreSimilarlyConverted(ExecutionScenario scenario, ExecutionResult results) {
        if (!(scenario.initExecution.size() == results.getInitResults().size())) {
            boolean $i$a$-check-QuiescentConsistencyVerifier$checkScenarioAndResultsAreSimilarlyConverted$52 = false;
            String $i$a$-check-QuiescentConsistencyVerifier$checkScenarioAndResultsAreSimilarlyConverted$52 = "Transformed scenario and results have different number of operations in init parts";
            throw new IllegalStateException($i$a$-check-QuiescentConsistencyVerifier$checkScenarioAndResultsAreSimilarlyConverted$52.toString());
        }
        if (!(scenario.postExecution.size() == results.getPostResults().size())) {
            boolean $i$a$-check-QuiescentConsistencyVerifier$checkScenarioAndResultsAreSimilarlyConverted$62 = false;
            String $i$a$-check-QuiescentConsistencyVerifier$checkScenarioAndResultsAreSimilarlyConverted$62 = "Transformed scenario and results have different number of operations in post parts";
            throw new IllegalStateException($i$a$-check-QuiescentConsistencyVerifier$checkScenarioAndResultsAreSimilarlyConverted$62.toString());
        }
        if (!(scenario.parallelExecution.size() == results.getParallelResultsWithClock().size())) {
            boolean bl = false;
            String string = "Transformed scenario and results have different number of parallel threads";
            throw new IllegalStateException(string.toString());
        }
        int n = scenario.getThreads();
        for (int t = 0; t < n; ++t) {
            if (scenario.parallelExecution.get(t).size() == results.getParallelResultsWithClock().get(t).size()) continue;
            boolean bl = false;
            String string = "Transformed scenario and resutls have different number of operations in thread " + t;
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final ExecutionScenario _get_converted_$lambda-2(ExecutionScenario $this_converted, ExecutionScenario it) {
        Intrinsics.checkNotNullParameter((Object)$this_converted, (String)"$this_converted");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ArrayList<List> parallelExecutionConverted = new ArrayList<List>();
        int n = $this_converted.getThreads();
        int n2 = 0;
        while (n2 < n) {
            int it2 = n2++;
            boolean bl = false;
            parallelExecutionConverted.add(new ArrayList());
        }
        List<List<Actor>> list = $this_converted.parallelExecution;
        Intrinsics.checkNotNullExpressionValue(list, (String)"parallelExecution");
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void threadActors;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv;
            int t = n3;
            boolean bl = false;
            for (Actor a : threadActors) {
                Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
                if (QuiescentConsistencyVerifierKt.access$isQuiescentConsistent(a)) {
                    Object[] objectArray = new Actor[]{a};
                    parallelExecutionConverted.add(CollectionsKt.mutableListOf((Object[])objectArray));
                    continue;
                }
                ((List)parallelExecutionConverted.get(t)).add(a);
            }
        }
        return new ExecutionScenario($this_converted.initExecution, (List<List<Actor>>)parallelExecutionConverted, $this_converted.postExecution);
    }
}

