/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.DSLParallelScenario;
import org.jetbrains.kotlinx.lincheck.DSLThreadScenario;
import org.jetbrains.kotlinx.lincheck.ScenarioDSLMarker;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;

@ScenarioDSLMarker
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u0003\u001a\u00020\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\u0002\b\u0012J\u001f\u0010\b\u001a\u00020\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\u0002\b\u0012J\u001f\u0010\n\u001a\u00020\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\u0002\b\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/lincheck/DSLScenarioBuilder;", "", "()V", "initial", "", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "initialSpecified", "", "parallel", "parallelSpecified", "post", "postSpecified", "buildScenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/lincheck/DSLThreadScenario;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/lincheck/DSLParallelScenario;", "lincheck"})
public final class DSLScenarioBuilder {
    @NotNull
    private final List<Actor> initial = new ArrayList();
    @NotNull
    private List<List<Actor>> parallel = new ArrayList();
    @NotNull
    private final List<Actor> post = new ArrayList();
    private boolean initialSpecified;
    private boolean parallelSpecified;
    private boolean postSpecified;

    public final void initial(@NotNull Function1<? super DSLThreadScenario, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!(!this.initialSpecified)) {
            boolean bl = false;
            String string = "Redeclaration of the initial part is prohibited.";
            throw new IllegalArgumentException(string.toString());
        }
        this.initialSpecified = true;
        DSLThreadScenario dSLThreadScenario = new DSLThreadScenario();
        block.invoke((Object)dSLThreadScenario);
        this.initial.addAll(dSLThreadScenario);
    }

    public final void parallel(@NotNull Function1<? super DSLParallelScenario, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!(!this.parallelSpecified)) {
            boolean bl = false;
            String string = "Redeclaration of the parallel part is prohibited.";
            throw new IllegalArgumentException(string.toString());
        }
        this.parallelSpecified = true;
        DSLParallelScenario dSLParallelScenario = new DSLParallelScenario();
        block.invoke((Object)dSLParallelScenario);
        this.parallel.addAll(dSLParallelScenario);
    }

    public final void post(@NotNull Function1<? super DSLThreadScenario, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!(!this.postSpecified)) {
            boolean bl = false;
            String string = "Redeclaration of tthe post part is prohibited.";
            throw new IllegalArgumentException(string.toString());
        }
        this.postSpecified = true;
        DSLThreadScenario dSLThreadScenario = new DSLThreadScenario();
        block.invoke((Object)dSLThreadScenario);
        this.post.addAll(dSLThreadScenario);
    }

    @NotNull
    public final ExecutionScenario buildScenario() {
        return new ExecutionScenario(this.initial, this.parallel, this.post);
    }
}

