/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.CTestConfiguration;
import org.jetbrains.kotlinx.lincheck.CTestStructure;
import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.execution.ActorGenerator;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionGenerator;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;

public class RandomExecutionGenerator
extends ExecutionGenerator {
    private final Random random;

    public RandomExecutionGenerator(CTestConfiguration testConfiguration, CTestStructure testStructure, RandomProvider randomProvider) {
        super(testConfiguration, testStructure);
        this.random = randomProvider.createRandom();
    }

    @Override
    public ExecutionScenario nextExecution() {
        List<Actor> postExecution;
        List validActorGeneratorsForInit = this.testStructure.actorGenerators.stream().filter(ag -> !ag.getUseOnce() && !ag.isSuspendable()).collect(Collectors.toList());
        ArrayList<Actor> initExecution = new ArrayList<Actor>();
        for (int i = 0; i < this.testConfiguration.getActorsBefore() && !validActorGeneratorsForInit.isEmpty(); ++i) {
            ActorGenerator ag2 = (ActorGenerator)validActorGeneratorsForInit.get(this.random.nextInt(validActorGeneratorsForInit.size()));
            initExecution.add(ag2.generate(0, this.random));
        }
        List<CTestStructure.OperationGroup> nonParallelGroups = this.testStructure.operationGroups.stream().filter(g -> g.nonParallel).collect(Collectors.toList());
        Collections.shuffle(nonParallelGroups, this.random);
        ArrayList<ActorGenerator> parallelGroup = new ArrayList<ActorGenerator>(this.testStructure.actorGenerators);
        nonParallelGroups.forEach(g -> parallelGroup.removeAll(g.actors));
        List<Object> parallelExecution = new ArrayList();
        ArrayList<ThreadGen> threadGens = new ArrayList<ThreadGen>();
        for (int t = 0; t < this.testConfiguration.getThreads(); ++t) {
            parallelExecution.add(new ArrayList());
            threadGens.add(new ThreadGen(t, this.testConfiguration.getActorsPerThread()));
        }
        for (int i = 0; i < nonParallelGroups.size(); ++i) {
            ((ThreadGen)threadGens.get((int)(i % threadGens.size()))).nonParallelActorGenerators.addAll(((CTestStructure.OperationGroup)nonParallelGroups.get((int)i)).actors);
        }
        ArrayList tgs2 = new ArrayList(threadGens);
        while (!threadGens.isEmpty()) {
            Iterator it = threadGens.iterator();
            while (it.hasNext()) {
                ThreadGen threadGen = (ThreadGen)it.next();
                int aGenIndexBound = threadGen.nonParallelActorGenerators.size() + parallelGroup.size();
                if (aGenIndexBound == 0) {
                    it.remove();
                    continue;
                }
                int aGenIndex = this.random.nextInt(aGenIndexBound);
                ActorGenerator agen = aGenIndex < threadGen.nonParallelActorGenerators.size() ? this.getActorGenFromGroup(threadGen.nonParallelActorGenerators, aGenIndex) : this.getActorGenFromGroup(parallelGroup, aGenIndex - threadGen.nonParallelActorGenerators.size());
                ((List)parallelExecution.get(threadGen.iThread)).add(agen.generate(threadGen.iThread + 1, this.random));
                if (--threadGen.left != 0) continue;
                it.remove();
            }
        }
        if ((parallelExecution = parallelExecution.stream().filter(actors -> !actors.isEmpty()).collect(Collectors.toList())).stream().noneMatch(actors -> actors.stream().anyMatch(Actor::isSuspendable))) {
            postExecution = new ArrayList();
            ArrayList<ActorGenerator> leftActorGenerators = new ArrayList<ActorGenerator>(parallelGroup);
            for (ThreadGen threadGen : tgs2) {
                leftActorGenerators.addAll(threadGen.nonParallelActorGenerators);
            }
            for (int i = 0; i < this.testConfiguration.getActorsAfter() && !leftActorGenerators.isEmpty(); ++i) {
                ActorGenerator agen = this.getActorGenFromGroup(leftActorGenerators, this.random.nextInt(leftActorGenerators.size()));
                postExecution.add(agen.generate(this.testConfiguration.getThreads() + 1, this.random));
            }
        } else {
            postExecution = Collections.emptyList();
        }
        return new ExecutionScenario(initExecution, parallelExecution, postExecution);
    }

    private ActorGenerator getActorGenFromGroup(List<ActorGenerator> aGens, int index) {
        ActorGenerator aGen = aGens.get(index);
        if (aGen.getUseOnce()) {
            aGens.remove(index);
        }
        return aGen;
    }

    private static class ThreadGen {
        final List<ActorGenerator> nonParallelActorGenerators = new ArrayList<ActorGenerator>();
        int iThread;
        int left;

        ThreadGen(int iThread, int nActors) {
            this.iThread = iThread;
            this.left = nActors;
        }
    }
}

