/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/lincheck/paramgen/ExpandingRangeIntGenerator;", "", "random", "Ljava/util/Random;", "minValueInclusive", "", "maxValueInclusive", "(Ljava/util/Random;II)V", "currentEndInclusive", "currentStartInclusive", "expansionDirection", "Lorg/jetbrains/kotlinx/lincheck/paramgen/ExpandingRangeIntGenerator$NextExpansionDirection;", "calculateFirstValue", "generateFromRandomRange", "rangeLowerBoundInclusive", "rangeUpperBoundInclusive", "nextExpansionDirection", "nextInt", "resetRange", "", "NextExpansionDirection", "lincheck"})
public final class ExpandingRangeIntGenerator {
    @NotNull
    private final Random random;
    private final int minValueInclusive;
    private final int maxValueInclusive;
    private int currentStartInclusive;
    private int currentEndInclusive;
    @NotNull
    private NextExpansionDirection expansionDirection;

    public ExpandingRangeIntGenerator(@NotNull Random random, int minValueInclusive, int maxValueInclusive) {
        int firstValue;
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.random = random;
        this.minValueInclusive = minValueInclusive;
        this.maxValueInclusive = maxValueInclusive;
        this.expansionDirection = NextExpansionDirection.UP;
        this.currentStartInclusive = firstValue = this.calculateFirstValue();
        this.currentEndInclusive = firstValue;
    }

    public final void resetRange() {
        int firstValue;
        this.currentStartInclusive = firstValue = this.calculateFirstValue();
        this.currentEndInclusive = firstValue;
    }

    public final int nextInt() {
        int n;
        if (this.expansionDirection == NextExpansionDirection.DISABLED || this.random.nextDouble() < 0.65) {
            return this.generateFromRandomRange(this.currentStartInclusive, this.currentEndInclusive);
        }
        if (this.expansionDirection == NextExpansionDirection.DOWN) {
            this.currentStartInclusive += -1;
            n = this.currentStartInclusive;
        } else {
            n = ++this.currentEndInclusive;
        }
        int value = n;
        this.expansionDirection = this.nextExpansionDirection();
        return value;
    }

    private final NextExpansionDirection nextExpansionDirection() {
        if (this.currentStartInclusive == this.minValueInclusive && this.currentEndInclusive == this.maxValueInclusive) {
            return NextExpansionDirection.DISABLED;
        }
        if (this.currentStartInclusive == this.minValueInclusive) {
            return NextExpansionDirection.UP;
        }
        if (this.currentEndInclusive == this.maxValueInclusive) {
            return NextExpansionDirection.DOWN;
        }
        return this.expansionDirection == NextExpansionDirection.UP ? NextExpansionDirection.DOWN : NextExpansionDirection.UP;
    }

    private final int generateFromRandomRange(int rangeLowerBoundInclusive, int rangeUpperBoundInclusive) {
        return rangeLowerBoundInclusive + this.random.nextInt(rangeUpperBoundInclusive - rangeLowerBoundInclusive + 1);
    }

    private final int calculateFirstValue() {
        return (int)(((long)this.minValueInclusive + (long)this.maxValueInclusive) / (long)2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlinx/lincheck/paramgen/ExpandingRangeIntGenerator$NextExpansionDirection;", "", "(Ljava/lang/String;I)V", "UP", "DOWN", "DISABLED", "lincheck"})
    private static final class NextExpansionDirection
    extends Enum<NextExpansionDirection> {
        public static final /* enum */ NextExpansionDirection UP = new NextExpansionDirection();
        public static final /* enum */ NextExpansionDirection DOWN = new NextExpansionDirection();
        public static final /* enum */ NextExpansionDirection DISABLED = new NextExpansionDirection();
        private static final /* synthetic */ NextExpansionDirection[] $VALUES;

        public static NextExpansionDirection[] values() {
            return (NextExpansionDirection[])$VALUES.clone();
        }

        public static NextExpansionDirection valueOf(String value) {
            return Enum.valueOf(NextExpansionDirection.class, value);
        }

        static {
            $VALUES = nextExpansionDirectionArray = new NextExpansionDirection[]{NextExpansionDirection.UP, NextExpansionDirection.DOWN, NextExpansionDirection.DISABLED};
        }
    }
}

