/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.runner.FixedActiveThreadsExecutorKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u000204:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0019H\u0082\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010 \u001a\u00020\b2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b \u0010!J\u001f\u0010#\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b#\u0010\u0018J\u001f\u0010$\u001a\u00020\b2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001dH\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b&\u0010'R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010+R\u001d\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor;", "", "nThreads", "runnerHash", "<init>", "(II)V", "", "timeoutMs", "", "await", "(J)V", "iThread", "deadline", "awaitTask", "(IJ)V", "close", "()V", "", "getResult", "(IJ)Ljava/lang/Object;", "getTask", "(I)Ljava/lang/Object;", "any", "setResult", "(ILjava/lang/Object;)V", "Lkotlin/Function0;", "getter", "spinWait", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "", "Ljava/lang/Runnable;", "tasks", "submitAndAwait", "([Ljava/lang/Runnable;J)V", "task", "submitTask", "submitTasks", "([Ljava/lang/Object;)V", "testThreadRunnable", "(I)Ljava/lang/Runnable;", "", "hangDetected", "Z", "I", "", "Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "threads", "Ljava/util/List;", "getThreads", "()Ljava/util/List;", "TestThread", "lincheck", "Ljava/io/Closeable;"})
public final class FixedActiveThreadsExecutor
implements Closeable {
    private final int nThreads;
    @NotNull
    private final List<TestThread> threads;
    @NotNull
    private /* synthetic */ AtomicReferenceArray tasks;
    @NotNull
    private /* synthetic */ AtomicReferenceArray results;
    private boolean hangDetected;

    /*
     * WARNING - void declaration
     */
    public FixedActiveThreadsExecutor(int nThreads, int runnerHash) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.nThreads = nThreads;
        this.tasks = new AtomicReferenceArray(this.nThreads);
        this.results = new AtomicReferenceArray(this.nThreads);
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.nThreads);
        FixedActiveThreadsExecutor fixedActiveThreadsExecutor = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void iThread;
            TestThread testThread;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TestThread it = testThread = new TestThread((int)iThread, runnerHash, this.testThreadRunnable((int)iThread));
            boolean bl2 = false;
            it.start();
            collection.add(testThread);
        }
        fixedActiveThreadsExecutor.threads = (List)destination$iv$iv;
    }

    @NotNull
    public final List<TestThread> getThreads() {
        return this.threads;
    }

    public final void submitAndAwait(@NotNull Runnable[] tasks, long timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        if (!(tasks.length == this.nThreads)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.submitTasks(tasks);
        this.await(timeoutMs);
    }

    private final void submitTasks(Object[] tasks) {
        int n = this.nThreads;
        for (int i = 0; i < n; ++i) {
            this.results.set(i, null);
            this.submitTask(i, tasks[i]);
        }
    }

    private final void submitTask(int iThread, Object task) {
        if (this.tasks.compareAndSet(iThread, null, task)) {
            return;
        }
        Object e = this.tasks.get(iThread);
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlinx.lincheck.runner.FixedActiveThreadsExecutor.TestThread");
        }
        TestThread thread = (TestThread)e;
        this.tasks.set(iThread, task);
        LockSupport.unpark(thread);
    }

    private final void await(long timeoutMs) {
        long deadline = System.currentTimeMillis() + timeoutMs;
        int n = this.nThreads;
        for (int iThread = 0; iThread < n; ++iThread) {
            this.awaitTask(iThread, deadline);
        }
    }

    private final void awaitTask(int iThread, long deadline) {
        Object result2 = this.getResult(iThread, deadline);
        if (!Intrinsics.areEqual((Object)result2, (Object)FixedActiveThreadsExecutorKt.access$getDONE$p())) {
            throw new ExecutionException((Throwable)result2);
        }
    }

    private final Object getResult(int iThread, long deadline) {
        Object var4_14;
        block5: {
            Object v1;
            FixedActiveThreadsExecutor this_$iv = this;
            boolean $i$f$spinWait = false;
            int n = 1000000;
            int n2 = 0;
            while (n2 < n) {
                int it$iv = n2++;
                boolean bl = false;
                boolean bl2 = false;
                Object e = this.results.get(iThread);
                if (e == null) continue;
                Object it$iv2 = e;
                boolean bl3 = false;
                v1 = it$iv2;
                break block5;
            }
            v1 = var4_14 = null;
        }
        if (var4_14 != null) {
            Object it = var4_14;
            boolean bl = false;
            return it;
        }
        Thread currentThread = Thread.currentThread();
        if (this.results.compareAndSet(iThread, null, Thread.currentThread())) {
            while (this.results.get(iThread) == currentThread) {
                long timeLeft = deadline - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    this.hangDetected = true;
                    throw new TimeoutException();
                }
                LockSupport.parkNanos(timeLeft * (long)1000000);
            }
        }
        Object e = this.results.get(iThread);
        Intrinsics.checkNotNull(e);
        return e;
    }

    private final Runnable testThreadRunnable(int iThread) {
        return () -> FixedActiveThreadsExecutor.testThreadRunnable$lambda-4(this, iThread);
    }

    private final Object getTask(int iThread) {
        Object var2_12;
        block4: {
            Object v1;
            FixedActiveThreadsExecutor this_$iv = this;
            boolean $i$f$spinWait = false;
            int n = 1000000;
            int n2 = 0;
            while (n2 < n) {
                int it$iv = n2++;
                boolean bl = false;
                boolean bl2 = false;
                Object e = this.tasks.get(iThread);
                if (e == null) continue;
                Object it$iv2 = e;
                boolean bl3 = false;
                v1 = it$iv2;
                break block4;
            }
            v1 = var2_12 = null;
        }
        if (var2_12 != null) {
            Object it = var2_12;
            boolean bl = false;
            return it;
        }
        Thread currentThread = Thread.currentThread();
        if (this.tasks.compareAndSet(iThread, null, Thread.currentThread())) {
            while (this.tasks.get(iThread) == currentThread) {
                LockSupport.park();
            }
        }
        Object e = this.tasks.get(iThread);
        Intrinsics.checkNotNull(e);
        return e;
    }

    private final void setResult(int iThread, Object any) {
        if (this.results.compareAndSet(iThread, null, any)) {
            return;
        }
        Object e = this.results.get(iThread);
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Thread");
        }
        Thread thread = (Thread)e;
        this.results.set(iThread, any);
        LockSupport.unpark(thread);
    }

    private final Object spinWait(Function0<? extends Object> getter) {
        boolean $i$f$spinWait = false;
        int n = 1000000;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Object object = getter.invoke();
            if (object == null) continue;
            Object it2 = object;
            boolean bl2 = false;
            return it2;
        }
        return null;
    }

    @Override
    public void close() {
        int n = 0;
        int n2 = this.nThreads;
        Object[] objectArray = new Object[n2];
        FixedActiveThreadsExecutor fixedActiveThreadsExecutor = this;
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = FixedActiveThreadsExecutorKt.access$getSHUTDOWN$p();
        }
        fixedActiveThreadsExecutor.submitTasks(objectArray);
        if (this.hangDetected) {
            for (TestThread t : this.threads) {
                t.stop();
            }
        }
    }

    private static final void testThreadRunnable$lambda-4(FixedActiveThreadsExecutor this$0, int $iThread) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object task;
        while (!Intrinsics.areEqual((Object)(task = this$0.getTask($iThread)), (Object)FixedActiveThreadsExecutorKt.access$getSHUTDOWN$p())) {
            this$0.tasks.set($iThread, null);
            Runnable runnable = (Runnable)task;
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this$0.setResult($iThread, UtilsKt.wrapInvalidAccessFromUnnamedModuleExceptionWithDescription(e));
                continue;
            }
            this$0.setResult($iThread, FixedActiveThreadsExecutorKt.access$getDONE$p());
        }
        return;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R \u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "Ljava/lang/Thread;", "iThread", "", "runnerHash", "r", "Ljava/lang/Runnable;", "(IILjava/lang/Runnable;)V", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "getCont", "()Lkotlinx/coroutines/CancellableContinuation;", "setCont", "(Lkotlinx/coroutines/CancellableContinuation;)V", "getIThread", "()I", "getRunnerHash", "lincheck"})
    public static final class TestThread
    extends Thread {
        private final int iThread;
        private final int runnerHash;
        @Nullable
        private CancellableContinuation<?> cont;

        public TestThread(int iThread, int runnerHash, @NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            super(r, "FixedActiveThreadsExecutor@" + runnerHash + "-" + iThread);
            this.iThread = iThread;
            this.runnerHash = runnerHash;
        }

        public final int getIThread() {
            return this.iThread;
        }

        public final int getRunnerHash() {
            return this.runnerHash;
        }

        @Nullable
        public final CancellableContinuation<?> getCont() {
            return this.cont;
        }

        public final void setCont(@Nullable CancellableContinuation<?> cancellableContinuation) {
            this.cont = cancellableContinuation;
        }
    }
}

