/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.verifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.CancellabilitySupportClassTransformer;
import org.jetbrains.kotlinx.lincheck.CancellableContinuationHolder;
import org.jetbrains.kotlinx.lincheck.Cancelled;
import org.jetbrains.kotlinx.lincheck.ExceptionResult;
import org.jetbrains.kotlinx.lincheck.Result;
import org.jetbrains.kotlinx.lincheck.ResumedResult;
import org.jetbrains.kotlinx.lincheck.Suspended;
import org.jetbrains.kotlinx.lincheck.SuspendedVoidResult;
import org.jetbrains.kotlinx.lincheck.TransformationClassLoader;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.ValueResult;
import org.jetbrains.kotlinx.lincheck.VoidResult;
import org.jetbrains.kotlinx.lincheck.verifier.Completion;
import org.jetbrains.kotlinx.lincheck.verifier.LTS;
import org.jetbrains.kotlinx.lincheck.verifier.Operation;
import org.jetbrains.kotlinx.lincheck.verifier.OperationType;
import org.jetbrains.kotlinx.lincheck.verifier.ResumptionInfo;
import org.jetbrains.kotlinx.lincheck.verifier.StateInfo;
import org.jetbrains.kotlinx.lincheck.verifier.TransitionInfo;
import org.objectweb.asm.ClassVisitor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\f\u001a\u00060\u0006R\u00020\u0000H\u0002J\u0010\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00010\u0001H\u0002J*\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J4\u0010\u0019\u001a\u00020\u001a*\u00060\u001bj\u0002`\u001c2\n\u0010\u001d\u001a\u00060\u0006R\u00020\u00002\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u00060\u0006R\u00020\u0000\u0012\u0004\u0012\u00020\u001a0\u001fH\u0002J\u001c\u0010 \u001a\n\u0018\u00010!j\u0004\u0018\u0001`\"*\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002JD\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%*\u00020\u000b2\b\u0010&\u001a\u0004\u0018\u00010\u00132 \u0010'\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0018\u00010!j\u0004\u0018\u0001`\"\u0012\u0004\u0012\u0002H%0(H\u0082\b\u00a2\u0006\u0002\u0010)JN\u0010*\u001a\u00020+*\u00020\u00132\u0006\u0010,\u001a\u00020\u00012\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160\u00152\u0016\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u0003010\u0015H\u0002R\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlinx/lincheck/verifier/LTS;", "", "sequentialSpecification", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "initialState", "Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;", "getInitialState", "()Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;", "stateInfos", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlinx/lincheck/verifier/StateInfo;", "createInitialState", "createInitialStateInstance", "kotlin.jvm.PlatformType", "findFirstAvailableTicket", "", "suspendedActorWithTickets", "", "Lorg/jetbrains/kotlinx/lincheck/verifier/Operation;", "resumedTicketsWithResults", "", "Lorg/jetbrains/kotlinx/lincheck/ResumedResult;", "generateDotGraph", "", "appendTransitions", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "state", "visitedStates", "Ljava/util/IdentityHashMap;", "computeRemappingFunction", "", "Lorg/jetbrains/kotlinx/lincheck/verifier/RemappingFunction;", "old", "intern", "T", "curOperation", "block", "Lkotlin/Function2;", "(Lorg/jetbrains/kotlinx/lincheck/verifier/StateInfo;Lorg/jetbrains/kotlinx/lincheck/verifier/Operation;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "invoke", "Lorg/jetbrains/kotlinx/lincheck/Result;", "externalState", "suspendedOperations", "", "resumedOperations", "continuationsMap", "Lkotlinx/coroutines/CancellableContinuation;", "State", "lincheck"})
public final class LTS {
    @NotNull
    private final Class<?> sequentialSpecification;
    @NotNull
    private final HashMap<StateInfo, StateInfo> stateInfos;
    @NotNull
    private final State initialState;

    public LTS(@NotNull Class<?> sequentialSpecification) {
        Intrinsics.checkNotNullParameter(sequentialSpecification, (String)"sequentialSpecification");
        Class<?> clazz = new TransformationClassLoader(LTS::sequentialSpecification$lambda-0).loadClass(sequentialSpecification.getName());
        Intrinsics.checkNotNull(clazz);
        this.sequentialSpecification = clazz;
        this.stateInfos = new HashMap();
        this.initialState = this.createInitialState();
    }

    @NotNull
    public final State getInitialState() {
        return this.initialState;
    }

    private final Result invoke(Operation $this$invoke, Object externalState, List<Operation> suspendedOperations, Map<Integer, ResumedResult> resumedOperations, Map<Operation, CancellableContinuation<?>> continuationsMap) {
        Object object;
        Result result2;
        List prevResumedTickets = CollectionsKt.toMutableList((Collection)resumedOperations.keySet());
        CancellableContinuationHolder.INSTANCE.setStoredLastCancellableCont(null);
        switch (WhenMappings.$EnumSwitchMapping$0[$this$invoke.getType().ordinal()]) {
            case 1: {
                result2 = UtilsKt.executeActor(externalState, $this$invoke.getActor(), (Continuation<Object>)((Continuation)new Completion($this$invoke.getTicket(), $this$invoke.getActor(), resumedOperations)));
                break;
            }
            case 2: {
                Object object2;
                ResumedResult resumedResult = resumedOperations.get($this$invoke.getTicket());
                Intrinsics.checkNotNull((Object)resumedResult);
                object = resumedResult.getContWithSuspensionPointRes();
                Continuation cont = (Continuation)object.component1();
                Object suspensionPointRes = ((kotlin.Result)object.component2()).unbox-impl();
                if (cont == null) {
                    object2 = suspensionPointRes;
                } else {
                    cont.resumeWith(suspensionPointRes);
                    ResumedResult resumedResult2 = resumedOperations.get($this$invoke.getTicket());
                    Intrinsics.checkNotNull((Object)resumedResult2);
                    object2 = ((kotlin.Result)resumedResult2.getContWithSuspensionPointRes().getSecond()).unbox-impl();
                }
                Object finalRes = object2;
                resumedOperations.remove($this$invoke.getTicket());
                result2 = UtilsKt.createLincheckResult(kotlin.Result.box-impl((Object)finalRes), true);
                break;
            }
            case 3: {
                CancellableContinuation<?> cancellableContinuation = continuationsMap.get(new Operation($this$invoke.getActor(), $this$invoke.getTicket(), OperationType.REQUEST));
                Intrinsics.checkNotNull(cancellableContinuation);
                UtilsKt.cancelByLincheck(cancellableContinuation, $this$invoke.getActor().getPromptCancellation());
                boolean wasSuspended = suspendedOperations.removeIf(arg_0 -> LTS.invoke$lambda-1($this$invoke, arg_0));
                if (!$this$invoke.getActor().getPromptCancellation() && !wasSuspended) {
                    boolean $i$a$-check-LTS$invoke$res$32 = false;
                    String $i$a$-check-LTS$invoke$res$32 = "The operation can be cancelled after resumption only in the prompt cancellation mode";
                    throw new IllegalStateException($i$a$-check-LTS$invoke$res$32.toString());
                }
                if (resumedOperations.remove($this$invoke.getTicket()) != null && !$this$invoke.getActor().getPromptCancellation()) {
                    boolean bl = false;
                    String string = "The operation can be resumed and then cancelled only with the prompt cancellation enabled";
                    throw new IllegalStateException(string.toString());
                }
                result2 = Cancelled.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Result res = result2;
        if (res == Suspended.INSTANCE) {
            CancellableContinuation<?> cont = CancellableContinuationHolder.INSTANCE.getStoredLastCancellableCont();
            CancellableContinuationHolder.INSTANCE.setStoredLastCancellableCont(null);
            if (cont != null) {
                continuationsMap.put($this$invoke, cont);
            }
            suspendedOperations.add($this$invoke);
        }
        Map<Integer, ResumedResult> $this$forEach$iv = resumedOperations;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            int resumedTicket = ((Number)entry.getKey()).intValue();
            ResumedResult res2 = (ResumedResult)entry.getValue();
            if (prevResumedTickets.contains(resumedTicket)) continue;
            suspendedOperations.removeIf(arg_0 -> LTS.invoke$lambda-5$lambda-4(resumedTicket, arg_0));
            res2.setBy($this$invoke.getActor());
        }
        return res;
    }

    private final <T> T intern(StateInfo $this$intern, Operation curOperation, Function2<? super StateInfo, ? super int[], ? extends T> block) {
        boolean $i$f$intern = false;
        if (!this.stateInfos.containsKey($this$intern)) {
            StateInfo stateInfo;
            List newSeqToCreate = curOperation != null ? CollectionsKt.plus((Collection)$this$intern.getState().getSeqToCreate(), (Object)curOperation) : CollectionsKt.emptyList();
            Map map = this.stateInfos;
            StateInfo it = stateInfo = $this$intern;
            boolean bl = false;
            it.setState(new State(newSeqToCreate));
            map.put($this$intern, stateInfo);
            Object v = this.stateInfos.get($this$intern);
            Intrinsics.checkNotNull(v);
            return (T)block.invoke(v, null);
        }
        Object v = this.stateInfos.get($this$intern);
        Intrinsics.checkNotNull(v);
        StateInfo old = (StateInfo)v;
        return (T)block.invoke((Object)old, (Object)this.computeRemappingFunction($this$intern, old));
    }

    /*
     * WARNING - void declaration
     */
    private final State createInitialState() {
        State state;
        void $this$intern$iv;
        void this_$iv;
        Object instance = this.createInitialStateInstance();
        State initialState = new State(CollectionsKt.emptyList());
        LTS lTS = this;
        Intrinsics.checkNotNullExpressionValue((Object)instance, (String)"instance");
        StateInfo stateInfo = new StateInfo(initialState, instance, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        Object curOperation$iv = null;
        boolean $i$f$intern = false;
        if (((LTS)this_$iv).stateInfos.containsKey($this$intern$iv)) {
            Object v = ((LTS)this_$iv).stateInfos.get($this$intern$iv);
            Intrinsics.checkNotNull(v);
            StateInfo old$iv = (StateInfo)v;
            ((LTS)this_$iv).computeRemappingFunction((StateInfo)$this$intern$iv, old$iv);
            boolean bl = false;
            state = initialState;
        } else {
            void var10_12;
            List newSeqToCreate$iv = CollectionsKt.emptyList();
            Map map = ((LTS)this_$iv).stateInfos;
            void it$iv = var10_12 = $this$intern$iv;
            boolean bl = false;
            it$iv.setState((LTS)this_$iv.new State(newSeqToCreate$iv));
            map.put($this$intern$iv, var10_12);
            Object v = ((LTS)this_$iv).stateInfos.get($this$intern$iv);
            Intrinsics.checkNotNull(v);
            StateInfo cfr_ignored_1 = (StateInfo)v;
            boolean bl2 = false;
            state = initialState;
        }
        return state;
    }

    private final Object createInitialStateInstance() {
        return this.sequentialSpecification.newInstance();
    }

    private final int[] computeRemappingFunction(StateInfo $this$computeRemappingFunction, StateInfo old) {
        int i;
        if ($this$computeRemappingFunction.getMaxTicket() == -1) {
            return null;
        }
        int n = 0;
        int n2 = $this$computeRemappingFunction.getMaxTicket() + 1;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = -1;
        }
        int[] rf = nArray;
        n2 = $this$computeRemappingFunction.getSuspendedOperations().size();
        for (i = 0; i < n2; ++i) {
            rf[$this$computeRemappingFunction.getSuspendedOperations().get((int)i).getTicket()] = old.getSuspendedOperations().get(i).getTicket();
        }
        n2 = $this$computeRemappingFunction.getResumedOperations().size();
        for (i = 0; i < n2; ++i) {
            rf[$this$computeRemappingFunction.getResumedOperations().get((int)i).getResumedActorTicket()] = old.getResumedOperations().get(i).getResumedActorTicket();
        }
        return rf;
    }

    private final int findFirstAvailableTicket(List<Operation> suspendedActorWithTickets, Map<Integer, ResumedResult> resumedTicketsWithResults) {
        int n = suspendedActorWithTickets.size() + resumedTicketsWithResults.size();
        for (int ticket = 0; ticket < n; ++ticket) {
            Object v0;
            Object object;
            block2: {
                object = suspendedActorWithTickets;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Operation it = (Operation)t;
                    boolean bl = false;
                    if (!(it.getTicket() == ticket)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if (v0 != null || resumedTicketsWithResults.containsKey(object = Integer.valueOf(ticket))) continue;
            return ticket;
        }
        return suspendedActorWithTickets.size() + resumedTicketsWithResults.size();
    }

    @NotNull
    public final String generateDotGraph() {
        StringBuilder builder = new StringBuilder();
        StringBuilder stringBuilder = builder.append("digraph {");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        StringBuilder stringBuilder2 = builder.append("\"" + this.initialState.hashCode() + "\" [style=filled, fillcolor=green]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        this.appendTransitions(builder, this.initialState, new IdentityHashMap<State, Unit>());
        StringBuilder stringBuilder3 = builder.append("}");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void appendTransitions(StringBuilder $this$appendTransitions, State state, IdentityHashMap<State, Unit> visitedStates) {
        state.getTransitionsByRequests$lincheck().forEach((arg_0, arg_1) -> LTS.appendTransitions$lambda-9($this$appendTransitions, state, visitedStates, this, arg_0, arg_1));
        state.getTransitionsByFollowUps$lincheck().forEach((arg_0, arg_1) -> LTS.appendTransitions$lambda-10($this$appendTransitions, state, visitedStates, this, arg_0, arg_1));
        state.getTransitionsByCancellations$lincheck().forEach((arg_0, arg_1) -> LTS.appendTransitions$lambda-11($this$appendTransitions, state, visitedStates, this, arg_0, arg_1));
    }

    private static final ClassVisitor sequentialSpecification$lambda-0(ClassVisitor cv) {
        Intrinsics.checkNotNullExpressionValue((Object)cv, (String)"cv");
        return new CancellabilitySupportClassTransformer(cv);
    }

    private static final boolean invoke$lambda-1(Operation $this_invoke, Operation it) {
        Intrinsics.checkNotNullParameter((Object)$this_invoke, (String)"$this_invoke");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getActor(), (Object)$this_invoke.getActor()) && it.getTicket() == $this_invoke.getTicket();
    }

    private static final boolean invoke$lambda-5$lambda-4(int $resumedTicket, Operation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTicket() == $resumedTicket;
    }

    private static final void appendTransitions$lambda-9(StringBuilder $this_appendTransitions, State $state, IdentityHashMap $visitedStates, LTS this$0, Actor actor, TransitionInfo transition) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this_appendTransitions, (String)"$this_appendTransitions");
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$visitedStates, (String)"$visitedStates");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        StringBuilder stringBuilder = $this_appendTransitions;
        int n = $state.hashCode();
        int n2 = transition.getNextState().hashCode();
        Result result2 = transition.getResult();
        int n3 = transition.getTicket();
        int[] nArray = transition.getRf();
        if (nArray != null) {
            String string2 = Arrays.toString(nArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        } else {
            string = null;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(n + " -> " + n2 + " [ label=\"<R," + actor + ":" + result2 + "," + n3 + ">, rf=" + string + "\" ]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        if ($visitedStates.put(transition.getNextState(), Unit.INSTANCE) == null) {
            this$0.appendTransitions($this_appendTransitions, transition.getNextState(), $visitedStates);
        }
    }

    private static final void appendTransitions$lambda-10(StringBuilder $this_appendTransitions, State $state, IdentityHashMap $visitedStates, LTS this$0, Integer ticket, TransitionInfo transition) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this_appendTransitions, (String)"$this_appendTransitions");
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$visitedStates, (String)"$visitedStates");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        StringBuilder stringBuilder = $this_appendTransitions;
        int n = $state.hashCode();
        int n2 = transition.getNextState().hashCode();
        Result result2 = transition.getResult();
        int n3 = transition.getTicket();
        int[] nArray = transition.getRf();
        if (nArray != null) {
            String string2 = Arrays.toString(nArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        } else {
            string = null;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(n + " -> " + n2 + " [ label=\"<F," + ticket + ":" + result2 + "," + n3 + ">, rf=" + string + "\" ]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        if ($visitedStates.put(transition.getNextState(), Unit.INSTANCE) == null) {
            this$0.appendTransitions($this_appendTransitions, transition.getNextState(), $visitedStates);
        }
    }

    private static final void appendTransitions$lambda-11(StringBuilder $this_appendTransitions, State $state, IdentityHashMap $visitedStates, LTS this$0, Integer ticket, TransitionInfo transition) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this_appendTransitions, (String)"$this_appendTransitions");
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$visitedStates, (String)"$visitedStates");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        StringBuilder stringBuilder = $this_appendTransitions;
        int n = $state.hashCode();
        int n2 = transition.getNextState().hashCode();
        Result result2 = transition.getResult();
        int n3 = transition.getTicket();
        int[] nArray = transition.getRf();
        if (nArray != null) {
            String string2 = Arrays.toString(nArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        } else {
            string = null;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(n + " -> " + n2 + " [ label=\"<C," + ticket + ":" + result2 + "," + n3 + ">, rf=" + string + "\" ]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        if ($visitedStates.put(transition.getNextState(), Unit.INSTANCE) == null) {
            this$0.appendTransitions($this_appendTransitions, transition.getNextState(), $visitedStates);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0099\u0001\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0082\u0001\u0010\u001d\u001a~\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\"\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(#\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020$0\u000f\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(%\u0012#\u0012!\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0\u000f\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b('\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0082\b\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0007H\u0002J<\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0003H\u0002J\"\u00101\u001a\b\u0012\u0004\u0012\u0002000\u00032\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020$02H\u0002J \u00103\u001a\u0004\u0018\u00010\u00072\u0006\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u0010J\u0016\u00107\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u0010J\"\u00108\u001a\u0004\u0018\u00010\u00072\u0006\u00104\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u00102\u0006\u00105\u001a\u00020-H\u0002J\u001a\u00109\u001a\u0004\u0018\u00010\u00072\u0006\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020-H\u0002J\u001c\u0010:\u001a\u00020;*\u00020-2\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020;H\u0002J\u001c\u0010>\u001a\u00020;*\u00020-2\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020;H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R'\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0015\u0010\u0012R'\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00070\u000f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0019\u0010\u0012\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;", "", "seqToCreate", "", "Lorg/jetbrains/kotlinx/lincheck/verifier/Operation;", "(Lorg/jetbrains/kotlinx/lincheck/verifier/LTS;Ljava/util/List;)V", "atomicallySuspendedAndCancelledTransition", "Lorg/jetbrains/kotlinx/lincheck/verifier/TransitionInfo;", "getAtomicallySuspendedAndCancelledTransition", "()Lorg/jetbrains/kotlinx/lincheck/verifier/TransitionInfo;", "atomicallySuspendedAndCancelledTransition$delegate", "Lkotlin/Lazy;", "getSeqToCreate", "()Ljava/util/List;", "transitionsByCancellations", "", "", "getTransitionsByCancellations$lincheck", "()Ljava/util/Map;", "transitionsByCancellations$delegate", "transitionsByFollowUps", "getTransitionsByFollowUps$lincheck", "transitionsByFollowUps$delegate", "transitionsByRequests", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "getTransitionsByRequests$lincheck", "transitionsByRequests$delegate", "copyAndApply", "T", "action", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "instance", "", "suspendedOperations", "Lorg/jetbrains/kotlinx/lincheck/ResumedResult;", "resumedTicketsWithResults", "Lkotlinx/coroutines/CancellableContinuation;", "continuationsMap", "(Lkotlin/jvm/functions/Function4;)Ljava/lang/Object;", "createAtomicallySuspendedAndCancelledTransition", "createTransition", "actorWithTicket", "result", "Lorg/jetbrains/kotlinx/lincheck/Result;", "suspendedActorWithTickets", "resumedOperations", "Lorg/jetbrains/kotlinx/lincheck/verifier/ResumptionInfo;", "getResumedOperations", "", "next", "actor", "expectedResult", "ticket", "nextByCancellation", "nextByFollowUp", "nextByRequest", "isLegalByFollowUp", "", "transitionInfo", "allowExtraSuspension", "isLegalByRequest", "lincheck"})
    public final class State {
        @NotNull
        private final List<Operation> seqToCreate;
        @NotNull
        private final Lazy transitionsByRequests$delegate;
        @NotNull
        private final Lazy transitionsByFollowUps$delegate;
        @NotNull
        private final Lazy transitionsByCancellations$delegate;
        @NotNull
        private final Lazy atomicallySuspendedAndCancelledTransition$delegate;

        public State(List<Operation> seqToCreate) {
            Intrinsics.checkNotNullParameter(seqToCreate, (String)"seqToCreate");
            this.seqToCreate = seqToCreate;
            this.transitionsByRequests$delegate = LazyKt.lazy((Function0)transitionsByRequests.2.INSTANCE);
            this.transitionsByFollowUps$delegate = LazyKt.lazy((Function0)transitionsByFollowUps.2.INSTANCE);
            this.transitionsByCancellations$delegate = LazyKt.lazy((Function0)transitionsByCancellations.2.INSTANCE);
            this.atomicallySuspendedAndCancelledTransition$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TransitionInfo>(this){
                final /* synthetic */ State this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final TransitionInfo invoke() {
                    return State.access$createAtomicallySuspendedAndCancelledTransition(this.this$0);
                }
            }));
        }

        @NotNull
        public final List<Operation> getSeqToCreate() {
            return this.seqToCreate;
        }

        @NotNull
        public final Map<Actor, TransitionInfo> getTransitionsByRequests$lincheck() {
            Lazy lazy = this.transitionsByRequests$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, TransitionInfo> getTransitionsByFollowUps$lincheck() {
            Lazy lazy = this.transitionsByFollowUps$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, TransitionInfo> getTransitionsByCancellations$lincheck() {
            Lazy lazy = this.transitionsByCancellations$delegate;
            return (Map)lazy.getValue();
        }

        private final TransitionInfo getAtomicallySuspendedAndCancelledTransition() {
            Lazy lazy = this.atomicallySuspendedAndCancelledTransition$delegate;
            return (TransitionInfo)lazy.getValue();
        }

        @Nullable
        public final TransitionInfo next(@NotNull Actor actor, @NotNull Result expectedResult, int ticket) {
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            Intrinsics.checkNotNullParameter((Object)expectedResult, (String)"expectedResult");
            return ticket == -1 ? this.nextByRequest(actor, expectedResult) : this.nextByFollowUp(actor, ticket, expectedResult);
        }

        /*
         * WARNING - void declaration
         */
        private final TransitionInfo createAtomicallySuspendedAndCancelledTransition() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void resumedTicketsWithResults;
            State this_$iv = this;
            boolean $i$f$copyAndApply = false;
            Object instance$iv = this_$iv.LTS.this.createInitialStateInstance();
            List suspendedOperations$iv = new ArrayList();
            Map resumedTicketsWithResults$iv = new LinkedHashMap();
            Map continuationsMap$iv = new LinkedHashMap();
            try {
                void $this$forEach$iv$iv;
                Iterable iterable = this_$iv.seqToCreate;
                LTS lTS = this_$iv.LTS.this;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Operation it$iv = (Operation)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
                    lTS.invoke(it$iv, instance$iv, suspendedOperations$iv, resumedTicketsWithResults$iv, continuationsMap$iv);
                }
            }
            catch (Exception e$iv) {
                throw new IllegalStateException(e$iv);
            }
            Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
            Map map = continuationsMap$iv;
            Map map2 = resumedTicketsWithResults$iv;
            List list = suspendedOperations$iv;
            Object instance = instance$iv;
            boolean bl = false;
            Iterable iterable = this.getResumedOperations((Map<Integer, ResumedResult>)resumedTicketsWithResults);
            State state = this;
            boolean $i$f$map = false;
            void var22_23 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResumptionInfo resumptionInfo = (ResumptionInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getResumedActorTicket());
            }
            Result result2 = Cancelled.INSTANCE;
            int[] nArray = null;
            int n = -1;
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            State state2 = state;
            return new TransitionInfo(state2, set, n, nArray, result2);
        }

        private final TransitionInfo nextByRequest(Actor actor, Result expectedResult) {
            TransitionInfo transitionInfo = this.getTransitionsByRequests$lincheck().computeIfAbsent(actor, arg_0 -> State.nextByRequest$lambda-3(this, LTS.this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)transitionInfo, (String)"transitionsByRequests.co\u2026          }\n            }");
            TransitionInfo transitionInfo2 = transitionInfo;
            if (actor.getAllowExtraSuspension() && Intrinsics.areEqual((Object)expectedResult, (Object)Cancelled.INSTANCE) && !Intrinsics.areEqual((Object)transitionInfo2.getResult(), (Object)Suspended.INSTANCE)) {
                return this.getAtomicallySuspendedAndCancelledTransition();
            }
            return this.isLegalByRequest(expectedResult, transitionInfo2, actor.getAllowExtraSuspension()) ? transitionInfo2 : null;
        }

        private final TransitionInfo nextByFollowUp(Actor actor, int ticket, Result expectedResult) {
            TransitionInfo transitionInfo = this.getTransitionsByFollowUps$lincheck().computeIfAbsent(ticket, arg_0 -> State.nextByFollowUp$lambda-5(this, actor, ticket, LTS.this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)transitionInfo, (String)"transitionsByFollowUps.c\u2026          }\n            }");
            TransitionInfo transitionInfo2 = transitionInfo;
            if (!(!Intrinsics.areEqual((Object)transitionInfo2.getResult(), (Object)Suspended.INSTANCE))) {
                boolean bl = false;
                String string = "Execution of the follow-up part of this operation " + actor.getMethod() + " suspended - this behaviour is not supported";
                throw new IllegalStateException(string.toString());
            }
            return this.isLegalByFollowUp(expectedResult, transitionInfo2, actor.getAllowExtraSuspension()) ? transitionInfo2 : null;
        }

        @NotNull
        public final TransitionInfo nextByCancellation(@NotNull Actor actor, int ticket) {
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            TransitionInfo transitionInfo = this.getTransitionsByCancellations$lincheck().computeIfAbsent(ticket, arg_0 -> State.nextByCancellation$lambda-8(this, actor, ticket, LTS.this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)transitionInfo, (String)"transitionsByCancellatio\u2026)\n            }\n        }");
            return transitionInfo;
        }

        private final boolean isLegalByRequest(Result $this$isLegalByRequest, TransitionInfo transitionInfo, boolean allowExtraSuspension) {
            return this.isLegalByFollowUp($this$isLegalByRequest, transitionInfo, allowExtraSuspension) || $this$isLegalByRequest.getWasSuspended() && (Intrinsics.areEqual((Object)transitionInfo.getResult(), (Object)Suspended.INSTANCE) || allowExtraSuspension) || !$this$isLegalByRequest.getWasSuspended() && Intrinsics.areEqual((Object)transitionInfo.getResult(), (Object)Suspended.INSTANCE);
        }

        private final boolean isLegalByFollowUp(Result $this$isLegalByFollowUp, TransitionInfo transitionInfo, boolean allowExtraSuspension) {
            return Intrinsics.areEqual((Object)$this$isLegalByFollowUp, (Object)transitionInfo.getResult()) || $this$isLegalByFollowUp instanceof ValueResult && transitionInfo.getResult() instanceof ValueResult && Intrinsics.areEqual((Object)((ValueResult)$this$isLegalByFollowUp).getValue(), (Object)((ValueResult)transitionInfo.getResult()).getValue()) && (!$this$isLegalByFollowUp.getWasSuspended() && transitionInfo.getResult().getWasSuspended() || $this$isLegalByFollowUp.getWasSuspended() && allowExtraSuspension) || $this$isLegalByFollowUp instanceof ExceptionResult && transitionInfo.getResult() instanceof ExceptionResult && Intrinsics.areEqual(((ExceptionResult)$this$isLegalByFollowUp).getTClazz(), ((ExceptionResult)transitionInfo.getResult()).getTClazz()) && (!$this$isLegalByFollowUp.getWasSuspended() && transitionInfo.getResult().getWasSuspended() || $this$isLegalByFollowUp.getWasSuspended() && allowExtraSuspension) || Intrinsics.areEqual((Object)$this$isLegalByFollowUp, (Object)VoidResult.INSTANCE) && Intrinsics.areEqual((Object)transitionInfo.getResult(), (Object)SuspendedVoidResult.INSTANCE) || Intrinsics.areEqual((Object)$this$isLegalByFollowUp, (Object)SuspendedVoidResult.INSTANCE) && Intrinsics.areEqual((Object)transitionInfo.getResult(), (Object)VoidResult.INSTANCE) && allowExtraSuspension;
        }

        /*
         * WARNING - void declaration
         */
        private final <T> T copyAndApply(Function4<Object, ? super List<Operation>, ? super Map<Integer, ResumedResult>, ? super Map<Operation, CancellableContinuation<?>>, ? extends T> action) {
            boolean $i$f$copyAndApply = false;
            Object instance = LTS.this.createInitialStateInstance();
            List suspendedOperations = new ArrayList();
            Map resumedTicketsWithResults = new LinkedHashMap();
            Map continuationsMap = new LinkedHashMap();
            try {
                void $this$forEach$iv;
                Iterable iterable = this.seqToCreate;
                LTS lTS = LTS.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Operation it = (Operation)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)instance, (String)"instance");
                    lTS.invoke(it, instance, suspendedOperations, resumedTicketsWithResults, continuationsMap);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            Intrinsics.checkNotNullExpressionValue((Object)instance, (String)"instance");
            return (T)action.invoke(instance, (Object)suspendedOperations, (Object)resumedTicketsWithResults, (Object)continuationsMap);
        }

        /*
         * WARNING - void declaration
         */
        private final TransitionInfo createTransition(Operation actorWithTicket, Result result2, Object instance, List<Operation> suspendedActorWithTickets, List<ResumptionInfo> resumedOperations) {
            TransitionInfo transitionInfo;
            void this_$iv;
            StateInfo stateInfo = new StateInfo(this, instance, suspendedActorWithTickets, resumedOperations);
            LTS lTS = LTS.this;
            StateInfo $this$intern$iv = stateInfo;
            boolean $i$f$intern = false;
            if (((LTS)this_$iv).stateInfos.containsKey($this$intern$iv)) {
                void rf;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object v = ((LTS)this_$iv).stateInfos.get($this$intern$iv);
                Intrinsics.checkNotNull(v);
                StateInfo old$iv = (StateInfo)v;
                int[] nArray = ((LTS)this_$iv).computeRemappingFunction($this$intern$iv, old$iv);
                StateInfo nextStateInfo = old$iv;
                boolean bl = false;
                Iterable iterable = stateInfo.getResumedOperations();
                State state = nextStateInfo.getState();
                boolean $i$f$map = false;
                void var17_24 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResumptionInfo resumptionInfo = (ResumptionInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getResumedActorTicket());
                }
                Result result3 = result2;
                void var30_41 = rf;
                int n = rf != null && result2 == Suspended.INSTANCE ? rf[actorWithTicket.getTicket()] : actorWithTicket.getTicket();
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                State state2 = state;
                transitionInfo = new TransitionInfo(state2, set, n, (int[])var30_41, result3);
            } else {
                StateInfo stateInfo2;
                List newSeqToCreate$iv = actorWithTicket != null ? CollectionsKt.plus((Collection)$this$intern$iv.getState().getSeqToCreate(), (Object)actorWithTicket) : CollectionsKt.emptyList();
                Map map = ((LTS)this_$iv).stateInfos;
                StateInfo it$iv = stateInfo2 = $this$intern$iv;
                boolean bl = false;
                it$iv.setState((LTS)this_$iv.new State(newSeqToCreate$iv));
                map.put($this$intern$iv, stateInfo2);
                Object v = ((LTS)this_$iv).stateInfos.get($this$intern$iv);
                Intrinsics.checkNotNull(v);
                int[] rf = null;
                StateInfo nextStateInfo = (StateInfo)v;
                boolean bl3 = false;
                Iterable $this$map$iv = stateInfo.getResumedOperations();
                State state = nextStateInfo.getState();
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ResumptionInfo it = (ResumptionInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.getResumedActorTicket());
                }
                Result result4 = result2;
                int[] nArray = rf;
                int n = actorWithTicket.getTicket();
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                State state3 = state;
                transitionInfo = new TransitionInfo(state3, set, n, nArray, result4);
            }
            return transitionInfo;
        }

        private final List<ResumptionInfo> getResumedOperations(Map<Integer, ResumedResult> resumedTicketsWithResults) {
            List resumedOperations = new ArrayList();
            resumedTicketsWithResults.forEach((arg_0, arg_1) -> State.getResumedOperations$lambda-12(resumedOperations, arg_0, arg_1));
            Iterable $this$sortedBy$iv = resumedOperations;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResumptionInfo it = (ResumptionInfo)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getResumedActorTicket());
                    it = (ResumptionInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getResumedActorTicket()));
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private static final TransitionInfo nextByRequest$lambda-3(State this$0, LTS this$1, Actor a) {
            void continuationsMap;
            void resumedTicketsWithResults;
            void suspendedOperations;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            State this_$iv = this$0;
            boolean $i$f$copyAndApply = false;
            Object instance$iv = this_$iv.LTS.this.createInitialStateInstance();
            List suspendedOperations$iv = new ArrayList();
            Map resumedTicketsWithResults$iv = new LinkedHashMap();
            Map continuationsMap$iv = new LinkedHashMap();
            try {
                void $this$forEach$iv$iv;
                Iterable iterable = this_$iv.seqToCreate;
                LTS lTS = this_$iv.LTS.this;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Operation it$iv = (Operation)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
                    lTS.invoke(it$iv, instance$iv, suspendedOperations$iv, resumedTicketsWithResults$iv, continuationsMap$iv);
                }
            }
            catch (Exception e$iv) {
                throw new IllegalStateException(e$iv);
            }
            Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
            Map map = continuationsMap$iv;
            Map map2 = resumedTicketsWithResults$iv;
            List list = suspendedOperations$iv;
            Object instance = instance$iv;
            boolean bl = false;
            int ticket = this$1.findFirstAvailableTicket((List)suspendedOperations, (Map)resumedTicketsWithResults);
            Operation op = new Operation(a, ticket, OperationType.REQUEST);
            Result result2 = this$1.invoke(op, instance, (List)suspendedOperations, (Map)resumedTicketsWithResults, (Map)continuationsMap);
            return this$0.createTransition(op, result2, instance, (List<Operation>)suspendedOperations, this$0.getResumedOperations((Map<Integer, ResumedResult>)resumedTicketsWithResults));
        }

        /*
         * WARNING - void declaration
         */
        private static final TransitionInfo nextByFollowUp$lambda-5(State this$0, Actor $actor, int $ticket, LTS this$1, Integer it) {
            void continuationsMap;
            void resumedTicketsWithResults;
            void suspendedOperations;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$actor, (String)"$actor");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            State this_$iv = this$0;
            boolean $i$f$copyAndApply = false;
            Object instance$iv = this_$iv.LTS.this.createInitialStateInstance();
            List suspendedOperations$iv = new ArrayList();
            Map resumedTicketsWithResults$iv = new LinkedHashMap();
            Map continuationsMap$iv = new LinkedHashMap();
            try {
                void $this$forEach$iv$iv;
                Iterable iterable = this_$iv.seqToCreate;
                LTS lTS = this_$iv.LTS.this;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Operation it$iv = (Operation)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
                    lTS.invoke(it$iv, instance$iv, suspendedOperations$iv, resumedTicketsWithResults$iv, continuationsMap$iv);
                }
            }
            catch (Exception e$iv) {
                throw new IllegalStateException(e$iv);
            }
            Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
            Map map = continuationsMap$iv;
            Map map2 = resumedTicketsWithResults$iv;
            List list = suspendedOperations$iv;
            Object instance = instance$iv;
            boolean bl = false;
            Operation op = new Operation($actor, $ticket, OperationType.FOLLOW_UP);
            Result result2 = this$1.invoke(op, instance, (List)suspendedOperations, (Map)resumedTicketsWithResults, (Map)continuationsMap);
            return this$0.createTransition(op, result2, instance, (List<Operation>)suspendedOperations, this$0.getResumedOperations((Map<Integer, ResumedResult>)resumedTicketsWithResults));
        }

        /*
         * WARNING - void declaration
         */
        private static final TransitionInfo nextByCancellation$lambda-8(State this$0, Actor $actor, int $ticket, LTS this$1, Integer it) {
            void continuationsMap;
            void resumedTicketsWithResults;
            void suspendedOperations;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$actor, (String)"$actor");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            State this_$iv = this$0;
            boolean $i$f$copyAndApply = false;
            Object instance$iv = this_$iv.LTS.this.createInitialStateInstance();
            List suspendedOperations$iv = new ArrayList();
            Map resumedTicketsWithResults$iv = new LinkedHashMap();
            Map continuationsMap$iv = new LinkedHashMap();
            try {
                void $this$forEach$iv$iv;
                Iterable iterable = this_$iv.seqToCreate;
                LTS lTS = this_$iv.LTS.this;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Operation it$iv = (Operation)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
                    lTS.invoke(it$iv, instance$iv, suspendedOperations$iv, resumedTicketsWithResults$iv, continuationsMap$iv);
                }
            }
            catch (Exception e$iv) {
                throw new IllegalStateException(e$iv);
            }
            Intrinsics.checkNotNullExpressionValue((Object)instance$iv, (String)"instance");
            Map map = continuationsMap$iv;
            Map map2 = resumedTicketsWithResults$iv;
            List list = suspendedOperations$iv;
            Object instance = instance$iv;
            boolean bl = false;
            Operation op = new Operation($actor, $ticket, OperationType.CANCELLATION);
            Result result2 = this$1.invoke(op, instance, (List)suspendedOperations, (Map)resumedTicketsWithResults, (Map)continuationsMap);
            if (!(result2 == Cancelled.INSTANCE)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            return this$0.createTransition(op, result2, instance, (List<Operation>)suspendedOperations, this$0.getResumedOperations((Map<Integer, ResumedResult>)resumedTicketsWithResults));
        }

        private static final void getResumedOperations$lambda-12(List $resumedOperations, Integer resumedTicket, ResumedResult res) {
            Intrinsics.checkNotNullParameter((Object)$resumedOperations, (String)"$resumedOperations");
            Intrinsics.checkNotNullParameter((Object)resumedTicket, (String)"resumedTicket");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            $resumedOperations.add(new ResumptionInfo(res.getResumedActor(), res.getBy(), resumedTicket));
        }

        public static final /* synthetic */ TransitionInfo access$createAtomicallySuspendedAndCancelledTransition(State $this) {
            return $this.createAtomicallySuspendedAndCancelledTransition();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperationType.values().length];
            nArray[OperationType.REQUEST.ordinal()] = 1;
            nArray[OperationType.FOLLOW_UP.ordinal()] = 2;
            nArray[OperationType.CANCELLATION.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

