/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.TransformationClassLoader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/lincheck/CustomObjectInputStream;", "Ljava/io/ObjectInputStream;", "loader", "Ljava/lang/ClassLoader;", "inputStream", "Ljava/io/InputStream;", "(Ljava/lang/ClassLoader;Ljava/io/InputStream;)V", "getLoader", "()Ljava/lang/ClassLoader;", "resolveClass", "Ljava/lang/Class;", "desc", "Ljava/io/ObjectStreamClass;", "lincheck"})
final class CustomObjectInputStream
extends ObjectInputStream {
    @NotNull
    private final ClassLoader loader;

    public CustomObjectInputStream(@NotNull ClassLoader loader, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
        this.loader = loader;
    }

    @NotNull
    public final ClassLoader getLoader() {
        return this.loader;
    }

    @Override
    @NotNull
    protected Class<?> resolveClass(@NotNull ObjectStreamClass desc) {
        String string;
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        if (this.loader instanceof TransformationClassLoader) {
            string = ((TransformationClassLoader)this.loader).remapClassName(desc.getName());
        } else {
            String string2 = desc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = TransformationClassLoader.REMAPPED_PACKAGE_CANONICAL_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"REMAPPED_PACKAGE_CANONICAL_NAME");
            string = StringsKt.removePrefix((String)string2, (CharSequence)string3);
        }
        String className = string;
        Class<?> clazz = Class.forName(className, true, this.loader);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
        return clazz;
    }
}

