/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.CTestConfiguration;
import org.jetbrains.kotlinx.lincheck.CTestConfigurationKt;
import org.jetbrains.kotlinx.lincheck.CTestStructure;
import org.jetbrains.kotlinx.lincheck.LincheckAssertionError;
import org.jetbrains.kotlinx.lincheck.LoggingLevel;
import org.jetbrains.kotlinx.lincheck.Options;
import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.Reporter;
import org.jetbrains.kotlinx.lincheck.ReporterKt;
import org.jetbrains.kotlinx.lincheck.annotations.LogLevel;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionGenerator;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenarioKt;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000bH\u0002J\u001c\u0010\u0014\u001a\n \u000e*\u0004\u0018\u00010\u00150\u0015*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\n \u000e*\u0004\u0018\u00010\u00190\u0019*\u00020\u000bH\u0002J\u0014\u0010\u001a\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0012*\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0012*\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker;", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "(Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/Options;)V", "reporter", "Lorg/jetbrains/kotlinx/lincheck/Reporter;", "testConfigurations", "", "Lorg/jetbrains/kotlinx/lincheck/CTestConfiguration;", "testStructure", "Lorg/jetbrains/kotlinx/lincheck/CTestStructure;", "kotlin.jvm.PlatformType", "check", "", "checkImpl", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "checkImpl$lincheck", "createExecutionGenerator", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionGenerator;", "randomProvider", "Lorg/jetbrains/kotlinx/lincheck/RandomProvider;", "createVerifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "minimize", "testCfg", "run", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "verifier", "tryMinimize", "Companion", "lincheck"})
@SourceDebugExtension(value={"SMAP\nLinChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinChecker.kt\norg/jetbrains/kotlinx/lincheck/LinChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1855#2:176\n1855#2,2:177\n1856#2:179\n1855#2,2:181\n1#3:180\n*S KotlinDebug\n*F\n+ 1 LinChecker.kt\norg/jetbrains/kotlinx/lincheck/LinChecker\n*L\n33#1:176\n34#1:177,2\n33#1:179\n87#1:181,2\n*E\n"})
public final class LinChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<?> testClass;
    private final CTestStructure testStructure;
    @NotNull
    private final List<CTestConfiguration> testConfigurations;
    @NotNull
    private final Reporter reporter;
    private static final int VERIFIER_REFRESH_CYCLE = 100;

    public LinChecker(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.testClass = testClass;
        this.testStructure = CTestStructure.getFromTestClass(this.testClass);
        Object object = options;
        if (object == null || (object = object.getLogLevel$lincheck()) == null) {
            LogLevel logLevel = this.testClass.getAnnotation(LogLevel.class);
            object = logLevel != null ? logLevel.value() : ReporterKt.DEFAULT_LOG_LEVEL;
        }
        Object logLevel = object;
        this.reporter = new Reporter((LoggingLevel)((Object)logLevel));
        Options<?, ?> options2 = options;
        this.testConfigurations = options2 != null ? CollectionsKt.listOf(options2.createTestConfigurations(this.testClass)) : CTestConfigurationKt.createFromTestClassAnnotations(this.testClass);
        Iterable $this$forEach$iv = this.testConfigurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CTestConfiguration cTestConfiguration = (CTestConfiguration)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = cTestConfiguration.getCustomScenarios();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ExecutionScenario it = (ExecutionScenario)element$iv2;
                boolean bl2 = false;
                it.setValidationFunction(this.testStructure.validationFunction);
            }
        }
    }

    public final void check() {
        LincheckFailure lincheckFailure = this.checkImpl$lincheck();
        if (lincheckFailure == null) {
            return;
        }
        LincheckFailure failure = lincheckFailure;
        throw new LincheckAssertionError(failure);
    }

    @Nullable
    public final LincheckFailure checkImpl$lincheck() {
        if (!(!((Collection)this.testConfigurations).isEmpty())) {
            boolean $i$a$-check-LinChecker$checkImpl$22 = false;
            String $i$a$-check-LinChecker$checkImpl$22 = "No Lincheck test configuration to run";
            throw new IllegalStateException($i$a$-check-LinChecker$checkImpl$22.toString());
        }
        for (CTestConfiguration testCfg : this.testConfigurations) {
            LincheckFailure failure;
            LincheckFailure lincheckFailure = failure = this.checkImpl(testCfg);
            if (lincheckFailure == null) continue;
            return lincheckFailure;
        }
        return null;
    }

    private final LincheckFailure checkImpl(CTestConfiguration $this$checkImpl) {
        RandomProvider randomProvider = this.testStructure.randomProvider;
        Intrinsics.checkNotNullExpressionValue((Object)randomProvider, (String)"randomProvider");
        ExecutionGenerator exGen = this.createExecutionGenerator($this$checkImpl, randomProvider);
        int n = $this$checkImpl.getCustomScenarios().size();
        for (int i = 0; i < n; ++i) {
            LincheckFailure failure;
            Verifier verifier = this.createVerifier($this$checkImpl);
            ExecutionScenario scenario = $this$checkImpl.getCustomScenarios().get(i);
            ExecutionScenarioKt.validate(scenario);
            this.reporter.logIteration(i + 1, $this$checkImpl.getCustomScenarios().size(), scenario);
            Intrinsics.checkNotNull((Object)verifier);
            LincheckFailure lincheckFailure = failure = this.run(scenario, $this$checkImpl, verifier);
            if (lincheckFailure == null) continue;
            return lincheckFailure;
        }
        Verifier verifier = null;
        verifier = this.createVerifier($this$checkImpl);
        n = $this$checkImpl.getIterations();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            if ((i2 + 1) % 100 == 0) {
                verifier = this.createVerifier($this$checkImpl);
            }
            ExecutionScenario scenario = exGen.nextExecution();
            Intrinsics.checkNotNull((Object)scenario);
            ExecutionScenarioKt.validate(scenario);
            this.reporter.logIteration(i2 + 1 + $this$checkImpl.getCustomScenarios().size(), $this$checkImpl.getIterations(), scenario);
            Verifier verifier2 = verifier;
            Intrinsics.checkNotNullExpressionValue((Object)verifier2, (String)"element");
            LincheckFailure failure = this.run(scenario, $this$checkImpl, verifier2);
            if (failure != null) {
                LincheckFailure minimizedFailedIteration = !$this$checkImpl.getMinimizeFailedScenario() ? failure : this.minimize(failure, $this$checkImpl);
                this.reporter.logFailedIteration(minimizedFailedIteration);
                return minimizedFailedIteration;
            }
            List<ParameterGenerator<?>> list = this.testStructure.parameterGenerators;
            Intrinsics.checkNotNullExpressionValue(list, (String)"parameterGenerators");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParameterGenerator it = (ParameterGenerator)element$iv;
                boolean bl2 = false;
                it.reset();
            }
        }
        return null;
    }

    private final LincheckFailure minimize(LincheckFailure $this$minimize, CTestConfiguration testCfg) {
        this.reporter.logScenarioMinimization($this$minimize.getScenario());
        LincheckFailure minimizedFailure = $this$minimize;
        while (this.tryMinimize(minimizedFailure.getScenario(), testCfg) != null) {
        }
        return minimizedFailure;
    }

    private final LincheckFailure tryMinimize(ExecutionScenario $this$tryMinimize, CTestConfiguration testCfg) {
        int n = $this$tryMinimize.getThreads().size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                int n2 = $this$tryMinimize.getThreads().get(i).size() + -1;
                if (0 > n2) continue;
                do {
                    int j;
                    ExecutionScenario executionScenario;
                    if ((executionScenario = ExecutionScenarioKt.tryMinimize($this$tryMinimize, i, j = n2--)) == null) continue;
                    Verifier verifier = this.createVerifier(testCfg);
                    Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"createVerifier(...)");
                    LincheckFailure lincheckFailure = this.run(executionScenario, testCfg, verifier);
                    if (lincheckFailure == null) continue;
                    LincheckFailure it = lincheckFailure;
                    boolean bl = false;
                    return it;
                } while (0 <= n2);
            } while (0 <= n);
        }
        return null;
    }

    private final LincheckFailure run(ExecutionScenario $this$run, CTestConfiguration testCfg, Verifier verifier) {
        return testCfg.createStrategy(this.testClass, $this$run, this.testStructure.validationFunction, this.testStructure.stateRepresentation, verifier).run();
    }

    private final Verifier createVerifier(CTestConfiguration $this$createVerifier) {
        Object[] objectArray = new Class[]{Class.class};
        Constructor<? extends Verifier> constructor = $this$createVerifier.getVerifierClass().getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{$this$createVerifier.getSequentialSpecification()};
        return constructor.newInstance(objectArray);
    }

    private final ExecutionGenerator createExecutionGenerator(CTestConfiguration $this$createExecutionGenerator, RandomProvider randomProvider) {
        Object[] objectArray = new Class[]{CTestConfiguration.class, CTestStructure.class, RandomProvider.class};
        Constructor<? extends ExecutionGenerator> constructor = $this$createExecutionGenerator.getGeneratorClass().getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{$this$createExecutionGenerator, this.testStructure, randomProvider};
        return constructor.newInstance(objectArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Companion.check(testClass, options);
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass) {
        Companion.check(testClass);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0012\b\u0002\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker$Companion;", "", "()V", "VERIFIER_REFRESH_CYCLE", "", "check", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "lincheck"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            new LinChecker(testClass, options).check();
        }

        public static /* synthetic */ void check$default(Companion companion, Class clazz, Options options, int n, Object object) {
            if ((n & 2) != 0) {
                options = null;
            }
            companion.check(clazz, options);
        }

        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass) {
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            org.jetbrains.kotlinx.lincheck.LinChecker$Companion.check$default(this, testClass, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

