/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.execution;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ActorKt;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGeneratorsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/lincheck/execution/ActorGenerator;", "", "method", "Ljava/lang/reflect/Method;", "parameterGenerators", "", "Lorg/jetbrains/kotlinx/lincheck/paramgen/ParameterGenerator;", "useOnce", "", "cancellableOnSuspension", "allowExtraSuspension", "blocking", "causesBlocking", "promptCancellation", "(Ljava/lang/reflect/Method;Ljava/util/List;ZZZZZZ)V", "isSuspendable", "()Z", "getUseOnce", "generate", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "threadId", "", "random", "Ljava/util/Random;", "toString", "", "lincheck"})
@SourceDebugExtension(value={"SMAP\nActorGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActorGenerator.kt\norg/jetbrains/kotlinx/lincheck/execution/ActorGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1549#2:55\n1620#2,3:56\n1549#2:59\n1620#2,3:60\n*S KotlinDebug\n*F\n+ 1 ActorGenerator.kt\norg/jetbrains/kotlinx/lincheck/execution/ActorGenerator\n*L\n37#1:55\n37#1:56,3\n38#1:59\n38#1:60,3\n*E\n"})
public final class ActorGenerator {
    @NotNull
    private final Method method;
    @NotNull
    private final List<ParameterGenerator<?>> parameterGenerators;
    private final boolean useOnce;
    private final boolean allowExtraSuspension;
    private final boolean blocking;
    private final boolean causesBlocking;
    private final boolean cancellableOnSuspension;
    private final boolean promptCancellation;

    public ActorGenerator(@NotNull Method method, @NotNull List<? extends ParameterGenerator<?>> parameterGenerators, boolean useOnce, boolean cancellableOnSuspension, boolean allowExtraSuspension, boolean blocking, boolean causesBlocking, boolean promptCancellation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(parameterGenerators, (String)"parameterGenerators");
        this.method = method;
        this.parameterGenerators = parameterGenerators;
        this.useOnce = useOnce;
        this.allowExtraSuspension = allowExtraSuspension;
        this.blocking = blocking;
        this.causesBlocking = causesBlocking;
        this.cancellableOnSuspension = cancellableOnSuspension && this.isSuspendable();
        this.promptCancellation = cancellableOnSuspension && promptCancellation;
    }

    public final boolean getUseOnce() {
        return this.useOnce;
    }

    @NotNull
    public final Actor generate(int threadId, @NotNull Random random) {
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Iterable iterable = this.parameterGenerators;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParameterGenerator parameterGenerator = (ParameterGenerator)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.generate());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            it = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it == ParameterGeneratorsKt.getTHREAD_ID_TOKEN() ? Integer.valueOf(threadId) : it);
        }
        List parameters = (List)destination$iv$iv;
        boolean cancelOnSuspension = this.cancellableOnSuspension & random.nextBoolean();
        boolean promptCancellation = cancelOnSuspension & this.promptCancellation & random.nextBoolean();
        return new Actor(this.method, parameters, cancelOnSuspension, this.allowExtraSuspension, this.blocking, this.causesBlocking, promptCancellation, false, 128, null);
    }

    public final boolean isSuspendable() {
        return ActorKt.isSuspendable(this.method);
    }

    @NotNull
    public String toString() {
        String string = this.method.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

