/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.runner.Done;
import org.jetbrains.kotlinx.lincheck.runner.FixedActiveThreadsExecutorKt;
import org.jetbrains.kotlinx.lincheck.runner.Shutdown;
import org.jetbrains.kotlinx.lincheck.runner.TestThreadExecution;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001/B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J%\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00102\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\rH\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\u001b\u0010%\u001a\u0004\u0018\u00010\r2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0'H\u0082\bJ#\u0010(\u001a\u00020\u00162\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00102\u0006\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\rH\u0002J\u001d\u0010+\u001a\u00020\u001f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0010H\u0002\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor;", "Ljava/io/Closeable;", "nThreads", "", "runnerHash", "(II)V", "hangDetected", "", "numberOfThreadsExceedAvailableProcessors", "getNumberOfThreadsExceedAvailableProcessors", "()Z", "results", "Lkotlinx/atomicfu/AtomicArray;", "", "tasks", "threads", "", "Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "getThreads", "()[Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "[Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "await", "", "Lorg/jetbrains/kotlinx/lincheck/runner/TestThreadExecution;", "timeoutNano", "([Lorg/jetbrains/kotlinx/lincheck/runner/TestThreadExecution;J)J", "awaitTask", "", "iThread", "deadline", "close", "", "getResult", "getTask", "setResult", "any", "shutdown", "spinWait", "getter", "Lkotlin/Function0;", "submitAndAwait", "submitTask", "task", "submitTasks", "([Lorg/jetbrains/kotlinx/lincheck/runner/TestThreadExecution;)V", "testThreadRunnable", "Ljava/lang/Runnable;", "TestThread", "lincheck"})
@SourceDebugExtension(value={"SMAP\nFixedActiveThreadsExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedActiveThreadsExecutor.kt\norg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,224:1\n187#1,11:236\n187#1,11:247\n1#2:225\n12271#3,2:226\n11667#3,8:228\n13309#3,2:258\n*S KotlinDebug\n*F\n+ 1 FixedActiveThreadsExecutor.kt\norg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor\n*L\n125#1:236,11\n163#1:247,11\n68#1:226,2\n71#1:228,8\n206#1:258,2\n*E\n"})
public final class FixedActiveThreadsExecutor
implements Closeable {
    private final int nThreads;
    @NotNull
    private /* synthetic */ AtomicReferenceArray tasks;
    @NotNull
    private /* synthetic */ AtomicReferenceArray results;
    private boolean hangDetected;
    @NotNull
    private final TestThread[] threads;
    private final boolean numberOfThreadsExceedAvailableProcessors;

    /*
     * WARNING - void declaration
     */
    public FixedActiveThreadsExecutor(int nThreads, int runnerHash) {
        this.nThreads = nThreads;
        this.tasks = new AtomicReferenceArray(this.nThreads);
        this.results = new AtomicReferenceArray(this.nThreads);
        int n = 0;
        int n2 = this.nThreads;
        TestThread[] testThreadArray = new TestThread[n2];
        FixedActiveThreadsExecutor fixedActiveThreadsExecutor = this;
        while (n < n2) {
            void it;
            TestThread testThread;
            int n3 = n++;
            TestThread testThread2 = testThread = new TestThread(n3, runnerHash, this.testThreadRunnable(n3));
            int n4 = n3;
            TestThread[] testThreadArray2 = testThreadArray;
            boolean bl = false;
            it.start();
            Unit unit = Unit.INSTANCE;
            testThreadArray2[n4] = testThread;
        }
        fixedActiveThreadsExecutor.threads = testThreadArray;
        this.numberOfThreadsExceedAvailableProcessors = Runtime.getRuntime().availableProcessors() < this.threads.length;
    }

    @NotNull
    public final TestThread[] getThreads() {
        return this.threads;
    }

    public final boolean getNumberOfThreadsExceedAvailableProcessors() {
        return this.numberOfThreadsExceedAvailableProcessors;
    }

    public final long submitAndAwait(@NotNull TestThreadExecution[] tasks, long timeoutNano) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
            TestThreadExecution[] $this$all$iv = tasks;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                TestThreadExecution element$iv;
                TestThreadExecution it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                int n2 = this.nThreads;
                int n3 = it.iThread;
                if (0 <= n3 ? n3 < n2 : false) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (!bl) {
            boolean $i$a$-require-FixedActiveThreadsExecutor$submitAndAwait$32 = false;
            String $i$a$-require-FixedActiveThreadsExecutor$submitAndAwait$32 = "Submitted tasks contain thread index outside of current executor bounds.";
            throw new IllegalArgumentException($i$a$-require-FixedActiveThreadsExecutor$submitAndAwait$32.toString());
        }
        TestThreadExecution[] $this$distinctBy$iv = tasks;
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList<TestThreadExecution> list$iv = new ArrayList<TestThreadExecution>();
        int n = $this$distinctBy$iv.length;
        for (int i = 0; i < n; ++i) {
            TestThreadExecution e$iv;
            TestThreadExecution it = e$iv = $this$distinctBy$iv[i];
            boolean bl3 = false;
            Integer key$iv = it.iThread;
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        if (!(((List)list$iv).size() == tasks.length)) {
            boolean bl4 = false;
            String string = "Submitted tasks have duplicate thread indices.";
            throw new IllegalArgumentException(string.toString());
        }
        this.submitTasks(tasks);
        return this.await(tasks, timeoutNano);
    }

    private final void submitTasks(TestThreadExecution[] tasks) {
        for (TestThreadExecution task : tasks) {
            int i = task.iThread;
            this.submitTask(i, task);
        }
    }

    private final void shutdown() {
        int n = this.nThreads;
        for (int i = 0; i < n; ++i) {
            this.submitTask(i, Shutdown.INSTANCE);
        }
    }

    private final void submitTask(int iThread, Object task) {
        this.results.set(iThread, null);
        Object old = this.tasks.getAndSet(iThread, task);
        if (old instanceof TestThread) {
            LockSupport.unpark((Thread)old);
        }
    }

    private final long await(TestThreadExecution[] tasks, long timeoutNano) {
        long startTime = System.nanoTime();
        long deadline = startTime + timeoutNano;
        Throwable exception = null;
        for (TestThreadExecution task : tasks) {
            Throwable e = this.awaitTask(task.iThread, deadline);
            if (e == null) continue;
            if (exception == null) {
                exception = e;
                continue;
            }
            ExceptionsKt.addSuppressed((Throwable)exception, (Throwable)e);
        }
        Throwable throwable = exception;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new ExecutionException(it);
        }
        return System.nanoTime() - startTime;
    }

    private final Throwable awaitTask(int iThread, long deadline) {
        Object result2 = this.getResult(iThread, deadline);
        return result2 instanceof Throwable ? (Throwable)result2 : null;
    }

    private final Object getResult(int iThread, long deadline) {
        Object var4_14;
        block5: {
            Object v1;
            FixedActiveThreadsExecutor this_$iv = this;
            boolean $i$f$spinWait = false;
            int spinningLoopIterations$iv = this_$iv.numberOfThreadsExceedAvailableProcessors ? 1 : 1000000;
            int n = 0;
            while (n < spinningLoopIterations$iv) {
                int it$iv = n++;
                boolean bl = false;
                boolean bl2 = false;
                Object e = this.results.get(iThread);
                if (e == null) continue;
                Object it$iv2 = e;
                boolean bl3 = false;
                v1 = it$iv2;
                break block5;
            }
            v1 = var4_14 = null;
        }
        if (var4_14 != null) {
            Object it = var4_14;
            boolean bl = false;
            return it;
        }
        Thread currentThread = Thread.currentThread();
        if (this.results.compareAndSet(iThread, null, currentThread)) {
            while (this.results.get(iThread) == currentThread) {
                long timeLeft = deadline - System.nanoTime();
                if (timeLeft <= 0L) {
                    this.hangDetected = true;
                    throw new TimeoutException();
                }
                LockSupport.parkNanos(timeLeft);
            }
        }
        Object e = this.results.get(iThread);
        Intrinsics.checkNotNull(e);
        return e;
    }

    private final Runnable testThreadRunnable(int iThread) {
        return () -> FixedActiveThreadsExecutor.testThreadRunnable$lambda$8(this, iThread);
    }

    private final Object getTask(int iThread) {
        Object var2_12;
        block4: {
            Object v1;
            FixedActiveThreadsExecutor this_$iv = this;
            boolean $i$f$spinWait = false;
            int spinningLoopIterations$iv = this_$iv.numberOfThreadsExceedAvailableProcessors ? 1 : 1000000;
            int n = 0;
            while (n < spinningLoopIterations$iv) {
                int it$iv = n++;
                boolean bl = false;
                boolean bl2 = false;
                Object e = this.tasks.get(iThread);
                if (e == null) continue;
                Object it$iv2 = e;
                boolean bl3 = false;
                v1 = it$iv2;
                break block4;
            }
            v1 = var2_12 = null;
        }
        if (var2_12 != null) {
            Object it = var2_12;
            boolean bl = false;
            return it;
        }
        Thread currentThread = Thread.currentThread();
        if (this.tasks.compareAndSet(iThread, null, currentThread)) {
            while (this.tasks.get(iThread) == currentThread) {
                LockSupport.park();
            }
        }
        Object e = this.tasks.get(iThread);
        Intrinsics.checkNotNull(e);
        return e;
    }

    private final void setResult(int iThread, Object any) {
        if (this.results.compareAndSet(iThread, null, any)) {
            return;
        }
        Object e = this.results.get(iThread);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type java.lang.Thread");
        Thread thread = (Thread)e;
        this.results.set(iThread, any);
        LockSupport.unpark(thread);
    }

    private final Object spinWait(Function0<? extends Object> getter) {
        boolean $i$f$spinWait = false;
        int spinningLoopIterations = this.numberOfThreadsExceedAvailableProcessors ? 1 : 1000000;
        int n = 0;
        while (n < spinningLoopIterations) {
            int it = n++;
            boolean bl = false;
            Object object = getter.invoke();
            if (object == null) continue;
            Object it2 = object;
            boolean bl2 = false;
            return it2;
        }
        return null;
    }

    @Override
    public void close() {
        this.shutdown();
        if (this.hangDetected) {
            Integer n = FixedActiveThreadsExecutorKt.access$getMajorJavaVersion$p();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"access$getMajorJavaVersion$p(...)");
            if (((Number)n).intValue() < 20) {
                TestThread[] $this$forEach$iv = this.threads;
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (int i = 0; i < n2; ++i) {
                    TestThread element$iv;
                    TestThread it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    it.stop();
                }
            }
        }
    }

    private static final void testThreadRunnable$lambda$8(FixedActiveThreadsExecutor this$0, int $iThread) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object task;
        while ((task = this$0.getTask($iThread)) != Shutdown.INSTANCE) {
            this$0.tasks.set($iThread, null);
            Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.lincheck.runner.TestThreadExecution");
            TestThreadExecution threadExecution = (TestThreadExecution)task;
            if (!(threadExecution.iThread == $iThread)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            try {
                threadExecution.run();
            }
            catch (Throwable e) {
                Throwable wrapped = UtilsKt.wrapInvalidAccessFromUnnamedModuleExceptionWithDescription(e);
                this$0.setResult($iThread, wrapped);
                continue;
            }
            this$0.setResult($iThread, Done.INSTANCE);
        }
        return;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R \u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor$TestThread;", "Ljava/lang/Thread;", "iThread", "", "runnerHash", "runnable", "Ljava/lang/Runnable;", "(IILjava/lang/Runnable;)V", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "getCont", "()Lkotlinx/coroutines/CancellableContinuation;", "setCont", "(Lkotlinx/coroutines/CancellableContinuation;)V", "getIThread", "()I", "getRunnerHash", "lincheck"})
    public static final class TestThread
    extends Thread {
        private final int iThread;
        private final int runnerHash;
        @Nullable
        private CancellableContinuation<?> cont;

        public TestThread(int iThread, int runnerHash, @NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            super(runnable, "FixedActiveThreadsExecutor@" + runnerHash + "-" + iThread);
            this.iThread = iThread;
            this.runnerHash = runnerHash;
        }

        public final int getIThread() {
            return this.iThread;
        }

        public final int getRunnerHash() {
            return this.runnerHash;
        }

        @Nullable
        public final CancellableContinuation<?> getCont() {
            return this.cont;
        }

        public final void setCont(@Nullable CancellableContinuation<?> cancellableContinuation) {
            this.cont = cancellableContinuation;
        }
    }
}

