/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ExecutionClassLoader;
import org.jetbrains.kotlinx.lincheck.TransformationClassLoader;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.runner.ExecutionPart;
import org.jetbrains.kotlinx.lincheck.runner.InvocationResult;
import org.jetbrains.kotlinx.lincheck.strategy.Strategy;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B/\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00103\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u000e\u00104\u001a\u00020/2\u0006\u00105\u001a\u00020\u0016J\b\u00106\u001a\u00020/H\u0016J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020:H\u0016J\b\u0010<\u001a\u00020/H\u0016J\u0018\u0010=\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010>\u001a\u000201H\u0016J\u0014\u0010?\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010@\u001a\u000208H\u0002J\b\u0010A\u001a\u00020\u001bH\u0016J\u000e\u0010B\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0018\u0010C\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u0010G\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u0010H\u001a\u00020IH&R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/Runner;", "Ljava/io/Closeable;", "strategy", "Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "_testClass", "Ljava/lang/Class;", "validationFunction", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "stateRepresentationFunction", "Ljava/lang/reflect/Method;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/Actor;Ljava/lang/reflect/Method;)V", "classLoader", "Lorg/jetbrains/kotlinx/lincheck/ExecutionClassLoader;", "getClassLoader$annotations", "()V", "getClassLoader", "()Lorg/jetbrains/kotlinx/lincheck/ExecutionClassLoader;", "completedOrSuspendedThreads", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCompletedOrSuspendedThreads", "()Ljava/util/concurrent/atomic/AtomicInteger;", "<set-?>", "Lorg/jetbrains/kotlinx/lincheck/runner/ExecutionPart;", "currentExecutionPart", "getCurrentExecutionPart", "()Lorg/jetbrains/kotlinx/lincheck/runner/ExecutionPart;", "isParallelExecutionCompleted", "", "()Z", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "getScenario", "()Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "setScenario", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;)V", "getStateRepresentationFunction", "()Ljava/lang/reflect/Method;", "getStrategy", "()Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "testClass", "getTestClass", "()Ljava/lang/Class;", "setTestClass", "(Ljava/lang/Class;)V", "getValidationFunction", "()Lorg/jetbrains/kotlinx/lincheck/Actor;", "afterCoroutineCancelled", "", "iThread", "", "afterCoroutineResumed", "afterCoroutineSuspended", "beforePart", "part", "close", "constructStateRepresentation", "", "createTransformer", "Lorg/objectweb/asm/ClassVisitor;", "cv", "initialize", "isCoroutineResumed", "actorId", "loadClass", "className", "needsTransformation", "onActorStart", "onFailure", "e", "", "onFinish", "onStart", "run", "Lorg/jetbrains/kotlinx/lincheck/runner/InvocationResult;", "lincheck"})
public abstract class Runner
implements Closeable {
    @NotNull
    private final Strategy strategy;
    @NotNull
    private final Class<?> _testClass;
    @Nullable
    private final Actor validationFunction;
    @Nullable
    private final Method stateRepresentationFunction;
    @NotNull
    private ExecutionScenario scenario;
    protected Class<?> testClass;
    @NotNull
    private final ExecutionClassLoader classLoader;
    @NotNull
    private final AtomicInteger completedOrSuspendedThreads;
    @Nullable
    private ExecutionPart currentExecutionPart;

    protected Runner(@NotNull Strategy strategy, @NotNull Class<?> _testClass, @Nullable Actor validationFunction, @Nullable Method stateRepresentationFunction) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter(_testClass, (String)"_testClass");
        this.strategy = strategy;
        this._testClass = _testClass;
        this.validationFunction = validationFunction;
        this.stateRepresentationFunction = stateRepresentationFunction;
        this.scenario = this.strategy.getScenario();
        this.classLoader = this.needsTransformation() || this.strategy.needsTransformation() ? (ExecutionClassLoader)new TransformationClassLoader(this.strategy, this) : new ExecutionClassLoader();
        this.completedOrSuspendedThreads = new AtomicInteger(0);
    }

    @NotNull
    protected final Strategy getStrategy() {
        return this.strategy;
    }

    @Nullable
    protected final Actor getValidationFunction() {
        return this.validationFunction;
    }

    @Nullable
    protected final Method getStateRepresentationFunction() {
        return this.stateRepresentationFunction;
    }

    @NotNull
    protected final ExecutionScenario getScenario() {
        return this.scenario;
    }

    protected final void setScenario(@NotNull ExecutionScenario executionScenario) {
        Intrinsics.checkNotNullParameter((Object)executionScenario, (String)"<set-?>");
        this.scenario = executionScenario;
    }

    @NotNull
    protected final Class<?> getTestClass() {
        Class<?> clazz = this.testClass;
        if (clazz != null) {
            return clazz;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testClass");
        return null;
    }

    protected final void setTestClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
        this.testClass = clazz;
    }

    @NotNull
    public final ExecutionClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static /* synthetic */ void getClassLoader$annotations() {
    }

    @NotNull
    protected final AtomicInteger getCompletedOrSuspendedThreads() {
        return this.completedOrSuspendedThreads;
    }

    @Nullable
    public final ExecutionPart getCurrentExecutionPart() {
        return this.currentExecutionPart;
    }

    public void initialize() {
        this.scenario = UtilsKt.convertForLoader(this.strategy.getScenario(), (ClassLoader)this.classLoader);
        String string = this._testClass.getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
        this.setTestClass(this.loadClass(string));
    }

    @Nullable
    public String constructStateRepresentation() {
        return null;
    }

    private final Class<?> loadClass(String className) {
        Class<?> clazz = this.classLoader.loadClass(className);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
        return clazz;
    }

    @Nullable
    public ClassVisitor createTransformer(@NotNull ClassVisitor cv) {
        Intrinsics.checkNotNullParameter((Object)cv, (String)"cv");
        return null;
    }

    public boolean needsTransformation() {
        return false;
    }

    @NotNull
    public abstract InvocationResult run();

    public void onStart(int iThread) {
    }

    public void onFinish(int iThread) {
    }

    public void onFailure(int iThread, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public void afterCoroutineSuspended(int iThread) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public void afterCoroutineResumed(int iThread) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public void afterCoroutineCancelled(int iThread) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public boolean isCoroutineResumed(int iThread, int actorId) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public final void onActorStart(int iThread) {
        this.strategy.onActorStart(iThread);
    }

    public final void beforePart(@NotNull ExecutionPart part) {
        Intrinsics.checkNotNullParameter((Object)((Object)part), (String)"part");
        this.completedOrSuspendedThreads.set(0);
        this.currentExecutionPart = part;
        this.strategy.beforePart(part);
    }

    @Override
    public void close() {
    }

    public final boolean isParallelExecutionCompleted() {
        return this.completedOrSuspendedThreads.get() == this.scenario.getNThreads();
    }
}

