/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.CancellationResult;
import org.jetbrains.kotlinx.lincheck.runner.ExecutionPart;
import org.jetbrains.kotlinx.lincheck.runner.ParallelThreadsRunner;
import org.jetbrains.kotlinx.lincheck.runner.UseClocks;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CoroutineCancellationTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J)\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategyRunner;", "Lorg/jetbrains/kotlinx/lincheck/runner/ParallelThreadsRunner;", "managedStrategy", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy;", "testClass", "Ljava/lang/Class;", "validationFunction", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "stateRepresentationMethod", "Ljava/lang/reflect/Method;", "timeoutMs", "", "useClocks", "Lorg/jetbrains/kotlinx/lincheck/runner/UseClocks;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy;Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/Actor;Ljava/lang/reflect/Method;JLorg/jetbrains/kotlinx/lincheck/runner/UseClocks;)V", "afterCoroutineCancelled", "", "iThread", "", "afterCoroutineResumed", "afterCoroutineSuspended", "cancelByLincheck", "Lorg/jetbrains/kotlinx/lincheck/CancellationResult;", "T", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "promptCancellation", "", "cancelByLincheck$lincheck", "constructStateRepresentation", "", "onFailure", "e", "", "onFinish", "onStart", "lincheck"})
final class ManagedStrategyRunner
extends ParallelThreadsRunner {
    @NotNull
    private final ManagedStrategy managedStrategy;

    public ManagedStrategyRunner(@NotNull ManagedStrategy managedStrategy, @NotNull Class<?> testClass, @Nullable Actor validationFunction, @Nullable Method stateRepresentationMethod, long timeoutMs, @NotNull UseClocks useClocks) {
        Intrinsics.checkNotNullParameter((Object)managedStrategy, (String)"managedStrategy");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)((Object)useClocks), (String)"useClocks");
        super(managedStrategy, testClass, validationFunction, stateRepresentationMethod, timeoutMs, useClocks);
        this.managedStrategy = managedStrategy;
    }

    @Override
    public void onStart(int iThread) {
        if (this.getCurrentExecutionPart() != ExecutionPart.PARALLEL) {
            return;
        }
        super.onStart(iThread);
        this.managedStrategy.onStart(iThread);
    }

    @Override
    public void onFinish(int iThread) {
        if (this.getCurrentExecutionPart() != ExecutionPart.PARALLEL) {
            return;
        }
        this.managedStrategy.onFinish(iThread);
        super.onFinish(iThread);
    }

    @Override
    public void onFailure(int iThread, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.managedStrategy.onFailure(iThread, e);
        super.onFailure(iThread, e);
    }

    @Override
    public void afterCoroutineSuspended(int iThread) {
        super.afterCoroutineSuspended(iThread);
        this.managedStrategy.afterCoroutineSuspended$lincheck(iThread);
    }

    @Override
    public void afterCoroutineResumed(int iThread) {
        super.afterCoroutineResumed(iThread);
        this.managedStrategy.afterCoroutineResumed$lincheck(iThread);
    }

    @Override
    public void afterCoroutineCancelled(int iThread) {
        super.afterCoroutineCancelled(iThread);
        this.managedStrategy.afterCoroutineCancelled$lincheck(iThread);
    }

    @Override
    @Nullable
    public String constructStateRepresentation() {
        int iThread = this.managedStrategy.currentThreadNumber();
        this.managedStrategy.enterIgnoredSection$lincheck(iThread);
        String stateRepresentation = super.constructStateRepresentation();
        this.managedStrategy.leaveIgnoredSection$lincheck(iThread);
        return stateRepresentation;
    }

    @Override
    @NotNull
    public <T> CancellationResult cancelByLincheck$lincheck(@NotNull CancellableContinuation<? super T> cont, boolean promptCancellation) {
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        CoroutineCancellationTracePoint cancellationTracePoint2 = this.managedStrategy.createAndLogCancellationTracePoint$lincheck();
        try {
            CancellationResult cancellationResult = super.cancelByLincheck$lincheck(cont, promptCancellation);
            CoroutineCancellationTracePoint coroutineCancellationTracePoint = cancellationTracePoint2;
            if (coroutineCancellationTracePoint != null) {
                coroutineCancellationTracePoint.initializeCancellationResult(cancellationResult);
            }
            if (cancellationResult != CancellationResult.CANCELLATION_FAILED) {
                this.managedStrategy.afterCoroutineCancelled$lincheck(this.managedStrategy.currentThreadNumber());
            }
            return cancellationResult;
        }
        catch (Throwable e) {
            block4: {
                CoroutineCancellationTracePoint coroutineCancellationTracePoint = cancellationTracePoint2;
                if (coroutineCancellationTracePoint == null) break block4;
                coroutineCancellationTracePoint.initializeException(e);
            }
            throw e;
        }
    }
}

