/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001H\u0002J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0001J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0001R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker;", "", "nThreads", "", "(I)V", "acquiredMonitors", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker$MonitorAcquiringInfo;", "waitForNotify", "", "waitingMonitor", "", "[Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker$MonitorAcquiringInfo;", "acquireMonitor", "", "iThread", "monitor", "canAcquireMonitor", "isWaiting", "notify", "", "notifyAll", "releaseMonitor", "waitOnMonitor", "MonitorAcquiringInfo", "lincheck"})
@SourceDebugExtension(value={"SMAP\nManagedStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1437:1\n13374#2,3:1438\n*S KotlinDebug\n*F\n+ 1 ManagedStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker\n*L\n1403#1:1438,3\n*E\n"})
final class MonitorTracker {
    @NotNull
    private final IdentityHashMap<Object, MonitorAcquiringInfo> acquiredMonitors = new IdentityHashMap();
    @NotNull
    private final MonitorAcquiringInfo[] waitingMonitor;
    @NotNull
    private final boolean[] waitForNotify;

    public MonitorTracker(int nThreads) {
        int n;
        int n2 = 0;
        Object[] objectArray = new MonitorAcquiringInfo[nThreads];
        MonitorTracker monitorTracker = this;
        while (n2 < nThreads) {
            n = n2++;
            objectArray[n] = null;
        }
        monitorTracker.waitingMonitor = objectArray;
        n2 = 0;
        objectArray = new boolean[nThreads];
        monitorTracker = this;
        while (n2 < nThreads) {
            n = n2++;
            objectArray[n] = (MonitorAcquiringInfo)false;
        }
        monitorTracker.waitForNotify = (boolean[])objectArray;
    }

    public final boolean acquireMonitor(int iThread, @NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        MonitorAcquiringInfo info = this.acquiredMonitors.computeIfAbsent(monitor, arg_0 -> MonitorTracker.acquireMonitor$lambda$0(monitor, iThread, arg_0));
        if (info.getIThread() != iThread) {
            this.waitingMonitor[iThread] = new MonitorAcquiringInfo(monitor, iThread, 0);
            return false;
        }
        int n = info.getTimesAcquired();
        info.setTimesAcquired(n + 1);
        this.waitingMonitor[iThread] = null;
        return true;
    }

    public final void releaseMonitor(@NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        MonitorAcquiringInfo monitorAcquiringInfo = this.acquiredMonitors.get(monitor);
        Intrinsics.checkNotNull((Object)monitorAcquiringInfo);
        MonitorAcquiringInfo info = monitorAcquiringInfo;
        int n = info.getTimesAcquired();
        info.setTimesAcquired(n + -1);
        if (info.getTimesAcquired() == 0) {
            this.acquiredMonitors.remove(monitor);
        }
    }

    public final boolean isWaiting(int iThread) {
        Object object = this.waitingMonitor[iThread];
        if (object == null || (object = ((MonitorAcquiringInfo)object).getMonitor()) == null) {
            return false;
        }
        Object monitor = object;
        return this.waitForNotify[iThread] || !this.canAcquireMonitor(iThread, monitor);
    }

    private final boolean canAcquireMonitor(int iThread, Object monitor) {
        MonitorAcquiringInfo monitorAcquiringInfo = this.acquiredMonitors.get(monitor);
        return monitorAcquiringInfo != null ? ((Object)monitorAcquiringInfo.getIThread()).equals(iThread) : true;
    }

    public final boolean waitOnMonitor(int iThread, @NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        MonitorAcquiringInfo info = this.acquiredMonitors.get(monitor);
        if (info != null) {
            if (info.getIThread() != iThread) {
                return true;
            }
            this.waitForNotify[iThread] = true;
            this.waitingMonitor[iThread] = info;
            this.acquiredMonitors.remove(monitor);
            return true;
        }
        info = this.waitingMonitor[iThread];
        if (!(info != null && info.getMonitor() == monitor && info.getIThread() == iThread)) {
            boolean bl = false;
            String string = "Monitor should have been acquired by this thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.waitForNotify[iThread]) {
            return true;
        }
        ((Map)this.acquiredMonitors).put(monitor, info);
        this.waitingMonitor[iThread] = null;
        return false;
    }

    public final void notify(@NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        this.notifyAll(monitor);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyAll(@NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        MonitorAcquiringInfo[] $this$forEachIndexed$iv = this.waitingMonitor;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (MonitorAcquiringInfo item$iv : $this$forEachIndexed$iv) {
            void info;
            int n = index$iv++;
            MonitorAcquiringInfo monitorAcquiringInfo = item$iv;
            int iThread = n;
            boolean bl = false;
            void v1 = info;
            if (monitor != (v1 != null ? v1.getMonitor() : null)) continue;
            this.waitForNotify[iThread] = false;
        }
    }

    private static final MonitorAcquiringInfo acquireMonitor$lambda$0(Object $monitor, int $iThread, Object it) {
        Intrinsics.checkNotNullParameter((Object)$monitor, (String)"$monitor");
        return new MonitorAcquiringInfo($monitor, $iThread, 0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker$MonitorAcquiringInfo;", "", "monitor", "iThread", "", "timesAcquired", "(Ljava/lang/Object;II)V", "getIThread", "()I", "getMonitor", "()Ljava/lang/Object;", "getTimesAcquired", "setTimesAcquired", "(I)V", "lincheck"})
    private static final class MonitorAcquiringInfo {
        @NotNull
        private final Object monitor;
        private final int iThread;
        private int timesAcquired;

        public MonitorAcquiringInfo(@NotNull Object monitor, int iThread, int timesAcquired) {
            Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
            this.monitor = monitor;
            this.iThread = iThread;
            this.timesAcquired = timesAcquired;
        }

        @NotNull
        public final Object getMonitor() {
            return this.monitor;
        }

        public final int getIThread() {
            return this.iThread;
        }

        public final int getTimesAcquired() {
            return this.timesAcquired;
        }

        public final void setTimesAcquired(int n) {
            this.timesAcquired = n;
        }
    }
}

