/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.runner.ExecutionPart;
import org.jetbrains.kotlinx.lincheck.runner.InvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.SpinCycleFoundAndReplayRequired;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategy;
import org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking.ModelCheckingCTestConfiguration;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0006&'()*+B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0014J\b\u0010\u001f\u001a\u00020\u001aH\u0014J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0014H\u0014R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy;", "testCfg", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingCTestConfiguration;", "testClass", "Ljava/lang/Class;", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "validationFunction", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "stateRepresentation", "Ljava/lang/reflect/Method;", "verifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingCTestConfiguration;Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Lorg/jetbrains/kotlinx/lincheck/Actor;Ljava/lang/reflect/Method;Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;)V", "currentInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "generationRandom", "Lkotlin/random/Random;", "maxInvocations", "", "maxNumberOfSwitches", "root", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "usedInvocations", "beforePart", "", "part", "Lorg/jetbrains/kotlinx/lincheck/runner/ExecutionPart;", "chooseThread", "iThread", "initializeInvocation", "onNewSwitch", "mustSwitch", "", "runImpl", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "shouldSwitch", "Choice", "Interleaving", "InterleavingBuilder", "InterleavingTreeNode", "SwitchChoosingNode", "ThreadChoosingNode", "lincheck"})
@SourceDebugExtension(value={"SMAP\nModelCheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public final class ModelCheckingStrategy
extends ManagedStrategy {
    private final int maxInvocations;
    private int usedInvocations;
    private int maxNumberOfSwitches;
    @NotNull
    private InterleavingTreeNode root;
    @NotNull
    private final Random generationRandom;
    private Interleaving currentInterleaving;

    public ModelCheckingStrategy(@NotNull ModelCheckingCTestConfiguration testCfg, @NotNull Class<?> testClass, @NotNull ExecutionScenario scenario, @Nullable Actor validationFunction, @Nullable Method stateRepresentation, @NotNull Verifier verifier) {
        Intrinsics.checkNotNullParameter((Object)testCfg, (String)"testCfg");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        super(testClass, scenario, verifier, validationFunction, stateRepresentation, testCfg);
        this.maxInvocations = testCfg.getInvocationsPerIteration();
        this.root = new ThreadChoosingNode(CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)this.getNThreads()))));
        this.generationRandom = RandomKt.Random((int)0);
    }

    @Override
    @Nullable
    protected LincheckFailure runImpl() {
        Interleaving interleaving = this.root.nextInterleaving();
        if (interleaving == null) {
            return null;
        }
        this.currentInterleaving = interleaving;
        while (this.usedInvocations < this.maxInvocations) {
            InvocationResult invocationResult = this.runInvocation();
            if (this.getSuddenInvocationResult() instanceof SpinCycleFoundAndReplayRequired) {
                Interleaving interleaving2 = this.currentInterleaving;
                if (interleaving2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
                    interleaving2 = null;
                }
                interleaving2.rollbackAfterSpinCycleFound();
                continue;
            }
            int n = this.usedInvocations;
            this.usedInvocations = n + 1;
            LincheckFailure lincheckFailure = this.checkResult(invocationResult);
            if (lincheckFailure != null) {
                LincheckFailure it = lincheckFailure;
                boolean bl = false;
                return it;
            }
            if (this.root.nextInterleaving() == null) break;
            this.currentInterleaving = this.currentInterleaving;
        }
        return null;
    }

    @Override
    protected void onNewSwitch(int iThread, boolean mustSwitch) {
        if (mustSwitch) {
            Interleaving interleaving = this.currentInterleaving;
            if (interleaving == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
                interleaving = null;
            }
            interleaving.newExecutionPosition(iThread);
        }
    }

    @Override
    protected boolean shouldSwitch(int iThread) {
        if (!(iThread == this.getCurrentThread())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        interleaving.newExecutionPosition(iThread);
        Interleaving interleaving2 = this.currentInterleaving;
        if (interleaving2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving2 = null;
        }
        return interleaving2.isSwitchPosition();
    }

    @Override
    protected void initializeInvocation() {
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        interleaving.initialize();
        super.initializeInvocation();
    }

    @Override
    public void beforePart(@NotNull ExecutionPart part) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)part), (String)"part");
        super.beforePart(part);
        switch (WhenMappings.$EnumSwitchMapping$0[part.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                Interleaving interleaving = this.currentInterleaving;
                if (interleaving == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
                    interleaving = null;
                }
                n = interleaving.chooseThread(0);
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int nextThread = n;
        this.getLoopDetector().beforePart(nextThread);
        this.setCurrentThread(nextThread);
    }

    @Override
    protected int chooseThread(int iThread) {
        int n;
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        int it = n = interleaving.chooseThread(iThread);
        boolean bl = false;
        if (!this.switchableThreads(iThread).contains(it)) {
            boolean bl2 = false;
            String string = StringsKt.trimIndent((String)("\n               Trying to switch the execution to thread " + it + ",\n               but only the following threads are eligible to switch: " + this.switchableThreads(iThread) + "\n           "));
            throw new IllegalStateException(string.toString());
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Choice;", "", "node", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "value", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;I)V", "getNode", "()Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "getValue", "()I", "lincheck"})
    private final class Choice {
        @NotNull
        private final InterleavingTreeNode node;
        private final int value;

        public Choice(InterleavingTreeNode node2, int value) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this.node = node2;
            this.value = value;
        }

        @NotNull
        public final InterleavingTreeNode getNode() {
            return this.node;
        }

        public final int getValue() {
            return this.value;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0015R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\b\u0012\u00060\u000fR\u00020\b\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "", "switchPositions", "", "", "threadSwitchChoices", "lastNotInitializedNode", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;)V", "executionPosition", "interleavingFinishingRandom", "Lkotlin/random/Random;", "lastNotInitializedNodeChoices", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Choice;", "nextThreadToSwitch", "", "chooseThread", "iThread", "initialize", "", "isSwitchPosition", "", "newExecutionPosition", "rollbackAfterSpinCycleFound", "lincheck"})
    private final class Interleaving {
        @NotNull
        private final List<Integer> switchPositions;
        @NotNull
        private final List<Integer> threadSwitchChoices;
        @Nullable
        private SwitchChoosingNode lastNotInitializedNode;
        private Random interleavingFinishingRandom;
        private Iterator<Integer> nextThreadToSwitch;
        @Nullable
        private List<Choice> lastNotInitializedNodeChoices;
        private int executionPosition;

        public Interleaving(@NotNull List<Integer> switchPositions, @Nullable List<Integer> threadSwitchChoices, SwitchChoosingNode lastNotInitializedNode) {
            Intrinsics.checkNotNullParameter(switchPositions, (String)"switchPositions");
            Intrinsics.checkNotNullParameter(threadSwitchChoices, (String)"threadSwitchChoices");
            this.switchPositions = switchPositions;
            this.threadSwitchChoices = threadSwitchChoices;
            this.lastNotInitializedNode = lastNotInitializedNode;
        }

        /*
         * WARNING - void declaration
         */
        public final void initialize() {
            block0: {
                void choices;
                List list;
                this.executionPosition = -1;
                this.interleavingFinishingRandom = RandomKt.Random((int)2);
                this.nextThreadToSwitch = this.threadSwitchChoices.iterator();
                ModelCheckingStrategy.this.getLoopDetector().initialize();
                this.lastNotInitializedNodeChoices = null;
                SwitchChoosingNode switchChoosingNode = this.lastNotInitializedNode;
                if (switchChoosingNode == null) break block0;
                SwitchChoosingNode it = switchChoosingNode;
                boolean bl = false;
                List list2 = list = (List)new ArrayList();
                Interleaving interleaving = this;
                boolean bl2 = false;
                it.setChoices((List<Choice>)choices);
                interleaving.lastNotInitializedNodeChoices = list;
                this.lastNotInitializedNode = null;
            }
        }

        public final void rollbackAfterSpinCycleFound() {
            block0: {
                List<Choice> list = this.lastNotInitializedNodeChoices;
                if (list == null) break block0;
                list.clear();
            }
        }

        public final int chooseThread(int iThread) {
            int n;
            Iterator<Integer> iterator = this.nextThreadToSwitch;
            if (iterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadToSwitch");
                iterator = null;
            }
            if (iterator.hasNext()) {
                Iterator<Integer> iterator2 = this.nextThreadToSwitch;
                if (iterator2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadToSwitch");
                    iterator2 = null;
                }
                n = ((Number)iterator2.next()).intValue();
            } else {
                this.lastNotInitializedNodeChoices = null;
                Collection collection = ModelCheckingStrategy.this.switchableThreads(iThread);
                Random random = this.interleavingFinishingRandom;
                if (random == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"interleavingFinishingRandom");
                    random = null;
                }
                n = ((Number)CollectionsKt.random((Collection)collection, (Random)random)).intValue();
            }
            return n;
        }

        public final boolean isSwitchPosition() {
            return this.switchPositions.contains(this.executionPosition);
        }

        public final void newExecutionPosition(int iThread) {
            block1: {
                int n = this.executionPosition;
                this.executionPosition = n + 1;
                Integer n2 = (Integer)CollectionsKt.lastOrNull(this.switchPositions);
                if (this.executionPosition <= (n2 != null ? n2 : -1)) break block1;
                List<Choice> list = this.lastNotInitializedNodeChoices;
                if (list != null) {
                    list.add(new Choice(new ThreadChoosingNode(ModelCheckingStrategy.this.switchableThreads(iThread)), this.executionPosition));
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007J\n\u0010\u0013\u001a\u00060\u0014R\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;)V", "lastNoninitializedNode", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "numberOfSwitches", "", "getNumberOfSwitches", "()I", "switchPositions", "", "threadSwitchChoices", "addLastNoninitializedNode", "", "addSwitchPosition", "switchPosition", "addThreadSwitchChoice", "iThread", "build", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "lincheck"})
    private final class InterleavingBuilder {
        @NotNull
        private final List<Integer> switchPositions = new ArrayList();
        @NotNull
        private final List<Integer> threadSwitchChoices = new ArrayList();
        @Nullable
        private SwitchChoosingNode lastNoninitializedNode;

        public final int getNumberOfSwitches() {
            return this.switchPositions.size();
        }

        public final void addSwitchPosition(int switchPosition) {
            this.switchPositions.add(switchPosition);
        }

        public final void addThreadSwitchChoice(int iThread) {
            this.threadSwitchChoices.add(iThread);
        }

        public final void addLastNoninitializedNode(@NotNull SwitchChoosingNode lastNoninitializedNode) {
            Intrinsics.checkNotNullParameter((Object)lastNoninitializedNode, (String)"lastNoninitializedNode");
            this.lastNoninitializedNode = lastNoninitializedNode;
        }

        @NotNull
        public final Interleaving build() {
            return new Interleaving(this.switchPositions, this.threadSwitchChoices, this.lastNoninitializedNode);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0014\u001a\u00060\u0005R\u00020\u0006H\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0018\u00010\u0018R\u00020\u0006J\u0018\u0010\u0017\u001a\u00060\u0018R\u00020\u00062\n\u0010\u0019\u001a\u00060\u001aR\u00020\u0006H&J\b\u0010\u001b\u001a\u00020\u0016H\u0004J\b\u0010\u001c\u001a\u00020\u0016H\u0004R$\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00060\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;)V", "choices", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Choice;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "getChoices", "()Ljava/util/List;", "setChoices", "(Ljava/util/List;)V", "fractionUnexplored", "", "<set-?>", "", "isFullyExplored", "()Z", "setFullyExplored", "(Z)V", "isInitialized", "chooseUnexploredNode", "finishExploration", "", "nextInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "interleavingBuilder", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "resetExploration", "updateExplorationStatistics", "lincheck"})
    @SourceDebugExtension(value={"SMAP\nModelCheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1855#2,2:314\n1789#2,3:317\n1726#2,3:320\n2989#2,5:323\n1855#2,2:328\n451#2,6:330\n1#3:316\n*S KotlinDebug\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode\n*L\n152#1:314,2\n168#1:317,3\n172#1:320,3\n178#1:323,5\n181#1:328,2\n187#1:330,6\n*E\n"})
    private abstract class InterleavingTreeNode {
        private double fractionUnexplored = 1.0;
        public List<Choice> choices;
        private boolean isFullyExplored;

        @NotNull
        public final List<Choice> getChoices() {
            List<Choice> list = this.choices;
            if (list != null) {
                return list;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"choices");
            return null;
        }

        public final void setChoices(@NotNull List<Choice> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.choices = list;
        }

        public final boolean isFullyExplored() {
            return this.isFullyExplored;
        }

        protected final void setFullyExplored(boolean bl) {
            this.isFullyExplored = bl;
        }

        public final boolean isInitialized() {
            return this.choices != null;
        }

        @Nullable
        public final Interleaving nextInterleaving() {
            if (this.isFullyExplored) {
                ModelCheckingStrategy modelCheckingStrategy = ModelCheckingStrategy.this;
                int n = modelCheckingStrategy.maxNumberOfSwitches;
                modelCheckingStrategy.maxNumberOfSwitches = n + 1;
                this.resetExploration();
            }
            if (this.isFullyExplored) {
                return null;
            }
            return this.nextInterleaving(new InterleavingBuilder());
        }

        @NotNull
        public abstract Interleaving nextInterleaving(@NotNull InterleavingBuilder var1);

        protected final void resetExploration() {
            if (!this.isInitialized()) {
                this.isFullyExplored = false;
                this.fractionUnexplored = 1.0;
                return;
            }
            Iterable $this$forEach$iv = this.getChoices();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Choice it = (Choice)element$iv;
                boolean bl = false;
                it.getNode().resetExploration();
            }
            this.updateExplorationStatistics();
        }

        public final void finishExploration() {
            this.isFullyExplored = true;
            this.fractionUnexplored = 0.0;
        }

        /*
         * WARNING - void declaration
         */
        protected final void updateExplorationStatistics() {
            boolean bl;
            boolean bl2;
            block6: {
                void $this$all$iv;
                Iterable $this$fold$iv;
                if (!this.isInitialized()) {
                    boolean bl3 = false;
                    String string = "An interleaving tree node was not initialized properly. Probably caused by non-deterministic behaviour (WeakHashMap, Object.hashCode, etc)";
                    throw new IllegalStateException(string.toString());
                }
                if (this.getChoices().isEmpty()) {
                    this.finishExploration();
                    return;
                }
                Iterable iterable = this.getChoices();
                double initial$iv = 0.0;
                boolean $i$f$fold = false;
                double accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void choice;
                    Choice choice2 = (Choice)element$iv;
                    double acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = acc + choice.getNode().fractionUnexplored;
                }
                double total = accumulator$iv;
                this.fractionUnexplored = total / (double)this.getChoices().size();
                $this$fold$iv = this.getChoices();
                InterleavingTreeNode interleavingTreeNode = this;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Choice it = (Choice)element$iv;
                        boolean bl5 = false;
                        if (it.getNode().isFullyExplored) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            interleavingTreeNode.isFullyExplored = bl = bl2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final Choice chooseUnexploredNode() {
            Object element$iv3;
            block4: {
                if (this.getChoices().size() == 1) {
                    return (Choice)CollectionsKt.first(this.getChoices());
                }
                Iterable $this$sumByDouble$iv = this.getChoices();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (Object element$iv2 : $this$sumByDouble$iv) {
                    void it;
                    Choice choice = (Choice)element$iv2;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = it.getNode().fractionUnexplored;
                    sum$iv = d + d2;
                }
                double total = sum$iv;
                double random = ModelCheckingStrategy.this.generationRandom.nextDouble() * total;
                double sumWeight = 0.0;
                Iterable $this$forEach$iv = this.getChoices();
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    Choice choice = (Choice)element$iv3;
                    boolean bl = false;
                    if (!((sumWeight += choice.getNode().fractionUnexplored) >= random)) continue;
                    return choice;
                }
                List<Choice> $this$last$iv = this.getChoices();
                boolean $i$f$last = false;
                ListIterator<Choice> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv3 = iterator$iv.previous();
                    Choice it = (Choice)element$iv3;
                    boolean bl = false;
                    if (!(!it.getNode().isFullyExplored)) continue;
                    break block4;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            return (Choice)element$iv3;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u00022\n\u0010\u0006\u001a\u00060\u0007R\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;)V", "nextInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "interleavingBuilder", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "lincheck"})
    private final class SwitchChoosingNode
    extends InterleavingTreeNode {
        @Override
        @NotNull
        public Interleaving nextInterleaving(@NotNull InterleavingBuilder interleavingBuilder) {
            boolean isLeaf;
            Intrinsics.checkNotNullParameter((Object)interleavingBuilder, (String)"interleavingBuilder");
            boolean bl = isLeaf = ModelCheckingStrategy.this.maxNumberOfSwitches == interleavingBuilder.getNumberOfSwitches();
            if (isLeaf) {
                this.finishExploration();
                if (!this.isInitialized()) {
                    interleavingBuilder.addLastNoninitializedNode(this);
                }
                return interleavingBuilder.build();
            }
            Choice choice = this.chooseUnexploredNode();
            interleavingBuilder.addSwitchPosition(choice.getValue());
            Interleaving interleaving = choice.getNode().nextInterleaving(interleavingBuilder);
            this.updateExplorationStatistics();
            return interleaving;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00060\bR\u00020\u00022\n\u0010\t\u001a\u00060\nR\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ThreadChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "switchableThreads", "", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;Ljava/util/List;)V", "nextInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "interleavingBuilder", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "lincheck"})
    @SourceDebugExtension(value={"SMAP\nModelCheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ThreadChoosingNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1549#2:314\n1620#2,3:315\n*S KotlinDebug\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ThreadChoosingNode\n*L\n196#1:314\n196#1:315,3\n*E\n"})
    private final class ThreadChoosingNode
    extends InterleavingTreeNode {
        /*
         * WARNING - void declaration
         */
        public ThreadChoosingNode(List<Integer> switchableThreads) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(switchableThreads, (String)"switchableThreads");
            Iterable iterable = switchableThreads;
            ModelCheckingStrategy modelCheckingStrategy = ModelCheckingStrategy.this;
            ThreadChoosingNode threadChoosingNode = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(modelCheckingStrategy.new Choice(modelCheckingStrategy.new SwitchChoosingNode(), (int)it));
            }
            threadChoosingNode.setChoices((List)destination$iv$iv);
        }

        @Override
        @NotNull
        public Interleaving nextInterleaving(@NotNull InterleavingBuilder interleavingBuilder) {
            Intrinsics.checkNotNullParameter((Object)interleavingBuilder, (String)"interleavingBuilder");
            Choice child = this.chooseUnexploredNode();
            interleavingBuilder.addThreadSwitchChoice(child.getValue());
            Interleaving interleaving = child.getNode().nextInterleaving(interleavingBuilder);
            this.updateExplorationStatistics();
            return interleaving;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutionPart.values().length];
            try {
                nArray[ExecutionPart.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionPart.PARALLEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionPart.POST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionPart.VALIDATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

