/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ActorKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B[\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003Ja\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlinx/lincheck/Actor;", "", "method", "Ljava/lang/reflect/Method;", "arguments", "", "cancelOnSuspension", "", "allowExtraSuspension", "blocking", "causesBlocking", "promptCancellation", "isSuspendable", "(Ljava/lang/reflect/Method;Ljava/util/List;ZZZZZZ)V", "getAllowExtraSuspension", "()Z", "getArguments", "()Ljava/util/List;", "getBlocking", "getCancelOnSuspension", "getCausesBlocking", "getMethod", "()Ljava/lang/reflect/Method;", "getPromptCancellation", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "", "lincheck"})
public final class Actor {
    @NotNull
    private final Method method;
    @NotNull
    private final List<Object> arguments;
    private final boolean cancelOnSuspension;
    private final boolean allowExtraSuspension;
    private final boolean blocking;
    private final boolean causesBlocking;
    private final boolean promptCancellation;
    private final boolean isSuspendable;

    @JvmOverloads
    public Actor(@NotNull Method method, @NotNull List<? extends Object> arguments, boolean cancelOnSuspension, boolean allowExtraSuspension, boolean blocking, boolean causesBlocking, boolean promptCancellation, boolean isSuspendable) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.method = method;
        this.arguments = arguments;
        this.cancelOnSuspension = cancelOnSuspension;
        this.allowExtraSuspension = allowExtraSuspension;
        this.blocking = blocking;
        this.causesBlocking = causesBlocking;
        this.promptCancellation = promptCancellation;
        this.isSuspendable = isSuspendable;
        if (this.promptCancellation && !this.cancelOnSuspension) {
            boolean bl = false;
            String string = "`promptCancellation` cannot be set to `true` if `cancelOnSuspension` is `false`";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Actor(Method method, List list, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        if ((n & 0x40) != 0) {
            bl5 = false;
        }
        if ((n & 0x80) != 0) {
            bl6 = ActorKt.isSuspendable(method);
        }
        this(method, list, bl, bl2, bl3, bl4, bl5, bl6);
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final List<Object> getArguments() {
        return this.arguments;
    }

    public final boolean getCancelOnSuspension() {
        return this.cancelOnSuspension;
    }

    public final boolean getAllowExtraSuspension() {
        return this.allowExtraSuspension;
    }

    public final boolean getBlocking() {
        return this.blocking;
    }

    public final boolean getCausesBlocking() {
        return this.causesBlocking;
    }

    public final boolean getPromptCancellation() {
        return this.promptCancellation;
    }

    public final boolean isSuspendable() {
        return this.isSuspendable;
    }

    @NotNull
    public String toString() {
        return this.method.getName() + CollectionsKt.joinToString$default((Iterable)this.arguments, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null) + (this.cancelOnSuspension ? " + " : "") + (this.promptCancellation ? "prompt_" : "") + (this.cancelOnSuspension ? "cancel" : "");
    }

    @NotNull
    public final Method component1() {
        return this.method;
    }

    @NotNull
    public final List<Object> component2() {
        return this.arguments;
    }

    public final boolean component3() {
        return this.cancelOnSuspension;
    }

    public final boolean component4() {
        return this.allowExtraSuspension;
    }

    public final boolean component5() {
        return this.blocking;
    }

    public final boolean component6() {
        return this.causesBlocking;
    }

    public final boolean component7() {
        return this.promptCancellation;
    }

    public final boolean component8() {
        return this.isSuspendable;
    }

    @NotNull
    public final Actor copy(@NotNull Method method, @NotNull List<? extends Object> arguments, boolean cancelOnSuspension, boolean allowExtraSuspension, boolean blocking, boolean causesBlocking, boolean promptCancellation, boolean isSuspendable) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return new Actor(method, arguments, cancelOnSuspension, allowExtraSuspension, blocking, causesBlocking, promptCancellation, isSuspendable);
    }

    public static /* synthetic */ Actor copy$default(Actor actor, Method method, List list, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, Object object) {
        if ((n & 1) != 0) {
            method = actor.method;
        }
        if ((n & 2) != 0) {
            list = actor.arguments;
        }
        if ((n & 4) != 0) {
            bl = actor.cancelOnSuspension;
        }
        if ((n & 8) != 0) {
            bl2 = actor.allowExtraSuspension;
        }
        if ((n & 0x10) != 0) {
            bl3 = actor.blocking;
        }
        if ((n & 0x20) != 0) {
            bl4 = actor.causesBlocking;
        }
        if ((n & 0x40) != 0) {
            bl5 = actor.promptCancellation;
        }
        if ((n & 0x80) != 0) {
            bl6 = actor.isSuspendable;
        }
        return actor.copy(method, list, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public int hashCode() {
        int result2 = this.method.hashCode();
        result2 = result2 * 31 + ((Object)this.arguments).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.cancelOnSuspension);
        result2 = result2 * 31 + Boolean.hashCode(this.allowExtraSuspension);
        result2 = result2 * 31 + Boolean.hashCode(this.blocking);
        result2 = result2 * 31 + Boolean.hashCode(this.causesBlocking);
        result2 = result2 * 31 + Boolean.hashCode(this.promptCancellation);
        result2 = result2 * 31 + Boolean.hashCode(this.isSuspendable);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Actor)) {
            return false;
        }
        Actor actor = (Actor)other;
        if (!Intrinsics.areEqual((Object)this.method, (Object)actor.method)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.arguments, actor.arguments)) {
            return false;
        }
        if (this.cancelOnSuspension != actor.cancelOnSuspension) {
            return false;
        }
        if (this.allowExtraSuspension != actor.allowExtraSuspension) {
            return false;
        }
        if (this.blocking != actor.blocking) {
            return false;
        }
        if (this.causesBlocking != actor.causesBlocking) {
            return false;
        }
        if (this.promptCancellation != actor.promptCancellation) {
            return false;
        }
        return this.isSuspendable == actor.isSuspendable;
    }

    @JvmOverloads
    public Actor(@NotNull Method method, @NotNull List<? extends Object> arguments, boolean cancelOnSuspension, boolean allowExtraSuspension, boolean blocking, boolean causesBlocking, boolean promptCancellation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this(method, arguments, cancelOnSuspension, allowExtraSuspension, blocking, causesBlocking, promptCancellation, false, 128, null);
    }

    @JvmOverloads
    public Actor(@NotNull Method method, @NotNull List<? extends Object> arguments, boolean cancelOnSuspension, boolean allowExtraSuspension, boolean blocking, boolean causesBlocking) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this(method, arguments, cancelOnSuspension, allowExtraSuspension, blocking, causesBlocking, false, false, 192, null);
    }

    @JvmOverloads
    public Actor(@NotNull Method method, @NotNull List<? extends Object> arguments, boolean cancelOnSuspension, boolean allowExtraSuspension, boolean blocking) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this(method, arguments, cancelOnSuspension, allowExtraSuspension, blocking, false, false, false, 224, null);
    }

    @JvmOverloads
    public Actor(@NotNull Method method, @NotNull List<? extends Object> arguments, boolean cancelOnSuspension, boolean allowExtraSuspension) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this(method, arguments, cancelOnSuspension, allowExtraSuspension, false, false, false, false, 240, null);
    }

    @JvmOverloads
    public Actor(@NotNull Method method, @NotNull List<? extends Object> arguments, boolean cancelOnSuspension) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this(method, arguments, cancelOnSuspension, false, false, false, false, false, 248, null);
    }

    @JvmOverloads
    public Actor(@NotNull Method method, @NotNull List<? extends Object> arguments) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this(method, arguments, false, false, false, false, false, false, 252, null);
    }
}

