/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/AtomicFieldUpdaterNames;", "", "()V", "unsafe", "Lsun/misc/Unsafe;", "getName", "", "updater", "lincheck"})
public final class AtomicFieldUpdaterNames {
    @NotNull
    public static final AtomicFieldUpdaterNames INSTANCE;
    @NotNull
    private static final Unsafe unsafe;

    private AtomicFieldUpdaterNames() {
    }

    @Nullable
    public final String getName(@NotNull Object updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(updater instanceof AtomicIntegerFieldUpdater || updater instanceof AtomicLongFieldUpdater || updater instanceof AtomicReferenceFieldUpdater)) {
            throw new IllegalArgumentException("Provided object is not a recognized Atomic*FieldUpdater type.");
        }
        try {
            Field tclassField = updater.getClass().getDeclaredField("tclass");
            Object object = unsafe.getObject(updater, unsafe.objectFieldOffset(tclassField));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            Class targetType = (Class)object;
            Field offsetField = updater.getClass().getDeclaredField("offset");
            long offset = unsafe.getLong(updater, unsafe.objectFieldOffset(offsetField));
            Field[] fieldArray = targetType.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            for (Field field : fieldArray) {
                try {
                    long fieldOffset;
                    if (Modifier.isNative(field.getModifiers())) continue;
                    long l = fieldOffset = Modifier.isStatic(field.getModifiers()) ? unsafe.staticFieldOffset(field) : unsafe.objectFieldOffset(field);
                    if (fieldOffset != offset) continue;
                    return field.getName();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    static {
        Unsafe unsafe;
        INSTANCE = new AtomicFieldUpdaterNames();
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object object = unsafeField.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type sun.misc.Unsafe");
            unsafe = (Unsafe)object;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get the Unsafe instance, please report it to the Lincheck team", ex);
        }
        AtomicFieldUpdaterNames.unsafe = unsafe;
    }
}

