/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CoroutineContextKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DebugKt;
import org.jetbrains.kotlinx.lincheck.ClassVersionGetter;
import org.jetbrains.kotlinx.lincheck.TransformationClassWriter;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.runner.TestThreadExecution;
import org.jetbrains.kotlinx.lincheck.strategy.managed.JavaUtilRemapper;
import org.jetbrains.kotlinx.lincheck.transformation.LincheckClassVisitor;
import org.jetbrains.kotlinx.lincheck.transformation.TransformationMode;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;

public class LincheckClassLoader
extends ClassLoader {
    public static final String REMAPPED_PACKAGE_INTERNAL_NAME = "org/jetbrains/kotlinx/lincheck/tran$f*rmed/";
    public static final String REMAPPED_PACKAGE_CANONICAL_NAME = UtilsKt.getCanonicalClassName("org/jetbrains/kotlinx/lincheck/tran$f*rmed/");
    public static final int ASM_API = 589824;
    private final TransformationMode transformationMode;
    private final Remapper remapper;
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private static final Map<String, byte[]> stressAndVerificationBytecodeCache = new ConcurrentHashMap<String, byte[]>();
    private static final Map<String, byte[]> modelCheckingBytecodeCache = new ConcurrentHashMap<String, byte[]>();

    public LincheckClassLoader(TransformationMode transformationMode) {
        this.transformationMode = transformationMode;
        this.remapper = transformationMode == TransformationMode.MODEL_CHECKING ? new JavaUtilRemapper() : null;
    }

    public Map<String, byte[]> getBytecodeCache() {
        if (this.transformationMode == TransformationMode.MODEL_CHECKING) {
            return modelCheckingBytecodeCache;
        }
        return stressAndVerificationBytecodeCache;
    }

    public Class<? extends TestThreadExecution> defineClass(String className, byte[] bytecode) {
        return super.defineClass(className, bytecode, 0, bytecode.length);
    }

    private static boolean doNotTransform(String className) {
        if (className.startsWith(REMAPPED_PACKAGE_CANONICAL_NAME)) {
            return false;
        }
        return className.startsWith("sun.") || className.startsWith("java.") || className.startsWith("jdk.internal.") || className.startsWith("kotlin.") && !className.startsWith("kotlin.collections.") && (!className.startsWith("kotlin.jvm.internal.Array") || !className.contains("Iterator")) && !className.startsWith("kotlin.ranges.") && !className.equals("kotlin.random.Random$Default") || className.startsWith("com.intellij.rt.coverage.") || className.startsWith("org.jetbrains.kotlinx.lincheck.") || className.equals(DebugKt.class.getName()) || className.equals(CoroutineContext.class.getName()) || className.equals(CoroutineContextKt.class.getName()) || className.equals(CoroutineScope.class.getName()) || className.equals(CancellableContinuation.class.getName()) || className.equals(CoroutineExceptionHandler.class.getName()) || className.equals(CoroutineDispatcher.class.getName()) || className.equals("kotlinx.coroutines.NotCompleted") || className.equals("kotlinx.coroutines.CancelHandler") || className.equals("kotlinx.coroutines.CancelHandlerBase");
    }

    boolean shouldBeTransformed(Class<?> clazz) {
        return !LincheckClassLoader.doNotTransform(this.remapClassName(clazz.getName()));
    }

    public String remapClassName(String className) {
        if (this.remapper != null) {
            String internalName = className.replace('.', '/');
            String remappedInternalName = this.remapper.mapType(internalName);
            return remappedInternalName.replace('/', '.');
        }
        return className;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> result2 = this.cache.get(name);
            if (result2 != null) {
                return result2;
            }
            if (LincheckClassLoader.doNotTransform(name)) {
                result2 = super.loadClass(name);
                this.cache.put(name, result2);
                return result2;
            }
            try {
                byte[] bytes = this.getBytecodeCache().get(name);
                if (bytes == null) {
                    bytes = this.instrument(this.originalName(name));
                    this.getBytecodeCache().put(name, bytes);
                }
                result2 = this.defineClass(name, bytes, 0, bytes.length);
                this.cache.put(name, result2);
                return result2;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot transform class " + name, e);
            }
        }
    }

    private byte[] instrument(String className) throws IOException {
        ClassReader cr = new ClassReader(className);
        ClassVersionGetter infoGetter = new ClassVersionGetter();
        cr.accept((ClassVisitor)infoGetter, 0);
        TransformationClassWriter cw = new TransformationClassWriter(infoGetter.getClassVersion(), this.remapper);
        LincheckClassVisitor cv = new LincheckClassVisitor(this.transformationMode, (ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 8);
        return cw.toByteArray();
    }

    private String originalName(String className) {
        if (className.startsWith(REMAPPED_PACKAGE_CANONICAL_NAME)) {
            return className.substring(REMAPPED_PACKAGE_CANONICAL_NAME.length());
        }
        return className;
    }

    @Override
    public URL getResource(String name) {
        return super.getResource(name);
    }
}

