/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.strategy.managed.InterleavingHistoryNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u0010\u001a\u00020\fJ>\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\nR\u00020\u00002\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00170\u000eH\u0002J7\u0010\u0018\u001a\u00020\u00122*\u0010\u0019\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00170\u001a\"\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0017\u00a2\u0006\u0002\u0010\u001bJ>\u0010\u001c\u001a\u0016\u0012\b\u0012\u00060\nR\u00020\u0000\u0012\b\u0012\u00060\nR\u00020\u00000\u00172\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\tH\u0002R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet;", "", "()V", "cursor", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$Cursor;", "getCursor", "()Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$Cursor;", "rootTransitions", "", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$InterleavingSequenceSetNode;", "addBranch", "", "chain", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingHistoryNode;", "clear", "hasPath", "", "node", "index", "subtract", "path", "Lkotlin/Pair;", "hashPath", "steps", "", "([Lkotlin/Pair;)Z", "wrapChain", "startIndex", "executionsCountedEarlier", "Cursor", "InterleavingSequenceSetNode", "lincheck"})
@SourceDebugExtension(value={"SMAP\nInterleavingSequenceTrackableSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterleavingSequenceTrackableSet.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,549:1\n1#2:550\n*E\n"})
public final class InterleavingSequenceTrackableSet {
    @NotNull
    private final Map<Integer, InterleavingSequenceSetNode> rootTransitions = new LinkedHashMap();
    @NotNull
    private final Cursor cursor = new Cursor();

    @NotNull
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void addBranch(@NotNull List<InterleavingHistoryNode> chain) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        if (!(!((Collection)chain).isEmpty())) {
            boolean bl = false;
            String string = "Internal error: Cycle chain can't be empty";
            throw new IllegalArgumentException(string.toString());
        }
        int firstElement = ((InterleavingHistoryNode)CollectionsKt.first(chain)).getThreadId();
        InterleavingSequenceSetNode interleavingSequenceSetNode = this.rootTransitions.get(firstElement);
        if (interleavingSequenceSetNode != null) {
            InterleavingSequenceSetNode it = interleavingSequenceSetNode;
            boolean bl = false;
            it.mergeBranch(chain, 0, 0);
            return;
        }
        interleavingSequenceSetNode = InterleavingSequenceTrackableSet.wrapChain$default(this, chain, 0, 0, 6, null);
        InterleavingSequenceSetNode nodesChainRoot = (InterleavingSequenceSetNode)interleavingSequenceSetNode.component1();
        InterleavingSequenceSetNode leaf = (InterleavingSequenceSetNode)interleavingSequenceSetNode.component2();
        Integer n = firstElement;
        this.rootTransitions.put(n, nodesChainRoot);
        this.cursor.setTo(leaf);
    }

    private final Pair<InterleavingSequenceSetNode, InterleavingSequenceSetNode> wrapChain(List<InterleavingHistoryNode> chain, int startIndex, int executionsCountedEarlier) {
        InterleavingSequenceSetNode root;
        if (!(startIndex <= CollectionsKt.getLastIndex(chain))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        InterleavingHistoryNode first = chain.get(startIndex);
        int firstExecutions = first.getExecutions() + first.getSpinCyclePeriod();
        int n = first.getThreadId();
        int n2 = firstExecutions - executionsCountedEarlier;
        int n3 = first.getSpinCyclePeriod();
        int n4 = first.getExecutionHash();
        boolean bl = startIndex == CollectionsKt.getLastIndex(chain);
        InterleavingSequenceSetNode current = root = new InterleavingSequenceSetNode(this, n, n2, n3, bl, n4, null, 32, null);
        n3 = chain.size();
        for (int i = startIndex + 1; i < n3; ++i) {
            InterleavingHistoryNode next = chain.get(i);
            int n5 = next.getThreadId();
            int n6 = next.getExecutions() + next.getSpinCyclePeriod();
            int n7 = next.getSpinCyclePeriod();
            int n8 = first.getExecutionHash();
            boolean bl2 = i == CollectionsKt.getLastIndex(chain);
            InterleavingSequenceSetNode nextNode = new InterleavingSequenceSetNode(this, n5, n6, n7, bl2, n8, null, 32, null);
            current.addTransition(next.getThreadId(), nextNode);
            current = nextNode;
        }
        return TuplesKt.to((Object)root, (Object)current);
    }

    static /* synthetic */ Pair wrapChain$default(InterleavingSequenceTrackableSet interleavingSequenceTrackableSet, List list, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return interleavingSequenceTrackableSet.wrapChain(list, n, n2);
    }

    public final void clear() {
        this.rootTransitions.clear();
    }

    public final boolean hashPath(Pair<Integer, Integer> ... steps) {
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        InterleavingSequenceSetNode interleavingSequenceSetNode = this.rootTransitions.get(((Pair)ArraysKt.first((Object[])steps)).getFirst());
        if (interleavingSequenceSetNode == null) {
            return false;
        }
        InterleavingSequenceSetNode r = interleavingSequenceSetNode;
        return this.hasPath(r, 0, 0, ArraysKt.toList((Object[])steps));
    }

    private final boolean hasPath(InterleavingSequenceSetNode node2, int index, int subtract, List<Pair<Integer, Integer>> path) {
        int iThread = ((Number)path.get(index).getFirst()).intValue();
        int executions = ((Number)path.get(index).getSecond()).intValue() - subtract;
        if (executions > node2.getExecutions()) {
            InterleavingSequenceSetNode interleavingSequenceSetNode = node2.transition(iThread);
            if (interleavingSequenceSetNode == null) {
                return false;
            }
            InterleavingSequenceSetNode next = interleavingSequenceSetNode;
            return this.hasPath(next, index, subtract + node2.getExecutions(), path);
        }
        if (executions < node2.getExecutions()) {
            return false;
        }
        if (index == CollectionsKt.getLastIndex(path)) {
            return node2.getCycleOccurred();
        }
        InterleavingSequenceSetNode interleavingSequenceSetNode = node2.transition(((Number)path.get(index + 1).getFirst()).intValue());
        if (interleavingSequenceSetNode == null) {
            return false;
        }
        InterleavingSequenceSetNode next = interleavingSequenceSetNode;
        return this.hasPath(next, index + 1, 0, path);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J!\u0010\u0012\u001a\u00020\u00112\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0004R\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0014H\u0082\bJ\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0007J\u0012\u0010\u001a\u001a\u00020\u00112\n\u0010\u001b\u001a\u00060\u0004R\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$Cursor;", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet;)V", "currentNode", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$InterleavingSequenceSetNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet;", "cycleLocationsHash", "", "getCycleLocationsHash", "()I", "cyclePeriod", "getCyclePeriod", "executionsCount", "isInCycle", "", "()Z", "clear", "", "ifValid", "action", "Lkotlin/Function1;", "invalidate", "onNextExecutionPoint", "onNextSwitchPoint", "threadId", "reset", "setTo", "interleavingSequenceSetNode", "lincheck"})
    @SourceDebugExtension(value={"SMAP\nInterleavingSequenceTrackableSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterleavingSequenceTrackableSet.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$Cursor\n*L\n1#1,549:1\n494#1,2:550\n494#1,2:552\n*S KotlinDebug\n*F\n+ 1 InterleavingSequenceTrackableSet.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$Cursor\n*L\n440#1:550,2\n467#1:552,2\n*E\n"})
    public final class Cursor {
        @Nullable
        private InterleavingSequenceSetNode currentNode;
        private int executionsCount;

        public final int getCycleLocationsHash() {
            InterleavingSequenceSetNode interleavingSequenceSetNode = this.currentNode;
            Intrinsics.checkNotNull((Object)interleavingSequenceSetNode);
            return interleavingSequenceSetNode.getCycleLocationsHash();
        }

        public final int getCyclePeriod() {
            InterleavingSequenceSetNode interleavingSequenceSetNode = this.currentNode;
            Intrinsics.checkNotNull((Object)interleavingSequenceSetNode);
            return interleavingSequenceSetNode.getCyclePeriod();
        }

        public final boolean isInCycle() {
            boolean bl;
            InterleavingSequenceSetNode interleavingSequenceSetNode = this.currentNode;
            if (interleavingSequenceSetNode != null) {
                InterleavingSequenceSetNode it = interleavingSequenceSetNode;
                boolean bl2 = false;
                bl = it.getCycleOccurred() && this.executionsCount == it.getExecutions();
            } else {
                bl = false;
            }
            return bl;
        }

        public final void setTo(@NotNull InterleavingSequenceSetNode interleavingSequenceSetNode) {
            Intrinsics.checkNotNullParameter((Object)interleavingSequenceSetNode, (String)"interleavingSequenceSetNode");
            this.currentNode = interleavingSequenceSetNode;
            this.executionsCount = interleavingSequenceSetNode.getExecutions();
        }

        public final void onNextExecutionPoint() {
            Cursor this_$iv = this;
            boolean $i$f$ifValid = false;
            InterleavingSequenceSetNode interleavingSequenceSetNode = this_$iv.currentNode;
            if (interleavingSequenceSetNode != null) {
                InterleavingSequenceSetNode node2 = interleavingSequenceSetNode;
                boolean bl = false;
                if (node2.getCycleOccurred() && this.executionsCount == node2.getExecutions()) {
                    return;
                }
                if (this.executionsCount < node2.getExecutions()) {
                    int n = this.executionsCount;
                    this.executionsCount = n + 1;
                    return;
                }
                this.executionsCount = 0;
                InterleavingSequenceSetNode nextChainNode = node2.transition(node2.getThreadId());
                if (nextChainNode == null) {
                    this.invalidate();
                    return;
                }
                this.currentNode = nextChainNode;
                this.onNextExecutionPoint();
            }
        }

        public final void onNextSwitchPoint(int threadId) {
            Cursor this_$iv = this;
            boolean $i$f$ifValid = false;
            InterleavingSequenceSetNode interleavingSequenceSetNode = this_$iv.currentNode;
            if (interleavingSequenceSetNode != null) {
                InterleavingSequenceSetNode node2 = interleavingSequenceSetNode;
                boolean bl = false;
                if (this.executionsCount != node2.getExecutions()) {
                    this.invalidate();
                    return;
                }
                this.executionsCount = 0;
                InterleavingSequenceSetNode nextNode = node2.transition(threadId);
                if (nextNode == null) {
                    this.invalidate();
                    return;
                }
                this.currentNode = nextNode;
            }
        }

        public final void reset(int threadId) {
            this.currentNode = (InterleavingSequenceSetNode)InterleavingSequenceTrackableSet.this.rootTransitions.get(threadId);
            this.executionsCount = 0;
        }

        private final void ifValid(Function1<? super InterleavingSequenceSetNode, Unit> action) {
            boolean $i$f$ifValid = false;
            InterleavingSequenceSetNode interleavingSequenceSetNode = this.currentNode;
            if (interleavingSequenceSetNode == null) {
                return;
            }
            action.invoke((Object)interleavingSequenceSetNode);
        }

        private final void invalidate() {
            this.currentNode = null;
        }

        public final void clear() {
            this.invalidate();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0000R\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u001b\u001a\u00060\u0000R\u00020\u000bJ$\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J&\u0010\"\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0014\u0010#\u001a\b\u0018\u00010\u0000R\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0000R\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$InterleavingSequenceSetNode;", "", "threadId", "", "executions", "cyclePeriod", "cycleOccurred", "", "cycleLocationsHash", "transitions", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet;IIIZILjava/util/Map;)V", "getCycleLocationsHash", "()I", "getCycleOccurred", "()Z", "setCycleOccurred", "(Z)V", "getCyclePeriod", "setCyclePeriod", "(I)V", "getExecutions", "setExecutions", "getThreadId", "addTransition", "", "node", "mergeBranch", "newChain", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingHistoryNode;", "startIndex", "executionsCountedEarlier", "mergeFurtherOrAddNewBranch", "transition", "lincheck"})
    public final class InterleavingSequenceSetNode {
        private final int threadId;
        private int executions;
        private int cyclePeriod;
        private boolean cycleOccurred;
        private final int cycleLocationsHash;
        @Nullable
        private Map<Integer, InterleavingSequenceSetNode> transitions;
        final /* synthetic */ InterleavingSequenceTrackableSet this$0;

        public InterleavingSequenceSetNode(InterleavingSequenceTrackableSet this$0, int threadId, int executions, int cyclePeriod, boolean cycleOccurred, @Nullable int cycleLocationsHash, Map<Integer, InterleavingSequenceSetNode> transitions) {
            this.this$0 = this$0;
            this.threadId = threadId;
            this.executions = executions;
            this.cyclePeriod = cyclePeriod;
            this.cycleOccurred = cycleOccurred;
            this.cycleLocationsHash = cycleLocationsHash;
            this.transitions = transitions;
        }

        public /* synthetic */ InterleavingSequenceSetNode(InterleavingSequenceTrackableSet interleavingSequenceTrackableSet, int n, int n2, int n3, boolean bl, int n4, Map map, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 0x20) != 0) {
                map = null;
            }
            this(interleavingSequenceTrackableSet, n, n2, n3, bl, n4, map);
        }

        public final int getThreadId() {
            return this.threadId;
        }

        public final int getExecutions() {
            return this.executions;
        }

        public final void setExecutions(int n) {
            this.executions = n;
        }

        public final int getCyclePeriod() {
            return this.cyclePeriod;
        }

        public final void setCyclePeriod(int n) {
            this.cyclePeriod = n;
        }

        public final boolean getCycleOccurred() {
            return this.cycleOccurred;
        }

        public final void setCycleOccurred(boolean bl) {
            this.cycleOccurred = bl;
        }

        public final int getCycleLocationsHash() {
            return this.cycleLocationsHash;
        }

        @Nullable
        public final InterleavingSequenceSetNode transition(int threadId) {
            Map<Integer, InterleavingSequenceSetNode> map = this.transitions;
            return map != null ? map.get(threadId) : null;
        }

        public final void addTransition(int threadId, @NotNull InterleavingSequenceSetNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Map<Integer, InterleavingSequenceSetNode> map = this.transitions;
            if (map != null) {
                Map<Integer, InterleavingSequenceSetNode> it = map;
                boolean bl = false;
                Integer n = threadId;
                it.put(n, node2);
                return;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)threadId, (Object)node2)};
            this.transitions = MapsKt.mutableMapOf((Pair[])pairArray);
        }

        public final void mergeBranch(@NotNull List<InterleavingHistoryNode> newChain, int startIndex, int executionsCountedEarlier) {
            Intrinsics.checkNotNullParameter(newChain, (String)"newChain");
            if (startIndex > CollectionsKt.getLastIndex(newChain)) {
                return;
            }
            InterleavingHistoryNode firstNewNode = newChain.get(startIndex);
            int firstNewNodeExecutions = firstNewNode.getExecutions() + firstNewNode.getSpinCyclePeriod() - executionsCountedEarlier;
            if (!(firstNewNode.getThreadId() == this.threadId)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (this.executions == firstNewNodeExecutions) {
                this.mergeFurtherOrAddNewBranch(newChain, startIndex + 1, 0);
            } else if (this.executions < firstNewNodeExecutions) {
                this.mergeFurtherOrAddNewBranch(newChain, startIndex, executionsCountedEarlier + this.executions);
            } else {
                if (startIndex == CollectionsKt.getLastIndex(newChain)) {
                    return;
                }
                int deltaExecutions = this.executions - firstNewNodeExecutions;
                int n = this.threadId;
                Map<Integer, InterleavingSequenceSetNode> map = this.transitions;
                int n2 = this.cyclePeriod;
                boolean bl = this.cycleOccurred;
                int n3 = this.cycleLocationsHash;
                InterleavingSequenceSetNode nextNode = new InterleavingSequenceSetNode(this.this$0, n, deltaExecutions, n2, bl, n3, map);
                this.executions = firstNewNodeExecutions;
                this.cyclePeriod = firstNewNode.getSpinCyclePeriod();
                this.cycleOccurred = firstNewNode.getCycleOccurred();
                Pair pair = InterleavingSequenceTrackableSet.wrapChain$default(this.this$0, newChain, startIndex + 1, 0, 4, null);
                InterleavingSequenceSetNode newChainRoot = (InterleavingSequenceSetNode)pair.component1();
                InterleavingSequenceSetNode newChainLeaf = (InterleavingSequenceSetNode)pair.component2();
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.threadId, (Object)nextNode), TuplesKt.to((Object)newChainRoot.threadId, (Object)newChainRoot)};
                this.transitions = MapsKt.mutableMapOf((Pair[])pairArray);
                this.this$0.getCursor().setTo(newChainLeaf);
            }
        }

        private final void mergeFurtherOrAddNewBranch(List<InterleavingHistoryNode> newChain, int startIndex, int executionsCountedEarlier) {
            if (startIndex > CollectionsKt.getLastIndex(newChain)) {
                return;
            }
            InterleavingHistoryNode newChainFirstNode = newChain.get(startIndex);
            InterleavingSequenceSetNode transition = this.transition(newChainFirstNode.getThreadId());
            if (transition == null) {
                Pair pair = this.this$0.wrapChain(newChain, startIndex, executionsCountedEarlier);
                InterleavingSequenceSetNode wrappedChainRoot = (InterleavingSequenceSetNode)pair.component1();
                InterleavingSequenceSetNode leaf = (InterleavingSequenceSetNode)pair.component2();
                this.addTransition(newChainFirstNode.getThreadId(), wrappedChainRoot);
                this.this$0.getCursor().setTo(leaf);
            } else {
                transition.mergeBranch(newChain, startIndex, executionsCountedEarlier);
            }
        }
    }
}

