/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.VoidResult;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CallStackTraceElement;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CodeLocationTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ForcibleExecutionFinishError;
import org.jetbrains.kotlinx.lincheck.strategy.managed.MethodCallTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.TracePointKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\nJ\u001b\u0010\u001c\u001a\u00020\u001b2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011J\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0015J\b\u0010\"\u001a\u00020\nH\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MethodCallTracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationTracePoint;", "iThread", "", "actorId", "callStackTrace", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "methodName", "", "stackTraceElement", "Ljava/lang/StackTraceElement;", "(IILjava/util/List;Ljava/lang/String;Ljava/lang/StackTraceElement;)V", "ownerName", "parameters", "", "", "[Ljava/lang/Object;", "returnedValue", "thrownException", "", "wasSuspended", "", "getWasSuspended", "()Z", "initializeOwnerName", "", "initializeParameters", "([Ljava/lang/Object;)V", "initializeReturnedValue", "value", "initializeThrownException", "exception", "toStringImpl", "lincheck"})
public final class MethodCallTracePoint
extends CodeLocationTracePoint {
    @NotNull
    private final String methodName;
    @Nullable
    private Object returnedValue;
    @Nullable
    private Throwable thrownException;
    @Nullable
    private Object[] parameters;
    @Nullable
    private String ownerName;

    public MethodCallTracePoint(int iThread, int actorId, @NotNull List<CallStackTraceElement> callStackTrace, @NotNull String methodName, @NotNull StackTraceElement stackTraceElement) {
        Intrinsics.checkNotNullParameter(callStackTrace, (String)"callStackTrace");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)stackTraceElement, (String)"stackTraceElement");
        super(iThread, actorId, callStackTrace, stackTraceElement);
        this.methodName = methodName;
        this.returnedValue = TracePointKt.access$getNO_VALUE$p();
    }

    public final boolean getWasSuspended() {
        return this.returnedValue == IntrinsicsKt.getCOROUTINE_SUSPENDED();
    }

    @Override
    @NotNull
    protected String toStringImpl() {
        StringBuilder stringBuilder;
        StringBuilder $this$toStringImpl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.ownerName != null) {
            $this$toStringImpl_u24lambda_u240.append(this.ownerName + ".");
        }
        $this$toStringImpl_u24lambda_u240.append(this.methodName + "(");
        if (this.parameters != null) {
            Intrinsics.checkNotNull((Object)this.parameters);
            $this$toStringImpl_u24lambda_u240.append(ArraysKt.joinToString$default((Object[])this.parameters, (CharSequence)",", null, null, (int)0, null, (Function1)toStringImpl.1.1.INSTANCE, (int)30, null));
        }
        $this$toStringImpl_u24lambda_u240.append(")");
        if (!Intrinsics.areEqual((Object)this.returnedValue, (Object)TracePointKt.access$getNO_VALUE$p()) && !Intrinsics.areEqual((Object)this.returnedValue, (Object)VoidResult.INSTANCE)) {
            $this$toStringImpl_u24lambda_u240.append(": " + TracePointKt.access$adornedStringRepresentation(this.returnedValue));
        } else if (this.thrownException != null && !Intrinsics.areEqual((Object)this.thrownException, (Object)ForcibleExecutionFinishError.INSTANCE)) {
            Throwable throwable = this.thrownException;
            Intrinsics.checkNotNull((Object)throwable);
            $this$toStringImpl_u24lambda_u240.append(": threw " + throwable.getClass().getSimpleName());
        }
        $this$toStringImpl_u24lambda_u240.append(" at " + TracePointKt.access$shorten(this.getStackTraceElement()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void initializeReturnedValue(@Nullable Object value) {
        this.returnedValue = value;
    }

    public final void initializeThrownException(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.thrownException = exception;
    }

    public final void initializeParameters(@NotNull Object[] parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.parameters = parameters;
    }

    public final void initializeOwnerName(@Nullable String ownerName) {
        this.ownerName = ownerName;
    }
}

