/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.transformation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Injections;
import org.jetbrains.kotlinx.lincheck.transformation.TransformationUtilsKt;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0005\u001a\u0012\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\rH\u0000\u001a[\u0010\"\u001a\u00020#*\u00020$2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020#0&\u00a2\u0006\u0002\b'2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020#0&\u00a2\u0006\u0002\b'2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020#0&\u00a2\u0006\u0002\b'H\u0080\b\u00f8\u0001\u0000\u001aB\u0010*\u001a\u00020#*\u00020$2\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020#0&\u00a2\u0006\u0002\b'2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020#0&\u00a2\u0006\u0002\b'H\u0080\b\u00f8\u0001\u0000\u001a)\u0010-\u001a\u00020#*\u00020$2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020#0&\u00a2\u0006\u0002\b'H\u0080\b\u00f8\u0001\u0000\u001a\u0018\u0010.\u001a\u00020#*\u00020$2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0000\u001a\u0014\u00100\u001a\u00020#*\u00020$2\u0006\u00101\u001a\u000202H\u0000\u001a\u0014\u00103\u001a\u000202*\u00020$2\u0006\u00104\u001a\u00020\rH\u0000\u001a\u0014\u00105\u001a\u00020#*\u00020$2\u0006\u00106\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u001c\u0010\u0010\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"P\u0010\u0014\u001a>\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00170\u0015j\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0017`\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0018\u0010\u001b\u001a\u00020\r*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00067"}, d2={"ASM_API", "", "CLASS_FOR_NAME_METHOD", "Lorg/objectweb/asm/commons/Method;", "getCLASS_FOR_NAME_METHOD", "()Lorg/objectweb/asm/commons/Method;", "CLASS_TYPE", "Lorg/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "getCLASS_TYPE", "()Lorg/objectweb/asm/Type;", "NOT_TRANSFORMED_JAVA_UTIL_CLASSES", "", "", "getNOT_TRANSFORMED_JAVA_UTIL_CLASSES", "()Ljava/util/Set;", "STRING_TYPE", "getSTRING_TYPE", "TRANSFORMED_JAVA_UTIL_INTERFACES", "getTRANSFORMED_JAVA_UTIL_INTERFACES", "functionToDeclaringClassMap", "Ljava/util/HashMap;", "Lkotlin/reflect/KFunction;", "Lkotlin/Pair;", "Lkotlin/collections/HashMap;", "getFunctionToDeclaringClassMap", "()Ljava/util/HashMap;", "canonicalClassName", "getCanonicalClassName", "(Ljava/lang/String;)Ljava/lang/String;", "getSuperclassName", "internalClassName", "isCoroutineStateMachineClass", "", "ifStatement", "", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "condition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "ifClause", "elseClause", "invokeIfInTestingCode", "original", "code", "invokeInIgnoredSection", "invokeStatic", "function", "loadLocals", "locals", "", "storeArguments", "methodDescriptor", "storeTopToLocal", "local", "lincheck"})
@SourceDebugExtension(value={"SMAP\nTransformationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformationUtils.kt\norg/jetbrains/kotlinx/lincheck/transformation/TransformationUtilsKt\n*L\n1#1,206:1\n93#1,10:207\n93#1,10:217\n*S KotlinDebug\n*F\n+ 1 TransformationUtils.kt\norg/jetbrains/kotlinx/lincheck/transformation/TransformationUtilsKt\n*L\n113#1:207,10\n126#1:217,10\n*E\n"})
public final class TransformationUtilsKt {
    @NotNull
    private static final HashMap<KFunction<?>, Pair<Type, Method>> functionToDeclaringClassMap = new HashMap();
    public static final int ASM_API = 589824;
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    @NotNull
    private static final Method CLASS_FOR_NAME_METHOD;
    @NotNull
    private static final Set<String> NOT_TRANSFORMED_JAVA_UTIL_CLASSES;
    @NotNull
    private static final Set<String> TRANSFORMED_JAVA_UTIL_INTERFACES;

    @NotNull
    public static final int[] storeArguments(@NotNull GeneratorAdapter $this$storeArguments, @NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$storeArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        Type[] argumentTypes = Type.getArgumentTypes((String)methodDescriptor);
        int[] locals = new int[argumentTypes.length];
        int n = argumentTypes.length + -1;
        if (0 <= n) {
            do {
                int i = n--;
                locals[i] = $this$storeArguments.newLocal(argumentTypes[i]);
                $this$storeArguments.storeLocal(locals[i], argumentTypes[i]);
            } while (0 <= n);
        }
        return locals;
    }

    public static final void loadLocals(@NotNull GeneratorAdapter $this$loadLocals, @NotNull int[] locals) {
        Intrinsics.checkNotNullParameter((Object)$this$loadLocals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locals, (String)"locals");
        for (int local : locals) {
            $this$loadLocals.loadLocal(local);
        }
    }

    public static final void storeTopToLocal(@NotNull GeneratorAdapter $this$storeTopToLocal, int local) {
        Intrinsics.checkNotNullParameter((Object)$this$storeTopToLocal, (String)"<this>");
        $this$storeTopToLocal.storeLocal(local);
        $this$storeTopToLocal.loadLocal(local);
    }

    @NotNull
    public static final HashMap<KFunction<?>, Pair<Type, Method>> getFunctionToDeclaringClassMap() {
        return functionToDeclaringClassMap;
    }

    public static final void invokeStatic(@NotNull GeneratorAdapter $this$invokeStatic, @NotNull KFunction<?> function) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeStatic, (String)"<this>");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Pair pair = functionToDeclaringClassMap.computeIfAbsent(function, arg_0 -> TransformationUtilsKt.invokeStatic$lambda$0((Function1)new Function1<KFunction<?>, Pair<? extends Type, ? extends Method>>(function){
            final /* synthetic */ KFunction<?> $function;
            {
                this.$function = $function;
                super(1);
            }

            @NotNull
            public final Pair<Type, Method> invoke(@NotNull KFunction<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                java.lang.reflect.Method method = ReflectJvmMapping.getJavaMethod(this.$function);
                Intrinsics.checkNotNull((Object)method);
                java.lang.reflect.Method it2 = method;
                boolean bl = false;
                return TuplesKt.to((Object)Type.getType(it2.getDeclaringClass()), (Object)Method.getMethod((java.lang.reflect.Method)it2));
            }
        }, arg_0));
        Type clazz = (Type)pair.component1();
        Method method = (Method)pair.component2();
        $this$invokeStatic.invokeStatic(clazz, method);
    }

    public static final void ifStatement(@NotNull GeneratorAdapter $this$ifStatement, @NotNull Function1<? super GeneratorAdapter, Unit> condition, @NotNull Function1<? super GeneratorAdapter, Unit> ifClause, @NotNull Function1<? super GeneratorAdapter, Unit> elseClause) {
        Intrinsics.checkNotNullParameter((Object)$this$ifStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(ifClause, (String)"ifClause");
        Intrinsics.checkNotNullParameter(elseClause, (String)"elseClause");
        boolean $i$f$ifStatement = false;
        Label ifClauseStart = $this$ifStatement.newLabel();
        Label end = $this$ifStatement.newLabel();
        condition.invoke((Object)$this$ifStatement);
        $this$ifStatement.ifZCmp(157, ifClauseStart);
        elseClause.invoke((Object)$this$ifStatement);
        $this$ifStatement.goTo(end);
        $this$ifStatement.visitLabel(ifClauseStart);
        ifClause.invoke((Object)$this$ifStatement);
        $this$ifStatement.visitLabel(end);
    }

    public static final void invokeIfInTestingCode(@NotNull GeneratorAdapter $this$invokeIfInTestingCode, @NotNull Function1<? super GeneratorAdapter, Unit> original, @NotNull Function1<? super GeneratorAdapter, Unit> code) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeIfInTestingCode, (String)"<this>");
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        boolean $i$f$invokeIfInTestingCode = false;
        GeneratorAdapter $this$ifStatement$iv = $this$invokeIfInTestingCode;
        boolean $i$f$ifStatement = false;
        Label ifClauseStart$iv = $this$ifStatement$iv.newLabel();
        Label end$iv = $this$ifStatement$iv.newLabel();
        GeneratorAdapter $this$invokeIfInTestingCode_u24lambda_u241 = $this$ifStatement$iv;
        boolean bl = false;
        TransformationUtilsKt.invokeStatic($this$invokeIfInTestingCode_u24lambda_u241, (KFunction)new Function0<Boolean>((Object)Injections.INSTANCE){

            @NotNull
            public final Boolean invoke() {
                return Injections.inTestingCode();
            }
        });
        $this$ifStatement$iv.ifZCmp(157, ifClauseStart$iv);
        original.invoke((Object)$this$ifStatement$iv);
        $this$ifStatement$iv.goTo(end$iv);
        $this$ifStatement$iv.visitLabel(ifClauseStart$iv);
        code.invoke((Object)$this$ifStatement$iv);
        $this$ifStatement$iv.visitLabel(end$iv);
    }

    public static final void invokeInIgnoredSection(@NotNull GeneratorAdapter $this$invokeInIgnoredSection, @NotNull Function1<? super GeneratorAdapter, Unit> code) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInIgnoredSection, (String)"<this>");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        boolean $i$f$invokeInIgnoredSection = false;
        TransformationUtilsKt.invokeStatic($this$invokeInIgnoredSection, (KFunction)new Function0<Boolean>((Object)Injections.INSTANCE){

            @NotNull
            public final Boolean invoke() {
                return Injections.enterIgnoredSection();
            }
        });
        int enteredIgnoredSection = $this$invokeInIgnoredSection.newLocal(Type.BOOLEAN_TYPE);
        $this$invokeInIgnoredSection.storeLocal(enteredIgnoredSection);
        code.invoke((Object)$this$invokeInIgnoredSection);
        GeneratorAdapter $this$ifStatement$iv = $this$invokeInIgnoredSection;
        boolean $i$f$ifStatement = false;
        Label ifClauseStart$iv = $this$ifStatement$iv.newLabel();
        Label end$iv = $this$ifStatement$iv.newLabel();
        GeneratorAdapter $this$invokeInIgnoredSection_u24lambda_u242 = $this$ifStatement$iv;
        boolean bl = false;
        $this$invokeInIgnoredSection_u24lambda_u242.loadLocal(enteredIgnoredSection);
        $this$ifStatement$iv.ifZCmp(157, ifClauseStart$iv);
        GeneratorAdapter $this$invokeInIgnoredSection_u24lambda_u244 = $this$ifStatement$iv;
        boolean bl2 = false;
        $this$ifStatement$iv.goTo(end$iv);
        $this$ifStatement$iv.visitLabel(ifClauseStart$iv);
        GeneratorAdapter $this$invokeInIgnoredSection_u24lambda_u243 = $this$ifStatement$iv;
        boolean bl3 = false;
        TransformationUtilsKt.invokeStatic($this$invokeInIgnoredSection_u24lambda_u243, (KFunction)new Function0<Unit>((Object)Injections.INSTANCE){

            public final void invoke() {
                Injections.leaveIgnoredSection();
            }
        });
        $this$ifStatement$iv.visitLabel(end$iv);
    }

    public static final boolean isCoroutineStateMachineClass(@NotNull String internalClassName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        return Intrinsics.areEqual((Object)TransformationUtilsKt.getSuperclassName(internalClassName), (Object)"kotlin/coroutines/jvm/internal/ContinuationImpl");
    }

    private static final String getSuperclassName(String internalClassName) {
        try {
            InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(internalClassName + ".class");
            if (inputStream == null) {
                return null;
            }
            InputStream classStream = inputStream;
            ClassReader classReader = new ClassReader(classStream);
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JM\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"org/jetbrains/kotlinx/lincheck/transformation/TransformationUtilsKt$getSuperclassName$SuperclassClassVisitor", "Lorg/objectweb/asm/ClassVisitor;", "()V", "<set-?>", "", "internalSuperclassName", "getInternalSuperclassName", "()Ljava/lang/String;", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "lincheck"})
            public final class SuperclassClassVisitor
            extends ClassVisitor {
                @Nullable
                private String internalSuperclassName;

                public SuperclassClassVisitor() {
                    super(589824);
                }

                @Nullable
                public final String getInternalSuperclassName() {
                    return this.internalSuperclassName;
                }

                public void visit(int version, int access, @Nullable String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
                    this.internalSuperclassName = superName;
                }
            }
            SuperclassClassVisitor superclassVisitor = new SuperclassClassVisitor();
            classReader.accept((ClassVisitor)superclassVisitor, 0);
            return superclassVisitor.getInternalSuperclassName();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @NotNull
    public static final String getCanonicalClassName(@NotNull String $this$canonicalClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$canonicalClassName, (String)"<this>");
        return StringsKt.replace$default((String)$this$canonicalClassName, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    public static final Type getSTRING_TYPE() {
        return STRING_TYPE;
    }

    public static final Type getCLASS_TYPE() {
        return CLASS_TYPE;
    }

    @NotNull
    public static final Method getCLASS_FOR_NAME_METHOD() {
        return CLASS_FOR_NAME_METHOD;
    }

    @NotNull
    public static final Set<String> getNOT_TRANSFORMED_JAVA_UTIL_CLASSES() {
        return NOT_TRANSFORMED_JAVA_UTIL_CLASSES;
    }

    @NotNull
    public static final Set<String> getTRANSFORMED_JAVA_UTIL_INTERFACES() {
        return TRANSFORMED_JAVA_UTIL_INTERFACES;
    }

    private static final Pair invokeStatic$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new Type[]{STRING_TYPE};
        CLASS_FOR_NAME_METHOD = new Method("forName", CLASS_TYPE, (Type[])objectArray);
        objectArray = new String[]{"java/util/ServiceLoader", "java/util/concurrent/TimeUnit", "java/util/OptionalDouble", "java/util/OptionalLong", "java/util/OptionalInt", "java/util/Optional", "java/util/Locale", "java/util/Locale$Category", "java/util/Locale$FilteringMode", "java/util/Currency", "java/util/Date", "java/util/Calendar", "java/util/TimeZone", "java/util/DoubleSummaryStatistics", "java/util/LongSummaryStatistics", "java/util/IntSummaryStatistics", "java/util/Formatter", "java/util/stream/PipelineHelper", "java/util/Random", "java/util/concurrent/ThreadLocalRandom"};
        NOT_TRANSFORMED_JAVA_UTIL_CLASSES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"java/util/concurrent/CompletionStage", "java/util/Observer", "java/util/concurrent/RejectedExecutionHandler", "java/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory", "java/util/jar/Pack200$Packer", "java/util/jar/Pack200$Unpacker", "java/util/prefs/PreferencesFactory", "java/util/ResourceBundle$CacheKeyReference", "java/util/prefs/PreferenceChangeListener", "java/util/prefs/NodeChangeListener", "java/util/logging/Filter", "java/util/spi/ResourceBundleControlProvider"};
        TRANSFORMED_JAVA_UTIL_INTERFACES = SetsKt.setOf((Object[])objectArray);
    }
}

