/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ActorKt;
import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.annotations.OpGroupConfig;
import org.jetbrains.kotlinx.lincheck.annotations.Operation;
import org.jetbrains.kotlinx.lincheck.annotations.Param;
import org.jetbrains.kotlinx.lincheck.annotations.StateRepresentation;
import org.jetbrains.kotlinx.lincheck.annotations.Validate;
import org.jetbrains.kotlinx.lincheck.execution.ActorGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.BooleanGen;
import org.jetbrains.kotlinx.lincheck.paramgen.ByteGen;
import org.jetbrains.kotlinx.lincheck.paramgen.DoubleGen;
import org.jetbrains.kotlinx.lincheck.paramgen.DummyParameterGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.EnumGen;
import org.jetbrains.kotlinx.lincheck.paramgen.FloatGen;
import org.jetbrains.kotlinx.lincheck.paramgen.IntGen;
import org.jetbrains.kotlinx.lincheck.paramgen.LongGen;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.ShortGen;
import org.jetbrains.kotlinx.lincheck.paramgen.StringGen;

public class CTestStructure {
    public final List<ActorGenerator> actorGenerators;
    public final List<ParameterGenerator<?>> parameterGenerators;
    public final List<OperationGroup> operationGroups;
    @Nullable
    public final Actor validationFunction;
    public final Method stateRepresentation;
    public final RandomProvider randomProvider;

    private CTestStructure(List<ActorGenerator> actorGenerators, List<ParameterGenerator<?>> parameterGenerators, List<OperationGroup> operationGroups, @Nullable Actor validationFunction, Method stateRepresentation, RandomProvider randomProvider) {
        this.actorGenerators = actorGenerators;
        this.parameterGenerators = parameterGenerators;
        this.operationGroups = operationGroups;
        this.validationFunction = validationFunction;
        this.stateRepresentation = stateRepresentation;
        this.randomProvider = randomProvider;
    }

    public static CTestStructure getFromTestClass(Class<?> testClass) {
        HashMap<String, OperationGroup> groupConfigs = new HashMap<String, OperationGroup>();
        ArrayList<ActorGenerator> actorGenerators = new ArrayList<ActorGenerator>();
        ArrayList<Actor> validationFunctions = new ArrayList<Actor>();
        ArrayList<Method> stateRepresentations = new ArrayList<Method>();
        RandomProvider randomProvider = new RandomProvider();
        HashMap parameterGeneratorsMap = new HashMap();
        for (Class<?> clazz = testClass; clazz != null; clazz = clazz.getSuperclass()) {
            CTestStructure.readTestStructureFromClass(clazz, groupConfigs, actorGenerators, parameterGeneratorsMap, validationFunctions, stateRepresentations, randomProvider);
        }
        if (stateRepresentations.size() > 1) {
            throw new IllegalStateException("Several functions marked with " + StateRepresentation.class.getSimpleName() + " were found, while at most one should be specified: " + stateRepresentations.stream().map(Method::getName).collect(Collectors.joining(", ")));
        }
        Method stateRepresentation = null;
        if (!stateRepresentations.isEmpty()) {
            stateRepresentation = (Method)stateRepresentations.get(0);
        }
        ArrayList parameterGenerators = new ArrayList(parameterGeneratorsMap.values());
        if (validationFunctions.size() > 1) {
            throw new IllegalStateException("At most one validation function is allowed, but several were detected: " + validationFunctions.stream().map(actor -> {
                Method method = actor.getMethod();
                return method.getDeclaringClass().getSimpleName() + "." + method.getName();
            }).collect(Collectors.joining(", ")));
        }
        Actor validationFunction = validationFunctions.isEmpty() ? null : (Actor)validationFunctions.get(0);
        return new CTestStructure(actorGenerators, parameterGenerators, new ArrayList<OperationGroup>(groupConfigs.values()), validationFunction, stateRepresentation, randomProvider);
    }

    private static void readTestStructureFromClass(Class<?> clazz, Map<String, OperationGroup> groupConfigs, List<ActorGenerator> actorGenerators, Map<Class<?>, ParameterGenerator<?>> parameterGeneratorsMap, List<Actor> validationFunctions, List<Method> stateRepresentations, RandomProvider randomProvider) {
        Map<String, ParameterGenerator<?>> namedGens = CTestStructure.createNamedGens(clazz, randomProvider);
        Map<Class<?>, ParameterGenerator<?>> defaultGens = CTestStructure.createDefaultGenerators(randomProvider);
        for (OpGroupConfig opGroupConfigAnn : (OpGroupConfig[])clazz.getAnnotationsByType(OpGroupConfig.class)) {
            groupConfigs.put(opGroupConfigAnn.name(), new OperationGroup(opGroupConfigAnn.name(), opGroupConfigAnn.nonParallel()));
        }
        for (Method m : CTestStructure.getDeclaredMethodSorted(clazz)) {
            if (m.isAnnotationPresent(Operation.class)) {
                String opNonParallelGroupName;
                Operation opAnn = m.getAnnotation(Operation.class);
                boolean isSuspendableMethod = ActorKt.isSuspendable(m);
                if (opAnn.params().length > 0 && opAnn.params().length != m.getParameterCount()) {
                    throw new IllegalArgumentException("Invalid count of parameter generators for " + (Method)m);
                }
                ArrayList gens = new ArrayList();
                int nParameters = m.getParameterCount() - (isSuspendableMethod ? 1 : 0);
                for (int i = 0; i < nParameters; ++i) {
                    String nameInOperation = opAnn.params().length > 0 ? opAnn.params()[i] : null;
                    Parameter parameter = m.getParameters()[i];
                    ParameterGenerator<?> parameterGenerator = CTestStructure.getOrCreateGenerator(m, parameter, nameInOperation, namedGens, defaultGens, randomProvider);
                    parameterGeneratorsMap.putIfAbsent(parameter.getType(), parameterGenerator);
                    gens.add(parameterGenerator);
                }
                ActorGenerator actorGenerator = new ActorGenerator(m, gens, opAnn.runOnce(), opAnn.cancellableOnSuspension(), opAnn.blocking(), opAnn.causesBlocking(), opAnn.promptCancellation());
                actorGenerators.add(actorGenerator);
                String opGroup = opAnn.group();
                if (!opGroup.isEmpty()) {
                    OperationGroup operationGroup = groupConfigs.get(opGroup);
                    if (operationGroup == null) {
                        throw new IllegalStateException("Operation group " + opGroup + " is not configured");
                    }
                    operationGroup.actors.add(actorGenerator);
                }
                if (!(opNonParallelGroupName = opAnn.nonParallelGroup()).isEmpty()) {
                    groupConfigs.computeIfAbsent(opNonParallelGroupName, name -> new OperationGroup((String)name, true));
                    groupConfigs.get((Object)opNonParallelGroupName).actors.add(actorGenerator);
                }
            }
            if (m.isAnnotationPresent(Validate.class)) {
                if (m.getParameterCount() != 0) {
                    throw new IllegalStateException("Validation function " + m.getName() + " should not have parameters");
                }
                validationFunctions.add(new Actor(m, Collections.emptyList()));
            }
            if (!m.isAnnotationPresent(StateRepresentation.class)) continue;
            if (m.getParameterCount() != 0) {
                throw new IllegalStateException("State representation function " + m.getName() + " should not have parameters");
            }
            if (m.getReturnType() != String.class) {
                throw new IllegalStateException("State representation function " + m.getName() + " should have String return type");
            }
            stateRepresentations.add(m);
        }
    }

    private static Map<String, ParameterGenerator<?>> createNamedGens(Class<?> clazz, RandomProvider randomProvider) {
        HashMap namedGens = new HashMap();
        Map<String, Class<Enum<?>>> enumGeneratorNameToClassMap = CTestStructure.collectNamedEnumGeneratorToClassMap(clazz);
        for (Param paramAnn : (Param[])clazz.getAnnotationsByType(Param.class)) {
            if (paramAnn.name().isEmpty()) {
                throw new IllegalArgumentException("@Param name in class declaration cannot be empty");
            }
            if (enumGeneratorNameToClassMap.containsKey(paramAnn.name())) {
                Class<? extends Enum<?>> enumClass = enumGeneratorNameToClassMap.get(paramAnn.name());
                namedGens.put(paramAnn.name(), CTestStructure.createEnumGenerator(paramAnn.conf(), randomProvider, enumClass));
                continue;
            }
            namedGens.put(paramAnn.name(), CTestStructure.createGenerator(paramAnn, randomProvider));
        }
        return namedGens;
    }

    private static Map<String, Class<? extends Enum<?>>> collectNamedEnumGeneratorToClassMap(Class<?> clazz) {
        HashMap enumGeneratorNameToClassMap = new HashMap();
        Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Operation.class)).flatMap(method -> Arrays.stream(method.getParameters())).filter(parameter -> parameter.getType().isEnum() && parameter.isAnnotationPresent(Param.class) && !((Param[])parameter.getAnnotationsByType(Param.class))[0].name().isEmpty()).forEach(parameter -> {
            String paramGenName = ((Param[])parameter.getAnnotationsByType(Param.class))[0].name();
            Class<?> enumClass = parameter.getType();
            enumGeneratorNameToClassMap.merge(paramGenName, enumClass, (storedClass, currentClass) -> {
                if (storedClass != currentClass) {
                    throw new IllegalStateException("Enum param gen with name " + paramGenName + " can't be associated with two different types: " + storedClass.getSimpleName() + " and " + currentClass.getSimpleName());
                }
                return storedClass;
            });
        });
        return enumGeneratorNameToClassMap;
    }

    private static Method[] getDeclaredMethodSorted(Class<?> clazz) {
        Method[] methods2 = clazz.getDeclaredMethods();
        Comparator<Method> comparator = Comparator.comparing(Method::getName).thenComparing(m -> Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(":")));
        Arrays.sort(methods2, comparator);
        return methods2;
    }

    private static ParameterGenerator<?> getOrCreateGenerator(Method m, Parameter p, String nameInOperation, Map<String, ParameterGenerator<?>> namedGens, Map<Class<?>, ParameterGenerator<?>> defaultGens, RandomProvider randomProvider) {
        Param paramAnn = p.getAnnotation(Param.class);
        if (paramAnn == null) {
            String name;
            String string = nameInOperation != null ? nameInOperation : (name = p.isNamePresent() ? p.getName() : null);
            if (name != null) {
                return CTestStructure.checkAndGetNamedGenerator(namedGens, name);
            }
            ParameterGenerator<?> defaultGenerator = defaultGens.get(p.getType());
            if (defaultGenerator != null) {
                return defaultGenerator;
            }
            if (p.getType().isEnum()) {
                EnumGen<?> generator = CTestStructure.createEnumGenerator("", randomProvider, p.getType());
                defaultGens.put(p.getType(), generator);
                return generator;
            }
            throw new IllegalStateException("Generator for parameter \"" + p + "\" in method \"" + m.getName() + "\" should be specified.");
        }
        if (!paramAnn.name().isEmpty() && paramAnn.gen() != DummyParameterGenerator.class) {
            throw new IllegalStateException("@Param should have either name or gen with optionally configuration");
        }
        if (!paramAnn.name().isEmpty()) {
            return CTestStructure.checkAndGetNamedGenerator(namedGens, paramAnn.name());
        }
        if (p.getType().isEnum()) {
            Class<?> enumClass = p.getType();
            return CTestStructure.createEnumGenerator(paramAnn.conf(), randomProvider, enumClass);
        }
        return CTestStructure.createGenerator(paramAnn, randomProvider);
    }

    private static ParameterGenerator<?> createGenerator(Param paramAnn, RandomProvider randomProvider) {
        try {
            return paramAnn.gen().getConstructor(RandomProvider.class, String.class).newInstance(randomProvider, paramAnn.conf());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create parameter gen", e);
        }
    }

    private static EnumGen<?> createEnumGenerator(String configuration, RandomProvider randomProvider, Class<? extends Enum<?>> enumClass) {
        return new EnumGen(enumClass, randomProvider, configuration);
    }

    private static Map<Class<?>, ParameterGenerator<?>> createDefaultGenerators(RandomProvider randomProvider) {
        HashMap defaultGens = new HashMap();
        defaultGens.put(Boolean.TYPE, new BooleanGen(randomProvider, ""));
        defaultGens.put(Boolean.class, (ParameterGenerator)defaultGens.get(Boolean.TYPE));
        defaultGens.put(Byte.TYPE, new ByteGen(randomProvider, ""));
        defaultGens.put(Byte.class, (ParameterGenerator)defaultGens.get(Byte.TYPE));
        defaultGens.put(Short.TYPE, new ShortGen(randomProvider, ""));
        defaultGens.put(Short.class, (ParameterGenerator)defaultGens.get(Short.TYPE));
        defaultGens.put(Integer.TYPE, new IntGen(randomProvider, ""));
        defaultGens.put(Integer.class, (ParameterGenerator)defaultGens.get(Integer.TYPE));
        defaultGens.put(Long.TYPE, new LongGen(randomProvider, ""));
        defaultGens.put(Long.class, (ParameterGenerator)defaultGens.get(Long.TYPE));
        defaultGens.put(Float.TYPE, new FloatGen(randomProvider, ""));
        defaultGens.put(Float.class, (ParameterGenerator)defaultGens.get(Float.TYPE));
        defaultGens.put(Double.TYPE, new DoubleGen(randomProvider, ""));
        defaultGens.put(Double.class, (ParameterGenerator)defaultGens.get(Double.TYPE));
        defaultGens.put(String.class, new StringGen(randomProvider, ""));
        return defaultGens;
    }

    private static ParameterGenerator<?> checkAndGetNamedGenerator(Map<String, ParameterGenerator<?>> namedGens, String name) {
        return Objects.requireNonNull(namedGens.get(name), "Unknown generator name: \"" + name + "\"");
    }

    public static class OperationGroup {
        public final String name;
        public final boolean nonParallel;
        public final List<ActorGenerator> actors;

        public OperationGroup(String name, boolean nonParallel) {
            this.name = name;
            this.nonParallel = nonParallel;
            this.actors = new ArrayList<ActorGenerator>();
        }

        public String toString() {
            return "OperationGroup{name='" + this.name + "', nonParallel=" + this.nonParallel + ", actors=" + this.actors + "}";
        }
    }
}

