/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u001a\n\u0010\u000f\u001a\u00020\u0006*\u00020\u0006\u001a2\u0010\u0010\u001a\u00020\u0006*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00112\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0015\u0010\r\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\"\u0015\u0010\u000e\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001b"}, d2={"INIT_THREAD_ID", "", "POST_THREAD_ID", "VALIDATION_THREAD_ID", "hasPostPartAndSuspendableActors", "", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "getHasPostPartAndSuspendableActors", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;)Z", "hasSuspendableActors", "getHasSuspendableActors", "hasSuspendableActorsInInitPart", "getHasSuspendableActorsInInitPart", "isParallelPartEmpty", "isValid", "copy", "splitIntoParts", "", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "initPartSize", "postPartSize", "validationFunction", "tryMinimize", "threadId", "actorId", "validate", "", "lincheck"})
@SourceDebugExtension(value={"SMAP\nExecutionScenario.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionScenario.kt\norg/jetbrains/kotlinx/lincheck/execution/ExecutionScenarioKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1726#2,3:209\n1747#2,3:212\n1747#2,3:215\n1747#2,3:218\n1549#2:221\n1620#2,3:222\n1559#2:225\n1590#2,4:226\n766#2:230\n857#2,2:231\n1549#2:234\n1620#2,3:235\n1#3:233\n*S KotlinDebug\n*F\n+ 1 ExecutionScenario.kt\norg/jetbrains/kotlinx/lincheck/execution/ExecutionScenarioKt\n*L\n78#1:209,3\n84#1:212,3\n90#1:215,3\n97#1:218,3\n133#1:221\n133#1:222,3\n159#1:225\n159#1:226,4\n165#1:230\n165#1:231,2\n188#1:234\n188#1:235,3\n*E\n"})
public final class ExecutionScenarioKt {
    public static final int INIT_THREAD_ID = 0;
    public static final int POST_THREAD_ID = 0;
    public static final int VALIDATION_THREAD_ID = 0;

    public static final boolean isParallelPartEmpty(@NotNull ExecutionScenario $this$isParallelPartEmpty) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isParallelPartEmpty, (String)"<this>");
            Iterable $this$all$iv = $this$isParallelPartEmpty.getParallelExecution();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean getHasSuspendableActors(@NotNull ExecutionScenario $this$hasSuspendableActors) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasSuspendableActors, (String)"<this>");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)CollectionsKt.flatten((Iterable)$this$hasSuspendableActors.getParallelExecution()), (Iterable)$this$hasSuspendableActors.getPostExecution());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Actor it = (Actor)element$iv;
                    boolean bl2 = false;
                    if (!it.isSuspendable()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean getHasSuspendableActorsInInitPart(@NotNull ExecutionScenario $this$hasSuspendableActorsInInitPart) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasSuspendableActorsInInitPart, (String)"<this>");
            Iterable $this$any$iv = $this$hasSuspendableActorsInInitPart.getInitExecution();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Actor it = (Actor)element$iv;
                    boolean bl2 = false;
                    if (!it.isSuspendable()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean getHasPostPartAndSuspendableActors(@NotNull ExecutionScenario $this$hasPostPartAndSuspendableActors) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$hasPostPartAndSuspendableActors, (String)"<this>");
            Iterable $this$any$iv = $this$hasPostPartAndSuspendableActors.getParallelExecution();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        List actors = (List)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = actors;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                Actor it = (Actor)element$iv2;
                                boolean bl4 = false;
                                if (!it.isSuspendable()) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl && !((Collection)$this$hasPostPartAndSuspendableActors.getPostExecution()).isEmpty();
    }

    public static final boolean isValid(@NotNull ExecutionScenario $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        return !ExecutionScenarioKt.isParallelPartEmpty($this$isValid) && !ExecutionScenarioKt.getHasSuspendableActorsInInitPart($this$isValid) && !ExecutionScenarioKt.getHasPostPartAndSuspendableActors($this$isValid);
    }

    public static final void validate(@NotNull ExecutionScenario $this$validate) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        if (!(!ExecutionScenarioKt.isParallelPartEmpty($this$validate))) {
            boolean $i$a$-require-ExecutionScenarioKt$validate$42 = false;
            String $i$a$-require-ExecutionScenarioKt$validate$42 = "Scenario has empty parallel part";
            throw new IllegalArgumentException($i$a$-require-ExecutionScenarioKt$validate$42.toString());
        }
        if (ExecutionScenarioKt.getHasSuspendableActors($this$validate)) {
            if (!(!ExecutionScenarioKt.getHasSuspendableActorsInInitPart($this$validate))) {
                boolean $i$a$-require-ExecutionScenarioKt$validate$52 = false;
                String $i$a$-require-ExecutionScenarioKt$validate$52 = "Scenario contains suspendable methods in initial part";
                throw new IllegalArgumentException($i$a$-require-ExecutionScenarioKt$validate$52.toString());
            }
            if (!(!ExecutionScenarioKt.getHasPostPartAndSuspendableActors($this$validate))) {
                boolean bl = false;
                String string = "Scenario with suspendable methods has non-empty post part";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExecutionScenario copy(@NotNull ExecutionScenario $this$copy) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Iterable iterable = $this$copy.getParallelExecution();
        List list = new ArrayList($this$copy.getInitExecution());
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList((Collection)it));
        }
        Actor actor = $this$copy.getValidationFunction();
        List list3 = new ArrayList($this$copy.getPostExecution());
        List list4 = (List)destination$iv$iv;
        List list5 = list;
        return new ExecutionScenario(list5, list4, list3, actor);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ExecutionScenario tryMinimize(@NotNull ExecutionScenario $this$tryMinimize, int threadId, int actorId) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)$this$tryMinimize, (String)"<this>");
        if (!(threadId < $this$tryMinimize.getThreads().size() && actorId < $this$tryMinimize.getThreads().get(threadId).size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int initPartSize = threadId == 0 && actorId < $this$tryMinimize.getInitExecution().size() ? $this$tryMinimize.getInitExecution().size() - 1 : $this$tryMinimize.getInitExecution().size();
        int postPartSize = threadId == 0 && actorId >= $this$tryMinimize.getInitExecution().size() + $this$tryMinimize.getParallelExecution().get(0).size() ? $this$tryMinimize.getPostExecution().size() - 1 : $this$tryMinimize.getPostExecution().size();
        Object object = $this$tryMinimize.getThreads();
        boolean $i$f$mapIndexed = false;
        void var7_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void actors;
            List list;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list2 = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List $this$tryMinimize_u24lambda_u2410_u24lambda_u249 = list = CollectionsKt.toMutableList((Collection)((Collection)actors));
            boolean bl2 = false;
            if (i == threadId) {
                $this$tryMinimize_u24lambda_u2410_u24lambda_u249.remove(actorId);
            }
            collection.add(list);
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapIndexedTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !((Collection)it).isEmpty();
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object it = object = ExecutionScenarioKt.splitIntoParts((List)destination$iv$iv, initPartSize, postPartSize, $this$tryMinimize.getValidationFunction());
        boolean bl = false;
        return ExecutionScenarioKt.isValid((ExecutionScenario)it) ? object : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final ExecutionScenario splitIntoParts(List<? extends List<Actor>> $this$splitIntoParts, int initPartSize, int postPartSize, Actor validationFunction) {
        void $this$mapTo$iv$iv;
        if ($this$splitIntoParts.isEmpty()) {
            return new ExecutionScenario(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), validationFunction);
        }
        int firstThreadSize = $this$splitIntoParts.get(0).size();
        List<Actor> initExecution = $this$splitIntoParts.get(0).subList(0, initPartSize);
        List<Actor> postExecution = $this$splitIntoParts.get(0).subList(firstThreadSize - postPartSize, firstThreadSize);
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)$this$splitIntoParts);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(i == false ? $this$splitIntoParts.get(0).subList(initPartSize, firstThreadSize - postPartSize) : $this$splitIntoParts.get((int)i));
        }
        List parallelExecution = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (((List)parallelExecution.get(0)).isEmpty()) {
            parallelExecution.remove(0);
        }
        if (parallelExecution.size() == 1) {
            List threadExecution = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)initExecution, (Iterable)((Iterable)parallelExecution.get(0))), (Iterable)postExecution);
            return new ExecutionScenario(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)threadExecution), CollectionsKt.emptyList(), validationFunction);
        }
        return new ExecutionScenario(initExecution, parallelExecution, postExecution, validationFunction);
    }
}

