/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ExecutionClassLoader;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.runner.ExecutionPart;
import org.jetbrains.kotlinx.lincheck.runner.InvocationResult;
import org.jetbrains.kotlinx.lincheck.strategy.Strategy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B/\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&J\u0010\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&J\u0010\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u0014J\b\u0010/\u001a\u00020(H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\u0018\u00102\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u00103\u001a\u00020*H&J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u000206H&J\u0006\u00107\u001a\u00020(J\u000e\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0018\u00109\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010:\u001a\u00020;H&J\u0010\u0010<\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&J\u0010\u0010=\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&J\b\u0010>\u001a\u00020?H&R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/Runner;", "Ljava/io/Closeable;", "strategy", "Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "testClass", "Ljava/lang/Class;", "validationFunction", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "stateRepresentationFunction", "Ljava/lang/reflect/Method;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/Actor;Ljava/lang/reflect/Method;)V", "classLoader", "Lorg/jetbrains/kotlinx/lincheck/ExecutionClassLoader;", "getClassLoader", "()Lorg/jetbrains/kotlinx/lincheck/ExecutionClassLoader;", "completedOrSuspendedThreads", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCompletedOrSuspendedThreads", "()Ljava/util/concurrent/atomic/AtomicInteger;", "<set-?>", "Lorg/jetbrains/kotlinx/lincheck/runner/ExecutionPart;", "currentExecutionPart", "getCurrentExecutionPart", "()Lorg/jetbrains/kotlinx/lincheck/runner/ExecutionPart;", "isParallelExecutionCompleted", "", "()Z", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "getScenario", "()Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "getStateRepresentationFunction", "()Ljava/lang/reflect/Method;", "getStrategy", "()Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "getTestClass", "()Ljava/lang/Class;", "getValidationFunction", "()Lorg/jetbrains/kotlinx/lincheck/Actor;", "afterCoroutineCancelled", "", "iThread", "", "afterCoroutineResumed", "afterCoroutineSuspended", "beforePart", "part", "close", "constructStateRepresentation", "", "isCoroutineResumed", "actorId", "isCurrentRunnerThread", "thread", "Ljava/lang/Thread;", "onActorFinish", "onActorStart", "onFailure", "e", "", "onFinish", "onStart", "run", "Lorg/jetbrains/kotlinx/lincheck/runner/InvocationResult;", "lincheck"})
public abstract class Runner
implements Closeable {
    @NotNull
    private final Strategy strategy;
    @NotNull
    private final Class<?> testClass;
    @Nullable
    private final Actor validationFunction;
    @Nullable
    private final Method stateRepresentationFunction;
    @NotNull
    private final ExecutionClassLoader classLoader;
    @NotNull
    private final ExecutionScenario scenario;
    @NotNull
    private final AtomicInteger completedOrSuspendedThreads;
    @Nullable
    private ExecutionPart currentExecutionPart;

    protected Runner(@NotNull Strategy strategy, @NotNull Class<?> testClass, @Nullable Actor validationFunction, @Nullable Method stateRepresentationFunction) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.strategy = strategy;
        this.testClass = testClass;
        this.validationFunction = validationFunction;
        this.stateRepresentationFunction = stateRepresentationFunction;
        this.classLoader = new ExecutionClassLoader();
        this.scenario = this.strategy.getScenario();
        this.completedOrSuspendedThreads = new AtomicInteger(0);
    }

    @NotNull
    protected final Strategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    protected final Class<?> getTestClass() {
        return this.testClass;
    }

    @Nullable
    protected final Actor getValidationFunction() {
        return this.validationFunction;
    }

    @Nullable
    protected final Method getStateRepresentationFunction() {
        return this.stateRepresentationFunction;
    }

    @NotNull
    public final ExecutionClassLoader getClassLoader() {
        return this.classLoader;
    }

    @NotNull
    protected final ExecutionScenario getScenario() {
        return this.scenario;
    }

    @NotNull
    protected final AtomicInteger getCompletedOrSuspendedThreads() {
        return this.completedOrSuspendedThreads;
    }

    @Nullable
    public final ExecutionPart getCurrentExecutionPart() {
        return this.currentExecutionPart;
    }

    @Nullable
    public String constructStateRepresentation() {
        return null;
    }

    @NotNull
    public abstract InvocationResult run();

    public abstract void onStart(int var1);

    public abstract void onFinish(int var1);

    public abstract void onFailure(int var1, @NotNull Throwable var2);

    public abstract void afterCoroutineSuspended(int var1);

    public abstract void afterCoroutineResumed(int var1);

    public abstract void afterCoroutineCancelled(int var1);

    public abstract boolean isCoroutineResumed(int var1, int var2);

    public final void onActorStart(int iThread) {
        this.strategy.onActorStart(iThread);
    }

    public final void onActorFinish() {
        this.strategy.onActorFinish();
    }

    public final void beforePart(@NotNull ExecutionPart part) {
        Intrinsics.checkNotNullParameter((Object)((Object)part), (String)"part");
        this.completedOrSuspendedThreads.set(0);
        this.currentExecutionPart = part;
        this.strategy.beforePart(part);
    }

    @Override
    public void close() {
    }

    public abstract boolean isCurrentRunnerThread(@NotNull Thread var1);

    public final boolean isParallelExecutionCompleted() {
        return this.completedOrSuspendedThreads.get() == this.scenario.getNThreads();
    }
}

