/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.util.UnsafeHolder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/AtomicFieldUpdaterNames;", "", "()V", "getAtomicFieldUpdaterName", "", "updater", "getAtomicFieldUpdaterName$lincheck", "lincheck"})
public final class AtomicFieldUpdaterNames {
    @NotNull
    public static final AtomicFieldUpdaterNames INSTANCE = new AtomicFieldUpdaterNames();

    private AtomicFieldUpdaterNames() {
    }

    @Nullable
    public final String getAtomicFieldUpdaterName$lincheck(@NotNull Object updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(updater instanceof AtomicIntegerFieldUpdater || updater instanceof AtomicLongFieldUpdater || updater instanceof AtomicReferenceFieldUpdater)) {
            throw new IllegalArgumentException("Provided object is not a recognized Atomic*FieldUpdater type.");
        }
        try {
            Field tclassField = updater.getClass().getDeclaredField("tclass");
            Object object = UnsafeHolder.INSTANCE.getUNSAFE().getObject(updater, UnsafeHolder.INSTANCE.getUNSAFE().objectFieldOffset(tclassField));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            Class targetType = (Class)object;
            Field offsetField = updater.getClass().getDeclaredField("offset");
            long offset = UnsafeHolder.INSTANCE.getUNSAFE().getLong(updater, UnsafeHolder.INSTANCE.getUNSAFE().objectFieldOffset(offsetField));
            return UtilsKt.findFieldNameByOffset(targetType, offset);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

